/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.olap.compiler.ast;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.CdMdxTokenLocation;
import crazydev.common.mdx.scanner.token.CdMdxAmpDelimitedCompositeIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxAmpDelimitedIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxIdentifierToken;
import crazydev.iccube.exception.OlapErrorCode;
import crazydev.iccube.mdx.parser.ast.MdxEntity;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionArgExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.expression.method.MdxMethodArgExpression;
import crazydev.iccube.mdx.parser.ast.expression.method.MdxMethodCallExpression;
import crazydev.iccube.olap.compiler.OlapCompilationContext;
import crazydev.iccube.olap.compiler.exception.OlapCompilationException;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierMultiValueKeyPart;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierNamePart;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierPart;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifierSingleValueKeyPart;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.instr.OlapInstr;
import crazydev.iccube.olap.eval.instr.OlapInstrLocationRange;
import crazydev.iccube.olap.eval.method.OlapMethodCallArgInstr;
import crazydev.iccube.olap.eval.select.OlapAsNamedSetInstr;
import crazydev.iccube.olap.eval.select.OlapLambdaInstr;
import crazydev.iccube.olap.eval.select.OlapNullLambdaInstr;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class MdxEntityCompiler<ENTITY extends MdxEntity> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final OlapInstr compile(OlapCompilationContext context, ENTITY mdx) {
        context.pushCurrentMdxEntity((MdxEntity)mdx);
        try {
            OlapInstr instr;
            OlapInstr olapInstr = instr = this.doCompile(context, mdx);
            return olapInstr;
        }
        finally {
            context.popCurrentMdxEntity();
        }
    }

    protected abstract OlapInstr doCompile(OlapCompilationContext var1, ENTITY var2);

    public static OlapEntityIdentifier createOlapIdentifier(MdxIdentifierExpression id) {
        OlapEntityIdentifierPart[] parts = new OlapEntityIdentifierPart[id.getPartCount()];
        int idx = 0;
        for (CdMdxIdentifierToken part : id.getParts()) {
            if (!part.isKey()) {
                parts[idx++] = new OlapEntityIdentifierNamePart(part.isDelimited(), part.getIdentifier());
                continue;
            }
            CdMdxAmpDelimitedIdentifierToken key = (CdMdxAmpDelimitedIdentifierToken)part;
            if (!key.isComposite()) {
                parts[idx++] = new OlapEntityIdentifierSingleValueKeyPart(key.getIdentifier());
                continue;
            }
            CdMdxAmpDelimitedCompositeIdentifierToken xkey = (CdMdxAmpDelimitedCompositeIdentifierToken)part;
            parts[idx++] = new OlapEntityIdentifierMultiValueKeyPart(xkey.getIdentifiers());
        }
        return new OlapEntityIdentifier(id, parts);
    }

    public static OlapEntityIdentifier createOlapMeasuresIdentifier() {
        return new OlapEntityIdentifier("Measures");
    }

    public static OlapInstrLocationRange createRange(MdxEntity entity) {
        CdMdxToken firstToken = entity.getFirstToken();
        CdMdxToken lastToken = entity.getLastToken();
        return MdxEntityCompiler.createRange(firstToken, lastToken);
    }

    protected static OlapInstrLocationRange createRange(CdMdxToken from, CdMdxToken to) {
        int fromOffset = MdxEntityCompiler.createFromOffset(from);
        int fromLineNumber = MdxEntityCompiler.createFromLineNumber(from);
        int toOffset = MdxEntityCompiler.createToOffset(to);
        String fromMdx = from.getMdx();
        String fromMdxHash = from.getMdxHash();
        String toMdx = to.getMdx();
        String toMdxHash = to.getMdxHash();
        if (fromMdx != toMdx) {
            throw new CdProgrammingException("Inconsistent (token) MDX");
        }
        if (fromMdxHash != toMdxHash) {
            throw new CdProgrammingException("Inconsistent (token) MDX-hash");
        }
        return new OlapInstrLocationRange(fromMdx, fromMdxHash, fromOffset, toOffset, fromLineNumber);
    }

    private static int createFromOffset(CdMdxToken token) {
        CdMdxTokenLocation tkLocation = token.getLocation();
        return tkLocation.offset();
    }

    private static int createFromLineNumber(CdMdxToken token) {
        CdMdxTokenLocation tkLocation = token.getLocation();
        return tkLocation.lineNumber();
    }

    private static int createToOffset(CdMdxToken token) {
        CdMdxTokenLocation tkLocation = token.getLocation();
        return tkLocation.offset() + token.getLexeme().length() - 1;
    }

    protected static OlapMethodCallArgInstr[] compileMethodCallArgs(OlapCompilationContext context, MdxMethodCallExpression mdx) {
        List<MdxMethodArgExpression> mdxArgs = mdx.getArgs();
        OlapMethodCallArgInstr[] instrs = new OlapMethodCallArgInstr[mdxArgs.size()];
        for (int idx = 0; idx < mdxArgs.size(); ++idx) {
            MdxMethodArgExpression expr = mdxArgs.get(idx);
            Object instr = context.compile(expr.getArg());
            instrs[idx] = new OlapMethodCallArgInstr(MdxEntityCompiler.createRange(expr), expr.getName(), (OlapInstr)instr);
        }
        return instrs;
    }

    protected static OlapInstr[] compileArgs(OlapCompilationContext context, @Nullable OlapFunction function, List<MdxFunctionArgExpression> mdxArgs) {
        HashSet<String> asNames = new HashSet<String>();
        OlapInstr[] instrs = new OlapInstr[mdxArgs.size()];
        for (int idx = 0; idx < mdxArgs.size(); ++idx) {
            OlapAsNamedSetInstr asNamedSet;
            String asName;
            MdxFunctionArgExpression expr = mdxArgs.get(idx);
            Object arg = context.compile(expr.getArg());
            if (arg instanceof OlapAsNamedSetInstr && (asName = (asNamedSet = (OlapAsNamedSetInstr)arg).getAsName()) != null && !asNames.add(asName)) {
                throw new OlapCompilationException(context, OlapErrorCode.FUNCTION_AS_PARAMETER_DUPLICATED, new Serializable[]{asName});
            }
            Object instr = function != null && !((OlapInstr)arg).isMissingFunctionArgument() && function.getArgsInfo().isLambda(expr.getIndex()) ? (((OlapInstr)arg).isNull() ? new OlapNullLambdaInstr(MdxEntityCompiler.createRange(expr)) : new OlapLambdaInstr(MdxEntityCompiler.createRange(expr), (OlapInstr)arg, function)) : arg;
            instrs[idx] = instr;
        }
        return instrs;
    }
}

