/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.notification.transporter.email;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.notification.OlapNotification;
import crazydev.iccube.notification.OlapNotificationLevel;
import crazydev.iccube.notification.OlapNotificationParams;
import crazydev.iccube.notification.OlapNotificationServiceTransporter;
import crazydev.iccube.notification.OlapNotificationType;
import crazydev.iccube.notification.transporter.email.OlapNotificationEmailService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.io.Serializable;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class OlapNotificationEmailServiceTransporter
extends OlapNotificationServiceTransporter {
    private final OlapNotificationEmailService service;
    private final String id;
    private final InternetAddress fromAddress;
    private final String from;
    private final InternetAddress[] toAddresses;
    private final String to;
    @Nullable
    private final InternetAddress[] ccAddresses;
    private final String cc;

    public OlapNotificationEmailServiceTransporter(OlapNotificationEmailService service, String id, String from, String to, @Nullable String cc) throws AddressException {
        this.service = service;
        this.id = id;
        this.fromAddress = new InternetAddress(from);
        this.from = from;
        this.toAddresses = InternetAddress.parse((String)to);
        this.to = to;
        this.ccAddresses = cc != null ? InternetAddress.parse((String)cc) : null;
        this.cc = cc;
    }

    private static String getSubject(OlapNotification notification) {
        CharSequence subject;
        OlapNotificationType type = notification.getType();
        if (OlapNotificationType.ALERT == type && (subject = OlapNotificationEmailServiceTransporter.getSubjectFromAlert(notification)) != null) {
            return subject;
        }
        subject = new StringBuilder();
        OlapNotificationLevel level = notification.getLevel();
        ((StringBuilder)subject).append("[").append(level).append("] ").append(type);
        if (OlapNotificationType.SERVER_READY == type) {
            ((StringBuilder)subject).append(" ").append(notification.getServerId().asString());
        } else {
            String schema = notification.getSchema();
            if (schema != null) {
                ((StringBuilder)subject).append(" ").append(schema);
            }
        }
        return ((StringBuilder)subject).toString();
    }

    @Nullable
    private static String getSubjectFromAlert(OlapNotification notification) {
        OlapNotificationParams params = notification.getParams();
        String subject = params.getParamAsString("Alert Subject");
        if (CdStringUtils.isNotNullAndNotBlank((String)subject)) {
            return subject;
        }
        return null;
    }

    private static String getBody(OlapNotification notification) {
        CharSequence body;
        OlapNotificationType type = notification.getType();
        if (OlapNotificationType.ALERT == type && (body = OlapNotificationEmailServiceTransporter.getBodyFromAlert(notification)) != null) {
            return body;
        }
        body = new StringBuilder();
        ((StringBuilder)body).append("").append("Status : ").append(notification.getLevel()).append("\n").append("Type   : ").append(notification.getType()).append("\n").append("Date   : ").append(notification.getDate()).append("\n").append("icCube : ").append(notification.getServerId().asString()).append("\n").append("-").append("\n");
        OlapNotificationParams params = notification.getParams();
        if (!params.isEmpty()) {
            for (String name : params.getNames()) {
                ((StringBuilder)body).append(name).append(" : ").append(params.getParamAsString(name)).append("\n");
            }
            ((StringBuilder)body).append("-").append("\n");
        }
        return ((StringBuilder)body).toString();
    }

    @Nullable
    private static String getBodyFromAlert(OlapNotification notification) {
        OlapNotificationParams params = notification.getParams();
        String body = params.getParamAsString("Alert Body");
        if (CdStringUtils.isNotNullAndNotBlank((String)body)) {
            return body;
        }
        return null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String asLogInfo() {
        StringBuilder info = new StringBuilder(this.id);
        info.append(" [service:").append(this.service.getId()).append("]");
        info.append(" [from:").append(this.from).append("]");
        info.append(" [to:").append(this.to).append("]");
        if (this.cc != null) {
            info.append(" [cc:").append(this.cc).append("]");
        }
        return info.toString();
    }

    @Override
    public void handleNotification(OlapNotification notification) {
        String subject = OlapNotificationEmailServiceTransporter.getSubject(notification);
        String body = OlapNotificationEmailServiceTransporter.getBody(notification);
        InternetAddress fromAddress = this.getFromAddress(notification);
        Object[] toAddresses = this.getToAddresses(notification);
        InternetAddress[] ccAddresses = this.getCcAddresses(notification);
        Serializable attachment = this.getAttachment(notification);
        String attachmentName = this.getAttachmentName(notification);
        if (OlapLoggers.NOTIFICATION.isDebugEnabled()) {
            OlapLoggers.NOTIFICATION.debug((Object)("[notification] alert eMail [" + subject + "] to " + Arrays.toString(toAddresses)));
        }
        this.service.send(fromAddress, (InternetAddress[])toAddresses, ccAddresses, subject, body, attachment, attachmentName);
    }

    private InternetAddress getFromAddress(OlapNotification notification) {
        return this.fromAddress;
    }

    private InternetAddress[] getToAddresses(OlapNotification notification) {
        InternetAddress[] addresses;
        OlapNotificationType type = notification.getType();
        if (OlapNotificationType.ALERT == type && (addresses = this.getToAddressesFromAlert(notification)) != null) {
            return addresses;
        }
        return this.toAddresses;
    }

    @Nullable
    private InternetAddress[] getToAddressesFromAlert(OlapNotification notification) {
        OlapNotificationParams params = notification.getParams();
        InternetAddress[] addresses = (InternetAddress[])params.getParam("Alert To");
        if (addresses != null && addresses.length > 0) {
            return addresses;
        }
        return null;
    }

    @Nullable
    private InternetAddress[] getCcAddresses(OlapNotification notification) {
        return this.ccAddresses;
    }

    @Nullable
    private Serializable getAttachment(OlapNotification notification) {
        Serializable attachment;
        OlapNotificationType type = notification.getType();
        if (OlapNotificationType.ALERT == type && (attachment = this.getAttachmentFromAlert(notification)) != null) {
            return attachment;
        }
        return null;
    }

    @Nullable
    private Serializable getAttachmentFromAlert(OlapNotification notification) {
        OlapNotificationParams params = notification.getParams();
        Serializable attachment = params.getParam("Alert Attachment");
        if (attachment != null) {
            return attachment;
        }
        return null;
    }

    @Nullable
    private String getAttachmentName(OlapNotification notification) {
        String attachment;
        OlapNotificationType type = notification.getType();
        if (OlapNotificationType.ALERT == type && (attachment = this.getAttachmentNameFromAlert(notification)) != null) {
            return attachment;
        }
        return null;
    }

    @Nullable
    private String getAttachmentNameFromAlert(OlapNotification notification) {
        OlapNotificationParams params = notification.getParams();
        String attachment = params.getParamAsString("Alert Attachment Name");
        if (attachment != null) {
            return attachment;
        }
        return null;
    }
}

