/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.notification.transporter.email;

import crazydev.common.utils.CdPasswordUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.notification.OlapNotificationServiceException;
import crazydev.iccube.notification.definition.OlapNotificationTransportServiceDefinition;
import crazydev.iccube.notification.transporter.email.OlapNotificationEmailService;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public class OlapNotificationEmailJavaMailService
extends OlapNotificationEmailService {
    public static final String MAIL_SMTP = "mail.smtp";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static final String USERNAME = "icCube.username";
    public static final String PASSWORD = "icCube.password";
    protected final Properties smtpProperties = new Properties();
    @Nullable
    protected SmtpAuthenticator authenticator;

    public OlapNotificationEmailJavaMailService() {
        OlapLoggers.SERVER.info((Object)"[notification] eMail service (JavaMail SMTP) created");
    }

    @Override
    public void configure(OlapNotificationTransportServiceDefinition configuration) throws OlapNotificationServiceException {
        super.configure(configuration);
        List<String> properties = configuration.getConfigurationProperties();
        for (String property : properties) {
            if (!property.startsWith(MAIL_SMTP)) continue;
            String value = configuration.getConfigurationProperty(property);
            OlapLoggers.NOTIFICATION.debug((Object)("[notification] SMTP : " + property + " [" + value + "]"));
            this.smtpProperties.put(property, value);
            if (!MAIL_SMTP_AUTH.equals(property) || !"true".equals(value)) continue;
            String user = configuration.getConfigurationProperty(USERNAME);
            if (CdStringUtils.isNullOrBlank((String)user)) {
                throw new OlapNotificationServiceException("eMail missing icCube.username property");
            }
            String password = configuration.getConfigurationProperty(PASSWORD);
            if (CdStringUtils.isNullOrBlank((String)password)) {
                throw new OlapNotificationServiceException("eMail missing icCube.password property");
            }
            String pwd = CdPasswordUtils.deObfuscate((String)password);
            this.authenticator = new SmtpAuthenticator(user, pwd);
        }
    }

    @Nullable
    public String getUser() {
        if (this.authenticator == null) {
            return null;
        }
        return this.authenticator.user;
    }

    @Nullable
    public String getPassword() {
        if (this.authenticator == null) {
            return null;
        }
        return this.authenticator.pwd;
    }

    @Override
    public void send(InternetAddress from, InternetAddress[] to, @Nullable InternetAddress[] cc, String subject, String body, @Nullable Serializable attachment, @Nullable String attachmentName) {
        if (OlapLoggers.NOTIFICATION.isDebugEnabled()) {
            OlapLoggers.NOTIFICATION.debug((Object)("[notification] (send-SMTP) alert eMail [" + subject + "] to " + Arrays.toString(to)));
        }
        Session session = Session.getDefaultInstance((Properties)this.smtpProperties, (Authenticator)this.authenticator);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)from);
            message.setRecipients(Message.RecipientType.TO, (Address[])to);
            if (cc != null && cc.length > 0) {
                message.setRecipients(Message.RecipientType.CC, (Address[])cc);
            }
            message.setSubject(subject);
            if (attachment == null) {
                message.setText(body);
            }
            if (attachment != null) {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart bodyPart = new MimeBodyPart();
                bodyPart.setText(body);
                multipart.addBodyPart((BodyPart)bodyPart);
                MimeBodyPart attachmentPart = new MimeBodyPart();
                if (attachment instanceof File) {
                    File reportFile = (File)attachment;
                    FileDataSource fds = new FileDataSource(reportFile);
                    attachmentPart.setDataHandler(new DataHandler((DataSource)fds));
                    attachmentPart.setFileName(attachmentName != null ? attachmentName : fds.getName());
                } else {
                    byte[] reportFile = (byte[])attachment;
                    ByteArrayDataSource fds = new ByteArrayDataSource(reportFile, "application/pdf");
                    attachmentPart.setDataHandler(new DataHandler((DataSource)fds));
                    attachmentPart.setFileName(attachmentName != null ? attachmentName : "report.pdf");
                }
                multipart.addBodyPart((BodyPart)attachmentPart);
                message.setContent((Multipart)multipart);
            }
            if (OlapLoggers.NOTIFICATION.isDebugEnabled()) {
                OlapLoggers.NOTIFICATION.debug((Object)("[notification] (send-SMTP-started) alert SMTP eMail [" + subject + "] to : " + Arrays.toString(to)));
            }
            Transport.send((Message)message);
            if (OlapLoggers.NOTIFICATION.isDebugEnabled()) {
                OlapLoggers.NOTIFICATION.debug((Object)("[notification] (send-SMTP-completed) alert SMTP eMail [" + subject + "] to : " + Arrays.toString(to)));
            }
        }
        catch (MessagingException ex) {
            OlapLoggers.NOTIFICATION.error((Object)"[notification] eMail error", (Throwable)ex);
        }
    }

    static class SmtpAuthenticator
    extends Authenticator {
        final String user;
        final String pwd;

        SmtpAuthenticator(String user, String pwd) {
            this.user = user;
            this.pwd = pwd;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.pwd);
        }
    }
}

