/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.notification.definition;

import crazydev.common.configuration.CdConfigurationUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="transporter")
public class OlapNotificationTransporterDefinition {
    @XmlElement(name="id", required=true)
    private String id;
    @XmlElement(name="service", required=true)
    private String service;
    @XmlElement(name="param", required=false)
    private List<Param> params;

    public void validate() throws OlapConfigurationException {
        if (CdStringUtils.isNullOrBlank((String)this.id)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"id"});
        }
        if (CdStringUtils.isNullOrBlank((String)this.service)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"service"});
        }
        if (this.params != null) {
            for (Param param : this.params) {
                param.value = CdConfigurationUtils.substVars((String)param.value);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getService() {
        return this.service;
    }

    public List<Param> getParams() {
        return this.params == null ? Collections.emptyList() : this.params;
    }

    public List<String> getConfigurationProperties() {
        ArrayList<String> names = new ArrayList<String>();
        for (Param param : this.getParams()) {
            names.add(param.getName());
        }
        return names;
    }

    @Nullable
    public String getConfigurationProperty(String name) {
        for (Param param : this.getParams()) {
            if (param.name == null || !param.name.equals(name)) continue;
            return param.value;
        }
        return null;
    }

    @XmlType(name="paramType", namespace="transporter")
    @XmlRootElement(name="param")
    public static class Param {
        @XmlElement(name="name", required=true)
        private String name;
        @XmlElement(name="value", required=true)
        private String value;

        public Param() {
        }

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

