/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.notification.definition;

import crazydev.common.configuration.CdConfigurationUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="transportService")
public class OlapNotificationTransportServiceDefinition {
    @XmlElement(name="id", required=true)
    private String id;
    @XmlElement(name="service-class", required=true)
    private String serviceClass;
    @XmlElement(name="param", required=false)
    private List<Param> params;

    public void validate() throws OlapConfigurationException {
        if (CdStringUtils.isNullOrBlank((String)this.id)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"id"});
        }
        if (CdStringUtils.isNullOrBlank((String)this.serviceClass)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"service-class"});
        }
        if (this.params != null) {
            for (Param param : this.params) {
                param.value = CdConfigurationUtils.substVars((String)param.value);
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getServiceClass() {
        return this.serviceClass.trim();
    }

    public List<Param> getParams() {
        return this.params == null ? Collections.emptyList() : this.params;
    }

    public void setParams(List<Param> params) {
        this.params = params;
    }

    public List<String> getConfigurationProperties() {
        ArrayList<String> names = new ArrayList<String>();
        for (Param param : this.getParams()) {
            names.add(param.getName());
        }
        return names;
    }

    @Nullable
    public String getConfigurationProperty(String name) {
        for (Param param : this.getParams()) {
            if (param.name == null || !param.name.equals(name)) continue;
            return param.value;
        }
        return null;
    }

    @XmlType(name="paramType", namespace="transportService")
    @XmlRootElement(name="param")
    public static class Param {
        @XmlElement(name="name", required=true)
        private String name;
        @XmlElement(name="value", required=true)
        private String value;

        public Param() {
        }

        public Param(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

