/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.notification;

import crazydev.iccube.notification.OlapNotification;
import crazydev.iccube.notification.OlapNotificationFilter;
import crazydev.iccube.notification.OlapNotificationServiceTransporter;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OlapNotificationServiceListener {
    @Nullable
    private final OlapNotificationFilter filter;
    private final List<OlapNotificationServiceTransporter> transporters;

    public OlapNotificationServiceListener(@Nullable OlapNotificationFilter filter, List<OlapNotificationServiceTransporter> transporters) {
        this.filter = filter;
        this.transporters = transporters;
        OlapLoggers.NOTIFICATION.info((Object)"[notification] listener registered");
        OlapLoggers.NOTIFICATION.info((Object)("[notification]         filter : " + OlapNotificationFilter.asLogInfo(filter)));
        for (OlapNotificationServiceTransporter transporter : transporters) {
            OlapLoggers.NOTIFICATION.info((Object)("[notification]    transporter : " + transporter.asLogInfo()));
        }
    }

    public void onNotification(OlapNotification notification) {
        try {
            if (this.filter == null || this.filter.accepts(notification)) {
                for (OlapNotificationServiceTransporter transporter : this.transporters) {
                    try {
                        transporter.handleNotification(notification);
                    }
                    catch (RuntimeException ex) {
                        OlapLoggers.NOTIFICATION.error((Object)("[notification] could not notify the transporter [" + transporter.getId() + "]"), (Throwable)ex);
                    }
                }
            }
        }
        catch (RuntimeException ex) {
            OlapLoggers.NOTIFICATION.error((Object)"[notification] could not notify the transporters", (Throwable)ex);
        }
    }
}

