/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mock.census;

import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryLineDataTable;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.OlapBuilderProperty;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderBaseDimension;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderMultiLevelHierarchy;
import crazydev.iccube.mock.census.OlapCensusCube;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import java.util.Arrays;
import java.util.List;

public abstract class OlapCensusPeople {
    public static final String PEOPLE_KEY0 = "Key0 People";
    public static final String PEOPLE_KEY1 = "Key1 People";
    public static IOlapBuilderDimensionDef<IOlapBuilderHierarchyDef> peopleDim;
    public static OlapBuilderHierarchyLevel peopleLevel;
    public static OlapDimension DIMENSION;
    public static OlapHierarchy HPEOPLE;
    public static OlapLevel LPEOPLE;
    public static OlapMember DEFAULT;
    public static OlapMember MARC;
    public static OlapMember MARINA;
    public static OlapMember ANAIS;
    public static OlapMember WILLIAM;

    public static void createDefinitions() {
        String peopleData = "Marc [x], Marc KEY0    , Marc KEY1     ,    \nMarina  , Marina KEY0  , Marina KEY1   , marina@planet.com \nAnais   , Anais KEY0   , Anais KEY1    , anais@planet.com  \nWilliam , William KEY0 , William KEY1  ,                   \n";
        String PEOPLE_NAME = "Name";
        String PEOPLE_EMAIL = "E-Mail";
        List<IOlapBuilderDataColumnDef> columns = OlapBuilderDataColumn.createStringColumns("Name", PEOPLE_KEY0, PEOPLE_KEY1, "E-Mail");
        OlapBuilderInMemoryLineDataTable peopleTable = OlapBuilderInMemoryLineDataTable.__createWithColumns(OlapCensusCube.ds, "People Data", "Marc [x], Marc KEY0    , Marc KEY1     ,    \nMarina  , Marina KEY0  , Marina KEY1   , marina@planet.com \nAnais   , Anais KEY0   , Anais KEY1    , anais@planet.com  \nWilliam , William KEY0 , William KEY1  ,                   \n", ",", columns);
        peopleLevel = new OlapBuilderHierarchyLevel("L-People", null, null, false, false, Arrays.asList(peopleTable.getSelectedColumn(PEOPLE_KEY0), peopleTable.getSelectedColumn(PEOPLE_KEY1)), peopleTable.getSelectedColumn("Name"), Arrays.asList(OlapBuilderProperty.createProperty("E-Mail", peopleTable.getSelectedColumn("E-Mail"))));
        OlapBuilderMultiLevelHierarchy peopleHierarchy = new OlapBuilderMultiLevelHierarchy("H-People", true, peopleLevel);
        peopleDim = OlapBuilderBaseDimension.createMultiLevelDimension((IOlapBuilderTabularDataDef)peopleTable, "People", "Census.People", peopleHierarchy);
    }

    public static void initStatics(OlapNameContext nameContext, OlapCube cube) {
        DIMENSION = cube.lookupDimensionByName(nameContext, peopleDim.getName());
        HPEOPLE = DIMENSION.getBaseHierarchy();
        LPEOPLE = HPEOPLE.unfilteredLookupLevelByName(nameContext, "L-People");
        DEFAULT = MARC = LPEOPLE.unfilteredLookupMemberByName(nameContext, "Marc [x]");
        MARINA = LPEOPLE.unfilteredLookupMemberByName(nameContext, "Marina");
        ANAIS = LPEOPLE.unfilteredLookupMemberByName(nameContext, "Anais");
        WILLIAM = LPEOPLE.unfilteredLookupMemberByName(nameContext, "William");
        DIMENSION.validateConsistency(new OlapBuilderErrorManager());
    }
}

