/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mock.census;

import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryLineDataTable;
import crazydev.iccube.builder.errors.OlapBuilderErrorManager;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderDimensionDef;
import crazydev.iccube.builder.model.def.IOlapBuilderHierarchyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderPropertyDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTabularDataDef;
import crazydev.iccube.builder.model.impl.OlapBuilderAllLevelParsedDefinition;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.OlapBuilderProperty;
import crazydev.iccube.builder.model.impl.dimension.OlapBuilderBaseDimension;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderHierarchyLevel;
import crazydev.iccube.builder.model.impl.hierarchy.OlapBuilderMultiLevelHierarchy;
import crazydev.iccube.mock.census.OlapCensusCube;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMember;
import java.util.List;

public abstract class OlapCensusLocation {
    public static final String C_BRGY_KEY = "Key Barangay";
    public static IOlapBuilderDimensionDef<IOlapBuilderHierarchyDef> locationDim;
    public static OlapBuilderHierarchyLevel brgyLevel;
    public static OlapDimension DIMENSION;
    public static OlapHierarchy ADMIN;
    public static OlapLevel ALL_LEVEL;
    public static OlapMember ALL;
    public static OlapMember DEFAULT;
    public static OlapLevel REGION;
    public static OlapMember REGION_IX;
    public static OlapMember REGION_X;
    public static OlapMember REGION_XI;
    public static OlapLevel CITY;
    public static OlapMember CAGAYAN_DE_ORO;
    public static OlapMember BUTUAN;
    public static OlapLevel BARANGAY;
    public static OlapMember CAGAYAN_DE_ORO_BRGY_22;
    public static OlapMember CAGAYAN_DE_ORO_BRGY_23;
    public static OlapMember CAGAYAN_DE_ORO_BRGY_24;
    public static OlapMember BUTUAN_BRGY_01;
    public static OlapMember BUTUAN_BRGY_02;
    public static OlapMember OPOL_BRGY_00;
    public static OlapHierarchy PHYS;
    public static OlapMember PHYS_ALL;
    public static OlapLevel PHYS_ISLAND;
    public static OlapMember PHYS_CAMIGUIN;
    public static OlapMember PHYS_MINDANAO;
    public static OlapLevel PHYS_CITY;
    public static OlapMember PHYS_CAGAYAN_DE_ORO;
    public static OlapMember PHYS_BUTUAN;

    public static void createDefinitions() {
        String adminData = "Region IX , Region IX KEY ,                ,                    ,                    ,       ,                         ,                             ,          ,       ,          ,              \nRegion X  , Region X KEY  , Cagayan de Oro , Cagayan de Oro KEY , Constantino Jarula , Type 1, Cagayan de Oro Brgy. 22 , Cagayan de Oro Brgy. 22 KEY , Emilio Uy, Type 2, Mindanao , Mindanao KEY \nRegion X  , Region X KEY  , Cagayan de Oro , Cagayan de Oro KEY , Constantino Jarula , Type 1, Cagayan de Oro Brgy. 23 , Cagayan de Oro Brgy. 23 KEY ,          ,       , Mindanao , Mindanao KEY \nRegion X  , Region X KEY  , Cagayan de Oro , Cagayan de Oro KEY , Constantino Jarula , Type 1, Cagayan de Oro Brgy. 24 , Cagayan de Oro Brgy. 24 KEY ,          ,       , Mindanao , Mindanao KEY \nRegion X  , Region X KEY  , Butuan         , Butuan KEY         ,                    ,       , Butuan Brgy. 01         , Butuan Brgy. 01 KEY         ,          ,       , Mindanao , Mindanao KEY \nRegion X  , Region X KEY  , Butuan         , Butuan KEY         ,                    ,       , Butuan Brgy. 02         , Butuan Brgy. 02 KEY         ,          ,       , Mindanao , Mindanao KEY \nRegion X  , Region X KEY  ,                ,                    ,                    ,       , Opol Brgy. 00           , Opol Brgy. 00 KEY           ,          ,       , Mindanao , Mindanao KEY \nRegion XI , Region XI KEY ,                ,                    ,                    ,       ,                         ,                             ,          ,       ,          ,              \n          ,               ,                ,                    ,                    ,       ,                         ,                             ,          ,       , Camiguin , Camiguin KEY \n";
        String C_REGION = "Region";
        String C_REGION_KEY = "Key Region";
        String C_CITY = "City";
        String C_CITY_KEY = "Key City";
        String C_CITY_MAYOR = "Mayor";
        String C_CITY_GOV_TYPE = "City Gov. Type";
        String C_BRGY = "Barangay";
        String C_BRGY_CAPTAIN = "Captain";
        String C_BRGY_GOV_TYPE = "Brgy. Gov. Type";
        String C_ISLAND = "Island";
        String C_ISLAND_KEY = "Key Island";
        List<IOlapBuilderDataColumnDef> columns = OlapBuilderDataColumn.createStringColumns("Region", "Key Region", "City", "Key City", "Mayor", "City Gov. Type", "Barangay", C_BRGY_KEY, "Captain", "Brgy. Gov. Type", "Island", "Key Island");
        OlapBuilderInMemoryLineDataTable adminTable = OlapBuilderInMemoryLineDataTable.__createWithColumns(OlapCensusCube.ds, "Admin Data", "Region IX , Region IX KEY ,                ,                    ,                    ,       ,                         ,                             ,          ,       ,          ,              \nRegion X  , Region X KEY  , Cagayan de Oro , Cagayan de Oro KEY , Constantino Jarula , Type 1, Cagayan de Oro Brgy. 22 , Cagayan de Oro Brgy. 22 KEY , Emilio Uy, Type 2, Mindanao , Mindanao KEY \nRegion X  , Region X KEY  , Cagayan de Oro , Cagayan de Oro KEY , Constantino Jarula , Type 1, Cagayan de Oro Brgy. 23 , Cagayan de Oro Brgy. 23 KEY ,          ,       , Mindanao , Mindanao KEY \nRegion X  , Region X KEY  , Cagayan de Oro , Cagayan de Oro KEY , Constantino Jarula , Type 1, Cagayan de Oro Brgy. 24 , Cagayan de Oro Brgy. 24 KEY ,          ,       , Mindanao , Mindanao KEY \nRegion X  , Region X KEY  , Butuan         , Butuan KEY         ,                    ,       , Butuan Brgy. 01         , Butuan Brgy. 01 KEY         ,          ,       , Mindanao , Mindanao KEY \nRegion X  , Region X KEY  , Butuan         , Butuan KEY         ,                    ,       , Butuan Brgy. 02         , Butuan Brgy. 02 KEY         ,          ,       , Mindanao , Mindanao KEY \nRegion X  , Region X KEY  ,                ,                    ,                    ,       , Opol Brgy. 00           , Opol Brgy. 00 KEY           ,          ,       , Mindanao , Mindanao KEY \nRegion XI , Region XI KEY ,                ,                    ,                    ,       ,                         ,                             ,          ,       ,          ,              \n          ,               ,                ,                    ,                    ,       ,                         ,                             ,          ,       , Camiguin , Camiguin KEY \n", ",", columns);
        OlapBuilderHierarchyLevel regionLevel = new OlapBuilderHierarchyLevel("Region", null, adminTable.getSelectedColumn("Region"), adminTable.getSelectedColumn("Key Region"), new IOlapBuilderPropertyDef[0]);
        OlapBuilderHierarchyLevel cityLevel = new OlapBuilderHierarchyLevel("City", null, adminTable.getSelectedColumn("City"), adminTable.getSelectedColumn("Key City"), OlapBuilderProperty.createProperty("Mayor", adminTable.getSelectedColumn("Mayor")), OlapBuilderProperty.createProperty("Gov. Type", adminTable.getSelectedColumn("City Gov. Type")));
        brgyLevel = new OlapBuilderHierarchyLevel("Barangay", null, adminTable.getSelectedColumn("Barangay"), adminTable.getSelectedColumn(C_BRGY_KEY), OlapBuilderProperty.createProperty("Captain", adminTable.getSelectedColumn("Captain")), OlapBuilderProperty.createProperty("Gov. Type", adminTable.getSelectedColumn("Brgy. Gov. Type")));
        OlapBuilderMultiLevelHierarchy adminHierarchy = new OlapBuilderMultiLevelHierarchy("Admin", true, OlapBuilderAllLevelParsedDefinition.create(null, "Philippines"), regionLevel, cityLevel, brgyLevel);
        OlapBuilderHierarchyLevel islandLevel = new OlapBuilderHierarchyLevel("Island", null, adminTable.getSelectedColumn("Island"), adminTable.getSelectedColumn("Key Island"), new IOlapBuilderPropertyDef[0]);
        OlapBuilderMultiLevelHierarchy physHierarchy = new OlapBuilderMultiLevelHierarchy("Physical H.", false, OlapBuilderAllLevelParsedDefinition.create(null, "Philippines"), islandLevel, cityLevel);
        locationDim = OlapBuilderBaseDimension.createMultiLevelDimension((IOlapBuilderTabularDataDef)adminTable, "Location", "Census.Location", adminHierarchy, physHierarchy);
    }

    public static void initStatics(OlapNameContext nameContext, OlapCube cube) {
        DIMENSION = cube.lookupDimensionByName(nameContext, locationDim.getName());
        ADMIN = DIMENSION.getBaseHierarchy();
        ALL_LEVEL = ADMIN.getAllLevel();
        DEFAULT = ALL = ADMIN.getAllMember();
        ADMIN.setDefaultMember(DEFAULT);
        REGION = ADMIN.getLevels().get(1);
        REGION_IX = REGION.unfilteredLookupMemberByName(nameContext, "Region IX");
        REGION_X = REGION.unfilteredLookupMemberByName(nameContext, "Region X");
        REGION_XI = REGION.unfilteredLookupMemberByName(nameContext, "Region XI");
        CITY = ADMIN.getLevels().get(2);
        CAGAYAN_DE_ORO = CITY.unfilteredLookupMemberByName(nameContext, "Cagayan de Oro");
        BUTUAN = CITY.unfilteredLookupMemberByName(nameContext, "Butuan");
        BARANGAY = ADMIN.getLevels().get(3);
        CAGAYAN_DE_ORO_BRGY_22 = BARANGAY.unfilteredLookupMemberByName(nameContext, "Cagayan de Oro Brgy. 22");
        CAGAYAN_DE_ORO_BRGY_23 = BARANGAY.unfilteredLookupMemberByName(nameContext, "Cagayan de Oro Brgy. 23");
        CAGAYAN_DE_ORO_BRGY_24 = BARANGAY.unfilteredLookupMemberByName(nameContext, "Cagayan de Oro Brgy. 24");
        BUTUAN_BRGY_01 = BARANGAY.unfilteredLookupMemberByName(nameContext, "Butuan Brgy. 01");
        BUTUAN_BRGY_02 = BARANGAY.unfilteredLookupMemberByName(nameContext, "Butuan Brgy. 02");
        OPOL_BRGY_00 = BARANGAY.unfilteredLookupMemberByName(nameContext, "Opol Brgy. 00");
        PHYS = DIMENSION.lookupHierarchyByName(nameContext, "Physical H.");
        PHYS_ALL = PHYS.getAllMember();
        PHYS.setDefaultMember(PHYS_ALL);
        PHYS_ISLAND = PHYS.unfilteredLookupLevelByName(nameContext, "Island");
        PHYS_CAMIGUIN = PHYS_ISLAND.unfilteredLookupMemberByName(nameContext, "Camiguin");
        PHYS_MINDANAO = PHYS_ISLAND.unfilteredLookupMemberByName(nameContext, "Mindanao");
        PHYS_CITY = PHYS.unfilteredLookupLevelByName(nameContext, "City");
        PHYS_CAGAYAN_DE_ORO = PHYS_CITY.unfilteredLookupMemberByName(nameContext, "Cagayan de Oro");
        PHYS_BUTUAN = PHYS_CITY.unfilteredLookupMemberByName(nameContext, "Butuan");
        DIMENSION.validateConsistency(new OlapBuilderErrorManager());
    }
}

