/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mock.census;

import crazydev.iccube.builder.datasource.facts.OlapBuilderFacts;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryDataSource;
import crazydev.iccube.builder.datasource.memory.OlapBuilderInMemoryLineDataTable;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.OlapBuilderCube;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.model.impl.OlapBuilderDataViewLinks;
import crazydev.iccube.builder.model.impl.OlapBuilderHeaderCube;
import crazydev.iccube.builder.model.impl.OlapBuilderMeasure;
import crazydev.iccube.enums.OlapAggregationType;
import crazydev.iccube.enums.OlapLevelType;
import crazydev.iccube.mock.census.OlapCensusLocation;
import crazydev.iccube.mock.census.OlapCensusMeasures;
import crazydev.iccube.mock.census.OlapCensusPeople;
import crazydev.iccube.mock.census.OlapCensusStatistics;
import crazydev.iccube.mock.census.OlapCensusTime;
import crazydev.iccube.olap.component.naming.OlapDefaultNamesContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.id.OlapEntityIdentifier;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.schema.OlapSchema;
import java.util.Arrays;
import java.util.List;

public class OlapCensusCube
extends OlapBuilderHeaderCube {
    public static final String CENSUS_CUBE_NAME = "Census";
    public static OlapBuilderCube censusCube;
    public static OlapCube INSTANCE;
    public static OlapMember CALC_MEASURES_AGE;
    public static OlapMember STATS_OPPOSITE;
    public static OlapBuilderInMemoryDataSource ds;

    public OlapCensusCube() {
        this("2000-01-01, Cagayan de Oro Brgy. 22 KEY, Marc KEY0    , Marc KEY1    , 1.1 ,     , 1.1 \n2000-01-01, Cagayan de Oro Brgy. 22 KEY, Marina KEY0  , Marina KEY1  , 1.2 ,     , 1.2 \n2000-01-01, Cagayan de Oro Brgy. 22 KEY, Anais KEY0   , Anais KEY1   ,     , 2.2 ,     \n2000-01-01, Cagayan de Oro Brgy. 22 KEY, William KEY0 , William KEY1 ,     , 2.3 ,     \n");
    }

    protected OlapCensusCube(String censusFactsData) {
        super(CENSUS_CUBE_NAME, "Testing cube", OlapCensusCube.setupFactsSource(censusFactsData));
        this.addDimension(OlapCensusPeople.peopleDim);
        this.addDimension(OlapCensusLocation.locationDim);
        this.addDimension(OlapCensusTime.timeDimension);
        this.addCalcMember("[Measures].[Age (cube)]", " - [Measures].[Age]", "BACK_COLOR = '222'");
        this.addDimension(OlapCensusStatistics.statsDim);
        this.addCalcMember("[Stats].[Opposite]", " - ( [Stats].DefaultMember, [Measures].CurrentMember )");
        this.addDataSource(ds);
        censusCube = this;
    }

    private static OlapBuilderFacts setupFactsSource(String censusFactsData) {
        ds = new OlapBuilderInMemoryDataSource("Census DS");
        OlapCensusLocation.createDefinitions();
        OlapCensusPeople.createDefinitions();
        OlapCensusTime.createDefinitions();
        OlapCensusStatistics.createDefinitions();
        String C_TIME_KEY = OlapLevelType.MONTH.getName();
        String C_BARANGAY_KEY = "Key Barangay";
        String C_PEOPLE_KEY0 = "Key0 People";
        String C_PEOPLE_KEY1 = "Key1 People";
        String C_MEASURE_AGE = "AGE";
        String C_MEASURE_SIZE = "SIZE";
        String C_MEASURE_MAX_AGE = "MAX-AGE";
        List<IOlapBuilderDataColumnDef> columns = Arrays.asList(OlapBuilderDataColumn.createDateColumn(C_TIME_KEY), OlapBuilderDataColumn.createStringColumn("Key Barangay"), OlapBuilderDataColumn.createStringColumn("Key0 People"), OlapBuilderDataColumn.createStringColumn("Key1 People"), OlapBuilderDataColumn.createDoubleColumn("AGE"), OlapBuilderDataColumn.createDoubleColumn("SIZE"), OlapBuilderDataColumn.createDoubleColumn("MAX-AGE"));
        OlapBuilderInMemoryLineDataTable censusFactsDataTable = OlapBuilderInMemoryLineDataTable.__createWithColumns(ds, "Census Facts Data", censusFactsData, ",", columns);
        OlapBuilderMeasure age = new OlapBuilderMeasure("Age", OlapAggregationType.SUM, censusFactsDataTable.getSelectedColumn("AGE"), "BACK_COLOR = 255");
        OlapBuilderMeasure size = new OlapBuilderMeasure("Size", OlapAggregationType.SUM, censusFactsDataTable.getSelectedColumn("SIZE"));
        OlapBuilderMeasure minAge = new OlapBuilderMeasure("Max-Age", OlapAggregationType.MAX, censusFactsDataTable.getSelectedColumn("MAX-AGE"));
        OlapBuilderFacts<OlapBuilderInMemoryLineDataTable> censusFactsSource = new OlapBuilderFacts<OlapBuilderInMemoryLineDataTable>(censusFactsDataTable, age, size, minAge);
        censusFactsSource.addLink(OlapCensusPeople.peopleDim, OlapBuilderDataViewLinks.createSymmetricalLink(censusFactsDataTable.getSelectedColumn("Key0 People"), censusFactsDataTable.getSelectedColumn("Key1 People")));
        censusFactsSource.addLink(OlapCensusLocation.locationDim, OlapBuilderDataViewLinks.createSymmetricalLink(censusFactsDataTable.getSelectedColumn("Key Barangay")));
        censusFactsSource.addLink(OlapCensusTime.timeDimension, OlapBuilderDataViewLinks.createSymmetricalLink(censusFactsDataTable.getSelectedColumn(C_TIME_KEY)));
        return censusFactsSource;
    }

    public static void initStaticFields(OlapSchema schema) {
        OlapDefaultNamesContext nameContext = OlapDefaultNamesContext.SINGLETON;
        INSTANCE = schema.lookupCubeByName(nameContext, censusCube.getName());
        OlapCubeCalculatedMemberManager cmembers = INSTANCE.getCalcMemberManager();
        CALC_MEASURES_AGE = ((OlapCalculatedMemberManager)cmembers).lookupCalculatedMember(nameContext, new OlapEntityIdentifier("Measures", "Age (cube)"));
        if (CALC_MEASURES_AGE == null) {
            throw new RuntimeException("Missing MEASURES_AGE!");
        }
        OlapCensusMeasures.initStatics(nameContext, INSTANCE);
        OlapCensusTime.initStatics(nameContext, INSTANCE);
        OlapCensusLocation.initStatics(nameContext, INSTANCE);
        OlapCensusPeople.initStatics(nameContext, INSTANCE);
        OlapCubeCalculatedMemberManager schemaCalcMemberManager = INSTANCE.getCalcMemberManager();
        STATS_OPPOSITE = ((OlapCalculatedMemberManager)schemaCalcMemberManager).lookupCalculatedMember(nameContext, new OlapEntityIdentifier("Stats", "Opposite"));
        OlapCensusStatistics.initStatics(nameContext, INSTANCE);
    }
}

