/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.exception;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.error.CdMdxErrorLocation;
import crazydev.common.mdx.scanner.CdMdxToken;
import java.io.Serializable;

public class MdxParserTokenLocationRange
extends CdMdxErrorLocation
implements Comparable<MdxParserTokenLocationRange>,
Serializable {
    private static final long serialVersionUID = -5006906967373531293L;
    private final String mdx;
    private final String mdxHash;
    private int from;
    private int to;
    private int lineNumber;

    public MdxParserTokenLocationRange(CdMdxToken token) {
        this(token.getLocation().mdx(), token.getLocation().mdxHash(), token.getLocation().offset(), token.getLocation().offset() + token.getLexeme().length() - 1, token.getLocation().lineNumber());
    }

    private MdxParserTokenLocationRange(String mdx, String mdxHash, int from, int to, int lineNumber) {
        this.mdx = mdx;
        this.mdxHash = mdxHash;
        this.from = from;
        this.to = to;
        this.lineNumber = lineNumber;
    }

    public String mdx() {
        return this.mdx;
    }

    public String mdxHash() {
        return this.mdxHash;
    }

    public int from() {
        return this.from;
    }

    public int to() {
        return this.to;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    @Override
    public int compareTo(MdxParserTokenLocationRange other) {
        int thisOffset = this.from;
        int otherOffset = other.from;
        return thisOffset < otherOffset ? -1 : (thisOffset == otherOffset ? 0 : 1);
    }

    public void updateLocationRange(int from, int to) {
        this.from = from;
        this.to = to;
    }

    public boolean equals(Object o) {
        throw new CdProgrammingException();
    }

    public int hashCode() {
        throw new CdProgrammingException();
    }

    public String asString(CdBabylonService babylon) {
        return "line:" + this.lineNumber;
    }
}

