/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.excel;

import crazydev.common.mdx.scanner.CdMdxScanner;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.CdMdxTokenKind;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.mdx.scanner.token.CdMdxDelimitedIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxRegularIdentifierToken;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdxExcelFixDotMembers {
    @Nullable
    public static String fixMdxStatement(MdxParsingContext context, String mdx, String mdxHash) throws CdMdxScannerException {
        CdMdxScanner scanner = new CdMdxScanner();
        List tokens = scanner.scan(mdx, mdxHash);
        ArrayList<String> levelUniqueNames = new ArrayList<String>();
        for (int idx = 0; idx < tokens.size(); ++idx) {
            CdMdxToken token = (CdMdxToken)tokens.get(idx);
            if (!MdxExcelFixDotMembers.isIdentifier("Members", token) || idx <= 1 || ((CdMdxToken)tokens.get(idx - 1)).getKind() != CdMdxTokenKind.DOT || ((CdMdxToken)tokens.get(idx - 2)).getKind() != CdMdxTokenKind.WHITE_SPACES || ((CdMdxToken)tokens.get(idx - 3)).getKind() != CdMdxTokenKind.COMMA) continue;
            String levelUniqueName = MdxExcelFixDotMembers.extractLevelUniqueName(tokens, idx);
            if (levelUniqueName == null) {
                return null;
            }
            levelUniqueNames.add(levelUniqueName);
        }
        if (levelUniqueNames.isEmpty()) {
            return null;
        }
        String fixedMdx = mdx;
        for (String levelUniqueName : levelUniqueNames) {
            fixedMdx = fixedMdx.replaceFirst(", \\.Members", ", " + levelUniqueName + ".Members");
        }
        return fixedMdx;
    }

    @Nullable
    private static String extractLevelUniqueName(List<CdMdxToken> tokens, int dotMembersPos) {
        ArrayList<CdMdxDelimitedIdentifierToken> levelUniqueName = new ArrayList<CdMdxDelimitedIdentifierToken>();
        boolean inLevelUniqueName = false;
        for (int pos = dotMembersPos - 1; pos > 0; --pos) {
            CdMdxToken token = tokens.get(pos);
            if (!inLevelUniqueName) {
                if (!MdxExcelFixDotMembers.isIdentifier("Members", token)) continue;
                inLevelUniqueName = true;
                continue;
            }
            if (MdxExcelFixDotMembers.isIdentifier("Except", token)) break;
            if (!(token instanceof CdMdxDelimitedIdentifierToken)) continue;
            levelUniqueName.add(0, (CdMdxDelimitedIdentifierToken)token);
        }
        if (levelUniqueName.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (CdMdxDelimitedIdentifierToken token : levelUniqueName) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(token.getLexeme());
        }
        return sb.toString();
    }

    private static boolean isIdentifier(String id, CdMdxToken token) {
        if (token instanceof CdMdxRegularIdentifierToken) {
            CdMdxRegularIdentifierToken xtoken = (CdMdxRegularIdentifierToken)token;
            return xtoken.getIdentifier().equals(id);
        }
        return false;
    }
}

