/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.select;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxNamedSetIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectSetProperties;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectWithClause;
import org.jetbrains.annotations.Nullable;

public class MdxSelectNamedSet
extends MdxSelectWithClause {
    private final CdMdxToken set;
    private final MdxNamedSetIdentifierExpression id;
    private final MdxExpression formula;
    private final boolean dynamicEvaluation;
    @Nullable
    private final MdxSelectSetProperties properties;

    public MdxSelectNamedSet(CdMdxToken set, MdxNamedSetIdentifierExpression id, MdxExpression formula, boolean dynamicEvaluation, @Nullable MdxSelectSetProperties properties) {
        this.set = set;
        this.id = id;
        this.formula = formula;
        this.dynamicEvaluation = dynamicEvaluation;
        this.properties = properties;
    }

    @Override
    public CdMdxToken getFirstToken() {
        return this.set;
    }

    @Override
    public CdMdxToken getLastToken() {
        if (this.properties != null) {
            return this.properties.getLastToken();
        }
        return this.formula.getLastToken();
    }

    public MdxNamedSetIdentifierExpression getId() {
        return this.id;
    }

    @Nullable
    public String getCubeName() {
        return this.id.getCubeName();
    }

    public String getSetName() {
        return this.id.getSetName();
    }

    public String getMdx() {
        return this.formula.asMdx();
    }

    public MdxExpression getFormula() {
        return this.formula;
    }

    public boolean isDynamicEvaluation() {
        return this.dynamicEvaluation;
    }

    @Nullable
    public String getDisplayFolder() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getDisplayFolder();
    }

    @Nullable
    public String getDescription() {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getDescription();
    }

    @Override
    public String toString() {
        return this.id.toString() + " AS ...";
    }
}

