/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.select;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectEntity;

public abstract class MdxSelectMemberProperty
extends MdxSelectEntity {
    private final MdxIdentifierExpression name;
    private final MdxExpression value;

    public MdxSelectMemberProperty(MdxIdentifierExpression name, MdxExpression value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public CdMdxToken getFirstToken() {
        return this.name.getFirstToken();
    }

    @Override
    public CdMdxToken getLastToken() {
        return this.value.getLastToken();
    }

    public MdxIdentifierExpression getName() {
        return this.name;
    }

    public String getResolvedName() {
        if (this.name.getPartCount() != 1) {
            throw new CdProgrammingException("Invalid member property name [" + String.valueOf(this.name) + "]");
        }
        return this.name.getParts().get(0).getIdentifier();
    }

    public MdxExpression getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "[name:" + this.name.toString() + "][value:" + this.value.toString() + "]";
    }
}

