/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.select;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectMeasureProperties;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectMeasureProperty;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectWithClause;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdxSelectMeasure
extends MdxSelectWithClause {
    private final boolean definedAtSelectLevel;
    private final CdMdxToken firstToken;
    @Nullable
    private final String cubeName;
    private final String measureName;
    private final MdxIdentifierExpression id;
    private final MdxExpression formula;
    private final MdxSelectMeasureProperties properties;

    public MdxSelectMeasure(boolean definedAtSelectLevel, CdMdxToken firstToken, @Nullable String cubeName, String measureName, MdxIdentifierExpression id, MdxExpression formula, MdxSelectMeasureProperties properties) {
        this.definedAtSelectLevel = definedAtSelectLevel;
        this.firstToken = firstToken;
        this.cubeName = cubeName;
        this.measureName = measureName;
        this.id = id;
        this.formula = formula;
        this.properties = properties;
    }

    @Override
    public CdMdxToken getFirstToken() {
        return this.firstToken;
    }

    @Override
    public CdMdxToken getLastToken() {
        if (this.properties == null) {
            return this.formula.getLastToken();
        }
        List xproperties = this.properties.getProperties();
        MdxSelectMeasureProperty property = (MdxSelectMeasureProperty)xproperties.get(xproperties.size() - 1);
        return property.getLastToken();
    }

    public boolean isDefinedAtSelectLevel() {
        return this.definedAtSelectLevel;
    }

    @Nullable
    public String getCubeName() {
        return this.cubeName;
    }

    public String getMeasureName() {
        return this.measureName;
    }

    public MdxIdentifierExpression getId() {
        return this.id;
    }

    public MdxExpression getFormula() {
        return this.formula;
    }

    public MdxSelectMeasureProperties getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return this.id.toString() + " AS ...";
    }
}

