/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.expression.set;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdxSetExpression
extends MdxExpression {
    private final CdMdxToken open;
    private final CdMdxToken close;
    private final List<MdxExpression> exprs;

    public MdxSetExpression(CdMdxToken open, CdMdxToken close, List<MdxExpression> exprs) {
        this.open = open;
        this.close = close;
        this.exprs = exprs == null ? Collections.emptyList() : exprs;
    }

    @Override
    public List<MdxExpression> getChildren() {
        ArrayList<MdxExpression> children = new ArrayList<MdxExpression>();
        for (MdxExpression expr : this.exprs) {
            children.add(expr);
        }
        return children;
    }

    @Override
    public CdMdxToken getFirstToken() {
        return this.open;
    }

    @Override
    protected CdMdxToken doGetLastToken() {
        return this.close;
    }

    public List<MdxExpression> getExprs() {
        return this.exprs;
    }

    @Override
    @Nullable
    public List<String> extractMeasures() {
        ArrayList<String> measures = null;
        for (MdxExpression expr : this.exprs) {
            List<String> extracted = expr.extractMeasures();
            if (extracted == null || extracted.isEmpty()) continue;
            if (measures == null) {
                measures = new ArrayList<String>();
            }
            measures.addAll(extracted);
        }
        return measures;
    }

    public String toString() {
        return "{ ... }";
    }
}

