/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.expression.scase;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class MdxCaseExpression
extends MdxExpression {
    private final CdMdxToken xcase;
    private final CdMdxToken xend;
    private final List<WhenThen> whenThens;
    @Nullable
    private final MdxExpression elseResult;

    public MdxCaseExpression(CdMdxToken xcase, CdMdxToken xend, List<WhenThen> whenThens, @Nullable MdxExpression elseResult) {
        this.xcase = xcase;
        this.xend = xend;
        this.whenThens = whenThens;
        this.elseResult = elseResult;
    }

    @Override
    public List<MdxExpression> getChildren() {
        ArrayList<MdxExpression> children = new ArrayList<MdxExpression>();
        for (WhenThen whenThen : this.whenThens) {
            children.add(whenThen.when);
            children.add(whenThen.then);
        }
        return children;
    }

    @Override
    public CdMdxToken getFirstToken() {
        return this.xcase;
    }

    @Override
    protected CdMdxToken doGetLastToken() {
        return this.xend;
    }

    public List<WhenThen> getWhenThens() {
        return this.whenThens;
    }

    @Nullable
    public MdxExpression getElseResult() {
        return this.elseResult;
    }

    public String toString() {
        return "CASE( ... )";
    }

    public static class WhenThen {
        public final MdxExpression when;
        public final MdxExpression then;

        public WhenThen(MdxExpression when, MdxExpression then) {
            this.when = when;
            this.then = then;
        }
    }
}

