/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.expression.perspective;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveStatement;
import java.util.ArrayList;
import java.util.List;

public class MdxPerspectiveExpression
extends MdxExpression {
    private final List<MdxPerspectiveStatement> statements;

    public MdxPerspectiveExpression(List<MdxPerspectiveStatement> statements) {
        this.statements = statements;
        if (statements.isEmpty()) {
            throw new CdProgrammingException("internal error: missing perspective statements");
        }
    }

    @Override
    public CdMdxToken getFirstToken() {
        if (this.statements.isEmpty()) {
            throw new CdProgrammingException("internal error: missing perspective statements");
        }
        MdxPerspectiveStatement statement = this.statements.get(0);
        return statement.getFirstToken();
    }

    @Override
    protected CdMdxToken doGetLastToken() {
        if (this.statements.isEmpty()) {
            throw new CdProgrammingException("internal error: missing perspective statements");
        }
        MdxPerspectiveStatement statement = this.statements.get(this.statements.size() - 1);
        return statement.getLastToken();
    }

    @Override
    public List<MdxExpression> getChildren() {
        ArrayList<MdxExpression> children = new ArrayList<MdxExpression>();
        for (MdxPerspectiveStatement statement : this.statements) {
            statement.getMdxExpressionChildren(children);
        }
        return children;
    }

    public List<MdxPerspectiveStatement> getStatements() {
        return this.statements;
    }
}

