/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.expression.operator;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.CdMdxTokenKind;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.operator.MdxOperatorCallExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdxBinaryOperatorCallExpression
extends MdxOperatorCallExpression {
    private final MdxExpression left;
    private final MdxExpression right;

    public MdxBinaryOperatorCallExpression(CdMdxToken operator, MdxExpression left, MdxExpression right) {
        this(operator, null, left, right);
    }

    public MdxBinaryOperatorCallExpression(CdMdxToken token1, @Nullable CdMdxToken token2, MdxExpression left, MdxExpression right) {
        super(token1, token2);
        this.left = left;
        this.right = right;
    }

    @Override
    public List<MdxExpression> getChildren() {
        ArrayList<MdxExpression> children = new ArrayList<MdxExpression>();
        children.add(this.left);
        children.add(this.right);
        return children;
    }

    @Override
    public CdMdxToken getFirstToken() {
        return this.left.getFirstToken();
    }

    @Override
    protected CdMdxToken doGetLastToken() {
        return this.right.getLastToken();
    }

    public MdxExpression left() {
        return this.left;
    }

    public MdxExpression right() {
        return this.right;
    }

    @Override
    @Nullable
    public List<String> extractMeasures() {
        ArrayList<String> measures = null;
        if (CdMdxTokenKind.MULTIPLY.equals((Object)this.token1.getKind())) {
            List<String> extractedR;
            List<String> extractedL = this.left.extractMeasures();
            if (extractedL != null && !extractedL.isEmpty()) {
                measures = new ArrayList<String>(extractedL);
            }
            if ((extractedR = this.right.extractMeasures()) != null && !extractedR.isEmpty()) {
                if (measures == null) {
                    measures = new ArrayList();
                }
                measures.addAll(extractedR);
            }
        }
        return measures;
    }
}

