/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.expression.drillthrough;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.token.CdMdxStringToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.drillthrough.MdxDrillthroughReturnExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdxDrillthroughFunctionReturnExpression
extends MdxDrillthroughReturnExpression {
    private final MdxIdentifierExpression identifier;
    private final String name;
    private final CdMdxToken openParen;
    private final List<MdxExpression> arguments;
    private final CdMdxToken closeParen;
    @Nullable
    private final CdMdxStringToken userDefinedNameToken;

    public MdxDrillthroughFunctionReturnExpression(MdxIdentifierExpression identifier, String name, CdMdxToken openParen, List<MdxExpression> arguments, CdMdxToken closeParen, @Nullable CdMdxStringToken userDefinedNameToken) {
        this.identifier = identifier;
        this.name = name;
        this.openParen = openParen;
        this.arguments = arguments;
        this.closeParen = closeParen;
        this.userDefinedNameToken = userDefinedNameToken;
    }

    @Override
    public CdMdxToken getFirstToken() {
        return this.identifier.getFirstToken();
    }

    @Override
    protected CdMdxToken doGetLastToken() {
        if (this.userDefinedNameToken != null) {
            return this.userDefinedNameToken;
        }
        if (this.closeParen != null) {
            return this.closeParen;
        }
        if (this.arguments.isEmpty()) {
            return this.identifier.getLastToken();
        }
        MdxExpression lastArgument = this.arguments.get(this.arguments.size() - 1);
        return lastArgument.getLastToken();
    }

    @Override
    public List<MdxExpression> getChildren() {
        ArrayList<MdxExpression> children = new ArrayList<MdxExpression>();
        children.add(this.identifier);
        if (!this.arguments.isEmpty()) {
            children.addAll(this.arguments);
        }
        return children;
    }

    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public String getUserDefinedName() {
        if (this.userDefinedNameToken == null) {
            return null;
        }
        return this.userDefinedNameToken.getValue();
    }

    public List<MdxExpression> getArguments() {
        return this.arguments;
    }

    @Nullable
    public String getFirstArgumentMdx() {
        if (this.arguments.isEmpty()) {
            return null;
        }
        return this.arguments.get(0).asMdx();
    }

    @Override
    public String toString() {
        return this.name + "(...)";
    }
}

