/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.expression.authorization;

import crazydev.common.mdx.error.CdMdxErrorCode;
import crazydev.common.mdx.scanner.CdMdxPreProcessorTokenKind;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationElseStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationEndforeachStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationEndifStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationForEachStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationIfStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaScopeStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationStatement;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MdxAuthorizationSchemaExpressionPP
extends MdxExpression {
    private final MdxAuthorizationSchemaScopeStatement scope;
    private final List<MdxAuthorizationStatement> statements;

    private MdxAuthorizationSchemaExpressionPP(MdxAuthorizationSchemaScopeStatement scope, List<MdxAuthorizationStatement> statements) {
        this.scope = scope;
        this.statements = statements;
    }

    public static MdxAuthorizationSchemaExpressionPP validate(MdxAuthorizationSchemaScopeStatement scope, List<MdxAuthorizationStatement> statements) throws MdxParserException {
        MdxAuthorizationSchemaExpressionPP.validateForEachSequences(statements);
        MdxAuthorizationSchemaExpressionPP.validateIfSequences(statements);
        return new MdxAuthorizationSchemaExpressionPP(scope, statements);
    }

    private static void validateForEachSequences(List<MdxAuthorizationStatement> statements) throws MdxParserException {
        CdMdxPreProcessorTokenKind currentPP = null;
        CdMdxToken currentToken = null;
        for (MdxAuthorizationStatement statement : statements) {
            if (statement instanceof MdxAuthorizationForEachStatement) {
                if (currentPP != null) {
                    throw new MdxParserException(statement.getFirstToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_PP_NESTED_FOREACH, new Serializable[0]);
                }
                currentPP = CdMdxPreProcessorTokenKind.FOREACH;
                currentToken = statement.getFirstToken();
                continue;
            }
            if (statement instanceof MdxAuthorizationEndforeachStatement) {
                if (currentPP != CdMdxPreProcessorTokenKind.FOREACH) {
                    throw new MdxParserException(statement.getFirstToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_PP_ENDFOREACH_WO_FOREACH, new Serializable[0]);
                }
                currentPP = null;
                currentToken = null;
                continue;
            }
            if (!(statement instanceof MdxAuthorizationIfStatement) || currentPP == null) continue;
            throw new MdxParserException(statement.getFirstToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_PP_IF_WITHIN_FOREACH, new Serializable[0]);
        }
        if (currentPP != null) {
            throw new MdxParserException(currentToken, CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_PP_ENDFOREACH_MISSING, new Serializable[0]);
        }
    }

    private static void validateIfSequences(List<MdxAuthorizationStatement> statements) throws MdxParserException {
        CdMdxPreProcessorTokenKind currentPP = null;
        CdMdxToken currentToken = null;
        for (MdxAuthorizationStatement statement : statements) {
            if (statement instanceof MdxAuthorizationIfStatement) {
                if (currentPP != null) {
                    throw new MdxParserException(statement.getFirstToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_PP_NESTED_IF, new Serializable[0]);
                }
                currentPP = CdMdxPreProcessorTokenKind.IF;
                currentToken = statement.getFirstToken();
                continue;
            }
            if (statement instanceof MdxAuthorizationElseStatement) {
                if (currentPP != CdMdxPreProcessorTokenKind.IF) {
                    throw new MdxParserException(statement.getFirstToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_PP_ELSE_WO_IF, new Serializable[0]);
                }
                currentPP = CdMdxPreProcessorTokenKind.ELSE;
                currentToken = statement.getFirstToken();
                continue;
            }
            if (!(statement instanceof MdxAuthorizationEndifStatement)) continue;
            if (currentPP != CdMdxPreProcessorTokenKind.IF && currentPP != CdMdxPreProcessorTokenKind.ELSE) {
                throw new MdxParserException(statement.getFirstToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_PP_ENDIF_WO_IF, new Serializable[0]);
            }
            currentPP = null;
            currentToken = null;
        }
        if (currentPP != null) {
            throw new MdxParserException(currentToken, CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_PP_ENDIF_MISSING, new Serializable[0]);
        }
    }

    @Override
    public CdMdxToken getFirstToken() {
        return this.scope.getFirstToken();
    }

    @Override
    protected CdMdxToken doGetLastToken() {
        if (!this.statements.isEmpty()) {
            return this.statements.get(this.statements.size() - 1).getLastToken();
        }
        return this.scope.getLastToken();
    }

    @Override
    public List<MdxExpression> getChildren() {
        return new ArrayList<MdxExpression>();
    }

    public String getName() {
        return this.scope.getName();
    }

    public MdxAuthorizationSchemaScopeStatement getScope() {
        return this.scope;
    }

    public boolean containsPP() {
        for (MdxAuthorizationStatement statement : this.statements) {
            if (!statement.isPP()) continue;
            return true;
        }
        return false;
    }

    public List<MdxAuthorizationStatement> getStatements() {
        return this.statements;
    }
}

