/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser.ast.expression.authorization;

import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.iccube.authorization.permissions.common.OlapRoleAccess;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDrillthroughStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaAccessStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaScopeStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationStatement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MdxAuthorizationSchemaExpression
extends MdxExpression {
    private final MdxAuthorizationSchemaScopeStatement scope;
    @Nullable
    private final MdxAuthorizationSchemaAccessStatement access;
    @Nullable
    private final MdxAuthorizationDrillthroughStatement drillthrough;
    private final List<MdxAuthorizationStatement> statements;

    public MdxAuthorizationSchemaExpression(MdxAuthorizationSchemaScopeStatement scope, @Nullable MdxAuthorizationSchemaAccessStatement access, @Nullable MdxAuthorizationDrillthroughStatement drillthrough, List<MdxAuthorizationStatement> statements) {
        this.scope = scope;
        this.access = access;
        this.drillthrough = drillthrough;
        this.statements = statements;
    }

    @Override
    public CdMdxToken getFirstToken() {
        return this.scope.getFirstToken();
    }

    @Override
    protected CdMdxToken doGetLastToken() {
        if (!this.statements.isEmpty()) {
            return this.statements.get(this.statements.size() - 1).getLastToken();
        }
        if (this.drillthrough != null) {
            return this.drillthrough.getLastToken();
        }
        if (this.access != null) {
            return this.access.getLastToken();
        }
        return this.scope.getLastToken();
    }

    @Override
    public List<MdxExpression> getChildren() {
        return new ArrayList<MdxExpression>();
    }

    public String getName() {
        return this.scope.getName();
    }

    public OlapRoleAccess getSchemaAccess(OlapRoleAccess defaultSchemaAccess) {
        if (this.access != null) {
            return this.access.isWrite() ? OlapRoleAccess.READ_WRITE : OlapRoleAccess.READ;
        }
        return defaultSchemaAccess;
    }

    public boolean isDrillthroughDenied(boolean defaultDrillthroughDenied) {
        if (this.drillthrough != null) {
            return true;
        }
        return defaultDrillthroughDenied;
    }

    public boolean isAllAuthorized() {
        return this.statements.isEmpty();
    }

    public List<MdxAuthorizationStatement> getStatements() {
        return this.statements;
    }
}

