/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser;

import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.olap.entity.properties.member.OlapIntrinsicMemberPropertyManager;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.eval.select.tidypostprocessor.OlapTidyPostProcessorRepository;
import crazydev.iccube.olap.schema.OlapSchemaFunctionRepositorySnapshot;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class MdxParsingContext {
    private final OlapProperties properties;
    private final OlapFunctionRepository functionRepository;
    private final OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot;
    private final OlapIntrinsicMemberPropertyManager memberPropertyManager;
    private final boolean assertLastTokenParsed;
    private final boolean acceptSCAN_EMPTY_DELIMITED_ID;
    private final Set<String> declaredFunctions = new HashSet<String>();

    public MdxParsingContext(OlapProperties properties, OlapFunctionRepository functionRepository, OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot) {
        this(properties, functionRepository, schemaFunctionRepositorySnapshot, new OlapIntrinsicMemberPropertyManager(), true);
    }

    public MdxParsingContext(OlapProperties properties, OlapFunctionRepository functionRepository, OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot, Set<String> declaredFunctions) {
        this(properties, functionRepository, schemaFunctionRepositorySnapshot, new OlapIntrinsicMemberPropertyManager(), declaredFunctions, true, false);
    }

    public MdxParsingContext(OlapProperties properties, OlapFunctionRepository functionRepository, OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot, OlapIntrinsicMemberPropertyManager memberPropertyManager, boolean assertLastTokenParsed) {
        this(properties, functionRepository, schemaFunctionRepositorySnapshot, memberPropertyManager, Collections.emptySet(), assertLastTokenParsed, false);
    }

    public MdxParsingContext(OlapProperties properties, OlapFunctionRepository functionRepository, OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot, OlapIntrinsicMemberPropertyManager memberPropertyManager, boolean assertLastTokenParsed, boolean acceptSCAN_EMPTY_DELIMITED_ID) {
        this(properties, functionRepository, schemaFunctionRepositorySnapshot, memberPropertyManager, Collections.emptySet(), assertLastTokenParsed, acceptSCAN_EMPTY_DELIMITED_ID);
    }

    private MdxParsingContext(OlapProperties properties, OlapFunctionRepository functionRepository, OlapSchemaFunctionRepositorySnapshot schemaFunctionRepositorySnapshot, OlapIntrinsicMemberPropertyManager memberPropertyManager, Set<String> declaredFunctions, boolean assertLastTokenParsed, boolean acceptSCAN_EMPTY_DELIMITED_ID) {
        this.properties = properties;
        this.functionRepository = functionRepository;
        this.schemaFunctionRepositorySnapshot = schemaFunctionRepositorySnapshot;
        this.memberPropertyManager = memberPropertyManager;
        if (declaredFunctions != null) {
            this.declaredFunctions.addAll(declaredFunctions);
        }
        this.assertLastTokenParsed = assertLastTokenParsed;
        this.acceptSCAN_EMPTY_DELIMITED_ID = acceptSCAN_EMPTY_DELIMITED_ID;
    }

    public boolean isAssertLastTokenParsed() {
        return this.assertLastTokenParsed;
    }

    public boolean isAcceptSCAN_EMPTY_DELIMITED_ID() {
        return this.acceptSCAN_EMPTY_DELIMITED_ID;
    }

    public OlapProperties getProperties() {
        return this.properties;
    }

    public boolean isRegularFunctionName(String name) {
        return this.functionRepository.containsFunction(name);
    }

    public boolean isPostFixedFunctionName(String name) {
        return this.schemaFunctionRepositorySnapshot.containsPostFixedFunction(name);
    }

    public boolean isFunctionName(String name) {
        return this.schemaFunctionRepositorySnapshot.containsFunction(name);
    }

    public int getFunctionMaxParamCount(String name) {
        return this.schemaFunctionRepositorySnapshot.getFunctionMaxParamCount(name);
    }

    public boolean isParseableMemberPropertyName(String name) {
        return this.memberPropertyManager.isParseable(name);
    }

    public Set<String> getDeclaredFunctions() {
        return this.declaredFunctions;
    }

    public void setDeclaredFunctions(Set<String> declaredFunctions) {
        this.declaredFunctions.clear();
        this.declaredFunctions.addAll(declaredFunctions);
    }

    public boolean isTidyPostProcessorName(String name) {
        return OlapTidyPostProcessorRepository.INSTANCE.getTidyPostProcessor(name) != null;
    }
}

