/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.mdx.parser;

import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.mdx.error.CdMdxErrorCode;
import crazydev.common.mdx.scanner.CdMdxScanner;
import crazydev.common.mdx.scanner.CdMdxToken;
import crazydev.common.mdx.scanner.CdMdxTokenKind;
import crazydev.common.mdx.scanner.exception.CdMdxScannerException;
import crazydev.common.mdx.scanner.token.CdMdxAnnotationToken;
import crazydev.common.mdx.scanner.token.CdMdxDoubleToken;
import crazydev.common.mdx.scanner.token.CdMdxIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxLongToken;
import crazydev.common.mdx.scanner.token.CdMdxParameterToken;
import crazydev.common.mdx.scanner.token.CdMdxPreProcessorToken;
import crazydev.common.mdx.scanner.token.CdMdxRegularIdentifierToken;
import crazydev.common.mdx.scanner.token.CdMdxStringToken;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.configuration.component.properties.OlapPropertyAccessType;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescription;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescriptions;
import crazydev.iccube.mdx.parser.MdxParsingContext;
import crazydev.iccube.mdx.parser.MdxParsingStrategy;
import crazydev.iccube.mdx.parser.ast.MdxEntity;
import crazydev.iccube.mdx.parser.ast.expression.MdxExpression;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotation;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotationType;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxDebugTableAggregatorAnnotation;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxPropAnnotation;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxUserAnnotation;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationCreateFunctionStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationCreateSetStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationCubeStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDefaultMemberStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDenyAllStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDenyPerspectivesStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDenyReportingDataSourcesStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDenySchemasStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDimensionStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDocsPermsStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationDrillthroughStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationElseStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationEndforeachStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationEndifStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationExpression;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationForEachStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationHierarchyStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationIfStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationInheritStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationLevelStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationMeasureGroupStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationMeasureStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationPerspectiveStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationReportingDataSourceStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaAccessStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaExpressionPP;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaScopeStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationSchemaStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxAuthorizationTuplesStatement;
import crazydev.iccube.mdx.parser.ast.expression.authorization.MdxDocsPermsExpression;
import crazydev.iccube.mdx.parser.ast.expression.command.MdxExecCommandParamExpression;
import crazydev.iccube.mdx.parser.ast.expression.command.MdxExecCommandStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.create.MdxCreateCalcMemberStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.create.MdxCreateCategoryHierarchyStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.create.MdxCreateCategoryMemberStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.create.MdxCreateDrillthroughActionStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.create.MdxCreateFunctionStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.create.MdxCreateMeasureStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.create.MdxCreateSetStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.create.MdxSetTableAggregatorStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.define.MdxDefineDefaultMemberStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.drillthrough.MdxDrillthroughFunctionReturnExpression;
import crazydev.iccube.mdx.parser.ast.expression.drillthrough.MdxDrillthroughIdentifierReturnExpression;
import crazydev.iccube.mdx.parser.ast.expression.drillthrough.MdxDrillthroughReturnExpression;
import crazydev.iccube.mdx.parser.ast.expression.drillthrough.MdxDrillthroughStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.drop.MdxDropActionStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.drop.MdxDropAllStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.drop.MdxDropCalcMemberStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.drop.MdxDropCategoryHierarchyStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.drop.MdxDropFunctionStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.drop.MdxDropMeasureStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.drop.MdxDropSetStatementExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxDeclaredFunctionArgumentCallExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionArgExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionCallExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionLongArgArrayWrapperExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionNameExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionNativeBodyExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionStringArgArrayWrapperExpression;
import crazydev.iccube.mdx.parser.ast.expression.function.MdxFunctionTypedArgExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxNamedSetIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.expression.id.MdxQualifiedMeasureGroupNameIdentifierExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxAggrTypeExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxCubeExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxDoubleLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxFalseLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxLongLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxNoFunctionArgExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxNullLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxStringLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxTrueLiteralExpression;
import crazydev.iccube.mdx.parser.ast.expression.method.MdxMethodArgExpression;
import crazydev.iccube.mdx.parser.ast.expression.method.MdxMethodCallExpression;
import crazydev.iccube.mdx.parser.ast.expression.method.MdxMethodNameExpression;
import crazydev.iccube.mdx.parser.ast.expression.method.MdxMethodNamedArgExpression;
import crazydev.iccube.mdx.parser.ast.expression.method.MdxObjectMethodCallExpression;
import crazydev.iccube.mdx.parser.ast.expression.operator.MdxBinaryOperatorCallExpression;
import crazydev.iccube.mdx.parser.ast.expression.operator.MdxUnaryOperatorCallExpression;
import crazydev.iccube.mdx.parser.ast.expression.option.MdxOptionExpression;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveBinaryStatement;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveDefaultStatement;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveExpression;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveNameStatement;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveStatement;
import crazydev.iccube.mdx.parser.ast.expression.perspective.MdxPerspectiveUnaryStatement;
import crazydev.iccube.mdx.parser.ast.expression.scase.MdxCaseExpression;
import crazydev.iccube.mdx.parser.ast.expression.scase.MdxSearchCaseExpression;
import crazydev.iccube.mdx.parser.ast.expression.scase.MdxSimpleCaseExpression;
import crazydev.iccube.mdx.parser.ast.expression.script.MdxScriptExpression;
import crazydev.iccube.mdx.parser.ast.expression.set.MdxAsNamedSetExpression;
import crazydev.iccube.mdx.parser.ast.expression.set.MdxExistingSetExpression;
import crazydev.iccube.mdx.parser.ast.expression.set.MdxSetExpression;
import crazydev.iccube.mdx.parser.ast.expression.set.MdxSetItemOperatorExpression;
import crazydev.iccube.mdx.parser.ast.expression.tuple.MdxTupleOrParenExpression;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectAxisName;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCalcMember;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCalcMemberProperties;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCalcMemberProperty;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCategoryHierarchy;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCategoryMember;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCategoryProperties;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCategoryProperty;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectCellPropertyListClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectDimensionPropertyListClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectExtraAxisClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectExtraAxisClauses;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectFilterByClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectFilterByClauses;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectFunction;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectFunctionProperties;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectMeasure;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectMeasureProperties;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectMeasureProperty;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectMemberProperties;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectMemberProperty;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectNamedSet;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectQueryAxisClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectSetProperties;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectSlicerAxisClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectStatementExpression;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectTidyPostProcessorClause;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectTidyPostProcessorClauses;
import crazydev.iccube.mdx.parser.ast.select.MdxSelectWithClause;
import crazydev.iccube.mdx.parser.ast.statement.MdxStatementExpression;
import crazydev.iccube.mdx.parser.excel.MdxExcelFixDotMembers;
import crazydev.iccube.mdx.parser.exception.MdxDuplicatedFunctionParserException;
import crazydev.iccube.mdx.parser.exception.MdxParserException;
import crazydev.iccube.olap.loggers.OlapLoggers;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class MdxParser {
    static final Set<String> STANDARD_FUNCTIONS_CALL_WITH_NO_PAREN = new HashSet<String>();
    private final MdxParsingContext context;
    private final Set<String> forwardDeclaredFunctions = new HashSet<String>();
    private final Set<String> declaredFunctions = new HashSet<String>();
    private final String mdx;
    private final String mdxHash;
    private final List<CdMdxToken> tokens;
    @Nullable
    private String currentDeclaredFunctionName;
    @Nullable
    private List<MdxFunctionTypedArgExpression> currentDeclaredFunctionArguments;
    private int currentTokenIndex;
    private int lastTokenParsed;
    private boolean inTidyPostProcessor;

    private MdxParser(MdxParsingContext context, String mdx, String mdxHash, List<CdMdxToken> tokens) {
        this.context = context;
        this.declaredFunctions.addAll(context.getDeclaredFunctions());
        this.mdx = mdx;
        this.mdxHash = mdxHash;
        this.tokens = tokens;
        this.currentTokenIndex = 0;
        this.lastTokenParsed = -1;
        this.setupForwardDeclaredFunctions();
    }

    public static MdxScriptExpression parseMdxScript(MdxParsingContext context, String name, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        final String scriptName = name;
        return MdxParser.parse(new MdxParsingStrategy<MdxScriptExpression>(){

            @Override
            public MdxScriptExpression parse(MdxParser parser) throws CdMdxScannerException, MdxParserException {
                return parser.parseMdxScript(scriptName);
            }
        }, context, mdx, mdxHash);
    }

    public static MdxStatementExpression parseMdxStatement(MdxParsingContext context, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        try {
            return MdxParser.parseMdxStatementX(context, mdx, mdxHash);
        }
        catch (MdxParserException error) {
            return MdxParser.onParseMdxStatementXError(context, mdx, mdxHash, error);
        }
        catch (CdMdxScannerException error) {
            return MdxParser.onParseMdxStatementXError(context, mdx, mdxHash, error);
        }
    }

    @Nullable
    public static MdxStatementExpression extractMdxStatement(MdxParsingContext context, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        return MdxParser.parse(MdxParser::extractMdxStatement, context, mdx, mdxHash);
    }

    private static MdxStatementExpression onParseMdxStatementXError(MdxParsingContext context, String mdx, String mdxHash, MdxParserException error) throws MdxParserException {
        String fixedMdx;
        if (!error.isCausedBy((CdErrorCode)CdMdxErrorCode.PARSE_EXCEL_DOT_MEMBERS) || !context.getProperties().isExcelFixDotMembers()) {
            throw error;
        }
        try {
            fixedMdx = MdxExcelFixDotMembers.fixMdxStatement(context, mdx, mdxHash);
            if (fixedMdx == null) {
                throw error;
            }
        }
        catch (CdMdxScannerException fixedMdxError) {
            throw error;
        }
        try {
            OlapLoggers.MDX_PARSER.warn((Object)("EXCEL MDX .Members fix (original) : " + mdx));
            OlapLoggers.MDX_PARSER.warn((Object)("EXCEL MDX .Members fix (fixed)    : " + fixedMdx));
            return MdxParser.parseMdxStatementX(context, fixedMdx, mdxHash);
        }
        catch (MdxParserException fixedMdxError) {
            throw error;
        }
        catch (CdMdxScannerException fixedMdxError) {
            throw error;
        }
        catch (RuntimeException fixedMdxError) {
            throw error;
        }
    }

    private static MdxStatementExpression onParseMdxStatementXError(MdxParsingContext context, String mdx, String mdxHash, CdMdxScannerException error) throws CdMdxScannerException {
        String fixedMdx;
        if (!error.isCausedBy((CdErrorCode)CdMdxErrorCode.PARSE_EXCEL_DOT_MEMBERS) || !context.getProperties().isExcelFixDotMembers()) {
            throw error;
        }
        try {
            fixedMdx = MdxExcelFixDotMembers.fixMdxStatement(context, mdx, mdxHash);
            if (fixedMdx == null) {
                throw error;
            }
        }
        catch (CdMdxScannerException fixedMdxError) {
            throw error;
        }
        try {
            OlapLoggers.MDX_PARSER.warn((Object)("EXCEL MDX .Members fix (original) : " + mdx));
            OlapLoggers.MDX_PARSER.warn((Object)("EXCEL MDX .Members fix (fixed)    : " + fixedMdx));
            return MdxParser.parseMdxStatementX(context, fixedMdx, mdxHash);
        }
        catch (CdMdxScannerException | MdxParserException | RuntimeException fixedMdxError) {
            throw error;
        }
    }

    private static MdxStatementExpression parseMdxStatementX(MdxParsingContext context, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        return MdxParser.parse(parser -> parser.parseMdxStatement(false), context, mdx, mdxHash);
    }

    public static MdxSelectCalcMemberProperties parseCalcMemberProperties(MdxParsingContext context, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        return MdxParser.parse(parser -> {
            MdxSelectCalcMemberProperties properties = parser.parseCalcMemberProperties();
            if (properties != null) {
                return properties;
            }
            List<MdxSelectCalcMemberProperty> xproperties = Collections.emptyList();
            return new MdxSelectCalcMemberProperties(xproperties);
        }, context, mdx, mdxHash);
    }

    public static MdxExpression parseValueExpression(MdxParsingContext context, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        return MdxParser.parse(MdxParser::parseValueExpression, context, mdx, mdxHash);
    }

    public static MdxIdentifierExpression parseIdentifierExpression(MdxParsingContext context, String mdx, String mdxHash, String identifierKind) throws CdMdxScannerException, MdxParserException {
        return MdxParser.parse(parser -> parser.parseIdentifierX(identifierKind), context, mdx, mdxHash);
    }

    @Nullable
    public static MdxPerspectiveExpression parsePerspective(MdxParsingContext context, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        return MdxParser.parse(MdxParser::parsePerspectiveExpression, context, mdx, mdxHash);
    }

    @Nullable
    public static MdxAuthorizationExpression parseAuthorization(MdxParsingContext context, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        return MdxParser.parse(MdxParser::parseAuthorizationExpression, context, mdx, mdxHash);
    }

    @Nullable
    public static MdxDocsPermsExpression parseDocsPerms(MdxParsingContext context, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        return MdxParser.parse(MdxParser::parseDocsPermsExpression, context, mdx, mdxHash);
    }

    private static <ENTITY extends MdxEntity> ENTITY parse(MdxParsingStrategy<ENTITY> strategy, MdxParsingContext context, String mdx, String mdxHash) throws CdMdxScannerException, MdxParserException {
        CdMdxScanner scanner = new CdMdxScanner(context.isAcceptSCAN_EMPTY_DELIMITED_ID());
        List tokens = scanner.scan(mdx, mdxHash);
        MdxParser parser = new MdxParser(context, mdx, mdxHash, tokens);
        ENTITY entity = strategy.parse(parser);
        context.setDeclaredFunctions(parser.declaredFunctions);
        if (context.isAssertLastTokenParsed()) {
            for (int pos = parser.lastTokenParsed + 1; pos < tokens.size(); ++pos) {
                CdMdxToken unexpectedToken = (CdMdxToken)tokens.get(pos);
                if (CdMdxTokenKind.isInvisible((CdMdxTokenKind)unexpectedToken.getKind())) continue;
                throw new MdxParserException(unexpectedToken, CdMdxErrorCode.PARSE_UNEXPECTED_STATEMENT, new Serializable[]{unexpectedToken.getLexeme(), unexpectedToken.getKind()});
            }
        }
        return entity;
    }

    @Nullable
    private CdMdxToken parseToken() {
        CdMdxToken token;
        while ((token = this.doParseToken()) != null && CdMdxTokenKind.isInvisible((CdMdxTokenKind)token.getKind())) {
        }
        return token;
    }

    @Nullable
    private CdMdxToken doParseToken() {
        CdMdxToken token = null;
        if (this.currentTokenIndex < this.tokens.size()) {
            this.lastTokenParsed = this.currentTokenIndex;
            token = this.tokens.get(this.currentTokenIndex++);
        }
        return token;
    }

    private CdMdxToken parseToken(CdMdxTokenKind tokenKind) throws MdxParserException {
        CdMdxToken token = this.parseToken();
        if (token != null && token.getKind() == tokenKind) {
            return token;
        }
        throw new MdxParserException(token, CdMdxErrorCode.PARSE_MISSING, new Serializable[]{tokenKind.getLexemeForError(), token == null ? "eof" : token.getLexeme()});
    }

    @Nullable
    private CdMdxToken parseToken(boolean mandatory, OlapPropertyDescription prop, CdMdxTokenKind ... tokenKinds) throws MdxParserException {
        CdMdxTokenKind tokenKind = this.peekNextTokenKind();
        for (CdMdxTokenKind lookupTokenKind : tokenKinds) {
            if (tokenKind != lookupTokenKind) continue;
            return this.parseToken();
        }
        Class type = prop.getType();
        T[] constants = type.getEnumConstants();
        if (constants != null) {
            for (Object constant : constants) {
                CdMdxToken tk;
                String lexeme = constant.toString();
                if (tokenKind != CdMdxTokenKind.REGULAR_IDENTIFIER || (tk = this.peekNextToken(0)) == null || !tk.getLexeme().equals(lexeme)) continue;
                return this.parseToken();
            }
        }
        if (mandatory) {
            throw new MdxParserException(null, CdMdxErrorCode.PARSE_MISSING_OPTION, new Serializable[]{Arrays.toString(tokenKinds)});
        }
        return null;
    }

    @Nullable
    private CdMdxToken parseOptionalToken(CdMdxTokenKind tokenKind) {
        if (this.peekNextTokenKind() == tokenKind) {
            return this.parseToken();
        }
        return null;
    }

    private CdMdxToken parseTokenEx(String tokenKinds) {
        CdMdxToken token = this.parseToken();
        if (token == null) {
            throw new CdProgrammingException("Missing expected " + tokenKinds + " token.");
        }
        return token;
    }

    private void unparseToken() {
        CdMdxToken token;
        while ((token = this.doUnparseToken()) != null && CdMdxTokenKind.isInvisible((CdMdxTokenKind)token.getKind())) {
        }
    }

    @Nullable
    private CdMdxToken doUnparseToken() {
        if (--this.currentTokenIndex < 0) {
            throw new CdProgrammingException("Parse/unparse inconsistency.");
        }
        this.lastTokenParsed = this.currentTokenIndex;
        CdMdxToken currentToken = this.currentTokenIndex < this.tokens.size() ? this.tokens.get(this.currentTokenIndex) : null;
        return currentToken;
    }

    @Nullable
    private CdMdxToken currentToken() {
        CdMdxToken token = null;
        for (int tokenPos = this.currentTokenIndex; tokenPos < this.tokens.size() && CdMdxTokenKind.isInvisible((CdMdxTokenKind)(token = this.tokens.get(tokenPos)).getKind()); ++tokenPos) {
        }
        return token;
    }

    @Nullable
    private CdMdxTokenKind peekNextTokenKind() {
        CdMdxToken nextToken = this.peekNextToken(0);
        return nextToken == null ? null : nextToken.getKind();
    }

    @Nullable
    private CdMdxToken peekNextToken(int lookahead) {
        CdMdxToken lookAheadToken = null;
        int ct = 0;
        for (int pos = this.currentTokenIndex; pos < this.tokens.size() && ct <= lookahead; ++pos) {
            CdMdxToken token = this.tokens.get(pos);
            if (CdMdxTokenKind.isInvisible((CdMdxTokenKind)token.getKind())) continue;
            if (ct == lookahead) {
                lookAheadToken = token;
                break;
            }
            ++ct;
        }
        return lookAheadToken;
    }

    @Nullable
    private CdMdxToken prevToken() {
        CdMdxToken token = null;
        for (int tokenPos = this.currentTokenIndex - 1; tokenPos > -1 && CdMdxTokenKind.isInvisible((CdMdxTokenKind)(token = this.tokens.get(tokenPos)).getKind()); --tokenPos) {
        }
        return token;
    }

    private MdxScriptExpression parseMdxScript(String name) throws CdMdxScannerException, MdxParserException {
        MdxStatementExpression statement;
        ArrayList<MdxStatementExpression> statements = new ArrayList<MdxStatementExpression>();
        while ((statement = this.parseMdxStatement(true)) != null) {
            statements.add(statement);
        }
        return new MdxScriptExpression(name, statements);
    }

    @Nullable
    private MdxStatementExpression parseMdxStatement(boolean acceptEmptyStatement) throws CdMdxScannerException, MdxParserException {
        CdMdxToken token;
        MdxStatementExpression statement = null;
        if (this.currentTokenIndex < this.tokens.size() && (token = this.parseToken()) != null) {
            if (CdMdxTokenKind.DRILLTHROUGH == token.getKind()) {
                statement = this.parseDrillthrough(token);
            } else if (CdMdxTokenKind.ANNOTATION == token.getKind() || CdMdxTokenKind.WITH == token.getKind() || CdMdxTokenKind.SELECT == token.getKind()) {
                this.unparseToken();
                statement = this.parseSelect(false, true);
            } else if (CdMdxTokenKind.CREATE == token.getKind()) {
                statement = this.parseCreateStatement(token);
            } else if (CdMdxTokenKind.DEFINE_DEFAULT_MEMBER == token.getKind()) {
                statement = this.parseDefineDefaultMemberStatement(token);
            } else if (CdMdxTokenKind.DROP == token.getKind()) {
                statement = this.parseDropStatement(token);
            } else if (CdMdxTokenKind.IC3RUN == token.getKind()) {
                statement = this.parseExecStatement(token);
            } else {
                throw new MdxParserException(token, CdMdxErrorCode.PARSE_UNEXPECTED_STATEMENT, new Serializable[]{token.getLexeme(), token.getKind()});
            }
        }
        if (statement == null && !acceptEmptyStatement) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_UNEXPECTED_EMPTY_STATEMENT, new Serializable[0]);
        }
        return statement;
    }

    private MdxStatementExpression parseCreateStatement(CdMdxToken createToken) throws CdMdxScannerException, MdxParserException {
        boolean sessionScoped;
        if (CdMdxTokenKind.SESSION == this.peekNextTokenKind()) {
            this.parseToken();
            sessionScoped = true;
        } else {
            sessionScoped = false;
        }
        CdMdxTokenKind nextTokenKind = this.peekNextTokenKind();
        if (CdMdxTokenKind.CALCULATED == nextTokenKind) {
            CdMdxToken calculatedToken = this.parseToken();
            CdMdxToken memberToken = this.parseToken(CdMdxTokenKind.MEMBER);
            MdxSelectCalcMember calcMember = this.parseCreateMemberBodyClause(true, -1L, calculatedToken);
            return new MdxCreateCalcMemberStatementExpression(createToken, sessionScoped, calcMember);
        }
        if (CdMdxTokenKind.MEMBER == nextTokenKind) {
            CdMdxToken memberToken = this.parseToken(CdMdxTokenKind.MEMBER);
            MdxSelectCalcMember calcMember = this.parseCreateMemberBodyClause(true, -1L, memberToken);
            return new MdxCreateCalcMemberStatementExpression(createToken, sessionScoped, calcMember);
        }
        if (CdMdxTokenKind.DRILLTHROUGH == nextTokenKind) {
            return this.parseCreateDrillthroughAction(createToken);
        }
        if (CdMdxTokenKind.DYNAMIC == nextTokenKind || CdMdxTokenKind.STATIC == nextTokenKind || CdMdxTokenKind.SET == nextTokenKind) {
            boolean dynamicEvaluation = false;
            if (CdMdxTokenKind.DYNAMIC == nextTokenKind) {
                this.parseToken();
                dynamicEvaluation = true;
            } else if (CdMdxTokenKind.STATIC == nextTokenKind) {
                CdMdxToken tk = this.parseToken();
                dynamicEvaluation = false;
                if (this.isPeekNextTokenKindNativeOrFunction()) {
                    MdxSelectFunction function = this.parseCreateFunctionBodyClause(tk, true);
                    return new MdxCreateFunctionStatementExpression(createToken, function);
                }
            }
            CdMdxToken setToken = this.parseToken(CdMdxTokenKind.SET);
            MdxSelectNamedSet set = this.parseCreateSetBodyClause(setToken, dynamicEvaluation);
            return new MdxCreateSetStatementExpression(createToken, sessionScoped, set);
        }
        if (CdMdxTokenKind.CONST == nextTokenKind || CdMdxTokenKind.NATIVE == nextTokenKind || CdMdxTokenKind.FUNCTION == nextTokenKind) {
            CdMdxToken firstToken = this.parseToken();
            MdxSelectFunction function = this.parseCreateFunctionBodyClause(firstToken, true);
            return new MdxCreateFunctionStatementExpression(createToken, function);
        }
        if (CdMdxTokenKind.CATEGORY == nextTokenKind) {
            CdMdxToken categoryToken = this.parseToken();
            CdMdxToken lookahead = this.peekNextToken(0);
            if (lookahead != null && lookahead.getKind() == CdMdxTokenKind.REGULAR_IDENTIFIER && lookahead.getLexeme().equalsIgnoreCase("hierarchy")) {
                CdMdxToken hierarchyToken = this.parseToken();
                MdxSelectCategoryHierarchy categoryHierarchy = this.parseCreateCategoryHierarchyBodyClause(sessionScoped, categoryToken);
                return new MdxCreateCategoryHierarchyStatementExpression(createToken, categoryHierarchy);
            }
            boolean calculated = false;
            CdMdxToken calculatedTk = this.peekNextToken(0);
            if (calculatedTk != null && calculatedTk.getKind() == CdMdxTokenKind.CALCULATED) {
                this.parseToken(CdMdxTokenKind.CALCULATED);
                calculated = true;
            }
            CdMdxToken memberToken = this.parseToken(CdMdxTokenKind.MEMBER);
            MdxSelectCategoryMember categoryMember = this.parseCreateCategoryMemberBodyClause(sessionScoped, categoryToken, false, calculated);
            return new MdxCreateCategoryMemberStatementExpression(createToken, categoryMember);
        }
        if (CdMdxTokenKind.MEASURE == nextTokenKind) {
            CdMdxToken memberToken = this.parseToken(CdMdxTokenKind.MEASURE);
            MdxSelectMeasure calcMember = this.parseCreateMeasureBodyClause(true, memberToken);
            return new MdxCreateMeasureStatementExpression(createToken, calcMember);
        }
        if (CdMdxTokenKind.SET_TABLE_AGGREGATOR == nextTokenKind) {
            CdMdxToken tableAggrToken = this.parseToken(CdMdxTokenKind.SET_TABLE_AGGREGATOR);
            MdxIdentifierExpression measureId = this.parseIdentifier();
            CdMdxStringToken name = (CdMdxStringToken)this.parseToken(CdMdxTokenKind.STRING);
            return new MdxSetTableAggregatorStatementExpression(createToken, measureId, name);
        }
        if (nextTokenKind == null) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_CREATE_UNEXPECTED_EMPTY, new Serializable[0]);
        }
        throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_CREATE_UNEXPECTED_TYPE, new Serializable[]{nextTokenKind.getLexemeForError()});
    }

    private MdxStatementExpression parseCreateDrillthroughAction(CdMdxToken createToken) throws MdxParserException {
        MdxIdentifierExpression target;
        ArrayList<MdxDrillthroughReturnExpression> returnStatements;
        MdxLongLiteralExpression maxRows;
        MdxIdentifierExpression name;
        block3: {
            CdMdxIdentifierToken id;
            CdMdxToken lookaheadTARGET;
            CdMdxToken lookaheadEQ;
            this.parseToken(CdMdxTokenKind.DRILLTHROUGH);
            this.parseToken(CdMdxTokenKind.ACTION);
            name = this.parseActionIdentifier();
            this.parseToken(CdMdxTokenKind.AS);
            if (this.peekNextTokenKind() == CdMdxTokenKind.MAXROWS) {
                this.parseToken(CdMdxTokenKind.MAXROWS);
                CdMdxLongToken number = (CdMdxLongToken)this.parseToken(CdMdxTokenKind.LONG);
                maxRows = new MdxLongLiteralExpression(number);
            } else {
                maxRows = null;
            }
            this.parseToken(CdMdxTokenKind.RETURN);
            returnStatements = new ArrayList<MdxDrillthroughReturnExpression>();
            target = null;
            do {
                MdxDrillthroughReturnExpression returnStatement = this.parseDrillthroughReturnExpression();
                returnStatements.add(returnStatement);
                if (this.peekNextTokenKind() != CdMdxTokenKind.COMMA) break block3;
                this.parseToken(CdMdxTokenKind.COMMA);
            } while ((lookaheadEQ = this.peekNextToken(1)) == null || !CdMdxTokenKind.EQ.equals((Object)lookaheadEQ.getKind()) || (lookaheadTARGET = this.peekNextToken(0)) == null || !CdMdxTokenKind.isIdentifier((CdMdxTokenKind)lookaheadTARGET.getKind()) || (id = (CdMdxIdentifierToken)lookaheadTARGET).isKey() || !id.getIdentifier().equalsIgnoreCase("TARGET"));
            this.parseToken();
            this.parseToken(CdMdxTokenKind.EQ);
            target = this.parseIdentifier();
        }
        return new MdxCreateDrillthroughActionStatementExpression(createToken, name, maxRows, returnStatements, target);
    }

    private MdxIdentifierExpression parseActionIdentifier() throws MdxParserException {
        MdxIdentifierExpression id = this.parseIdentifierX("action name");
        if (id.isLastPartDefinedAsKey()) {
            throw new MdxParserException(id.getLastToken(), CdMdxErrorCode.PARSE_INVALID_ACTION_NAME, new Serializable[]{id.asMdx()});
        }
        if (id.getPartCount() != 1) {
            throw new MdxParserException((CdMdxToken)id.getFirstToken(), CdMdxErrorCode.PARSE_INVALID_ACTION_NAME, new Serializable[]{id.asMdx()});
        }
        return id;
    }

    private boolean isPeekNextTokenKindNativeOrFunction() {
        return CdMdxTokenKind.FUNCTION == this.peekNextTokenKind() || CdMdxTokenKind.NATIVE == this.peekNextTokenKind();
    }

    private MdxStatementExpression parseDefineDefaultMemberStatement(CdMdxToken defineToken) throws MdxParserException {
        MdxIdentifierExpression id = this.parseIdentifierX("default member");
        return new MdxDefineDefaultMemberStatementExpression(defineToken, id);
    }

    private MdxStatementExpression parseDropStatement(CdMdxToken dropToken) throws MdxParserException {
        boolean sessionScoped;
        if (CdMdxTokenKind.SESSION == this.peekNextTokenKind()) {
            this.parseToken();
            sessionScoped = true;
        } else {
            sessionScoped = false;
        }
        CdMdxTokenKind nextTokenKind = this.peekNextTokenKind();
        if (CdMdxTokenKind.MULTIPLY == nextTokenKind) {
            CdMdxToken lastToken = this.parseToken(CdMdxTokenKind.MULTIPLY);
            return new MdxDropAllStatementExpression(dropToken, lastToken);
        }
        if (CdMdxTokenKind.MEMBER == nextTokenKind) {
            this.parseToken(CdMdxTokenKind.MEMBER);
            List<MdxIdentifierExpression> ids = this.parseDropStatementIdentifiers("calc. member name");
            return new MdxDropCalcMemberStatementExpression(dropToken, sessionScoped, ids);
        }
        if (CdMdxTokenKind.MEASURE == nextTokenKind) {
            this.parseToken(CdMdxTokenKind.MEASURE);
            List<MdxIdentifierExpression> ids = this.parseDropStatementIdentifiers("measure name");
            return new MdxDropMeasureStatementExpression(dropToken, ids);
        }
        if (CdMdxTokenKind.SET == nextTokenKind) {
            this.parseToken(CdMdxTokenKind.SET);
            List<MdxNamedSetIdentifierExpression> ids = this.parseDropSetStatementIdentifiers();
            return new MdxDropSetStatementExpression(dropToken, sessionScoped, ids);
        }
        if (CdMdxTokenKind.ACTION == nextTokenKind) {
            this.parseToken(CdMdxTokenKind.ACTION);
            List<MdxIdentifierExpression> ids = this.parseDropActionStatementIdentifiers();
            return new MdxDropActionStatementExpression(dropToken, ids);
        }
        if (CdMdxTokenKind.FUNCTION == nextTokenKind) {
            this.parseToken(CdMdxTokenKind.FUNCTION);
            List<MdxIdentifierExpression> ids = this.parseDropStatementIdentifiers("function name");
            return new MdxDropFunctionStatementExpression(dropToken, ids);
        }
        if (CdMdxTokenKind.CATEGORY == nextTokenKind) {
            CdMdxToken categoryToken = this.parseToken(CdMdxTokenKind.CATEGORY);
            CdMdxToken lookahead = this.peekNextToken(0);
            CdMdxToken hierarchyToken = this.parseToken();
            if (hierarchyToken != null && hierarchyToken.getKind() == CdMdxTokenKind.REGULAR_IDENTIFIER && hierarchyToken.getLexeme().equalsIgnoreCase("hierarchy")) {
                List<MdxIdentifierExpression> ids = this.parseDropStatementIdentifiers("category hierarchy name");
                return new MdxDropCategoryHierarchyStatementExpression(dropToken, sessionScoped, ids);
            }
            throw new MdxParserException(categoryToken, CdMdxErrorCode.PARSE_MISSING, new Serializable[]{"hierarchy", hierarchyToken != null ? hierarchyToken.getLexeme() : ""});
        }
        if (nextTokenKind == null) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_DROP_UNEXPECTED_EMPTY, new Serializable[0]);
        }
        throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_DROP_UNEXPECTED_TYPE, new Serializable[]{nextTokenKind.getLexemeForError()});
    }

    private List<MdxIdentifierExpression> parseDropStatementIdentifiers(String identifierInfo) throws MdxParserException {
        ArrayList<MdxIdentifierExpression> ids = new ArrayList<MdxIdentifierExpression>();
        ids.add(this.parseIdentifierX(identifierInfo));
        while (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.COMMA);
            ids.add(this.parseIdentifierX(identifierInfo));
        }
        return ids;
    }

    private List<MdxNamedSetIdentifierExpression> parseDropSetStatementIdentifiers() throws MdxParserException {
        ArrayList<MdxNamedSetIdentifierExpression> ids = new ArrayList<MdxNamedSetIdentifierExpression>();
        ids.add(this.parseNamedSetIdentifier());
        while (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.COMMA);
            ids.add(this.parseNamedSetIdentifier());
        }
        return ids;
    }

    private List<MdxIdentifierExpression> parseDropActionStatementIdentifiers() throws MdxParserException {
        ArrayList<MdxIdentifierExpression> ids = new ArrayList<MdxIdentifierExpression>();
        ids.add(this.parseActionIdentifier());
        while (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.COMMA);
            ids.add(this.parseActionIdentifier());
        }
        return ids;
    }

    private MdxStatementExpression parseExecStatement(CdMdxToken execToken) throws MdxParserException {
        CdMdxToken commandToken = this.parseToken(CdMdxTokenKind.REGULAR_IDENTIFIER);
        ArrayList<MdxExecCommandParamExpression> params = new ArrayList<MdxExecCommandParamExpression>();
        while (this.peekNextTokenKind() != CdMdxTokenKind.SEMI_COLON) {
            params.add(this.parseExecCommandParamExpression());
            while (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
                this.parseToken(CdMdxTokenKind.COMMA);
                params.add(this.parseExecCommandParamExpression());
            }
        }
        CdMdxToken semiColonToken = this.parseToken(CdMdxTokenKind.SEMI_COLON);
        return new MdxExecCommandStatementExpression(execToken, commandToken, params, semiColonToken);
    }

    private MdxExecCommandParamExpression parseExecCommandParamExpression() throws MdxParserException {
        MdxExpression expr = this.parseValueExpression();
        return new MdxExecCommandParamExpression(expr);
    }

    private MdxStatementExpression parseDrillthrough(CdMdxToken drillthroughToken) throws CdMdxScannerException, MdxParserException {
        MdxLongLiteralExpression maxRows;
        if (this.peekNextTokenKind() == CdMdxTokenKind.MAXROWS) {
            this.parseToken(CdMdxTokenKind.MAXROWS);
            CdMdxLongToken number = (CdMdxLongToken)this.parseToken(CdMdxTokenKind.LONG);
            maxRows = new MdxLongLiteralExpression(number);
        } else {
            maxRows = null;
        }
        MdxStatementExpression select = this.parseSelect(false, true);
        ArrayList<MdxDrillthroughReturnExpression> returnStatements = new ArrayList<MdxDrillthroughReturnExpression>();
        if (this.peekNextTokenKind() == CdMdxTokenKind.RETURN) {
            this.parseToken(CdMdxTokenKind.RETURN);
            while (true) {
                MdxDrillthroughReturnExpression returnStatement = this.parseDrillthroughReturnExpression();
                returnStatements.add(returnStatement);
                if (this.peekNextTokenKind() != CdMdxTokenKind.COMMA) break;
                this.parseToken(CdMdxTokenKind.COMMA);
            }
        }
        if (select instanceof MdxSelectStatementExpression) {
            MdxSelectStatementExpression select_ = (MdxSelectStatementExpression)select;
            ArrayList<MdxSelectExtraAxisClause> extraAxisClauses = new ArrayList<MdxSelectExtraAxisClause>();
            ArrayList<MdxSelectFilterByClause> filterByClauses = new ArrayList<MdxSelectFilterByClause>();
            ArrayList<MdxSelectTidyPostProcessorClause> tidyPostProcessorClauses = new ArrayList<MdxSelectTidyPostProcessorClause>();
            this.parseExtraClauses(extraAxisClauses, filterByClauses, tidyPostProcessorClauses);
            select_.addExtraClauses(extraAxisClauses, filterByClauses, tidyPostProcessorClauses);
        }
        return new MdxDrillthroughStatementExpression(drillthroughToken, maxRows, select, returnStatements);
    }

    private MdxDrillthroughReturnExpression parseDrillthroughReturnExpression() throws MdxParserException {
        MdxIdentifierExpression identifier = null;
        if (this.peekNextTokenKind() == CdMdxTokenKind.CELL) {
            CdMdxToken cellToken = this.parseToken(CdMdxTokenKind.CELL);
            CdMdxRegularIdentifierToken cellTokenAsIdPart = new CdMdxRegularIdentifierToken(cellToken.getLocation(), "Cell");
            identifier = new MdxIdentifierExpression((CdMdxIdentifierToken)cellTokenAsIdPart);
        }
        if (identifier != null || CdMdxTokenKind.isIdentifier((CdMdxTokenKind)this.peekNextTokenKind())) {
            if (identifier == null) {
                identifier = this.parseIdentifierOnly();
            }
            if (this.peekNextTokenKind() == CdMdxTokenKind.OPEN_PAREN) {
                if (identifier.getPartCount() > 1 || identifier.isLastPartDefinedAsKey() || identifier.isDelimited()) {
                    throw new MdxParserException(this.peekNextToken(0), CdMdxErrorCode.PARSE_UNEXPECTED_RETURN_NAME, new Serializable[0]);
                }
                String name = identifier.getFirstToken().getIdentifier();
                ArrayList<MdxExpression> arguments = new ArrayList<MdxExpression>();
                CdMdxToken openParen = this.parseToken(CdMdxTokenKind.OPEN_PAREN);
                if (this.peekNextTokenKind() != CdMdxTokenKind.CLOSE_PAREN) {
                    this.parseDrillthroughArgumentReturnExpressions(arguments);
                }
                CdMdxToken closeParen = this.parseToken(CdMdxTokenKind.CLOSE_PAREN);
                CdMdxStringToken userDefinedNameToken = null;
                if (this.peekNextTokenKind() == CdMdxTokenKind.AS) {
                    this.parseToken(CdMdxTokenKind.AS);
                    userDefinedNameToken = (CdMdxStringToken)this.parseToken(CdMdxTokenKind.STRING);
                }
                return new MdxDrillthroughFunctionReturnExpression(identifier, name, openParen, arguments, closeParen, userDefinedNameToken);
            }
            CdMdxStringToken userDefinedNameToken = null;
            if (this.peekNextTokenKind() == CdMdxTokenKind.AS) {
                this.parseToken(CdMdxTokenKind.AS);
                userDefinedNameToken = (CdMdxStringToken)this.parseToken(CdMdxTokenKind.STRING);
            }
            return new MdxDrillthroughIdentifierReturnExpression(identifier, userDefinedNameToken);
        }
        throw new MdxParserException(this.peekNextToken(0), CdMdxErrorCode.PARSE_UNEXPECTED_RETURN_ID, new Serializable[0]);
    }

    private void parseDrillthroughArgumentReturnExpressions(List<MdxExpression> arguments) throws MdxParserException {
        while (true) {
            this.parseDrillthroughArgumentReturnExpression(arguments);
            if (this.peekNextTokenKind() != CdMdxTokenKind.COMMA) break;
            this.parseToken(CdMdxTokenKind.COMMA);
        }
    }

    private void parseDrillthroughArgumentReturnExpression(List<MdxExpression> arguments) throws MdxParserException {
        MdxExpression expression = this.parseValueExpression();
        arguments.add(expression);
    }

    private MdxStatementExpression parseSelect(boolean nested, boolean nonVisual) throws CdMdxScannerException, MdxParserException {
        CdMdxToken firstToken = this.parseToken();
        if (firstToken == null) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_WITH_SELECT, new Serializable[0]);
        }
        if (CdMdxTokenKind.ANNOTATION == firstToken.getKind()) {
            this.unparseToken();
            List<MdxAnnotation> annotations = this.parseSelectAnnotations();
            return this.parseSelect(nested, nonVisual, annotations, this.parseToken());
        }
        return this.parseSelect(nested, nonVisual, null, firstToken);
    }

    private MdxStatementExpression parseSelect(boolean nested, boolean nonVisual, @Nullable List<MdxAnnotation> annotations, @Nullable CdMdxToken firstToken) throws CdMdxScannerException, MdxParserException {
        MdxSelectTidyPostProcessorClauses tidyPostProcessorClauses;
        MdxSelectFilterByClauses filterByClauses;
        MdxSelectExtraAxisClauses extraAxisClauses;
        if (firstToken == null) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_WITH_SELECT, new Serializable[0]);
        }
        List<MdxSelectWithClause> withClauses = null;
        if (CdMdxTokenKind.WITH == firstToken.getKind()) {
            if (nested) {
                throw new MdxParserException(firstToken, CdMdxErrorCode.PARSE_UNEXPECTED_WITH_SUB_SELECTED, new Serializable[0]);
            }
            withClauses = this.parseSelectWithClauses();
            this.parseToken(CdMdxTokenKind.SELECT);
        } else if (CdMdxTokenKind.SELECT != firstToken.getKind()) {
            throw new MdxParserException(firstToken, CdMdxErrorCode.PARSE_MISSING_WITH_SELECT, new Serializable[0]);
        }
        List<MdxSelectQueryAxisClause> queryAxisClauses = this.parseSelectQueryAxisClauses(nested);
        this.parseToken(CdMdxTokenKind.FROM);
        MdxExpression subSelectClause = this.parseSubSelectClause();
        MdxSelectSlicerAxisClause slicerAxisClause = null;
        if (CdMdxTokenKind.WHERE == this.peekNextTokenKind()) {
            slicerAxisClause = this.parseSelectSlicerAxisClause();
        }
        MdxSelectCellPropertyListClause cellPropertyListClause = null;
        if (!(nested || CdMdxTokenKind.CELL != this.peekNextTokenKind() && CdMdxTokenKind.PROPERTIES != this.peekNextTokenKind())) {
            cellPropertyListClause = this.parseSelectCellPropertyListClause();
        }
        if (!nested) {
            ArrayList<MdxSelectExtraAxisClause> extraAxisClauses_ = new ArrayList<MdxSelectExtraAxisClause>();
            ArrayList<MdxSelectFilterByClause> filterByClauses_ = new ArrayList<MdxSelectFilterByClause>();
            ArrayList<MdxSelectTidyPostProcessorClause> tidyPostProcessorClauses_ = new ArrayList<MdxSelectTidyPostProcessorClause>();
            this.parseExtraClauses(extraAxisClauses_, filterByClauses_, tidyPostProcessorClauses_);
            extraAxisClauses = !extraAxisClauses_.isEmpty() ? new MdxSelectExtraAxisClauses(extraAxisClauses_) : null;
            filterByClauses = !filterByClauses_.isEmpty() ? new MdxSelectFilterByClauses(filterByClauses_) : null;
            tidyPostProcessorClauses = !tidyPostProcessorClauses_.isEmpty() ? new MdxSelectTidyPostProcessorClauses(tidyPostProcessorClauses_) : null;
        } else {
            extraAxisClauses = null;
            filterByClauses = null;
            tidyPostProcessorClauses = null;
        }
        if (!(cellPropertyListClause != null || nested || CdMdxTokenKind.CELL != this.peekNextTokenKind() && CdMdxTokenKind.PROPERTIES != this.peekNextTokenKind())) {
            cellPropertyListClause = this.parseSelectCellPropertyListClause();
        }
        return new MdxSelectStatementExpression(this.mdx, firstToken, nonVisual, withClauses, annotations, queryAxisClauses, slicerAxisClause, subSelectClause, cellPropertyListClause, filterByClauses, extraAxisClauses, tidyPostProcessorClauses);
    }

    private void parseExtraClauses(List<MdxSelectExtraAxisClause> extraAxisClauses, List<MdxSelectFilterByClause> filterByClauses, List<MdxSelectTidyPostProcessorClause> tidyPostProcessorClauses) throws MdxParserException {
        CdMdxTokenKind kind = this.peekNextTokenKind();
        while (kind == CdMdxTokenKind.AXIS || kind == CdMdxTokenKind.FILTERBY || kind == CdMdxTokenKind.TIDYPOSTPROCESSOR) {
            if (kind == CdMdxTokenKind.AXIS) {
                clause = this.parseExtraAxisClause();
                extraAxisClauses.add((MdxSelectExtraAxisClause)clause);
            } else if (kind == CdMdxTokenKind.FILTERBY) {
                clause = this.parseSelectFilterByClause();
                filterByClauses.add((MdxSelectFilterByClause)clause);
            } else {
                clause = this.parseSelectTidyPostProcessorClause();
                tidyPostProcessorClauses.add((MdxSelectTidyPostProcessorClause)clause);
            }
            kind = this.peekNextTokenKind();
        }
    }

    private MdxSelectExtraAxisClause parseExtraAxisClause() throws MdxParserException {
        CdMdxToken nonEmpty;
        CdMdxToken axis = this.parseToken(CdMdxTokenKind.AXIS);
        MdxSelectAxisName axisName = this.parseSelectAxisName(false, -1);
        if (CdMdxTokenKind.NON == this.peekNextTokenKind()) {
            nonEmpty = this.parseToken(CdMdxTokenKind.NON);
            this.parseToken(CdMdxTokenKind.EMPTY);
        } else {
            nonEmpty = null;
        }
        MdxExpression expression = this.parseExpression();
        MdxSelectDimensionPropertyListClause dimensionPropertyListClause = CdMdxTokenKind.DIMENSION == this.peekNextTokenKind() || CdMdxTokenKind.PROPERTIES == this.peekNextTokenKind() ? this.parseSelectDimensionPropertyListClause() : null;
        return new MdxSelectExtraAxisClause(axis, axisName, nonEmpty, expression, dimensionPropertyListClause);
    }

    private MdxSelectFilterByClause parseSelectFilterByClause() throws MdxParserException {
        CdMdxToken filterBy = this.parseToken(CdMdxTokenKind.FILTERBY);
        MdxExpression expression = this.parseExpression();
        return new MdxSelectFilterByClause(filterBy, expression);
    }

    private MdxSelectTidyPostProcessorClause parseSelectTidyPostProcessorClause() throws MdxParserException {
        CdMdxToken tidyPostProcessor = this.parseToken(CdMdxTokenKind.TIDYPOSTPROCESSOR);
        CdMdxToken addToResult = this.peekNextTokenKind() == CdMdxTokenKind.ADD_TO_RESULT ? this.parseToken(CdMdxTokenKind.ADD_TO_RESULT) : null;
        CdMdxToken tk = this.peekNextToken(0);
        if (tk == null) {
            throw new MdxParserException(tidyPostProcessor, CdMdxErrorCode.PARSE_MISSING_TIDY_POST_PROCESSOR_NAME, new Serializable[0]);
        }
        if (!CdMdxTokenKind.isIdentifier((CdMdxTokenKind)tk.getKind())) {
            throw new MdxParserException(tk, CdMdxErrorCode.PARSE_UNEXPECTED_TIDY_POST_PROCESSOR_NAME, new Serializable[]{tk.getLexeme()});
        }
        CdMdxIdentifierToken name = (CdMdxIdentifierToken)tk;
        if (!this.isTidyPostProcessorName(name)) {
            throw new MdxParserException((CdMdxToken)name, CdMdxErrorCode.PARSE_UNKNOWN_TIDY_POST_PROCESSOR, new Serializable[]{name.getLexeme()});
        }
        try {
            this.setInTidyPostProcessor();
            MdxExpression tidyPostProcessorCall = this.parseFunctionCall(null);
            MdxSelectTidyPostProcessorClause mdxSelectTidyPostProcessorClause = new MdxSelectTidyPostProcessorClause(tidyPostProcessor, addToResult, tidyPostProcessorCall);
            return mdxSelectTidyPostProcessorClause;
        }
        catch (MdxParserException exception) {
            if (exception.isCausedBy((CdErrorCode)CdMdxErrorCode.PARSE_UNKNOWN_FUNCTION_PROPERTY)) {
                throw new MdxParserException((CdMdxToken)name, CdMdxErrorCode.PARSE_UNKNOWN_TIDY_POST_PROCESSOR, new Serializable[]{name.getLexeme()});
            }
            throw exception;
        }
        finally {
            this.unsetInTidyPostProcessor();
        }
    }

    private void setInTidyPostProcessor() {
        this.inTidyPostProcessor = true;
    }

    private void unsetInTidyPostProcessor() {
        this.inTidyPostProcessor = false;
    }

    private List<MdxAnnotation> parseSelectAnnotations() throws MdxParserException {
        return this.parseAnnotations(MdxAnnotationType.Prop, MdxAnnotationType.User, MdxAnnotationType.DebugTableAggregator);
    }

    private List<MdxAnnotation> parseAnnotations(MdxAnnotationType ... expected) throws MdxParserException {
        ArrayList<MdxAnnotation> annotations = new ArrayList<MdxAnnotation>();
        while (this.peekNextTokenKind() == CdMdxTokenKind.ANNOTATION) {
            annotations.add(this.parseAnnotation(expected));
        }
        return annotations;
    }

    private MdxAnnotation parseAnnotation(MdxAnnotationType ... expected) throws MdxParserException {
        CdMdxAnnotationToken token = (CdMdxAnnotationToken)this.parseToken(CdMdxTokenKind.ANNOTATION);
        String tokenName = token.getName();
        if (MdxAnnotationType.Prop.name().equalsIgnoreCase(tokenName)) {
            return this.expectedAnnotation(token, this.parsePropAnnotation(token), expected);
        }
        if (MdxAnnotationType.User.name().equalsIgnoreCase(tokenName)) {
            return this.expectedAnnotation(token, this.parseUserAnnotation(token), expected);
        }
        if (MdxAnnotationType.DebugTableAggregator.name().equalsIgnoreCase(tokenName)) {
            return this.expectedAnnotation(token, this.parseDebugTableAggregatorAnnotation(token), expected);
        }
        throw new MdxParserException((CdMdxToken)token, CdMdxErrorCode.PARSE_UNKNOWN_ANNOTATION, new Serializable[]{tokenName});
    }

    private MdxPropAnnotation parsePropAnnotation(CdMdxAnnotationToken token) throws MdxParserException {
        OlapProperty property;
        this.parseToken(CdMdxTokenKind.OPEN_PAREN);
        MdxIdentifierExpression propNameExpr = this.parseAnnotationPropName();
        String propName = propNameExpr.asParsedString();
        OlapPropertyDescription description = OlapPropertyDescriptions.getDescription(propName);
        if (description == null) {
            throw new MdxParserException((CdMdxToken)token, CdMdxErrorCode.PARSE_PROP_ANNOTATION_UNKNOWN, new Serializable[]{propName});
        }
        if (description.getAccessType() == OlapPropertyAccessType.READ) {
            throw new MdxParserException((CdMdxToken)token, CdMdxErrorCode.PARSE_PROP_ANNOTATION_READ_ONLY, new Serializable[]{propName});
        }
        this.parseToken(CdMdxTokenKind.EQ);
        CdMdxToken valueToken = this.parseToken(true, description, CdMdxTokenKind.TRUE, CdMdxTokenKind.FALSE, CdMdxTokenKind.STRING, CdMdxTokenKind.LONG, CdMdxTokenKind.DOUBLE);
        String value = valueToken instanceof CdMdxStringToken ? ((CdMdxStringToken)valueToken).getValue() : valueToken.getLexeme();
        try {
            property = description.asPropertyFromString("mdx", value);
        }
        catch (OlapConfigurationException ex) {
            throw new MdxParserException((CdMdxToken)token, CdMdxErrorCode.PARSE_PROP_ANNOTATION_TYPE, new Serializable[]{propName, ex.getMessage()});
        }
        this.parseToken(CdMdxTokenKind.CLOSE_PAREN);
        return new MdxPropAnnotation(property);
    }

    private MdxIdentifierExpression parseAnnotationPropName() throws MdxParserException {
        ArrayList<CdMdxIdentifierToken> parts = new ArrayList<CdMdxIdentifierToken>();
        while (true) {
            parts.add((CdMdxIdentifierToken)this.parseToken(CdMdxTokenKind.REGULAR_IDENTIFIER));
            if (this.peekNextTokenKind() != CdMdxTokenKind.DOT) break;
            this.parseToken(CdMdxTokenKind.DOT);
        }
        return new MdxIdentifierExpression(parts);
    }

    private MdxUserAnnotation parseUserAnnotation(CdMdxAnnotationToken token) throws MdxParserException {
        String roleName = null;
        this.parseToken(CdMdxTokenKind.OPEN_PAREN);
        while (true) {
            CdMdxRegularIdentifierToken tokenName;
            String name;
            if ("role".equalsIgnoreCase(name = (tokenName = this.parseAnnotationName(token)).getIdentifier())) {
                this.parseToken(CdMdxTokenKind.EQ);
                roleName = this.parseAnnotationString(tokenName);
            }
            if (CdMdxTokenKind.COMMA != this.peekNextTokenKind()) break;
            this.parseToken(CdMdxTokenKind.COMMA);
        }
        this.parseToken(CdMdxTokenKind.CLOSE_PAREN);
        if (roleName == null) {
            throw new MdxParserException((CdMdxToken)token, CdMdxErrorCode.PARSE_USER_ANNOTATION_MISSING_ROLE_NAME, new Serializable[0]);
        }
        return new MdxUserAnnotation(roleName);
    }

    private MdxDebugTableAggregatorAnnotation parseDebugTableAggregatorAnnotation(CdMdxAnnotationToken token) throws MdxParserException {
        this.parseToken(CdMdxTokenKind.OPEN_PAREN);
        this.parseToken(CdMdxTokenKind.CLOSE_PAREN);
        return new MdxDebugTableAggregatorAnnotation();
    }

    private CdMdxRegularIdentifierToken parseAnnotationName(CdMdxAnnotationToken token) throws MdxParserException {
        if (CdMdxTokenKind.REGULAR_IDENTIFIER == this.peekNextTokenKind()) {
            return (CdMdxRegularIdentifierToken)this.parseToken(CdMdxTokenKind.REGULAR_IDENTIFIER);
        }
        throw new MdxParserException((CdMdxToken)token, CdMdxErrorCode.PARSE_MISSING_PARAM_FOR_ANNOTATION, new Serializable[]{token.getName()});
    }

    private String parseAnnotationString(CdMdxRegularIdentifierToken tokenName) throws MdxParserException {
        if (this.peekNextTokenKind() == CdMdxTokenKind.STRING) {
            CdMdxStringToken token = (CdMdxStringToken)this.parseToken(CdMdxTokenKind.STRING);
            return token.getValue();
        }
        throw new MdxParserException((CdMdxToken)tokenName, CdMdxErrorCode.PARSE_MISSING_STRING_VALUE_FOR_ANNOTATION_PARAM, new Serializable[]{tokenName.getIdentifier()});
    }

    private MdxAnnotation expectedAnnotation(CdMdxAnnotationToken token, MdxAnnotation annotation, MdxAnnotationType ... expectedAnnotations) throws MdxParserException {
        if (expectedAnnotations == null || expectedAnnotations.length == 0) {
            return annotation;
        }
        for (MdxAnnotationType expectedAnnotation : expectedAnnotations) {
            if (expectedAnnotation != annotation.getType()) continue;
            return annotation;
        }
        throw new MdxParserException((CdMdxToken)token, CdMdxErrorCode.PARSE_UNEXPECTED_ANNOTATION, new Serializable[]{annotation.getName(), this.expectedAnnotationNames(expectedAnnotations)});
    }

    private String expectedAnnotationNames(MdxAnnotationType[] expectedAnnotations) {
        if (expectedAnnotations == null || expectedAnnotations.length == 0) {
            return "not-available";
        }
        StringBuilder sb = new StringBuilder();
        for (MdxAnnotationType expectedAnnotation : expectedAnnotations) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(expectedAnnotation.name());
        }
        return sb.toString();
    }

    private MdxSelectCellPropertyListClause parseSelectCellPropertyListClause() throws MdxParserException {
        CdMdxToken cellProperties;
        ArrayList<MdxIdentifierExpression> properties = new ArrayList<MdxIdentifierExpression>();
        if (CdMdxTokenKind.CELL == this.peekNextTokenKind()) {
            cellProperties = this.parseToken(CdMdxTokenKind.CELL);
            this.parseToken(CdMdxTokenKind.PROPERTIES);
        } else if (CdMdxTokenKind.PROPERTIES == this.peekNextTokenKind()) {
            cellProperties = this.parseToken(CdMdxTokenKind.PROPERTIES);
        } else {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_CELL_PROPERTIES, new Serializable[0]);
        }
        while (true) {
            MdxIdentifierExpression id = this.parseCellPropertiesIdentifier();
            properties.add(id);
            if (CdMdxTokenKind.COMMA != this.peekNextTokenKind()) break;
            this.parseToken(CdMdxTokenKind.COMMA);
        }
        if (properties.isEmpty()) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_CELL_PROPERTIES, new Serializable[0]);
        }
        return new MdxSelectCellPropertyListClause(cellProperties, properties);
    }

    private MdxIdentifierExpression parseCellPropertiesIdentifier() throws MdxParserException {
        CdMdxToken token = this.parseToken();
        if (token == null) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_CELL_PROPERTIES_ID, new Serializable[0]);
        }
        if (!CdMdxTokenKind.isIdentifier((CdMdxTokenKind)token.getKind())) {
            throw new MdxParserException(token, CdMdxErrorCode.PARSE_MISSING_CELL_PROPERTIES_ID_X, new Serializable[]{token.getKind()});
        }
        CdMdxIdentifierToken id = (CdMdxIdentifierToken)token;
        if (id.isKey()) {
            throw new MdxParserException((CdMdxToken)id, CdMdxErrorCode.PARSE_UNEXPECTED_CELL_PROPERTIES_ID_KEY, new Serializable[]{id.getLexeme()});
        }
        return new MdxIdentifierExpression(id);
    }

    private List<MdxSelectWithClause> parseSelectWithClauses() throws CdMdxScannerException, MdxParserException {
        ArrayList<MdxSelectWithClause> clauses = new ArrayList<MdxSelectWithClause>();
        long calcMemberDeclarationOrder = 0L;
        while (this.peekNextTokenKind() != null) {
            CdMdxTokenKind nextTokenKind = this.peekNextTokenKind();
            if (CdMdxTokenKind.CONST == nextTokenKind || CdMdxTokenKind.NATIVE == nextTokenKind || CdMdxTokenKind.FUNCTION == nextTokenKind) {
                CdMdxToken firstToken = this.parseToken();
                MdxSelectFunction functionDeclaration = this.parseCreateFunctionBodyClause(firstToken, false);
                clauses.add(functionDeclaration);
                continue;
            }
            if (CdMdxTokenKind.CALCULATED == nextTokenKind) {
                CdMdxToken calculated = this.parseToken(CdMdxTokenKind.CALCULATED);
                this.parseToken(CdMdxTokenKind.MEMBER);
                clauses.add(this.parseCreateMemberBodyClause(false, calcMemberDeclarationOrder++, calculated));
                continue;
            }
            if (CdMdxTokenKind.MEMBER == nextTokenKind) {
                CdMdxToken member = this.parseToken(CdMdxTokenKind.MEMBER);
                clauses.add(this.parseCreateMemberBodyClause(false, calcMemberDeclarationOrder++, member));
                continue;
            }
            if (CdMdxTokenKind.CELL == nextTokenKind) {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_NOT_SUPPORTED, new Serializable[]{"CREATE CELL CALCULATION"});
            }
            if (CdMdxTokenKind.DYNAMIC == nextTokenKind || CdMdxTokenKind.STATIC == nextTokenKind || CdMdxTokenKind.SET == nextTokenKind) {
                boolean dynamicEvaluation = true;
                CdMdxToken tk = null;
                if (CdMdxTokenKind.DYNAMIC == nextTokenKind) {
                    tk = this.parseToken();
                    dynamicEvaluation = true;
                } else if (CdMdxTokenKind.STATIC == nextTokenKind) {
                    tk = this.parseToken();
                    dynamicEvaluation = false;
                }
                if (tk != null && CdMdxTokenKind.STATIC == tk.getKind() && this.isPeekNextTokenKindNativeOrFunction()) {
                    MdxSelectFunction function = this.parseCreateFunctionBodyClause(tk, false);
                    clauses.add(function);
                    continue;
                }
                CdMdxToken set = this.parseToken(CdMdxTokenKind.SET);
                clauses.add(this.parseCreateSetBodyClause(set, dynamicEvaluation));
                continue;
            }
            if (CdMdxTokenKind.CATEGORY == nextTokenKind) {
                CdMdxToken categoryToken = this.parseToken();
                CdMdxToken lookahead = this.peekNextToken(0);
                if (lookahead != null && lookahead.getKind() == CdMdxTokenKind.REGULAR_IDENTIFIER && lookahead.getLexeme().equalsIgnoreCase("hierarchy")) {
                    CdMdxToken hierarchyToken = this.parseToken();
                    clauses.add(this.parseCreateCategoryHierarchyBodyClause(false, categoryToken));
                    continue;
                }
                boolean dynamic = true;
                CdMdxToken modifier = this.peekNextToken(0);
                if (modifier != null && modifier.getKind() == CdMdxTokenKind.DYNAMIC) {
                    this.parseToken(CdMdxTokenKind.DYNAMIC);
                } else if (modifier != null && modifier.getKind() == CdMdxTokenKind.STATIC) {
                    this.parseToken(CdMdxTokenKind.STATIC);
                    dynamic = false;
                }
                boolean calculated = false;
                CdMdxToken calculatedTk = this.peekNextToken(0);
                if (calculatedTk != null && calculatedTk.getKind() == CdMdxTokenKind.CALCULATED) {
                    this.parseToken(CdMdxTokenKind.CALCULATED);
                    calculated = true;
                }
                CdMdxToken memberToken = this.parseToken(CdMdxTokenKind.MEMBER);
                clauses.add(this.parseCreateCategoryMemberBodyClause(false, categoryToken, dynamic, calculated));
                continue;
            }
            if (CdMdxTokenKind.MEASURE == nextTokenKind) {
                CdMdxToken measure = this.parseToken(CdMdxTokenKind.MEASURE);
                clauses.add(this.parseCreateMeasureBodyClause(false, measure));
                continue;
            }
            if (!CdMdxTokenKind.isIdentifier((CdMdxTokenKind)nextTokenKind)) break;
            clauses.add(this.parseCreateMemberBodyClause(false, calcMemberDeclarationOrder++, null));
        }
        if (clauses.isEmpty()) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_MEMBER_SET_WITH, new Serializable[0]);
        }
        return clauses;
    }

    private void setupForwardDeclaredFunctions() {
        CdMdxToken tk2 = null;
        CdMdxToken tk1 = null;
        CdMdxToken tk0 = null;
        int pos = 0;
        while (pos < this.tokens.size() - 1) {
            CdMdxToken tk;
            if (CdMdxTokenKind.isInvisible((CdMdxTokenKind)(tk = this.tokens.get(pos++)).getKind())) continue;
            tk2 = tk1;
            tk1 = tk0;
            tk0 = tk;
            if (tk2 == null || CdMdxTokenKind.FUNCTION != tk2.getKind() || CdMdxTokenKind.REGULAR_IDENTIFIER != tk1.getKind() || CdMdxTokenKind.OPEN_PAREN != tk0.getKind()) continue;
            this.forwardDeclaredFunctions.add(((CdMdxRegularIdentifierToken)tk1).getIdentifier());
        }
    }

    private MdxSelectNamedSet parseCreateSetBodyClause(@Nullable CdMdxToken set, boolean dynamicEvaluation) throws CdMdxScannerException, MdxParserException {
        MdxSelectSetProperties properties;
        MdxNamedSetIdentifierExpression id = this.parseNamedSetIdentifier();
        this.parseToken(CdMdxTokenKind.AS);
        MdxExpression formula = this.parseNestedExpression(null);
        if (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.COMMA);
            properties = this.parseSetProperties();
        } else {
            properties = null;
        }
        return new MdxSelectNamedSet(set != null ? set : id.getFirstToken(), id, formula, dynamicEvaluation, properties);
    }

    private MdxSelectSetProperties parseSetProperties() throws MdxParserException {
        CdMdxToken lastToken = null;
        CdMdxToken displayFolder = null;
        CdMdxToken description = null;
        while (true) {
            CdMdxToken token;
            if ((token = this.parseToken()) == null || !CdMdxTokenKind.isIdentifier((CdMdxTokenKind)token.getKind())) {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_SET_PROPERTY_NAME, new Serializable[0]);
            }
            CdMdxIdentifierToken id = (CdMdxIdentifierToken)token;
            if (id.isKey()) {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_INVALID_SET_PROPERTY_NAME, new Serializable[0]);
            }
            String tokenID = id.getIdentifier();
            this.parseToken(CdMdxTokenKind.EQ);
            lastToken = this.parseToken(CdMdxTokenKind.STRING);
            if (tokenID.equalsIgnoreCase("DISPLAY_FOLDER")) {
                displayFolder = lastToken;
            } else if (tokenID.equalsIgnoreCase("DESCRIPTION")) {
                description = lastToken;
            } else {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_INVALID_SET_PROPERTY_NAME, new Serializable[0]);
            }
            if (CdMdxTokenKind.COMMA != this.peekNextTokenKind()) break;
            this.parseToken(CdMdxTokenKind.COMMA);
        }
        return new MdxSelectSetProperties(lastToken, displayFolder, description);
    }

    private MdxNamedSetIdentifierExpression parseNamedSetIdentifier() throws MdxParserException {
        MdxIdentifierExpression id = this.parseIdentifierX("named set name");
        if (id.getPartCount() > 2 || id.isLastPartDefinedAsKey()) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_INVALID_NAME_SET_NAME, new Serializable[]{id.asMdx()});
        }
        return new MdxNamedSetIdentifierExpression(id);
    }

    private MdxIdentifierExpression parseAsNamedSetIdentifier() throws MdxParserException {
        MdxIdentifierExpression id = this.parseIdentifierX("as named set name");
        if (id.getPartCount() > 1 || id.isLastPartDefinedAsKey()) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_INVALID_NAME_SET_NAME, new Serializable[]{id.asMdx()});
        }
        return id;
    }

    private MdxSelectFunction parseCreateFunctionBodyClause(CdMdxToken firstToken, boolean createStatement) throws MdxParserException {
        boolean isNative;
        boolean isStatic;
        boolean isConstant;
        if (CdMdxTokenKind.FUNCTION == firstToken.getKind()) {
            boolean isNative2;
            boolean isStatic2;
            boolean isConstant2;
            if (CdMdxTokenKind.CONST == this.peekNextTokenKind()) {
                isConstant2 = true;
                isStatic2 = false;
                isNative2 = false;
                this.parseToken(CdMdxTokenKind.CONST);
            } else if (CdMdxTokenKind.STATIC == this.peekNextTokenKind()) {
                isConstant2 = false;
                isStatic2 = true;
                isNative2 = false;
                this.parseToken(CdMdxTokenKind.STATIC);
            } else {
                isConstant2 = false;
                isStatic2 = false;
                isNative2 = false;
            }
            return this.parseCreateFunctionBodyClause(firstToken, createStatement, isConstant2, isStatic2, isNative2);
        }
        if (CdMdxTokenKind.CONST == firstToken.getKind() || CdMdxTokenKind.STATIC == firstToken.getKind()) {
            isConstant = CdMdxTokenKind.CONST == firstToken.getKind();
            boolean bl = isStatic = CdMdxTokenKind.STATIC == firstToken.getKind();
            if (CdMdxTokenKind.NATIVE == this.peekNextTokenKind()) {
                isNative = true;
                this.parseToken(CdMdxTokenKind.NATIVE);
            } else {
                isNative = false;
            }
        } else if (CdMdxTokenKind.NATIVE == firstToken.getKind()) {
            isNative = true;
            if (CdMdxTokenKind.CONST == this.peekNextTokenKind()) {
                isConstant = true;
                isStatic = false;
                this.parseToken(CdMdxTokenKind.CONST);
            } else if (CdMdxTokenKind.STATIC == this.peekNextTokenKind()) {
                isConstant = false;
                isStatic = true;
                this.parseToken(CdMdxTokenKind.STATIC);
            } else {
                isConstant = false;
                isStatic = false;
            }
        } else {
            throw new MdxParserException(firstToken, CdMdxErrorCode.PARSE_MISSING, new Serializable[]{firstToken.getLexeme()});
        }
        this.parseToken(CdMdxTokenKind.FUNCTION);
        return this.parseCreateFunctionBodyClause(firstToken, createStatement, isConstant, isStatic, isNative);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MdxSelectFunction parseCreateFunctionBodyClause(CdMdxToken firstToken, boolean createStatement, boolean isConstant, boolean isStatic, boolean isNative) throws MdxParserException {
        MdxIdentifierExpression name = this.parseCreateFunctionBodyClause$name();
        if (createStatement ? this.context.isRegularFunctionName(name.getFirstToken().getIdentifier()) || this.isFunctionDeclared(name.getFirstToken().getIdentifier()) : this.isFunctionNameX(name.getFirstToken(), true)) {
            throw new MdxDuplicatedFunctionParserException((CdMdxToken)name.getFirstToken(), name.getLastPartAsString());
        }
        this.parseToken(CdMdxTokenKind.OPEN_PAREN);
        List<MdxFunctionTypedArgExpression> argNames = this.parseCreateFunctionBodyClause$argNames(name);
        this.parseToken(CdMdxTokenKind.CLOSE_PAREN);
        if (isConstant && !argNames.isEmpty()) {
            throw new MdxParserException((CdMdxToken)name.getFirstToken(), CdMdxErrorCode.PARSE_CONST_FUNCTION_ARGS, new Serializable[]{name.asMdx()});
        }
        this.parseToken(CdMdxTokenKind.AS);
        try {
            this.currentDeclaredFunctionName = name.getLastPartAsString();
            this.currentDeclaredFunctionArguments = argNames;
            MdxExpression body = this.parseCreateFunctionBodyClause$body(createStatement, this.currentDeclaredFunctionName, this.currentDeclaredFunctionArguments, isNative);
            MdxSelectFunctionProperties properties = this.parseFunctionProperties(createStatement, isConstant, isStatic);
            this.declaredFunctions.add(name.getLastPartAsString());
            MdxSelectFunction mdxSelectFunction = new MdxSelectFunction(firstToken, isConstant, isStatic, name, argNames, body, properties);
            return mdxSelectFunction;
        }
        finally {
            this.currentDeclaredFunctionName = null;
            this.currentDeclaredFunctionArguments = null;
        }
    }

    private MdxExpression parseCreateFunctionBodyClause$body(boolean createStatement, String functionName, List<MdxFunctionTypedArgExpression> args, boolean isNative) throws MdxParserException {
        CdMdxToken token;
        if (!isNative) {
            return this.parseValueExpression();
        }
        while ((token = this.doParseToken()) != null) {
            if (!CdMdxTokenKind.isInvisible((CdMdxTokenKind)token.getKind())) {
                throw new MdxParserException(token, CdMdxErrorCode.PARSE_MISSING, new Serializable[]{CdMdxTokenKind.COMMENT.getLexemeForError(), token.getLexeme()});
            }
            if (CdMdxTokenKind.COMMENT != token.getKind()) continue;
            return new MdxFunctionNativeBodyExpression(!createStatement, functionName, args, token);
        }
        throw new MdxParserException(null, CdMdxErrorCode.PARSE_MISSING, new Serializable[]{CdMdxTokenKind.COMMENT.getLexemeForError(), "eof"});
    }

    @Nullable
    private MdxSelectFunctionProperties parseFunctionProperties(boolean createStatement, boolean isConstant, boolean isStatic) throws MdxParserException {
        if (!isConstant && !isStatic) {
            return null;
        }
        CdMdxToken cubeNameTk = null;
        String cubeName = null;
        CdMdxToken cachedTk = null;
        Boolean cached = null;
        while (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
            String prop;
            this.parseToken(CdMdxTokenKind.COMMA);
            CdMdxToken token = this.parseToken();
            if (token != null && token.getKind() == CdMdxTokenKind.CUBE) {
                prop = "CUBE";
            } else {
                if (token == null || !CdMdxTokenKind.isIdentifier((CdMdxTokenKind)token.getKind())) {
                    throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_FUNC_PROPERTY_NAME, new Serializable[0]);
                }
                CdMdxIdentifierToken id = (CdMdxIdentifierToken)token;
                if (id.isKey()) {
                    throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_INVALID_FUNC_PROPERTY_NAME, new Serializable[0]);
                }
                prop = ((CdMdxIdentifierToken)token).getIdentifier();
            }
            this.parseToken(CdMdxTokenKind.EQ);
            if ("CUBE".equalsIgnoreCase(prop)) {
                MdxIdentifierExpression idExpr;
                MdxExpression cubeExpr = this.parseValueExpression();
                if (cubeExpr instanceof MdxIdentifierExpression && !(idExpr = (MdxIdentifierExpression)cubeExpr).isLastPartDefinedAsKey() && idExpr.getPartCount() == 1) {
                    CdMdxIdentifierToken idTk = idExpr.getPart(0);
                    cubeNameTk = cubeExpr.getFirstToken();
                    cubeName = idTk.getIdentifier();
                    continue;
                }
                throw new MdxParserException(cubeExpr.getFirstToken(), CdMdxErrorCode.PARSE_FUNCTION_CUBE, new Serializable[0]);
            }
            if ("CACHED".equalsIgnoreCase(prop)) {
                MdxExpression cachedExpr = this.parseValueExpression();
                if (cachedExpr instanceof MdxTrueLiteralExpression) {
                    cachedTk = cachedExpr.getFirstToken();
                    cached = true;
                    continue;
                }
                if (cachedExpr instanceof MdxFalseLiteralExpression) {
                    cachedTk = cachedExpr.getFirstToken();
                    cached = false;
                    continue;
                }
                throw new MdxParserException(cachedExpr.getFirstToken(), CdMdxErrorCode.PARSE_FUNCTION_CACHED, new Serializable[0]);
            }
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_INVALID_FUNC_PROPERTY_NAME, new Serializable[0]);
        }
        if (!createStatement || isConstant) {
            cubeNameTk = null;
            cubeName = null;
        }
        if (cubeNameTk != null || cachedTk != null) {
            return new MdxSelectFunctionProperties(cubeNameTk, cubeName, cachedTk, cached);
        }
        return null;
    }

    private MdxIdentifierExpression parseCreateFunctionBodyClause$name() throws MdxParserException {
        MdxIdentifierExpression name = this.parseIdentifierX("function name");
        if (name.getPartCount() != 1) {
            throw new MdxParserException((CdMdxToken)name.getFirstToken(), CdMdxErrorCode.PARSE_FUNCTION_NAME_MULTI_PART_ID, new Serializable[]{name.asMdx()});
        }
        CdMdxIdentifierToken firstIdPart = name.getParts().get(0);
        if (name.isLastPartDefinedAsKey()) {
            throw new MdxParserException((CdMdxToken)name.getFirstToken(), CdMdxErrorCode.PARSE_FUNCTION_NAME_KEY, new Serializable[]{name.asMdx()});
        }
        if (firstIdPart.isDelimited()) {
            throw new MdxParserException((CdMdxToken)name.getFirstToken(), CdMdxErrorCode.PARSE_FUNCTION_NAME_DELIMITED_ID, new Serializable[]{name.asMdx()});
        }
        return name;
    }

    private List<MdxFunctionTypedArgExpression> parseCreateFunctionBodyClause$argNames(MdxIdentifierExpression functionName) throws MdxParserException {
        ArrayList<MdxFunctionTypedArgExpression> argNames = new ArrayList<MdxFunctionTypedArgExpression>();
        if (CdMdxTokenKind.CLOSE_PAREN == this.peekNextTokenKind()) {
            return argNames;
        }
        while (true) {
            MdxIdentifierExpression argName;
            MdxIdentifierExpression argType;
            MdxIdentifierExpression typeOrArgName = this.parseIdentifierX("function parameter type/name");
            if (CdMdxTokenKind.isIdentifier((CdMdxTokenKind)this.peekNextTokenKind())) {
                argType = this.assertFunctionArgType(functionName, argNames, typeOrArgName);
                argName = this.assertFunctionArgName(functionName, argNames, this.parseIdentifierX("function parameter name"));
            } else {
                argType = null;
                argName = this.assertFunctionArgName(functionName, argNames, typeOrArgName);
            }
            String argNameAsString = argName.getFirstToken().getIdentifier();
            if (this.context.isRegularFunctionName(argNameAsString) || this.isFunctionDeclared(argNameAsString)) {
                throw new MdxParserException((CdMdxToken)argName.getFirstToken(), CdMdxErrorCode.PARSE_FUNCTION_ARG_NAME_INVALID, new Serializable[]{functionName.asMdx(), argName.asMdx()});
            }
            argNames.add(new MdxFunctionTypedArgExpression(argType, argName));
            if (CdMdxTokenKind.COMMA != this.peekNextTokenKind()) break;
            this.parseToken(CdMdxTokenKind.COMMA);
        }
        return argNames;
    }

    private MdxIdentifierExpression assertFunctionArgType(MdxIdentifierExpression functionName, List<MdxFunctionTypedArgExpression> argNames, MdxIdentifierExpression type) throws MdxParserException {
        if (type.isLastPartDefinedAsKey()) {
            throw new MdxParserException((CdMdxToken)type.getFirstToken(), CdMdxErrorCode.PARSE_FUNCTION_ARG_TYPE_KEY, new Serializable[]{functionName.asMdx(), type.asMdx()});
        }
        if (type.isDelimited()) {
            throw new MdxParserException((CdMdxToken)type.getFirstToken(), CdMdxErrorCode.PARSE_FUNCTION_ARG_TYPE_DELIMITED_ID, new Serializable[]{functionName.asMdx(), type.asMdx() + "'"});
        }
        return type;
    }

    private MdxIdentifierExpression assertFunctionArgName(MdxIdentifierExpression functionName, List<MdxFunctionTypedArgExpression> argNames, MdxIdentifierExpression name) throws MdxParserException {
        if (name.getPartCount() != 1) {
            throw new MdxParserException((CdMdxToken)name.getFirstToken(), CdMdxErrorCode.PARSE_FUNCTION_ARG_NAME_MULTI_PART_ID, new Serializable[]{functionName.asMdx(), name.asMdx()});
        }
        CdMdxIdentifierToken firstIdPart = name.getParts().get(0);
        if (name.isLastPartDefinedAsKey()) {
            throw new MdxParserException((CdMdxToken)name.getFirstToken(), CdMdxErrorCode.PARSE_FUNCTION_ARG_NAME_KEY, new Serializable[]{functionName.asMdx(), name.asMdx()});
        }
        if (firstIdPart.isDelimited()) {
            throw new MdxParserException((CdMdxToken)name.getFirstToken(), CdMdxErrorCode.PARSE_FUNCTION_ARG_NAME_DELIMITED_ID, new Serializable[]{functionName.asMdx(), name.asMdx() + "'"});
        }
        for (MdxFunctionTypedArgExpression argName : argNames) {
            if (!argName.getName().equalsIgnoreCase(name.getLastPartAsString())) continue;
            throw new MdxParserException((CdMdxToken)name.getFirstToken(), CdMdxErrorCode.PARSE_FUNCTION_ARG_DUPLICATED, new Serializable[]{functionName.asMdx(), name.asMdx()});
        }
        return name;
    }

    private MdxSelectMeasure parseCreateMeasureBodyClause(boolean createStatement, @Nullable CdMdxToken first) throws CdMdxScannerException, MdxParserException {
        MdxIdentifierExpression id = this.parseMeasureIdentifier(createStatement);
        String measureName = id.getLastPartAsString();
        String cubeName = id.getPartCount() > 1 ? id.getFirstToken().getIdentifier() : null;
        this.parseToken(CdMdxTokenKind.AS);
        CdMdxToken firstToken = first != null ? first : id.getFirstToken();
        MdxExpression formula = this.parseNestedExpression(null);
        if (this.peekNextTokenKind() != CdMdxTokenKind.COMMA) {
            throw new MdxParserException((CdMdxToken)id.getFirstToken(), CdMdxErrorCode.PARSE_MEASURE_MISSING_PROPERTIES, new Serializable[]{id.asMdx()});
        }
        this.parseToken(CdMdxTokenKind.COMMA);
        MdxSelectMeasureProperties properties = this.parseMeasureProperties(id, measureName);
        return new MdxSelectMeasure(!createStatement, firstToken, cubeName, measureName, id, formula, properties);
    }

    private MdxSelectCalcMember parseCreateMemberBodyClause(boolean createStatement, long declarationOrder, @Nullable CdMdxToken first) throws CdMdxScannerException, MdxParserException {
        MdxSelectCalcMemberProperties properties;
        MdxIdentifierExpression id = this.parseCalcMemberIdentifier();
        this.parseToken(CdMdxTokenKind.AS);
        MdxExpression formula = this.parseCalculatedMemberFormula();
        if (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.COMMA);
            properties = this.parseCalcMemberProperties();
        } else {
            properties = null;
        }
        if (properties != null) {
            this.assertNoDuplicate(id, properties);
        }
        return new MdxSelectCalcMember(!createStatement, declarationOrder, (CdMdxToken)(first != null ? first : id.getFirstToken()), id, formula, properties);
    }

    private MdxSelectCategoryHierarchy parseCreateCategoryHierarchyBodyClause(boolean sessionScoped, @Nullable CdMdxToken first) throws CdMdxScannerException, MdxParserException {
        MdxSelectCategoryProperties properties;
        MdxIdentifierExpression id = this.parseCategoryHierarchyIdentifier();
        if (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.COMMA);
            properties = this.parseCategoryProperties();
        } else {
            properties = null;
        }
        if (properties != null) {
            this.assertNoDuplicate(id, properties);
        }
        return new MdxSelectCategoryHierarchy(sessionScoped, (CdMdxToken)(first != null ? first : id.getFirstToken()), id, properties);
    }

    private MdxIdentifierExpression parseCategoryHierarchyIdentifier() throws MdxParserException {
        MdxIdentifierExpression id = this.parseIdentifierX("category hierarchy name");
        if (id.isLastPartDefinedAsKey()) {
            throw new MdxParserException(id.getLastToken(), CdMdxErrorCode.PARSE_INVALID_CATEGORY_HIERARCHY_NAME_KEY, new Serializable[]{id.asMdx()});
        }
        if (id.getPartCount() != 2) {
            throw new MdxParserException((CdMdxToken)id.getFirstToken(), CdMdxErrorCode.PARSE_INVALID_CATEGORY_HIERARCHY_NAME, new Serializable[]{id.asMdx()});
        }
        return id;
    }

    private MdxSelectCategoryMember parseCreateCategoryMemberBodyClause(boolean sessionScoped, @Nullable CdMdxToken first, boolean dynamicEvaluation, boolean calculated) throws CdMdxScannerException, MdxParserException {
        MdxSelectCategoryProperties properties;
        MdxIdentifierExpression id = this.parseCategoryMemberIdentifier();
        this.parseToken(CdMdxTokenKind.AS);
        MdxExpression formula = this.parseCategoryMemberFormula();
        if (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.COMMA);
            properties = this.parseCategoryProperties();
        } else {
            properties = null;
        }
        if (properties != null) {
            this.assertNoDuplicate(id, properties);
        }
        MdxSelectCategoryMember member = new MdxSelectCategoryMember(sessionScoped, (CdMdxToken)(first != null ? first : id.getFirstToken()), id, dynamicEvaluation, calculated, formula, properties);
        return member;
    }

    private MdxIdentifierExpression parseCategoryMemberIdentifier() throws MdxParserException {
        MdxIdentifierExpression id = this.parseIdentifierX("category member name");
        if (id.isLastPartDefinedAsKey()) {
            throw new MdxParserException(id.getLastToken(), CdMdxErrorCode.PARSE_INVALID_CATEGORY_MEMBER_NAME_KEY, new Serializable[]{id.asMdx()});
        }
        if (id.getPartCount() < 2) {
            throw new MdxParserException((CdMdxToken)id.getFirstToken(), CdMdxErrorCode.PARSE_INVALID_CATEGORY_MEMBER_NAME, new Serializable[]{id.asMdx()});
        }
        return id;
    }

    private MdxExpression parseCategoryMemberFormula() throws CdMdxScannerException, MdxParserException {
        return this.parseNestedExpression(null);
    }

    @Nullable
    private MdxSelectCategoryProperties parseCategoryProperties() throws CdMdxScannerException, MdxParserException {
        ArrayList<MdxSelectCategoryProperty> properties = new ArrayList<MdxSelectCategoryProperty>();
        while (true) {
            MdxSelectCategoryProperty property = this.parseCategoryProperty();
            properties.add(property);
            if (CdMdxTokenKind.COMMA != this.peekNextTokenKind()) break;
            this.parseToken(CdMdxTokenKind.COMMA);
        }
        return !properties.isEmpty() ? new MdxSelectCategoryProperties((List<MdxSelectCategoryProperty>)properties) : null;
    }

    private MdxSelectCategoryProperty parseCategoryProperty() throws CdMdxScannerException, MdxParserException {
        CdMdxToken token = this.parseToken();
        if (token == null || !CdMdxTokenKind.isIdentifier((CdMdxTokenKind)token.getKind())) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_CATEGORY_MEMBER_PROPERTY_NAME, new Serializable[0]);
        }
        CdMdxIdentifierToken id = (CdMdxIdentifierToken)token;
        if (id.isKey()) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_INVALID_CATEGORY_MEMBER_PROPERTY_NAME, new Serializable[0]);
        }
        this.parseToken(CdMdxTokenKind.EQ);
        MdxExpression expr = this.parseValueExpression();
        return new MdxSelectCategoryProperty(new MdxIdentifierExpression(id), expr);
    }

    @Nullable
    private MdxAuthorizationExpression parseAuthorizationExpression() throws CdMdxScannerException, MdxParserException {
        ArrayList<List<CdMdxToken>> allLineTokens = new ArrayList<List<CdMdxToken>>();
        ArrayList<CdMdxToken> lineToken = null;
        for (int ii = 0; ii < this.tokens.size(); ++ii) {
            CdMdxToken token = this.tokens.get(ii);
            if (CdMdxTokenKind.EOL != token.getKind()) {
                if (lineToken == null) {
                    lineToken = new ArrayList<CdMdxToken>();
                    allLineTokens.add(lineToken);
                }
                lineToken.add(token);
                continue;
            }
            if (ii > 1 && this.tokens.get(ii - 1).getKind() == CdMdxTokenKind.EOL) {
                allLineTokens.add(new ArrayList());
                lineToken = null;
                continue;
            }
            lineToken = null;
        }
        MdxParser.fixMultiLineAuthorizations(allLineTokens);
        int line = 0;
        boolean state_GLOBAL = true;
        boolean state_SCHEMA_SCOPE_HEADER = false;
        boolean state_SCHEMA_SCOPE_CONTENT = false;
        MdxAuthorizationSchemaAccessStatement g_DefaultAccess = null;
        MdxAuthorizationDrillthroughStatement g_Drillthrough = null;
        ArrayList<MdxAuthorizationSchemaStatement> g_SchemaStatements = new ArrayList<MdxAuthorizationSchemaStatement>();
        ArrayList<MdxAuthorizationSchemaExpressionPP> g_SchemaExpressions = new ArrayList<MdxAuthorizationSchemaExpressionPP>();
        MdxAuthorizationSchemaScopeStatement s_Scope = null;
        ArrayList<MdxAuthorizationStatement> s_Statements = new ArrayList<MdxAuthorizationStatement>();
        while (line < allLineTokens.size()) {
            MdxIdentifierExpression name;
            CdMdxToken rw;
            CdMdxToken lineType;
            CdMdxTokenKind lineTypeLookAhead;
            CdMdxToken plusMinusToken;
            this.tokens.clear();
            this.tokens.addAll((Collection)allLineTokens.get(line++));
            this.currentTokenIndex = 0;
            this.lastTokenParsed = -1;
            CdMdxToken lookahead = this.peekNextToken(0);
            if (lookahead == null) continue;
            CdMdxTokenKind tokenKind = lookahead.getKind();
            if (state_GLOBAL) {
                if (CdMdxTokenKind.RANGE == tokenKind) {
                    state_GLOBAL = false;
                    state_SCHEMA_SCOPE_HEADER = true;
                    state_SCHEMA_SCOPE_CONTENT = false;
                }
            } else if (state_SCHEMA_SCOPE_HEADER) {
                state_GLOBAL = false;
                state_SCHEMA_SCOPE_HEADER = false;
                state_SCHEMA_SCOPE_CONTENT = true;
            } else if (state_SCHEMA_SCOPE_CONTENT) {
                if (CdMdxTokenKind.RANGE == tokenKind) {
                    g_SchemaExpressions.add(MdxAuthorizationSchemaExpressionPP.validate(s_Scope, s_Statements));
                    s_Scope = null;
                    s_Statements = new ArrayList();
                    state_GLOBAL = false;
                    state_SCHEMA_SCOPE_HEADER = true;
                    state_SCHEMA_SCOPE_CONTENT = false;
                }
            } else {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_EXPRESSION, new Serializable[0]);
            }
            if (state_GLOBAL && (CdMdxTokenKind.PLUS == tokenKind || CdMdxTokenKind.MINUS == tokenKind)) {
                plusMinusToken = this.parseToken();
                lineTypeLookAhead = this.peekNextTokenKind();
                lineType = CdMdxTokenKind.DRILLTHROUGH == lineTypeLookAhead ? this.parseToken(CdMdxTokenKind.DRILLTHROUGH) : this.parseToken(CdMdxTokenKind.REGULAR_IDENTIFIER);
                if ("schemaAccess".equalsIgnoreCase(lineType.getLexeme())) {
                    if (CdMdxTokenKind.MINUS == plusMinusToken.getKind()) {
                        throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_LINE_TYPE, new Serializable[]{lineType.getLexeme()});
                    }
                    rw = this.parseToken(CdMdxTokenKind.REGULAR_IDENTIFIER);
                    if (!"R".equalsIgnoreCase(rw.getLexeme()) && !"W".equalsIgnoreCase(rw.getLexeme())) {
                        throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_MISSING_RW, new Serializable[]{lineType.getLexeme()});
                    }
                    if (g_DefaultAccess != null) {
                        throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_LINE_TYPE, new Serializable[]{lineType.getLexeme()});
                    }
                    g_DefaultAccess = new MdxAuthorizationSchemaAccessStatement(plusMinusToken, rw);
                    continue;
                }
                if ("drillthrough".equalsIgnoreCase(lineType.getLexeme())) {
                    if (CdMdxTokenKind.PLUS == plusMinusToken.getKind()) {
                        throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_LINE_TYPE, new Serializable[]{lineType.getLexeme()});
                    }
                    if (g_Drillthrough != null) {
                        throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_LINE_TYPE, new Serializable[]{lineType.getLexeme()});
                    }
                    g_Drillthrough = new MdxAuthorizationDrillthroughStatement(plusMinusToken);
                    continue;
                }
                if ("schema".equalsIgnoreCase(lineType.getLexeme())) {
                    name = this.parseIdentifierOnly();
                    if (name.getPartCount() != 1 || name.isLastPartDefinedAsKey()) {
                        throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_NAME, new Serializable[]{"schema : " + name.asMdx()});
                    }
                    g_SchemaStatements.add(new MdxAuthorizationSchemaStatement(plusMinusToken, name.getFirstToken()));
                    continue;
                }
                if ("schemaS".equalsIgnoreCase(lineType.getLexeme()) && plusMinusToken.getKind() == CdMdxTokenKind.MINUS && this.peekNextTokenKind() == null) {
                    g_SchemaStatements.add(new MdxAuthorizationDenySchemasStatement(plusMinusToken));
                    continue;
                }
            }
            if (state_SCHEMA_SCOPE_HEADER) {
                CdMdxToken rangeToken = this.parseToken(CdMdxTokenKind.RANGE);
                CdMdxToken schemaToken = this.parseToken(CdMdxTokenKind.REGULAR_IDENTIFIER);
                MdxIdentifierExpression name2 = this.parseIdentifierOnly();
                if (name2.getPartCount() != 1 || name2.isLastPartDefinedAsKey()) {
                    throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_NAME, new Serializable[]{"schema : " + name2.asMdx()});
                }
                CdMdxIdentifierToken schemaName = name2.getFirstToken();
                s_Scope = new MdxAuthorizationSchemaScopeStatement(rangeToken, schemaName);
                continue;
            }
            if (state_SCHEMA_SCOPE_CONTENT) {
                CdMdxToken token;
                if (this.isIF(lookahead)) {
                    token = this.parseToken();
                    MdxExpression vExpr = this.parseValueExpression();
                    s_Statements.add(new MdxAuthorizationIfStatement(token, vExpr));
                    continue;
                }
                if (this.isELSE(lookahead)) {
                    token = this.parseToken();
                    s_Statements.add(new MdxAuthorizationElseStatement(token));
                    continue;
                }
                if (this.isENDIF(lookahead)) {
                    token = this.parseToken();
                    s_Statements.add(new MdxAuthorizationEndifStatement(token));
                    continue;
                }
                if (this.isForEach(lookahead)) {
                    MdxIdentifierExpression dimension;
                    CdMdxToken star;
                    token = this.parseToken();
                    CdMdxToken tokenHierarchy = this.parseToken(CdMdxTokenKind.REGULAR_IDENTIFIER);
                    if (!(tokenHierarchy instanceof CdMdxRegularIdentifierToken) || !tokenHierarchy.getLexeme().equalsIgnoreCase("hierarchy")) {
                        throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_PP_FOREACH_TYPE, new Serializable[]{tokenHierarchy.getLexeme()});
                    }
                    if (this.peekNextTokenKind() == CdMdxTokenKind.MULTIPLY) {
                        star = this.parseToken();
                        dimension = null;
                    } else {
                        star = null;
                        dimension = this.parseIdentifierOnly();
                    }
                    CdMdxToken valueExprLookahead = this.peekNextToken(1);
                    MdxExpression filterExpr = valueExprLookahead != null ? this.parseValueExpression() : null;
                    s_Statements.add(new MdxAuthorizationForEachStatement(token, tokenHierarchy, star, dimension, filterExpr));
                    continue;
                }
                if (this.isEndForEach(lookahead)) {
                    token = this.parseToken();
                    s_Statements.add(new MdxAuthorizationEndforeachStatement(token));
                    continue;
                }
                if (CdMdxTokenKind.PLUS == tokenKind || CdMdxTokenKind.MINUS == tokenKind) {
                    plusMinusToken = this.parseToken();
                    lineTypeLookAhead = this.peekNextTokenKind();
                    lineType = CdMdxTokenKind.CUBE == lineTypeLookAhead ? this.parseToken(CdMdxTokenKind.CUBE) : (CdMdxTokenKind.DIMENSION == lineTypeLookAhead ? this.parseToken(CdMdxTokenKind.DIMENSION) : (CdMdxTokenKind.MEASURE == lineTypeLookAhead ? this.parseToken(CdMdxTokenKind.MEASURE) : (CdMdxTokenKind.DRILLTHROUGH == lineTypeLookAhead ? this.parseToken(CdMdxTokenKind.DRILLTHROUGH) : (CdMdxTokenKind.ALL == lineTypeLookAhead ? this.parseToken(CdMdxTokenKind.ALL) : this.parseToken(CdMdxTokenKind.REGULAR_IDENTIFIER)))));
                    if ("schemaAccess".equalsIgnoreCase(lineType.getLexeme())) {
                        if (CdMdxTokenKind.MINUS == plusMinusToken.getKind()) {
                            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_LINE_TYPE, new Serializable[]{lineType.getLexeme()});
                        }
                        rw = this.parseToken(CdMdxTokenKind.REGULAR_IDENTIFIER);
                        if (!"R".equalsIgnoreCase(rw.getLexeme()) && !"W".equalsIgnoreCase(rw.getLexeme())) {
                            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_MISSING_RW, new Serializable[]{lineType.getLexeme()});
                        }
                        s_Statements.add(new MdxAuthorizationSchemaAccessStatement(plusMinusToken, rw));
                        continue;
                    }
                    if ("drillthrough".equalsIgnoreCase(lineType.getLexeme())) {
                        if (CdMdxTokenKind.PLUS == plusMinusToken.getKind()) {
                            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_LINE_TYPE, new Serializable[]{lineType.getLexeme()});
                        }
                        s_Statements.add(new MdxAuthorizationDrillthroughStatement(plusMinusToken));
                        continue;
                    }
                    if ("reportingDataSource".equalsIgnoreCase(lineType.getLexeme())) {
                        name = this.parseIdentifierOnly();
                        if (name.getPartCount() != 1 || name.isLastPartDefinedAsKey()) {
                            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_NAME, new Serializable[]{"reportingDataSource : " + name.asMdx()});
                        }
                        s_Statements.add(new MdxAuthorizationReportingDataSourceStatement(plusMinusToken, name.getFirstToken()));
                        continue;
                    }
                    if ("reportingDataSourceS".equalsIgnoreCase(lineType.getLexeme()) && plusMinusToken.getKind() == CdMdxTokenKind.MINUS && this.peekNextTokenKind() == null) {
                        s_Statements.add(new MdxAuthorizationDenyReportingDataSourcesStatement(plusMinusToken));
                        continue;
                    }
                    if ("all".equalsIgnoreCase(lineType.getLexeme()) && plusMinusToken.getKind() == CdMdxTokenKind.MINUS && this.peekNextTokenKind() == null) {
                        s_Statements.add(new MdxAuthorizationDenyAllStatement(plusMinusToken));
                        continue;
                    }
                    if ("dimension".equalsIgnoreCase(lineType.getLexeme())) {
                        name = this.parseIdentifierOnly();
                        if (name.getPartCount() != 1 || name.isLastPartDefinedAsKey()) {
                            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_NAME, new Serializable[]{"dimension : " + name.asMdx()});
                        }
                        s_Statements.add(new MdxAuthorizationDimensionStatement(plusMinusToken, name));
                        continue;
                    }
                    if ("hierarchy".equalsIgnoreCase(lineType.getLexeme())) {
                        name = this.parseIdentifierOnly();
                        if (name.isLastPartDefinedAsKey()) {
                            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_NAME, new Serializable[]{"hierarchy : " + name.asMdx()});
                        }
                        s_Statements.add(new MdxAuthorizationHierarchyStatement(plusMinusToken, name));
                        continue;
                    }
                    if ("level".equalsIgnoreCase(lineType.getLexeme())) {
                        if (CdMdxTokenKind.PLUS == plusMinusToken.getKind()) {
                            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_LINE_TYPE, new Serializable[]{lineType.getLexeme()});
                        }
                        name = this.parseIdentifierOnly();
                        if (name.isLastPartDefinedAsKey()) {
                            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_NAME, new Serializable[]{"level : " + name.asMdx()});
                        }
                        s_Statements.add(new MdxAuthorizationLevelStatement(plusMinusToken, name));
                        continue;
                    }
                    if ("defaultMember".equalsIgnoreCase(lineType.getLexeme())) {
                        if (CdMdxTokenKind.MINUS == plusMinusToken.getKind()) {
                            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_LINE_TYPE, new Serializable[]{lineType.getLexeme()});
                        }
                        name = this.parseIdentifierOnly();
                        s_Statements.add(new MdxAuthorizationDefaultMemberStatement(plusMinusToken, name));
                        continue;
                    }
                    if ("perspective".equalsIgnoreCase(lineType.getLexeme())) {
                        name = this.parseIdentifierOnly();
                        if (name.getPartCount() != 1 || name.isLastPartDefinedAsKey()) {
                            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_NAME, new Serializable[]{"perspective : " + name.asMdx()});
                        }
                        s_Statements.add(new MdxAuthorizationPerspectiveStatement(plusMinusToken, name.getFirstToken()));
                        continue;
                    }
                    if ("perspectiveS".equalsIgnoreCase(lineType.getLexeme()) && plusMinusToken.getKind() == CdMdxTokenKind.MINUS && this.peekNextTokenKind() == null) {
                        s_Statements.add(new MdxAuthorizationDenyPerspectivesStatement(plusMinusToken));
                        continue;
                    }
                    if ("cube".equalsIgnoreCase(lineType.getLexeme())) {
                        CdMdxToken rw2;
                        CdMdxToken rwLookAhead = this.peekNextToken(0);
                        if (rwLookAhead != null && ("R".equalsIgnoreCase(rwLookAhead.getLexeme()) || "W".equalsIgnoreCase(rwLookAhead.getLexeme()))) {
                            this.parseToken();
                            rw2 = rwLookAhead;
                        } else {
                            rw2 = null;
                        }
                        MdxIdentifierExpression name3 = this.parseIdentifierOnly();
                        if (name3.getPartCount() != 1 || name3.isLastPartDefinedAsKey()) {
                            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_NAME, new Serializable[]{"cube : " + name3.asMdx()});
                        }
                        s_Statements.add(new MdxAuthorizationCubeStatement(plusMinusToken, rw2, name3.getFirstToken()));
                        continue;
                    }
                    if ("measureGroup".equalsIgnoreCase(lineType.getLexeme())) {
                        name = this.parseIdentifierOnly();
                        if (name.isLastPartDefinedAsKey()) {
                            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_NAME, new Serializable[]{"cube : " + name.asMdx()});
                        }
                        s_Statements.add(new MdxAuthorizationMeasureGroupStatement(plusMinusToken, name));
                        continue;
                    }
                    if ("measure".equalsIgnoreCase(lineType.getLexeme())) {
                        name = this.parseIdentifierOnly();
                        if (name.isLastPartDefinedAsKey()) {
                            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_NAME, new Serializable[]{"cube : " + name.asMdx()});
                        }
                        s_Statements.add(new MdxAuthorizationMeasureStatement(plusMinusToken, name));
                        continue;
                    }
                    if ("tuples".equalsIgnoreCase(lineType.getLexeme())) {
                        CdMdxToken dc_LookAhead = this.peekNextToken(0);
                        CdMdxToken dc = dc_LookAhead != null && ("D".equalsIgnoreCase(dc_LookAhead.getLexeme()) || "C".equalsIgnoreCase(dc_LookAhead.getLexeme()) || "DC".equalsIgnoreCase(dc_LookAhead.getLexeme()) || "CD".equalsIgnoreCase(dc_LookAhead.getLexeme()) || "DA".equalsIgnoreCase(dc_LookAhead.getLexeme()) || "DAC".equalsIgnoreCase(dc_LookAhead.getLexeme()) || "CDA".equalsIgnoreCase(dc_LookAhead.getLexeme())) ? this.parseToken() : null;
                        CdMdxToken noDesc_LookAhead = this.peekNextToken(0);
                        CdMdxToken noDesc = noDesc_LookAhead != null && "NO_DESC".equalsIgnoreCase(noDesc_LookAhead.getLexeme()) ? this.parseToken() : null;
                        CdMdxToken measureGroupNamesMinusToken = null;
                        List<MdxQualifiedMeasureGroupNameIdentifierExpression> measureGroupNamesExpression = null;
                        CdMdxToken measureGroups_LookAhead = this.peekNextToken(0);
                        if ("measureGroups".equalsIgnoreCase(measureGroups_LookAhead.getLexeme())) {
                            if (dc != null && dc.getLexeme().equalsIgnoreCase("D")) {
                                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_UNEXPECTED_MEASURE_GROUP_NAMES, new Serializable[0]);
                            }
                            this.parseToken();
                            this.parseToken(CdMdxTokenKind.EQ);
                            if (CdMdxTokenKind.MINUS == this.peekNextTokenKind()) {
                                measureGroupNamesMinusToken = this.parseToken();
                            } else if (CdMdxTokenKind.PLUS == this.peekNextTokenKind()) {
                                this.parseToken();
                            }
                            measureGroupNamesExpression = this.parseMeasureGroupNames();
                        }
                        MdxExpression set = this.parseValueExpression();
                        s_Statements.add(new MdxAuthorizationTuplesStatement(plusMinusToken, dc, noDesc, set, measureGroupNamesMinusToken, measureGroupNamesExpression));
                        continue;
                    }
                } else if (CdMdxTokenKind.isKeyword((CdMdxTokenKind)CdMdxTokenKind.CREATE)) {
                    CdMdxToken createToken = this.parseToken();
                    CdMdxTokenKind nextTokenKind = this.peekNextTokenKind();
                    if (CdMdxTokenKind.SET == nextTokenKind) {
                        CdMdxToken setToken = this.parseToken(CdMdxTokenKind.SET);
                        MdxSelectNamedSet set = this.parseCreateSetBodyClause(setToken, false);
                        s_Statements.add(new MdxAuthorizationCreateSetStatement(createToken, set));
                        continue;
                    }
                    if (CdMdxTokenKind.FUNCTION == nextTokenKind) {
                        CdMdxToken firstToken = this.parseToken();
                        MdxSelectFunction function = this.parseCreateFunctionBodyClause(firstToken, true);
                        s_Statements.add(new MdxAuthorizationCreateFunctionStatement(createToken, function));
                        continue;
                    }
                }
            }
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_EXPRESSION, new Serializable[0]);
        }
        if (s_Scope != null) {
            g_SchemaExpressions.add(MdxAuthorizationSchemaExpressionPP.validate(s_Scope, s_Statements));
        }
        if (g_DefaultAccess == null && g_Drillthrough == null && g_SchemaStatements.isEmpty() && g_SchemaExpressions.isEmpty()) {
            return null;
        }
        return new MdxAuthorizationExpression(g_DefaultAccess, g_Drillthrough, g_SchemaStatements, g_SchemaExpressions);
    }

    private static void fixMultiLineAuthorizations(List<List<CdMdxToken>> lines) {
        ArrayList<List<Object>> fixed = new ArrayList<List<Object>>();
        ArrayList<CdMdxToken> createLine = null;
        for (List<CdMdxToken> line : lines) {
            if (createLine == null) {
                if (!line.isEmpty() && "create".equalsIgnoreCase(line.get(0).getLexeme())) {
                    createLine = new ArrayList<CdMdxToken>();
                    createLine.addAll(line);
                    continue;
                }
                fixed.add(line);
                continue;
            }
            if (MdxParser.isEmptyAuthorizationLine(line)) {
                fixed.add(createLine);
                createLine = null;
                continue;
            }
            createLine.addAll(line);
        }
        if (createLine != null) {
            fixed.add(createLine);
            createLine = null;
        }
        lines.clear();
        lines.addAll(fixed);
    }

    private static boolean isEmptyAuthorizationLine(List<CdMdxToken> line) {
        for (CdMdxToken token : line) {
            if (token.isInvisible()) continue;
            return false;
        }
        return true;
    }

    private List<MdxQualifiedMeasureGroupNameIdentifierExpression> parseMeasureGroupNames() throws MdxParserException {
        ArrayList<MdxQualifiedMeasureGroupNameIdentifierExpression> expressions = new ArrayList<MdxQualifiedMeasureGroupNameIdentifierExpression>();
        expressions.add(this.parseMeasureGroupName());
        while (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.COMMA);
            expressions.add(this.parseMeasureGroupName());
        }
        return expressions;
    }

    private MdxQualifiedMeasureGroupNameIdentifierExpression parseMeasureGroupName() throws MdxParserException {
        MdxIdentifierExpression id = this.parseIdentifierX("measure group name");
        if (id.getPartCount() != 2 || id.isLastPartDefinedAsKey()) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_INVALID_MEASURE_GROUP_NAME, new Serializable[]{id.asMdx()});
        }
        return new MdxQualifiedMeasureGroupNameIdentifierExpression(id);
    }

    private boolean isIF(CdMdxToken token) {
        if (token instanceof CdMdxPreProcessorToken) {
            CdMdxPreProcessorToken ppToken = (CdMdxPreProcessorToken)token;
            return "IF".equalsIgnoreCase(ppToken.getName());
        }
        return false;
    }

    private boolean isELSE(CdMdxToken token) {
        if (token instanceof CdMdxPreProcessorToken) {
            CdMdxPreProcessorToken ppToken = (CdMdxPreProcessorToken)token;
            return "ELSE".equalsIgnoreCase(ppToken.getName());
        }
        return false;
    }

    private boolean isENDIF(CdMdxToken token) {
        if (token instanceof CdMdxPreProcessorToken) {
            CdMdxPreProcessorToken ppToken = (CdMdxPreProcessorToken)token;
            return "ENDIF".equalsIgnoreCase(ppToken.getName());
        }
        return false;
    }

    private boolean isForEach(CdMdxToken token) {
        if (token instanceof CdMdxPreProcessorToken) {
            CdMdxPreProcessorToken ppToken = (CdMdxPreProcessorToken)token;
            return "FOREACH".equalsIgnoreCase(ppToken.getName());
        }
        return false;
    }

    private boolean isEndForEach(CdMdxToken token) {
        if (token instanceof CdMdxPreProcessorToken) {
            CdMdxPreProcessorToken ppToken = (CdMdxPreProcessorToken)token;
            return "ENDFOREACH".equalsIgnoreCase(ppToken.getName());
        }
        return false;
    }

    @Nullable
    private MdxDocsPermsExpression parseDocsPermsExpression() throws CdMdxScannerException, MdxParserException {
        ArrayList allLineTokens = new ArrayList();
        ArrayList<CdMdxToken> lineToken = null;
        for (int ii = 0; ii < this.tokens.size(); ++ii) {
            CdMdxToken token = this.tokens.get(ii);
            if (CdMdxTokenKind.EOL != token.getKind()) {
                if (lineToken == null) {
                    lineToken = new ArrayList<CdMdxToken>();
                    allLineTokens.add(lineToken);
                }
                lineToken.add(token);
                continue;
            }
            lineToken = null;
        }
        int line = 0;
        MdxAuthorizationInheritStatement inherit = null;
        ArrayList<MdxAuthorizationDocsPermsStatement> statements = new ArrayList<MdxAuthorizationDocsPermsStatement>();
        while (line < allLineTokens.size()) {
            this.tokens.clear();
            this.tokens.addAll((Collection)allLineTokens.get(line++));
            this.currentTokenIndex = 0;
            this.lastTokenParsed = -1;
            CdMdxToken lookahead = this.peekNextToken(0);
            if (lookahead == null) continue;
            CdMdxTokenKind tokenKind = lookahead.getKind();
            if (CdMdxTokenKind.PLUS == tokenKind || CdMdxTokenKind.MINUS == tokenKind) {
                CdMdxToken plusMinusToken = this.parseToken();
                MdxIdentifierExpression name = this.parseIdentifierOnly();
                if (name.getPartCount() != 1 || name.isLastPartDefinedAsKey()) {
                    throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_NAME, new Serializable[]{name.asMdx()});
                }
                if ("inherit".equalsIgnoreCase(name.getLastPartAsString())) {
                    inherit = new MdxAuthorizationInheritStatement(plusMinusToken);
                    continue;
                }
                CdMdxToken rw = this.parseToken(CdMdxTokenKind.REGULAR_IDENTIFIER);
                if (!"READ".equalsIgnoreCase(rw.getLexeme()) && !"WRITE".equalsIgnoreCase(rw.getLexeme())) {
                    throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_MISSING_READ_WRITE, new Serializable[]{name.getLastPartAsString()});
                }
                if (plusMinusToken.getLexeme().equals("-")) {
                    throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_MINUS, new Serializable[]{"- " + name.getLastPartAsString()});
                }
                statements.add(new MdxAuthorizationDocsPermsStatement(plusMinusToken, name, rw));
                continue;
            }
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_AUTHORIZATION_UNEXPECTED_EXPRESSION, new Serializable[0]);
        }
        if (inherit == null && statements.isEmpty()) {
            return null;
        }
        return new MdxDocsPermsExpression(inherit, statements);
    }

    @Nullable
    private MdxPerspectiveExpression parsePerspectiveExpression() throws CdMdxScannerException, MdxParserException {
        CdMdxToken lookahead;
        ArrayList<MdxPerspectiveStatement> statements = new ArrayList<MdxPerspectiveStatement>();
        while ((lookahead = this.peekNextToken(0)) != null) {
            MdxExpression expression;
            if (lookahead instanceof CdMdxRegularIdentifierToken) {
                MdxPerspectiveStatement statement;
                CdMdxRegularIdentifierToken identifierToken = (CdMdxRegularIdentifierToken)lookahead;
                String id = identifierToken.getIdentifier();
                if ("rename".equalsIgnoreCase(id)) {
                    statement = this.parsePerspectiveRename();
                    statements.add(statement);
                    continue;
                }
                if ("default".equalsIgnoreCase(id)) {
                    statement = this.parsePerspectiveDefault();
                    statements.add(statement);
                    continue;
                }
            }
            if ((expression = this.parseValueExpression()) instanceof MdxUnaryOperatorCallExpression) {
                statements.add(new MdxPerspectiveUnaryStatement((MdxUnaryOperatorCallExpression)expression));
                continue;
            }
            if (expression instanceof MdxBinaryOperatorCallExpression) {
                statements.add(new MdxPerspectiveBinaryStatement((MdxBinaryOperatorCallExpression)expression));
                continue;
            }
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_UNEXPECTED_PERSPECTIVE_EXPRESSION, new Serializable[0]);
        }
        return statements.isEmpty() ? null : new MdxPerspectiveExpression(statements);
    }

    private MdxPerspectiveStatement parsePerspectiveRename() throws MdxParserException {
        CdMdxRegularIdentifierToken name = (CdMdxRegularIdentifierToken)this.parseToken(CdMdxTokenKind.REGULAR_IDENTIFIER);
        MdxIdentifierExpression from = this.parseIdentifierX("perspective name from");
        this.parseToken(CdMdxTokenKind.AS);
        MdxIdentifierExpression to = this.parseIdentifierX("perspective name to");
        if (to.getPartCount() != 1) {
            throw new MdxParserException((CdMdxToken)to.getFirstToken(), CdMdxErrorCode.PARSE_UNEXPECTED_PERSPECTIVE_RENAME_NAME, new Serializable[]{to.asMdx()});
        }
        CdMdxIdentifierToken toFirstPart = to.getPart(0);
        if (toFirstPart.isKey()) {
            throw new MdxParserException((CdMdxToken)to.getFirstToken(), CdMdxErrorCode.PARSE_UNEXPECTED_PERSPECTIVE_RENAME_NAME, new Serializable[]{to.asMdx()});
        }
        return new MdxPerspectiveNameStatement(name, to, from);
    }

    private MdxPerspectiveStatement parsePerspectiveDefault() throws MdxParserException {
        CdMdxRegularIdentifierToken name = (CdMdxRegularIdentifierToken)this.parseToken(CdMdxTokenKind.REGULAR_IDENTIFIER);
        MdxIdentifierExpression defaultMember = this.parseIdentifierX("new default member");
        return new MdxPerspectiveDefaultStatement(name, defaultMember);
    }

    private MdxExpression parseCalculatedMemberFormula() throws CdMdxScannerException, MdxParserException {
        return this.parseNestedExpression(null);
    }

    @Nullable
    private MdxSelectCalcMemberProperties parseCalcMemberProperties() throws CdMdxScannerException, MdxParserException {
        ArrayList<MdxSelectCalcMemberProperty> properties = new ArrayList<MdxSelectCalcMemberProperty>();
        while (true) {
            MdxSelectCalcMemberProperty property = this.parseCalcMemberProperty();
            properties.add(property);
            if (CdMdxTokenKind.COMMA != this.peekNextTokenKind()) break;
            this.parseToken(CdMdxTokenKind.COMMA);
        }
        return !properties.isEmpty() ? new MdxSelectCalcMemberProperties((List<MdxSelectCalcMemberProperty>)properties) : null;
    }

    private MdxSelectMeasureProperties parseMeasureProperties(MdxIdentifierExpression measureId, String measureName) throws CdMdxScannerException, MdxParserException {
        ArrayList<MdxSelectMeasureProperty> properties = new ArrayList<MdxSelectMeasureProperty>();
        while (true) {
            MdxSelectMeasureProperty property = this.parseMeasureProperty(measureName);
            properties.add(property);
            if (CdMdxTokenKind.COMMA != this.peekNextTokenKind()) break;
            this.parseToken(CdMdxTokenKind.COMMA);
        }
        if (properties.isEmpty()) {
            throw new MdxParserException((CdMdxToken)measureId.getFirstToken(), CdMdxErrorCode.PARSE_MEASURE_MISSING_PROPERTIES, new Serializable[]{measureId.asMdx()});
        }
        MdxSelectMeasureProperties properties_ = new MdxSelectMeasureProperties((List<MdxSelectMeasureProperty>)properties);
        this.assertNoDuplicate(measureId, properties_);
        return properties_;
    }

    private MdxExpression parseNestedExpression(@Nullable CdMdxIdentifierToken propertyId) throws CdMdxScannerException, MdxParserException {
        if (CdMdxTokenKind.STRING != this.peekNextTokenKind()) {
            return this.parseValueExpression();
        }
        if (propertyId != null && propertyId.getIdentifier().equalsIgnoreCase("FORMAT_STRING")) {
            return this.parseValueExpression();
        }
        CdMdxStringToken token = (CdMdxStringToken)this.parseToken(CdMdxTokenKind.STRING);
        if (token.isSingleQuoted()) {
            String formulaAsStr = token.getValue();
            int formulaOffset = token.getLocation().offset() + 1;
            int formulaLineNumber = token.getLocation().lineNumber();
            CdMdxScanner formulaScanner = new CdMdxScanner(this.mdx, this.mdxHash, formulaOffset, formulaLineNumber);
            List formulaTokens = formulaScanner.scan(formulaAsStr, this.mdxHash);
            MdxParser formulaParser = new MdxParser(this.context, this.mdx, this.mdxHash, formulaTokens);
            MdxExpression formula = formulaParser.parseValueExpression();
            if (formulaParser.lastTokenParsed < formulaParser.tokens.size() - 1) {
                for (int pos = formulaParser.lastTokenParsed + 1; pos < formulaParser.tokens.size(); ++pos) {
                    CdMdxToken unexpectedToken = formulaParser.tokens.get(pos);
                    if (CdMdxTokenKind.isInvisible((CdMdxTokenKind)unexpectedToken.getKind())) continue;
                    throw new MdxParserException(unexpectedToken, CdMdxErrorCode.PARSE_UNEXPECTED_STATEMENT, new Serializable[]{unexpectedToken.getLexeme(), unexpectedToken.getKind()});
                }
            }
            formula.setAsNestedExpression(token);
            return formula;
        }
        this.unparseToken();
        return this.parseValueExpression();
    }

    private void assertNoDuplicate(MdxIdentifierExpression id, MdxSelectMemberProperties<?> properties) throws MdxParserException {
        HashSet<String> names = new HashSet<String>();
        for (MdxSelectMemberProperty property : properties.getProperties()) {
            String pname = property.getResolvedName().toLowerCase();
            if (names.contains(pname)) {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_PROPERTY_DUPLICATED, new Serializable[]{property.getResolvedName(), id.asMdx()});
            }
            names.add(pname);
        }
    }

    private MdxIdentifierExpression parseMeasureIdentifier(boolean createStatement) throws MdxParserException {
        MdxIdentifierExpression id = this.parseIdentifierX("measure name");
        if (id.isLastPartDefinedAsKey()) {
            throw new MdxParserException(id.getLastToken(), CdMdxErrorCode.PARSE_MEASURE_INVALID_NAME_KEY, new Serializable[]{id.asMdx()});
        }
        if (!createStatement ? id.getPartCount() > 2 : id.getPartCount() > 3) {
            throw new MdxParserException(id.getLastToken(), CdMdxErrorCode.PARSE_MEASURE_INVALID_NAME, new Serializable[]{id.asMdx()});
        }
        return id;
    }

    private MdxIdentifierExpression parseCalcMemberIdentifier() throws MdxParserException {
        MdxIdentifierExpression id = this.parseIdentifierX("calc. member name");
        if (id.isLastPartDefinedAsKey()) {
            throw new MdxParserException(id.getLastToken(), CdMdxErrorCode.PARSE_INVALID_CALC_MEMBER_NAME_KEY, new Serializable[]{id.asMdx()});
        }
        return id;
    }

    private MdxSelectCalcMemberProperty parseCalcMemberProperty() throws CdMdxScannerException, MdxParserException {
        CdMdxToken token = this.parseToken();
        if (token == null || !CdMdxTokenKind.isIdentifier((CdMdxTokenKind)token.getKind())) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_CALC_MEMBER_PROPERTY_NAME, new Serializable[0]);
        }
        CdMdxIdentifierToken id = (CdMdxIdentifierToken)token;
        if (id.isKey()) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_INVALID_CALC_MEMBER_PROPERTY_NAME, new Serializable[0]);
        }
        this.parseToken(CdMdxTokenKind.EQ);
        if (this.peekNextTokenKind() == CdMdxTokenKind.CUBE) {
            CdMdxToken cube = this.parseToken();
            return new MdxSelectCalcMemberProperty(new MdxIdentifierExpression(id), new MdxCubeExpression(cube));
        }
        MdxExpression expr = this.parseNestedExpression(id);
        return new MdxSelectCalcMemberProperty(new MdxIdentifierExpression(id), expr);
    }

    private MdxSelectMeasureProperty parseMeasureProperty(String measureName) throws CdMdxScannerException, MdxParserException {
        CdMdxToken token = this.parseToken();
        if (token == null || !CdMdxTokenKind.isIdentifier((CdMdxTokenKind)token.getKind())) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MEASURE_MISSING_PROPERTY_NAME, new Serializable[]{measureName});
        }
        CdMdxIdentifierToken id = (CdMdxIdentifierToken)token;
        if (id.isKey()) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MEASURE_INVALID_PROPERTY_NAME, new Serializable[]{measureName});
        }
        this.parseToken(CdMdxTokenKind.EQ);
        CdMdxTokenKind nextTokenKind = this.peekNextTokenKind();
        MdxExpression expr = CdMdxTokenKind.isAggrType((CdMdxTokenKind)nextTokenKind) ? new MdxAggrTypeExpression(this.parseToken()) : this.parseNestedExpression(id);
        return new MdxSelectMeasureProperty(new MdxIdentifierExpression(id), expr);
    }

    private List<MdxSelectQueryAxisClause> parseSelectQueryAxisClauses(boolean nested) throws MdxParserException {
        ArrayList<MdxSelectQueryAxisClause> axes = new ArrayList<MdxSelectQueryAxisClause>();
        while (CdMdxTokenKind.FROM != this.peekNextTokenKind() && null != this.peekNextTokenKind()) {
            axes.add(this.parseSelectQueryAxisClause(nested, axes.size()));
            this.parseOptionalToken(CdMdxTokenKind.COMMA);
        }
        int paging = -1;
        for (int ii = 0; ii < axes.size(); ++ii) {
            MdxSelectQueryAxisClause axis = (MdxSelectQueryAxisClause)axes.get(ii);
            if (!axis.isTidyPaging()) continue;
            if (paging != -1) {
                throw new MdxParserException(axis.getLastToken(), CdMdxErrorCode.PARSE_TIDY_PAGING_DUPLICATED, new Serializable[0]);
            }
            paging = ii;
        }
        if (paging != -1 && paging != axes.size() - 1) {
            throw new MdxParserException(((MdxSelectQueryAxisClause)axes.get(paging)).getLastToken(), CdMdxErrorCode.PARSE_TIDY_PAGING_NOT_LAST, new Serializable[0]);
        }
        if (paging != -1 && axes.size() < 3) {
            throw new MdxParserException(((MdxSelectQueryAxisClause)axes.get(paging)).getLastToken(), CdMdxErrorCode.PARSE_TIDY_PAGING_NOT_ENOUGH_AXES, new Serializable[0]);
        }
        return axes;
    }

    private MdxSelectQueryAxisClause parseSelectQueryAxisClause(boolean nested, int axisNb) throws MdxParserException {
        CdMdxToken nonEmpty;
        if (!nested && CdMdxTokenKind.NON == this.peekNextTokenKind()) {
            nonEmpty = this.parseToken(CdMdxTokenKind.NON);
            this.parseToken(CdMdxTokenKind.EMPTY);
        } else {
            nonEmpty = null;
        }
        MdxExpression expression = this.parseExpression();
        MdxSelectDimensionPropertyListClause dimensionPropertyListClause = !nested && (CdMdxTokenKind.DIMENSION == this.peekNextTokenKind() || CdMdxTokenKind.PROPERTIES == this.peekNextTokenKind()) ? this.parseSelectDimensionPropertyListClause() : null;
        this.parseToken(CdMdxTokenKind.ON);
        boolean withRole = !nested;
        MdxSelectAxisName axisName = this.parseSelectAxisName(withRole, axisNb);
        return new MdxSelectQueryAxisClause(nonEmpty, expression, dimensionPropertyListClause, axisName, false);
    }

    private MdxSelectDimensionPropertyListClause parseSelectDimensionPropertyListClause() throws MdxParserException {
        CdMdxToken dimensionProperties;
        ArrayList<MdxIdentifierExpression> properties = new ArrayList<MdxIdentifierExpression>();
        if (CdMdxTokenKind.DIMENSION == this.peekNextTokenKind()) {
            dimensionProperties = this.parseToken(CdMdxTokenKind.DIMENSION);
            if (CdMdxTokenKind.ALL == this.peekNextTokenKind()) {
                this.parseToken(CdMdxTokenKind.ALL);
                this.parseToken(CdMdxTokenKind.PROPERTIES);
                return new MdxSelectDimensionPropertyListClause(dimensionProperties, true);
            }
            this.parseToken(CdMdxTokenKind.PROPERTIES);
        } else if (CdMdxTokenKind.PROPERTIES == this.peekNextTokenKind()) {
            dimensionProperties = this.parseToken(CdMdxTokenKind.PROPERTIES);
        } else {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_DIM_PROPERTIES, new Serializable[0]);
        }
        while (true) {
            MdxIdentifierExpression id;
            if ((id = this.parseIdentifierX("property name")).isLastPartDefinedAsKey()) {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_INVALID_PROPERTY_NAME_KEY, new Serializable[]{id.asMdx()});
            }
            properties.add(id);
            if (CdMdxTokenKind.COMMA != this.peekNextTokenKind()) break;
            this.parseToken(CdMdxTokenKind.COMMA);
        }
        if (properties.isEmpty()) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_DIM_PROPERTIES, new Serializable[0]);
        }
        return new MdxSelectDimensionPropertyListClause(dimensionProperties, properties);
    }

    private MdxSelectAxisName parseSelectAxisName(boolean withRole, int nb) throws MdxParserException {
        CdMdxToken nextToken = this.parseToken();
        if (nextToken == null) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_AXIS_NAME, new Serializable[0]);
        }
        if (withRole && nextToken.getKind() == CdMdxTokenKind.STRING) {
            return new MdxSelectAxisName((CdMdxStringToken)nextToken, nb);
        }
        if (nextToken.getKind() == CdMdxTokenKind.AXES || nextToken.getKind() == CdMdxTokenKind.COLUMNS || nextToken.getKind() == CdMdxTokenKind.ROWS || nextToken.getKind() == CdMdxTokenKind.PAGES || nextToken.getKind() == CdMdxTokenKind.SECTIONS || nextToken.getKind() == CdMdxTokenKind.CHAPTERS) {
            return new MdxSelectAxisName(nextToken);
        }
        if (nextToken.getKind() == CdMdxTokenKind.AXIS) {
            this.parseToken(CdMdxTokenKind.OPEN_PAREN);
            CdMdxLongToken value = (CdMdxLongToken)this.parseToken(CdMdxTokenKind.LONG);
            if (value.getValue() < 0L) {
                throw new MdxParserException((CdMdxToken)value, CdMdxErrorCode.PARSE_INVALID_AXIS_NUMBER, new Serializable[]{nextToken.getLexeme()});
            }
            CdMdxToken close = this.parseToken(CdMdxTokenKind.CLOSE_PAREN);
            return new MdxSelectAxisName(nextToken, close, value.getValue());
        }
        if (nextToken.getKind() == CdMdxTokenKind.LONG) {
            CdMdxLongToken value = (CdMdxLongToken)nextToken;
            return new MdxSelectAxisName((CdMdxToken)value, (CdMdxToken)value, value.getValue());
        }
        throw new MdxParserException(nextToken, CdMdxErrorCode.PARSE_INVALID_AXIS_NAME, new Serializable[]{nextToken.getLexeme()});
    }

    private MdxSelectSlicerAxisClause parseSelectSlicerAxisClause() throws MdxParserException {
        CdMdxToken where = this.parseToken(CdMdxTokenKind.WHERE);
        MdxExpression expr = this.parseExpression();
        return new MdxSelectSlicerAxisClause(where, expr);
    }

    private MdxExpression parseSubSelectClause() throws CdMdxScannerException, MdxParserException {
        CdMdxToken token = this.parseToken();
        if (token == null) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_CUBE, new Serializable[0]);
        }
        if (CdMdxTokenKind.NON == token.getKind() || CdMdxTokenKind.OPEN_PAREN == token.getKind()) {
            return this.parseSubSelect(token);
        }
        return this.parseCubeName(token);
    }

    private MdxIdentifierExpression parseCubeName(CdMdxToken token) throws MdxParserException {
        if (!CdMdxTokenKind.isIdentifier((CdMdxTokenKind)token.getKind())) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_CUBE, new Serializable[0]);
        }
        CdMdxIdentifierToken id = (CdMdxIdentifierToken)token;
        if (id.isKey()) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_INVALID_CUBE_NAME_KEY, new Serializable[]{id.getLexeme()});
        }
        return new MdxIdentifierExpression(id);
    }

    private MdxExpression parseSubSelect(CdMdxToken token) throws CdMdxScannerException, MdxParserException {
        boolean nonVisual = false;
        if (CdMdxTokenKind.NON == token.getKind()) {
            this.parseToken(CdMdxTokenKind.VISUAL);
            nonVisual = true;
        }
        if (CdMdxTokenKind.OPEN_PAREN != token.getKind()) {
            this.parseToken(CdMdxTokenKind.OPEN_PAREN);
        }
        MdxStatementExpression subSelectQuery = this.parseSelect(true, nonVisual);
        this.parseToken(CdMdxTokenKind.CLOSE_PAREN);
        return subSelectQuery;
    }

    private List<MdxExpression> parseExpressions(@Nullable CdMdxTokenKind closingTokenKind) throws MdxParserException {
        ArrayList<MdxExpression> expressions = new ArrayList<MdxExpression>();
        expressions.add(this.parseExpression());
        while (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.COMMA);
            if (closingTokenKind != null && this.peekNextTokenKind() == closingTokenKind) continue;
            expressions.add(this.parseExpression());
        }
        return expressions;
    }

    private MdxExpression parseExpression() throws MdxParserException {
        return this.parseValueExpression();
    }

    private MdxExpression parseValueExpression() throws MdxParserException {
        MdxExpression expr = this.parseTerm6();
        while (CdMdxTokenKind.OR == this.peekNextTokenKind()) {
            CdMdxToken op = this.parseToken(CdMdxTokenKind.OR);
            MdxExpression or = this.parseTerm6();
            expr = new MdxBinaryOperatorCallExpression(op, expr, or);
        }
        return expr;
    }

    private MdxExpression parseTerm6() throws MdxParserException {
        MdxExpression expr = this.parseTerm5();
        while (CdMdxTokenKind.XOR == this.peekNextTokenKind()) {
            CdMdxToken op = this.parseToken(CdMdxTokenKind.XOR);
            MdxExpression xor = this.parseTerm5();
            expr = new MdxBinaryOperatorCallExpression(op, expr, xor);
        }
        return expr;
    }

    private MdxExpression parseTerm5() throws MdxParserException {
        MdxExpression expr = this.parseTerm4();
        while (CdMdxTokenKind.AND == this.peekNextTokenKind()) {
            CdMdxToken op = this.parseToken(CdMdxTokenKind.AND);
            MdxExpression and = this.parseTerm4();
            expr = new MdxBinaryOperatorCallExpression(op, expr, and);
        }
        return expr;
    }

    private MdxExpression parseTerm4() throws MdxParserException {
        if (CdMdxTokenKind.NOT == this.peekNextTokenKind()) {
            CdMdxToken op = this.parseToken(CdMdxTokenKind.NOT);
            MdxExpression not = this.parseTerm3();
            return new MdxUnaryOperatorCallExpression(op, not);
        }
        return this.parseTerm3();
    }

    private MdxExpression parseTerm3() throws MdxParserException {
        MdxExpression expr = this.parseTerm2_is();
        CdMdxTokenKind operatorKind = this.peekNextTokenKind();
        if (CdMdxTokenKind.isCompOperator((CdMdxTokenKind)operatorKind)) {
            CdMdxToken op = this.parseTokenEx("comparison operator");
            MdxExpression operand = this.parseTerm2_is();
            switch (operatorKind) {
                case EQEQ: 
                case NEQEQ: 
                case GGT: 
                case LLT: 
                case GGE: 
                case LLE: 
                case EQ: 
                case NE: 
                case GT: 
                case LT: 
                case GE: 
                case LE: {
                    expr = new MdxBinaryOperatorCallExpression(op, expr, operand);
                    break;
                }
                default: {
                    throw new CdProgrammingException("The operator [" + String.valueOf(operatorKind) + "] is not expected here.");
                }
            }
        }
        return expr;
    }

    private MdxExpression parseTerm2_is() throws MdxParserException {
        MdxExpression expr = this.parseTerm2();
        if (CdMdxTokenKind.IS == this.peekNextTokenKind()) {
            CdMdxToken op = this.parseToken(CdMdxTokenKind.IS);
            if (CdMdxTokenKind.NOT == this.peekNextTokenKind()) {
                CdMdxToken opNOT = this.parseToken(CdMdxTokenKind.NOT);
                MdxExpression is = this.parseTerm2();
                expr = new MdxBinaryOperatorCallExpression(op, opNOT, expr, is);
            } else {
                MdxExpression is = this.parseTerm2();
                expr = new MdxBinaryOperatorCallExpression(op, expr, is);
            }
        }
        return expr;
    }

    private MdxExpression parseTerm2() throws MdxParserException {
        MdxExpression expr = this.parseTerm1();
        while (true) {
            CdMdxToken op;
            if (CdMdxTokenKind.PLUS == this.peekNextTokenKind()) {
                op = this.parseToken(CdMdxTokenKind.PLUS);
                MdxExpression plus = this.parseTerm1();
                expr = new MdxBinaryOperatorCallExpression(op, expr, plus);
                continue;
            }
            if (CdMdxTokenKind.MINUS != this.peekNextTokenKind()) break;
            op = this.parseToken(CdMdxTokenKind.MINUS);
            MdxExpression minus = this.parseTerm1();
            expr = new MdxBinaryOperatorCallExpression(op, expr, minus);
        }
        return expr;
    }

    private MdxExpression parseTerm1() throws MdxParserException {
        MdxExpression expr = this.parseTerm();
        while (true) {
            CdMdxToken op;
            if (CdMdxTokenKind.DIVIDE == this.peekNextTokenKind()) {
                op = this.parseToken(CdMdxTokenKind.DIVIDE);
                MdxExpression solidus = this.parseTerm();
                expr = new MdxBinaryOperatorCallExpression(op, expr, solidus);
                continue;
            }
            if (CdMdxTokenKind.MULTIPLY != this.peekNextTokenKind()) break;
            op = this.parseToken(CdMdxTokenKind.MULTIPLY);
            MdxExpression asterix = this.parseTerm();
            expr = new MdxBinaryOperatorCallExpression(op, expr, asterix);
        }
        return expr;
    }

    private MdxExpression parseTerm() throws MdxParserException {
        MdxExpression expr = this.parseFactor();
        while (CdMdxTokenKind.POWER == this.peekNextTokenKind()) {
            CdMdxToken op = this.parseToken(CdMdxTokenKind.POWER);
            MdxExpression power = this.parseFactor();
            expr = new MdxBinaryOperatorCallExpression(op, expr, power);
        }
        return expr;
    }

    private MdxExpression parseFactor() throws MdxParserException {
        ArrayList<CdMdxToken> tokens = null;
        while (CdMdxTokenKind.MINUS == this.peekNextTokenKind() || CdMdxTokenKind.PLUS == this.peekNextTokenKind()) {
            CdMdxToken token = this.parseTokenEx("+/- operator");
            if (tokens == null) {
                tokens = new ArrayList<CdMdxToken>();
            }
            tokens.add(token);
        }
        MdxExpression factor0 = this.parseFactor0_existing();
        if (tokens == null) {
            return factor0;
        }
        MdxExpression expr = factor0;
        for (int idx = tokens.size() - 1; idx >= 0; --idx) {
            CdMdxToken token = (CdMdxToken)tokens.get(idx);
            if (CdMdxTokenKind.MINUS == token.getKind()) {
                expr = new MdxUnaryOperatorCallExpression(token, expr);
                continue;
            }
            if (CdMdxTokenKind.PLUS != token.getKind()) continue;
            expr = new MdxUnaryOperatorCallExpression(token, expr);
        }
        return expr;
    }

    private MdxExpression parseFactor0_existing() throws MdxParserException {
        CdMdxToken existing = null;
        if (CdMdxTokenKind.EXISTING == this.peekNextTokenKind()) {
            existing = this.parseToken(CdMdxTokenKind.EXISTING);
        }
        MdxExpression expr = this.parseFactor0_range();
        return existing == null ? expr : new MdxExistingSetExpression(existing, expr);
    }

    private MdxExpression parseFactor0_range() throws MdxParserException {
        MdxExpression expr = this.parseFactor0_as();
        if (CdMdxTokenKind.RANGE == this.peekNextTokenKind()) {
            CdMdxToken op = this.parseToken(CdMdxTokenKind.RANGE);
            MdxExpression other = this.parseFactor0_as();
            return new MdxBinaryOperatorCallExpression(op, expr, other);
        }
        return expr;
    }

    private MdxExpression parseFactor0_as() throws MdxParserException {
        MdxExpression expr = this.parseFactor0();
        if (CdMdxTokenKind.OBJ_MC == this.peekNextTokenKind()) {
            CdMdxToken mcToken = this.parseToken(CdMdxTokenKind.OBJ_MC);
            expr = this.parseMethodCall(expr, mcToken);
        }
        if (CdMdxTokenKind.AS != this.peekNextTokenKind()) {
            return expr;
        }
        this.parseToken(CdMdxTokenKind.AS);
        MdxIdentifierExpression namedSetId = this.parseAsNamedSetIdentifier();
        return new MdxAsNamedSetExpression(expr, namedSetId);
    }

    private MdxExpression parseFactor0() throws MdxParserException {
        CdMdxRegularIdentifierToken id;
        CdMdxToken ntoken;
        CdMdxTokenKind nextTokenKind = this.peekNextTokenKind();
        if (nextTokenKind == null) {
            CdMdxToken prevToken = this.prevToken();
            if (prevToken == null) {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_UNEXPECTED_END_OF_STATEMENT, new Serializable[0]);
            }
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_EXPRESSION, new Serializable[]{prevToken.getLexeme()});
        }
        if (CdMdxTokenKind.PARAMETER == nextTokenKind) {
            CdMdxParameterToken parameter = (CdMdxParameterToken)this.parseToken(CdMdxTokenKind.PARAMETER);
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_NOT_SUPPORTED, new Serializable[]{"parameter"});
        }
        if (CdMdxTokenKind.NULL == nextTokenKind) {
            CdMdxToken token = this.parseToken(CdMdxTokenKind.NULL);
            MdxNullLiteralExpression expression = new MdxNullLiteralExpression(token);
            return this.parseFactor0PostProcessing(expression);
        }
        if (CdMdxTokenKind.TRUE == nextTokenKind) {
            CdMdxToken token = this.parseToken(CdMdxTokenKind.TRUE);
            MdxTrueLiteralExpression expression = new MdxTrueLiteralExpression(token);
            return this.parseFactor0PostProcessing(expression);
        }
        if (CdMdxTokenKind.FALSE == nextTokenKind) {
            CdMdxToken token = this.parseToken(CdMdxTokenKind.FALSE);
            MdxFalseLiteralExpression expression = new MdxFalseLiteralExpression(token);
            return this.parseFactor0PostProcessing(expression);
        }
        if (CdMdxTokenKind.STRING == nextTokenKind) {
            CdMdxStringToken value = (CdMdxStringToken)this.parseToken(CdMdxTokenKind.STRING);
            MdxStringLiteralExpression expression = new MdxStringLiteralExpression(value);
            return this.parseFactor0PostProcessing(expression);
        }
        if (CdMdxTokenKind.LONG == nextTokenKind) {
            CdMdxLongToken number = (CdMdxLongToken)this.parseToken(CdMdxTokenKind.LONG);
            MdxLongLiteralExpression expression = new MdxLongLiteralExpression(number);
            return this.parseFactor0PostProcessing(expression);
        }
        if (CdMdxTokenKind.DOUBLE == nextTokenKind) {
            CdMdxDoubleToken number = (CdMdxDoubleToken)this.parseToken(CdMdxTokenKind.DOUBLE);
            MdxDoubleLiteralExpression expression = new MdxDoubleLiteralExpression(number);
            return this.parseFactor0PostProcessing(expression);
        }
        if (CdMdxTokenKind.isOption((CdMdxTokenKind)nextTokenKind)) {
            CdMdxToken option = this.parseToken();
            return new MdxOptionExpression(option);
        }
        if (CdMdxTokenKind.CASE == nextTokenKind) {
            MdxExpression expression = this.parseCaseExpression();
            return this.parseFactor0PostProcessing(expression);
        }
        if (CdMdxTokenKind.OPEN_CURLY_BRACE == nextTokenKind) {
            CdMdxToken open = this.parseToken(CdMdxTokenKind.OPEN_CURLY_BRACE);
            List<MdxExpression> exprs = this.peekNextTokenKind() != CdMdxTokenKind.CLOSE_CURLY_BRACE ? this.parseExpressions(CdMdxTokenKind.CLOSE_CURLY_BRACE) : null;
            CdMdxToken close = this.parseToken(CdMdxTokenKind.CLOSE_CURLY_BRACE);
            MdxSetExpression set = new MdxSetExpression(open, close, exprs);
            if (this.peekNextTokenKind() == CdMdxTokenKind.DOT) {
                this.parseToken(CdMdxTokenKind.DOT);
                return this.parseFunctionCalls(set);
            }
            if (this.peekNextTokenKind() == CdMdxTokenKind.OPEN_PAREN) {
                return this.parseFunctionCalls(set);
            }
            return set;
        }
        if (CdMdxTokenKind.OPEN_PAREN == nextTokenKind) {
            CdMdxToken open = this.parseToken(CdMdxTokenKind.OPEN_PAREN);
            List<MdxExpression> exprs = this.peekNextTokenKind() != CdMdxTokenKind.CLOSE_PAREN ? this.parseExpressions(null) : Collections.emptyList();
            CdMdxToken close = this.parseToken(CdMdxTokenKind.CLOSE_PAREN);
            if (this.peekNextTokenKind() == CdMdxTokenKind.DOT) {
                this.parseToken(CdMdxTokenKind.DOT);
                return this.parseFunctionCalls(new MdxTupleOrParenExpression(open, close, exprs));
            }
            if (this.peekNextTokenKind() == CdMdxTokenKind.OPEN_PAREN) {
                return this.parseFunctionCalls(new MdxTupleOrParenExpression(open, close, exprs));
            }
            return new MdxTupleOrParenExpression(open, close, exprs);
        }
        if (CdMdxTokenKind.isIdentifier((CdMdxTokenKind)nextTokenKind)) {
            CdMdxIdentifierToken token = (CdMdxIdentifierToken)this.parseToken();
            if (token == null) {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_IDENTIFIER, new Serializable[0]);
            }
            if (this.isFunctionName(token, false)) {
                this.unparseToken();
                return this.parseFunctionCalls(null);
            }
            this.unparseToken();
            MdxIdentifierExpression id2 = this.parseIdentifier();
            if (this.peekNextTokenKind() == CdMdxTokenKind.DOT) {
                this.parseToken(CdMdxTokenKind.DOT);
                return this.parseFunctionCalls(id2);
            }
            if (this.peekNextTokenKind() == CdMdxTokenKind.OPEN_PAREN) {
                return this.parseFunctionCalls(id2);
            }
            return id2;
        }
        if (CdMdxTokenKind.PROPERTIES == nextTokenKind) {
            return this.parseFunctionCalls(null);
        }
        if (CdMdxTokenKind.AXIS == nextTokenKind) {
            return this.parseFunctionCalls(null);
        }
        if (this.context.getProperties().isExcelFixDotMembers() && CdMdxTokenKind.DOT == nextTokenKind && (ntoken = this.peekNextToken(1)) != null && ntoken instanceof CdMdxRegularIdentifierToken && (id = (CdMdxRegularIdentifierToken)ntoken).getIdentifier().equals("Members")) {
            throw new MdxParserException(null, CdMdxErrorCode.PARSE_EXCEL_DOT_MEMBERS, new Serializable[0]);
        }
        throw new MdxParserException(this.peekNextToken(0), CdMdxErrorCode.PARSE_UNEXPECTED_STATEMENT_X, new Serializable[]{nextTokenKind});
    }

    private MdxExpression parseFactor0PostProcessing(MdxExpression expression) throws MdxParserException {
        if (this.peekNextTokenKind() == CdMdxTokenKind.DOT) {
            this.parseToken(CdMdxTokenKind.DOT);
            return this.parseFunctionCalls(expression);
        }
        if (this.peekNextTokenKind() == CdMdxTokenKind.OPEN_PAREN) {
            return this.parseFunctionCalls(expression);
        }
        return expression;
    }

    private MdxIdentifierExpression parseIdentifierX(String identifierInfo) throws MdxParserException {
        ArrayList<CdMdxIdentifierToken> parts = new ArrayList<CdMdxIdentifierToken>();
        while (true) {
            CdMdxToken token;
            if ((token = this.parseToken()) == null) {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_INVALID_ID_EOF, new Serializable[]{identifierInfo});
            }
            if (!CdMdxTokenKind.isIdentifier((CdMdxTokenKind)token.getKind())) {
                if (!parts.isEmpty()) break;
                String currentToken = "'" + token.getLexeme() + "'";
                if (CdMdxTokenKind.isKeyword((CdMdxTokenKind)token.getKind())) {
                    throw new MdxParserException(token, CdMdxErrorCode.PARSE_INVALID_ID_KEYWORD, new Serializable[]{identifierInfo, currentToken});
                }
                throw new MdxParserException(token, CdMdxErrorCode.PARSE_INVALID_ID, new Serializable[]{identifierInfo, currentToken});
            }
            CdMdxIdentifierToken id = (CdMdxIdentifierToken)token;
            parts.add(id);
            if (this.peekNextTokenKind() != CdMdxTokenKind.DOT) break;
            this.parseToken(CdMdxTokenKind.DOT);
        }
        return new MdxIdentifierExpression(parts);
    }

    private MdxIdentifierExpression parseIdentifier() throws MdxParserException {
        ArrayList<CdMdxIdentifierToken> parts = new ArrayList<CdMdxIdentifierToken>();
        while (true) {
            CdMdxRegularIdentifierToken id;
            CdMdxToken token;
            if ((token = this.parseToken()) == null) {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_IDENTIFIER, new Serializable[0]);
            }
            if (!CdMdxTokenKind.isIdentifier((CdMdxTokenKind)token.getKind())) {
                if (CdMdxTokenKind.DIMENSION == token.getKind() && !parts.isEmpty()) {
                    this.unparseToken();
                    this.unparseToken();
                    break;
                }
                if (CdMdxTokenKind.PROPERTIES == token.getKind() && !parts.isEmpty()) {
                    this.unparseToken();
                    this.unparseToken();
                    break;
                }
                if (CdMdxTokenKind.ALL != token.getKind() || parts.isEmpty()) {
                    throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_IDENTIFIER, new Serializable[0]);
                }
            }
            Object object = id = token.getKind() == CdMdxTokenKind.ALL ? new CdMdxRegularIdentifierToken(token.getLocation(), token.getLexeme()) : (CdMdxIdentifierToken)token;
            if (this.isParseableMemberPropertyNameForIdentifier((CdMdxIdentifierToken)id)) {
                this.unparseToken();
                if (parts.isEmpty()) break;
                this.unparseToken();
                break;
            }
            if (this.isPostFixedFunctionName((CdMdxIdentifierToken)id)) {
                this.unparseToken();
                if (parts.isEmpty()) break;
                this.unparseToken();
                break;
            }
            parts.add((CdMdxIdentifierToken)id);
            if (this.peekNextTokenKind() != CdMdxTokenKind.DOT) break;
            this.parseToken(CdMdxTokenKind.DOT);
        }
        return new MdxIdentifierExpression(parts);
    }

    private MdxIdentifierExpression parseIdentifierOnly() throws MdxParserException {
        ArrayList<CdMdxIdentifierToken> parts = new ArrayList<CdMdxIdentifierToken>();
        while (true) {
            CdMdxToken token;
            if ((token = this.parseToken()) == null) {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_IDENTIFIER, new Serializable[0]);
            }
            if (CdMdxTokenKind.ALL == token.getKind()) {
                parts.add((CdMdxIdentifierToken)new CdMdxRegularIdentifierToken(token.getLocation(), token.getLexeme()));
            } else if (CdMdxTokenKind.isIdentifier((CdMdxTokenKind)token.getKind())) {
                parts.add((CdMdxIdentifierToken)token);
            } else {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_IDENTIFIER, new Serializable[0]);
            }
            if (this.peekNextTokenKind() != CdMdxTokenKind.DOT) break;
            this.parseToken(CdMdxTokenKind.DOT);
        }
        return new MdxIdentifierExpression(parts);
    }

    private MdxExpression parseCaseExpression() throws MdxParserException {
        CdMdxToken xcase = this.parseToken(CdMdxTokenKind.CASE);
        if (CdMdxTokenKind.WHEN != this.peekNextTokenKind()) {
            return this.parseSimpleCaseExpression(xcase);
        }
        return this.parseSearchCaseExpression(xcase);
    }

    private MdxExpression parseSimpleCaseExpression(CdMdxToken xcase) throws MdxParserException {
        MdxExpression elseResult;
        MdxExpression input = this.parseExpression();
        ArrayList<MdxCaseExpression.WhenThen> whenThens = new ArrayList<MdxCaseExpression.WhenThen>();
        do {
            this.parseToken(CdMdxTokenKind.WHEN);
            MdxExpression when = this.parseExpression();
            this.parseToken(CdMdxTokenKind.THEN);
            MdxExpression then = this.parseExpression();
            whenThens.add(new MdxCaseExpression.WhenThen(when, then));
        } while (CdMdxTokenKind.WHEN == this.peekNextTokenKind());
        if (CdMdxTokenKind.ELSE == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.ELSE);
            elseResult = this.parseExpression();
        } else {
            elseResult = null;
        }
        CdMdxToken xend = this.parseToken(CdMdxTokenKind.END);
        if (whenThens.isEmpty()) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_EMPTY_CASE, new Serializable[0]);
        }
        return new MdxSimpleCaseExpression(xcase, xend, input, whenThens, elseResult);
    }

    private MdxExpression parseSearchCaseExpression(CdMdxToken xcase) throws MdxParserException {
        MdxExpression elseResult;
        ArrayList<MdxCaseExpression.WhenThen> whenThens = new ArrayList<MdxCaseExpression.WhenThen>();
        do {
            this.parseToken(CdMdxTokenKind.WHEN);
            MdxExpression when = this.parseExpression();
            this.parseToken(CdMdxTokenKind.THEN);
            MdxExpression then = this.parseExpression();
            whenThens.add(new MdxCaseExpression.WhenThen(when, then));
        } while (CdMdxTokenKind.WHEN == this.peekNextTokenKind());
        if (CdMdxTokenKind.ELSE == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.ELSE);
            elseResult = this.parseExpression();
        } else {
            elseResult = null;
        }
        CdMdxToken xend = this.parseToken(CdMdxTokenKind.END);
        if (whenThens.isEmpty()) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_EMPTY_CASE, new Serializable[0]);
        }
        return new MdxSearchCaseExpression(xcase, xend, whenThens, elseResult);
    }

    private MdxExpression parseFunctionCalls(@Nullable MdxExpression arg0) throws MdxParserException {
        MdxExpression call = arg0;
        while (true) {
            call = this.parseFunctionCall(call);
            if (CdMdxTokenKind.DOT == this.peekNextTokenKind()) {
                this.parseToken(CdMdxTokenKind.DOT);
                continue;
            }
            if (CdMdxTokenKind.OPEN_PAREN != this.peekNextTokenKind()) break;
        }
        return call;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MdxExpression parseFunctionCall(@Nullable MdxExpression arg0) throws MdxParserException {
        String funName;
        boolean functionArgumentCall;
        CdMdxIdentifierToken name;
        CdMdxToken token = this.parseToken();
        if (token == null) {
            throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_FUNCTION_PROPERTY_NAME, new Serializable[0]);
        }
        CdMdxTokenKind kind = token.getKind();
        if (CdMdxTokenKind.isIdentifier((CdMdxTokenKind)kind)) {
            name = (CdMdxIdentifierToken)token;
            functionArgumentCall = false;
        } else if (CdMdxTokenKind.PROPERTIES == kind || CdMdxTokenKind.DIMENSION == kind || CdMdxTokenKind.AXIS == kind) {
            name = new CdMdxRegularIdentifierToken(token.getLocation(), token.getKind().name());
            functionArgumentCall = false;
        } else {
            if (arg0 == null || CdMdxTokenKind.OPEN_PAREN != kind) throw new MdxParserException(token, CdMdxErrorCode.PARSE_UNEXPECTED_FUNCTION_PROPERTY_NAME, new Serializable[]{token.getLexeme()});
            if (this.isDeclaredFunctionArgument(arg0) > -1) {
                name = (CdMdxIdentifierToken)arg0.getFirstToken();
                functionArgumentCall = true;
                arg0 = null;
                this.unparseToken();
            } else {
                boolean functionArgumentCall2 = false;
                MdxFunctionArgExpression arg = this.parseFunctionArgExpression(1);
                if (this.peekNextTokenKind() != CdMdxTokenKind.CLOSE_PAREN) {
                    CdMdxToken regularIdentifier = this.asRegularIdentifier(arg0);
                    if (regularIdentifier == null) throw new MdxParserException(token, CdMdxErrorCode.PARSE_ITEM_EXTRA_PARAM, new Serializable[]{arg0.asMdx()});
                    throw new MdxParserException(regularIdentifier, CdMdxErrorCode.PARSE_ITEM_UNKNOWN_FUNCTION, new Serializable[]{arg0.asMdx()});
                }
                CdMdxToken close = this.parseToken(CdMdxTokenKind.CLOSE_PAREN);
                if (!arg.isNoArg()) return new MdxSetItemOperatorExpression(token, close, arg0, arg);
                CdMdxToken regularIdentifier = this.asRegularIdentifier(arg0);
                if (regularIdentifier == null) throw new MdxParserException(token, CdMdxErrorCode.PARSE_ITEM_MISSING_PARAM, new Serializable[]{arg0.asMdx()});
                throw new MdxParserException(regularIdentifier, CdMdxErrorCode.PARSE_ITEM_UNKNOWN_FUNCTION, new Serializable[]{arg0.asMdx()});
            }
        }
        String string = funName = functionArgumentCall ? name.getIdentifier() : this.asFunctionName(name);
        if (funName != null) {
            ArrayList<MdxFunctionArgExpression> args = new ArrayList<MdxFunctionArgExpression>();
            CdMdxToken open = null;
            CdMdxToken close = null;
            if (CdMdxTokenKind.OPEN_PAREN == this.peekNextTokenKind()) {
                open = this.parseToken(CdMdxTokenKind.OPEN_PAREN);
                if (CdMdxTokenKind.CLOSE_PAREN != this.peekNextTokenKind()) {
                    args.addAll(this.parseFunctionArgExpressions(funName, arg0 == null ? 0 : 1));
                }
                close = this.parseToken(CdMdxTokenKind.CLOSE_PAREN);
            }
            if (arg0 != null && args.size() == 1 && this.context.getFunctionMaxParamCount(funName) <= 1) {
                MdxFunctionCallExpression functionCall = new MdxFunctionCallExpression(name, MdxFunctionCallExpression.Notation.FUNCTION_POSTFIXED, funName, arg0);
                return new MdxSetItemOperatorExpression(open, close, functionCall, (MdxExpression)args.get(0));
            }
            MdxFunctionCallExpression.Notation notation = arg0 == null ? MdxFunctionCallExpression.Notation.FUNCTION_REGULAR : MdxFunctionCallExpression.Notation.FUNCTION_POSTFIXED;
            int declaredFunctionArgumentIndex = this.isDeclaredFunctionArgument(funName);
            if (declaredFunctionArgumentIndex > -1) {
                if (arg0 != null) {
                    throw new RuntimeException("internal error : MDX unexpected syntax (1)");
                }
                if (open != null) return new MdxDeclaredFunctionArgumentCallExpression(name, open, close, this.currentDeclaredFunctionName, declaredFunctionArgumentIndex, funName, args);
                throw new RuntimeException("internal error : MDX unexpected syntax (2)");
            }
            if (notation != MdxFunctionCallExpression.Notation.FUNCTION_REGULAR || open != null || close != null || STANDARD_FUNCTIONS_CALL_WITH_NO_PAREN.contains(funName.toUpperCase())) return new MdxFunctionCallExpression(name, open, close, notation, funName, arg0, args);
            return new MdxFunctionNameExpression(name);
        }
        if (!this.isParseableMemberPropertyNameForFunctionCall(name)) throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_UNKNOWN_FUNCTION_PROPERTY, new Serializable[]{name.getLexeme()});
        return new MdxFunctionCallExpression(name, MdxFunctionCallExpression.Notation.PROPERTY, name.getIdentifier(), arg0);
    }

    @Nullable
    private CdMdxToken asRegularIdentifier(MdxExpression arg0) {
        MdxIdentifierExpression id;
        if (arg0 instanceof MdxIdentifierExpression && (id = (MdxIdentifierExpression)arg0).getParts().size() == 1 && !id.isLastPartDefinedAsKey()) {
            return (CdMdxToken)id.getParts().get(0);
        }
        return null;
    }

    private List<MdxFunctionArgExpression> parseFunctionArgExpressions(String function, int offset) throws MdxParserException {
        if ("LookupByKeys".equalsIgnoreCase(function)) {
            return this.parseFunctionArgExpressionsLookupByKeys(offset);
        }
        ArrayList<MdxFunctionArgExpression> expressions = new ArrayList<MdxFunctionArgExpression>();
        expressions.add(this.parseFunctionArgExpression(offset));
        while (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.COMMA);
            expressions.add(this.parseFunctionArgExpression(offset + expressions.size()));
        }
        return expressions;
    }

    private List<MdxFunctionArgExpression> parseFunctionArgExpressionsLookupByKeys(int offset) throws MdxParserException {
        CdMdxToken firstToken;
        int expectedCount;
        int ii;
        ArrayList<MdxFunctionArgExpression> expressions = new ArrayList<MdxFunctionArgExpression>();
        expressions.add(this.parseFunctionArgExpression(offset));
        while (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.COMMA);
            expressions.add(this.parseFunctionArgExpression(offset + expressions.size()));
        }
        boolean ignoreArg0 = offset == 0;
        int stringCount = 0;
        int longCount = 0;
        int n = ii = ignoreArg0 ? 1 : 0;
        while (ii < expressions.size()) {
            MdxExpression arg = ((MdxFunctionArgExpression)expressions.get(ii)).getArg();
            if (arg instanceof MdxStringLiteralExpression) {
                ++stringCount;
            } else if (arg instanceof MdxLongLiteralExpression) {
                ++longCount;
            }
            ++ii;
        }
        int n2 = expectedCount = ignoreArg0 ? expressions.size() - 1 : expressions.size();
        if (stringCount > 1 && stringCount == expectedCount) {
            int ii2;
            firstToken = ((MdxFunctionArgExpression)expressions.getFirst()).getArg().getFirstToken();
            CdMdxToken lastToken = ((MdxFunctionArgExpression)expressions.getLast()).getArg().getLastToken();
            ArrayList<String> args = new ArrayList<String>();
            int n3 = ii2 = ignoreArg0 ? 1 : 0;
            while (ii2 < expressions.size()) {
                MdxStringLiteralExpression arg = (MdxStringLiteralExpression)((MdxFunctionArgExpression)expressions.get(ii2)).getArg();
                args.add(arg.value());
                ++ii2;
            }
            if (ignoreArg0) {
                return List.of((MdxFunctionArgExpression)expressions.getFirst(), new MdxFunctionStringArgArrayWrapperExpression(firstToken, lastToken, offset, args));
            }
            return List.of(new MdxFunctionStringArgArrayWrapperExpression(firstToken, lastToken, offset, args));
        }
        if (longCount > 1 && longCount == expectedCount) {
            int ii3;
            firstToken = ((MdxFunctionArgExpression)expressions.getFirst()).getArg().getFirstToken();
            CdMdxToken lastToken = ((MdxFunctionArgExpression)expressions.getLast()).getArg().getLastToken();
            LongArrayList args = new LongArrayList();
            int n4 = ii3 = ignoreArg0 ? 1 : 0;
            while (ii3 < expressions.size()) {
                MdxLongLiteralExpression arg = (MdxLongLiteralExpression)((MdxFunctionArgExpression)expressions.get(ii3)).getArg();
                args.add(arg.value());
                ++ii3;
            }
            if (ignoreArg0) {
                return List.of((MdxFunctionArgExpression)expressions.getFirst(), new MdxFunctionLongArgArrayWrapperExpression(firstToken, lastToken, offset, args));
            }
            return List.of(new MdxFunctionLongArgArrayWrapperExpression(firstToken, lastToken, offset, args));
        }
        return expressions;
    }

    private MdxFunctionArgExpression parseFunctionArgExpression(int index) throws MdxParserException {
        MdxExpression expr = CdMdxTokenKind.COMMA == this.peekNextTokenKind() || CdMdxTokenKind.CLOSE_PAREN == this.peekNextTokenKind() ? new MdxNoFunctionArgExpression(this.tokens.get(this.currentTokenIndex), index) : this.parseValueExpression();
        return new MdxFunctionArgExpression(index, expr);
    }

    private boolean isParseableMemberPropertyNameForIdentifier(CdMdxIdentifierToken name) {
        return !name.isDelimited() && this.context.isParseableMemberPropertyName(name.getIdentifier());
    }

    private boolean isParseableMemberPropertyNameForFunctionCall(CdMdxIdentifierToken name) {
        return this.context.isParseableMemberPropertyName(name.getIdentifier());
    }

    private int isDeclaredFunctionArgument(MdxExpression expr) {
        if (!(expr instanceof MdxIdentifierExpression)) {
            return -1;
        }
        MdxIdentifierExpression id = (MdxIdentifierExpression)expr;
        if (!id.isSimple()) {
            return -1;
        }
        String name = id.getLastPartAsString();
        return this.isDeclaredFunctionArgument(name);
    }

    private int isDeclaredFunctionArgument(String name) {
        if (this.currentDeclaredFunctionArguments != null) {
            for (int ii = 0; ii < this.currentDeclaredFunctionArguments.size(); ++ii) {
                MdxFunctionTypedArgExpression declaredFunctionParam = this.currentDeclaredFunctionArguments.get(ii);
                if (!declaredFunctionParam.getName().equals(name)) continue;
                return ii;
            }
        }
        return -1;
    }

    private boolean isPostFixedFunctionName(CdMdxIdentifierToken name) {
        return !name.isDelimited() && this.context.isPostFixedFunctionName(name.getIdentifier());
    }

    private boolean isFunctionName(CdMdxIdentifierToken name, boolean ignoreForwardDeclaration) {
        return !name.isDelimited() && this.isFunctionNameX(name, ignoreForwardDeclaration);
    }

    private boolean isFunctionNameX(CdMdxIdentifierToken name, boolean ignoreForwardDeclaration) {
        if (this.inTidyPostProcessor && "_".equalsIgnoreCase(name.getIdentifier())) {
            return true;
        }
        return this.context.isFunctionName(name.getIdentifier()) || this.isFunctionDeclared(name.getIdentifier()) || !ignoreForwardDeclaration && this.isForwardDeclaredFunction(name.getIdentifier());
    }

    private boolean isFunctionDeclared(String name) {
        for (String function : this.declaredFunctions) {
            if (!function.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isForwardDeclaredFunction(String name) {
        for (String forwardFunctionName : this.forwardDeclaredFunctions) {
            if (!forwardFunctionName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private boolean isTidyPostProcessorName(CdMdxIdentifierToken name) {
        return this.context.isTidyPostProcessorName(name.getIdentifier());
    }

    @Nullable
    private String asFunctionName(CdMdxIdentifierToken name) {
        if (name.isDelimited()) {
            return null;
        }
        if (this.isFunctionNameX(name, false)) {
            return name.getIdentifier();
        }
        if (this.isTidyPostProcessorName(name)) {
            return name.getIdentifier();
        }
        return null;
    }

    private MdxExpression parseMethodCall(@Nullable MdxExpression expr, CdMdxToken mcToken) throws MdxParserException {
        MdxMethodCallExpression mcExpr = this.doParseMethodCall(expr, mcToken);
        while (CdMdxTokenKind.OBJ_MC == this.peekNextTokenKind()) {
            mcToken = this.parseToken(CdMdxTokenKind.OBJ_MC);
            mcExpr = this.doParseMethodCall(mcExpr, mcToken);
        }
        return mcExpr;
    }

    private MdxMethodCallExpression doParseMethodCall(@Nullable MdxExpression object, CdMdxToken mcToken) throws MdxParserException {
        MdxMethodNameExpression name = this.parseMethodCallName();
        if (CdMdxTokenKind.OPEN_PAREN == this.peekNextTokenKind()) {
            CdMdxToken openParen = this.parseToken(CdMdxTokenKind.OPEN_PAREN);
            List<MdxMethodArgExpression> args = CdMdxTokenKind.CLOSE_PAREN != this.peekNextTokenKind() ? this.doParseMethodCallArgs() : new ArrayList<MdxMethodArgExpression>();
            CdMdxToken closeParen = this.parseToken(CdMdxTokenKind.CLOSE_PAREN);
            return new MdxObjectMethodCallExpression(object, name, openParen, args, closeParen);
        }
        return new MdxObjectMethodCallExpression(object, name);
    }

    private MdxMethodNameExpression parseMethodCallName() throws MdxParserException {
        ArrayList<CdMdxToken> tokens = new ArrayList<CdMdxToken>();
        while (true) {
            CdMdxToken token;
            if ((token = this.parseToken()) == null) {
                throw new MdxParserException(this.currentToken(), CdMdxErrorCode.PARSE_MISSING_IDENTIFIER, new Serializable[0]);
            }
            tokens.add(token);
            if (this.peekNextTokenKind() != CdMdxTokenKind.DOT) break;
            tokens.add(this.parseToken(CdMdxTokenKind.DOT));
        }
        return new MdxMethodNameExpression(tokens);
    }

    private List<MdxMethodArgExpression> doParseMethodCallArgs() throws MdxParserException {
        ArrayList<MdxMethodArgExpression> expressions = new ArrayList<MdxMethodArgExpression>();
        expressions.add(this.doParseMethodCallArg(expressions.size()));
        while (CdMdxTokenKind.COMMA == this.peekNextTokenKind()) {
            this.parseToken(CdMdxTokenKind.COMMA);
            expressions.add(this.doParseMethodCallArg(expressions.size()));
        }
        return expressions;
    }

    private MdxMethodArgExpression doParseMethodCallArg(int argNo) throws MdxParserException {
        MdxBinaryOperatorCallExpression call;
        MdxExpression expr = this.parseValueExpression();
        if (expr instanceof MdxBinaryOperatorCallExpression && CdMdxTokenKind.EQ == (call = (MdxBinaryOperatorCallExpression)expr).getKind()) {
            List<MdxExpression> children = expr.getChildren();
            if (children.size() != 2) {
                throw new MdxParserException(expr.getFirstToken(), CdMdxErrorCode.PARSE_INVALID_METHOD_ARG, new Serializable[]{expr.asMdx()});
            }
            MdxExpression nameExpr = children.get(0);
            if (nameExpr instanceof MdxIdentifierExpression) {
                return new MdxMethodNamedArgExpression(argNo, (MdxIdentifierExpression)nameExpr, children.get(1));
            }
        }
        return new MdxMethodArgExpression(argNo, expr);
    }

    @Nullable
    private MdxStatementExpression extractMdxStatement() throws CdMdxScannerException, MdxParserException {
        CdMdxToken select = null;
        while ((select = this.parseToken()) != null && !CdMdxTokenKind.SELECT.equals((Object)select.getKind())) {
        }
        if (select == null) {
            return null;
        }
        this.unparseToken();
        MdxStatementExpression statement = this.parseSelect(false, true);
        return statement;
    }

    static {
        STANDARD_FUNCTIONS_CALL_WITH_NO_PAREN.add("DIMENSIONS");
        STANDARD_FUNCTIONS_CALL_WITH_NO_PAREN.add("USERNAME");
    }
}

