/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.info;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdFatalErrorHandler;
import crazydev.iccube.de.schlichtherle.license.DefaultLicenseParam;
import crazydev.iccube.de.schlichtherle.license.KeyStoreParam;
import crazydev.iccube.de.schlichtherle.license.LicenseManager;
import crazydev.iccube.de.schlichtherle.license.LicenseParam;
import crazydev.iccube.de.schlichtherle.util.ObfuscatedString;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.info.OlapLixParams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class OlapLixVerifier {
    public static final Logger LOGGER = Logger.getLogger((String)"icCube.general");
    private static LicenseManager lm;
    private static File licenseFile;

    public static File file() {
        return licenseFile;
    }

    @Nullable
    public static synchronized OlapLixContent verify(@Nullable CdFatalErrorHandler fatalErrorHandler, File lic, boolean assertValidityPeriod) {
        lm = null;
        licenseFile = lic;
        if (!licenseFile.exists()) {
            String error = new ObfuscatedString(new long[]{-8882308731120787451L, -5452472846534817445L, 4774984984559932097L}).toString();
            if (fatalErrorHandler == null) {
                LOGGER.error((Object)error);
                System.exit(-2);
                return null;
            }
            fatalErrorHandler.handle(error, -2);
            return null;
        }
        try {
            return OlapLixVerifier.doVerify(assertValidityPeriod, licenseFile);
        }
        catch (Exception ex) {
            String error = new ObfuscatedString(new long[]{3197561416441482040L, -3890094734801402401L, -982492658566057926L}).toString();
            if (fatalErrorHandler == null) {
                LOGGER.error((Object)error);
                LOGGER.error((Object)ex.getLocalizedMessage());
                System.exit(-2);
                return null;
            }
            fatalErrorHandler.handle(error, -2);
            return null;
        }
    }

    @Nullable
    public static synchronized OlapLixContent verifyOnChange(File lic, boolean assertValidityPeriod) {
        lm = null;
        licenseFile = lic;
        if (!licenseFile.exists()) {
            LOGGER.error((Object)new ObfuscatedString(new long[]{-8882308731120787451L, -5452472846534817445L, 4774984984559932097L}).toString());
            return null;
        }
        try {
            return OlapLixVerifier.doVerify(assertValidityPeriod, licenseFile);
        }
        catch (Exception ex) {
            LOGGER.error((Object)new ObfuscatedString(new long[]{3197561416441482040L, -3890094734801402401L, -982492658566057926L}).toString());
            String message = ex.getMessage();
            if (message != null) {
                LOGGER.error((Object)message);
            }
            return null;
        }
    }

    @Nullable
    public static synchronized OlapLixContent verifyOnRegister(byte[] lic) {
        lm = null;
        try {
            return OlapLixVerifier.doVerify(lic);
        }
        catch (Exception ex) {
            String error = new ObfuscatedString(new long[]{3197561416441482040L, -3890094734801402401L, -982492658566057926L}).toString();
            LOGGER.error((Object)error);
            LOGGER.error((Object)ex.getLocalizedMessage());
            return null;
        }
    }

    public static synchronized void verifyExpiryDate(CdFatalErrorHandler fatalErrorHandler, @Nullable OlapLixContent lix) {
        if (lm == null || lix == null) {
            fatalErrorHandler.handle(new ObfuscatedString(new long[]{3197561416441482040L, -3890094734801402401L, -982492658566057926L}).toString(), -2);
            return;
        }
        try {
            lm.validate(true, lix);
        }
        catch (Exception ex) {
            LOGGER.error((Object)new ObfuscatedString(new long[]{3197561416441482040L, -3890094734801402401L, -982492658566057926L}).toString());
            LOGGER.error((Object)ex.getLocalizedMessage());
            fatalErrorHandler.handle(new ObfuscatedString(new long[]{3197561416441482040L, -3890094734801402401L, -982492658566057926L}).toString(), -2);
        }
    }

    public static synchronized Map<String, String> createInfos(CdBabylonService babylon, OlapLixContent content) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        Map<String, String> infos = content.createInfos(babylon);
        for (Map.Entry<String, String> entry : infos.entrySet()) {
            values.put(entry.getKey(), entry.getValue());
        }
        return values;
    }

    private static OlapLixContent doVerify(boolean assertValidityPeriod, File licenseFile) throws Exception {
        if (lm == null) {
            MyKeyStoreParam publicKeyStoreParam = new MyKeyStoreParam();
            OlapLixParams cipherParam = new OlapLixParams();
            DefaultLicenseParam licenseParam = new DefaultLicenseParam("icCube", null, publicKeyStoreParam, cipherParam);
            lm = new MyLicenseManager(licenseParam, licenseFile);
        }
        OlapLixContent licenseContent = lm.verify(assertValidityPeriod);
        return licenseContent;
    }

    private static OlapLixContent doVerify(byte[] lix) throws Exception {
        if (lm == null) {
            MyKeyStoreParam publicKeyStoreParam = new MyKeyStoreParam();
            OlapLixParams cipherParam = new OlapLixParams();
            DefaultLicenseParam licenseParam = new DefaultLicenseParam("icCube", null, publicKeyStoreParam, cipherParam);
            lm = new MyLicenseManagerEx(licenseParam, lix);
        }
        OlapLixContent licenseContent = lm.verify(true);
        return licenseContent;
    }

    static class MyKeyStoreParam
    implements KeyStoreParam {
        MyKeyStoreParam() {
        }

        @Override
        public InputStream getStream() throws IOException {
            String resource = new ObfuscatedString(new long[]{8731528489593910106L, -1325383739413066374L}).toString();
            return this.getClass().getResourceAsStream(resource);
        }

        @Override
        public String getAlias() {
            return new ObfuscatedString(new long[]{3990143222332279930L, -1487332679989408527L}).toString();
        }

        @Override
        public String getStorePwd() {
            return new ObfuscatedString(new long[]{-864596317563745720L, 8291699880285045981L, -3316134537886055397L}).toString();
        }

        @Override
        public String getKeyPwd() {
            return null;
        }
    }

    static class MyLicenseManager
    extends LicenseManager {
        private final File licenseFile;

        public MyLicenseManager(LicenseParam licenseParam, File licenseFile) {
            super(licenseParam);
            this.licenseFile = licenseFile;
        }

        @Override
        protected byte[] getLicenseKey() {
            try {
                return LicenseManager.loadLicenseKey(this.licenseFile);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex.getMessage());
            }
        }
    }

    static class MyLicenseManagerEx
    extends LicenseManager {
        private final byte[] lix;

        public MyLicenseManagerEx(LicenseParam licenseParam, byte[] lix) {
            super(licenseParam);
            this.lix = lix;
        }

        @Override
        protected byte[] getLicenseKey() {
            return this.lix;
        }
    }
}

