/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.info;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.version.CdVersion;
import crazydev.iccube.de.schlichtherle.util.ObfuscatedString;
import crazydev.iccube.plugin.OlapPluginClassLoader;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Nullable;
import org.joda.time.Days;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;

public class OlapLixContent {
    public static final String TYPE_COMMUNITY = new ObfuscatedString(new long[]{5260799162345352525L, -1163542563359747587L, -7409976932704069521L}).toString();
    public static final String TYPE_ENTERPRISE = new ObfuscatedString(new long[]{3461296007495787983L, 5230752609173318193L, 7119677903896993578L}).toString();
    public static final String TYPE_ENTERPRISE_PLUS = new ObfuscatedString(new long[]{7731126296987278129L, 2997274346745314256L, -1150431970816988294L}).toString();
    public static final String TYPE_CORPORATE = new ObfuscatedString(new long[]{6904780054913205351L, 4378698441814442778L, -4198500890319003468L}).toString();
    public static final String TYPE_EVALUATION = new ObfuscatedString(new long[]{-8515406247098527862L, 1824938606143255207L, 3086134961607705863L}).toString();
    public static final String uuid = new ObfuscatedString(new long[]{-5924746243621594947L, -2725897500846180780L}).toString();
    public static final String type = new ObfuscatedString(new long[]{-4710036071491445868L, -7462401064229220028L}).toString();
    public static final String information = new ObfuscatedString(new long[]{6986681426467241710L, -5611348705976489508L, 980409622241896624L}).toString();
    public static final String subject = new ObfuscatedString(new long[]{1872431530418080569L, -3470536040005475576L}).toString();
    public static final String holderName = new ObfuscatedString(new long[]{4815094159912155327L, 4404298863310149440L, -765253463920357037L}).toString();
    public static final String newHolderName = new ObfuscatedString(new long[]{9127072138382174566L, 1503023003872698995L, 4133165012918211975L}).toString();
    public static final String major = new ObfuscatedString(new long[]{-6016228218253521088L, 2515677422257214745L}).toString();
    public static final String minor = new ObfuscatedString(new long[]{2305295332924852582L, -1922465599314827583L}).toString();
    public static final String patch = new ObfuscatedString(new long[]{-7882926347247441017L, -4934821182899855533L}).toString();
    public static final String issued = new ObfuscatedString(new long[]{736239502401058920L, -5470387522560919468L}).toString();
    public static final String notAfter = new ObfuscatedString(new long[]{-55899726627600907L, -1094596229394996685L}).toString();
    public static final String accessRights = new ObfuscatedString(new long[]{-3109562956338993454L, 7305974510949119840L, 4622737054716675792L}).toString();
    public static final String perspectives = new ObfuscatedString(new long[]{8708291202431310092L, -334186686277792440L, 8899522524130787584L}).toString();
    public static final String writeBack = new ObfuscatedString(new long[]{-6214381608526429847L, -3482656831751938264L, -520403325452909969L}).toString();
    public static final String gviLibrary = new ObfuscatedString(new long[]{3622231845451788415L, 8227945556881571158L, 2402990347260014574L}).toString();
    public static final String reportServer = new ObfuscatedString(new long[]{-1587264555864506372L, -7256134267556396116L, 3219769196409402637L}).toString();
    public static final String discussions = new ObfuscatedString(new long[]{8517963230419399450L, -6078509277659353165L, 8510012118153738346L}).toString();
    public static final String printServer = new ObfuscatedString(new long[]{7244014955722737117L, 2002105715638242719L, 4059391890030546091L}).toString();
    public static final String simultaneousMdxQuery = new ObfuscatedString(new long[]{-8506746172950108626L, -1445159827849834589L, -8243205484602141662L, -5755896797153844705L}).toString();
    public static final String multithreadedMdxQuery = new ObfuscatedString(new long[]{-7714423624021820091L, -2670318837060872230L, -907515975873376574L, -8647086939155534483L}).toString();
    public static final String vectorParallelSort = new ObfuscatedString(new long[]{-3287891568924793036L, -1580891672433335978L, 8743529081746602651L, 2379995099025233290L}).toString();
    public static final String memoryLimit = new ObfuscatedString(new long[]{-5309593975549144530L, -6535769853481100454L, 7477341067932420582L}).toString();
    public static final String mmapFacts = new ObfuscatedString(new long[]{-764378985282213030L, 6590643330658160048L, 5393106358486902116L}).toString();
    public static final String realTime = new ObfuscatedString(new long[]{6336212113972136402L, 4755704195255925797L}).toString();
    public static final String incrLoad = new ObfuscatedString(new long[]{-2776519025329645630L, -8842368753561110230L}).toString();
    public static final String incrLoadCount = new ObfuscatedString(new long[]{-2800026258456523865L, 7950989743378239733L, -6700638544949589796L}).toString();
    public static final String fastEngine = new ObfuscatedString(new long[]{7477891911789748988L, -2617599325347349025L, -5621134034097215177L}).toString();
    public static final String asyncLoad = new ObfuscatedString(new long[]{3190690617129286355L, 8497550197217784161L, 1655715279614527638L}).toString();
    public static final String tablePartitioning = new ObfuscatedString(new long[]{1411922983580135261L, 1406450081479859117L, 4292596707620106222L, 5874227729336275788L}).toString();
    public static final String indexPartitioning = new ObfuscatedString(new long[]{1419416563270802524L, -6485818658296012177L, 794087099803228587L, 2965776617587661885L}).toString();
    public static final String factsPartitioning = new ObfuscatedString(new long[]{-5278403664904939409L, -7742193579221454233L, 3165649519417662863L, -7136932439177360197L}).toString();
    public static final String offlineCubes = new ObfuscatedString(new long[]{7436176833196279499L, 1877949259533530838L, 7663011387899828357L}).toString();
    public static final String managementApi = new ObfuscatedString(new long[]{-5323989221433466198L, -8237155032245201560L, -3117312445947010572L}).toString();
    public static final String scheduler = new ObfuscatedString(new long[]{7172573212621766839L, -1740834821875961386L, -8608760232953950227L}).toString();
    public static final String monitoring = new ObfuscatedString(new long[]{-240380080564348977L, 8509466803664325930L, -662941783037540218L}).toString();
    public static final String notifications = new ObfuscatedString(new long[]{-420864837092204242L, 8072241446581904263L, 7803326790026809361L}).toString();
    public static final String userLimit = new ObfuscatedString(new long[]{-453453235476532766L, -7032323856555980317L, -1950820552127179101L}).toString();
    public static final String coreLimit = new ObfuscatedString(new long[]{5967474039112260644L, 7003971568603660837L, 6169168716035138731L}).toString();
    public static final String httpHost = new ObfuscatedString(new long[]{1779553578912993513L, 3390319529693151679L}).toString();
    public static final String httpPort = new ObfuscatedString(new long[]{-7131937557194032400L, -7247669616978811124L}).toString();
    public static final String sslPort = new ObfuscatedString(new long[]{4848122337435485229L, -670995507968138559L}).toString();
    public static final String ssl = new ObfuscatedString(new long[]{-502209965061884651L, -2938769410983006227L}).toString();
    public static final String ping = new ObfuscatedString(new long[]{44567699151946240L, -1899314990842350537L}).toString();
    public static final String pingBestEffort = new ObfuscatedString(new long[]{549765766768946012L, 2351947349782526873L, -934026645374755971L}).toString();
    public static final String pingOff = new ObfuscatedString(new long[]{-9157836566441285156L, 6472314139898295691L}).toString();
    public static final String authService = new ObfuscatedString(new long[]{-8955868927460659696L, 8873935708916071018L, -943414435565937210L}).toString();
    public static final String serverVersionMin = new ObfuscatedString(new long[]{2587717033913548566L, -4505510991052681556L, -6317152825116193707L}).toString();
    public static final String serverVersionMax = new ObfuscatedString(new long[]{-5188503266309644839L, -3548937912647365748L, -6783259795728240362L}).toString();
    public static final String poweredBy = new ObfuscatedString(new long[]{-809334413198245953L, -6762593427578217239L, 8527925053696074813L}).toString();
    public static final String docsDB = new ObfuscatedString(new long[]{-3022250940827066168L, -4108863309832981346L}).toString();
    public static final String bytes = new ObfuscatedString(new long[]{-643296722603190273L, -3942457496629085472L}).toString();
    public static final String filters = new ObfuscatedString(new long[]{6567035977861131771L, -665655850980366048L}).toString();
    public static final String backup = new ObfuscatedString(new long[]{-1330811971435678375L, 4081989634571114783L}).toString();
    public static final String multiTenant = new ObfuscatedString(new long[]{-3675017013342445942L, 5756761726050788059L, -8132380778647805037L}).toString();
    public static final String licUuid = new ObfuscatedString(new long[]{-2444555258243638151L, 452931644295487132L}).toString();
    public static final String licStatus = new ObfuscatedString(new long[]{-780217224179994679L, -2369693115665798595L, -1825514389536042571L}).toString();
    public static final String licNoLicense = new ObfuscatedString(new long[]{3535557246274205909L, 4437368793213795261L, -1202533159703356167L}).toString();
    public static final String licTo = new ObfuscatedString(new long[]{-8789401696076105900L, -1895992118357043429L}).toString();
    public static final String licType = new ObfuscatedString(new long[]{-2310282487112089577L, -6972897900778963194L}).toString();
    public static final String licVersion = new ObfuscatedString(new long[]{-5458468912126214330L, 6890019729657499606L, -3268100874928241079L}).toString();
    public static final String licIssuedOn = new ObfuscatedString(new long[]{1448166550967372083L, 7014760178438174714L, 4320763714333799567L}).toString();
    public static final String licValidUntil = new ObfuscatedString(new long[]{-5047213602139190534L, 1755470493250230019L, -6128404285281046176L}).toString();
    public static final String licPerpetual = new ObfuscatedString(new long[]{-2945136811473850360L, -3795100747528333763L, -3470425514201119102L}).toString();
    public static final String licExpired = new ObfuscatedString(new long[]{1802211743574202240L, -3975343714684856085L, 7652442440762355799L}).toString();
    public static int VERSION = 4;
    public static String NAME = "icCube-" + VERSION + ".lic";
    private final Object[] names;
    private final Object[] values;
    public final AtomicBoolean renewal = new AtomicBoolean(false);

    public OlapLixContent(Object[] names, Object[] values) {
        this.names = names;
        this.values = values;
    }

    public OlapLixContent(Object[] data) {
        this.names = (Object[])data[0];
        this.values = (Object[])data[1];
    }

    private static String translate(CdBabylonService babylon, boolean value) {
        return babylon.translate(value ? new ObfuscatedString(new long[]{-8435939920890332498L, 300183278327051968L}).toString() : new ObfuscatedString(new long[]{-6782498652983375390L, 6935250609736837965L}).toString(), new Serializable[0]);
    }

    private static String translatePoweredBy(CdBabylonService babylon, String value) {
        return babylon.translate(value, new Serializable[0]);
    }

    private static String translatePing(CdBabylonService babylon, String value) {
        return babylon.translate(value, new Serializable[0]);
    }

    private static String translateMemory(CdBabylonService babylon, int value) {
        if (value == Integer.MAX_VALUE) {
            return babylon.translate(new ObfuscatedString(new long[]{9072939566567184127L, -3902339635153039304L, -1710863940526678167L}).toString(), new Serializable[0]);
        }
        return value + "m";
    }

    private static String translateUsers(CdBabylonService babylon, int value) {
        if (value == Integer.MAX_VALUE) {
            return babylon.translate(new ObfuscatedString(new long[]{664255242411669290L, -8595068117231597848L, -2419228979156626210L}).toString(), new Serializable[0]);
        }
        return "" + value;
    }

    private static String translateCores(CdBabylonService babylon, int value) {
        if (value == Integer.MAX_VALUE) {
            return babylon.translate(new ObfuscatedString(new long[]{1681666192360523455L, 5987460078677456630L, -9111319004403588134L}).toString(), new Serializable[0]);
        }
        return "" + value;
    }

    private static String translateIncrLoadCount(CdBabylonService babylon, int value) {
        if (value == Integer.MAX_VALUE) {
            return babylon.translate(new ObfuscatedString(new long[]{-6595631741824434785L, 2891051150658292325L, -2463656755962081368L}).toString(), new Serializable[0]);
        }
        return "" + value;
    }

    private static String translateServerVersionMin(CdBabylonService babylon, @Nullable String value) {
        if (value == null) {
            return babylon.translate(new ObfuscatedString(new long[]{-1426412497418825644L, -6109968294003146555L, 6890657111387915662L, -8144841455833143881L}).toString(), new Serializable[0]);
        }
        return value;
    }

    private static String translateServerVersionMax(CdBabylonService babylon, @Nullable String value) {
        if (value == null) {
            return babylon.translate(new ObfuscatedString(new long[]{-4270756816700884099L, -8659371098238996019L, 5960007295637443733L, -1719214767970198391L}).toString(), new Serializable[0]);
        }
        return value;
    }

    private static String translateAuthService(CdBabylonService babylon, @Nullable String value) {
        if (value == null) {
            return babylon.translate(new ObfuscatedString(new long[]{4336400852657433137L, -827319001665980317L, 5404412764026997622L, 7669630526054188733L}).toString(), new Serializable[0]);
        }
        return value;
    }

    private static String translateBytes(CdBabylonService babylon, @Nullable Object bytes) {
        if (bytes == null) {
            return babylon.translate(new ObfuscatedString(new long[]{-3193122561662912948L, -7683069523797649066L, 3905016218431529580L}).toString(), new Serializable[0]);
        }
        return OlapLixContent.translateBytes_(babylon, bytes);
    }

    private static String translateFilters(CdBabylonService babylon, @Nullable Object filters) {
        if (filters == null) {
            return babylon.translate(new ObfuscatedString(new long[]{-5697772005289391152L, -2669961350554497927L, -3212306335570213125L}).toString(), new Serializable[0]);
        }
        return OlapLixContent.translateBytes_(babylon, filters);
    }

    private static String translateBytes_(CdBabylonService babylon, Object bytes) {
        StringBuilder sb = new StringBuilder();
        if (bytes instanceof Object[]) {
            Object[] array = (Object[])bytes;
            for (int ii = 0; ii < array.length; ii += 2) {
                if (ii > 0) {
                    sb.append(new ObfuscatedString(new long[]{-92471842775248179L, 6012584558207153208L}).toString());
                }
                sb.append((String)array[ii]);
            }
        }
        if (sb.length() == 0) {
            sb.append(new ObfuscatedString(new long[]{7637913018619262724L, 363060662058813238L}).toString());
        }
        return sb.toString();
    }

    private static String translatePort(CdBabylonService babylon, @Nullable Integer value) {
        if (value == null) {
            return babylon.translate(new ObfuscatedString(new long[]{1973396576154991026L, 8550640540715269663L, -3018470881108825693L}).toString(), new Serializable[0]);
        }
        return "" + value;
    }

    private static String translateHost(CdBabylonService babylon, @Nullable String value) {
        if (value == null) {
            return babylon.translate(new ObfuscatedString(new long[]{-1719069756915277673L, 7075234653687127670L, 3461996874694778491L}).toString(), new Serializable[0]);
        }
        return value;
    }

    public Object[] getProperties() {
        Object[] data = new Object[]{this.names, this.values};
        return data;
    }

    public Map<String, String> createInfos(CdBabylonService babylon) {
        LinkedHashMap<String, String> infos = new LinkedHashMap<String, String>();
        String v = this.getMajor() + "." + this.getMinor();
        Integer patch = this.getPatch();
        if (patch != null && patch != 0) {
            v = v + "." + patch;
        }
        Date na = this.getNotAfter();
        infos.put(babylon.translate(licUuid, new Serializable[0]), this.getUuid());
        infos.put(babylon.translate(licTo, new Serializable[0]), this.getHolderNameX());
        infos.put(babylon.translate(licType, new Serializable[0]), this.getType());
        infos.put(babylon.translate(information, new Serializable[0]), this.getInformation());
        infos.put(babylon.translate(licVersion, new Serializable[0]), v);
        infos.put(babylon.translate(licIssuedOn, new Serializable[0]), String.valueOf(this.getIssued()));
        infos.put(babylon.translate(licValidUntil, new Serializable[0]), na == null ? babylon.translate(licPerpetual, new Serializable[0]) : na.toString());
        if (this.hasExpired()) {
            infos.put(babylon.translate(licStatus, new Serializable[0]), babylon.translate(licExpired, new Serializable[0]));
        }
        infos.put(babylon.translate(poweredBy, new Serializable[0]), OlapLixContent.translatePoweredBy(babylon, this.getPoweredBy()));
        infos.put(babylon.translate(ping, new Serializable[0]), OlapLixContent.translatePing(babylon, this.getPing()));
        infos.put(babylon.translate(serverVersionMin, new Serializable[0]), OlapLixContent.translateServerVersionMin(babylon, this.getServerVersionMin()));
        infos.put(babylon.translate(serverVersionMax, new Serializable[0]), OlapLixContent.translateServerVersionMax(babylon, this.getServerVersionMax()));
        infos.put(babylon.translate(userLimit, new Serializable[0]), OlapLixContent.translateUsers(babylon, this.getUserLimit()));
        infos.put(babylon.translate(coreLimit, new Serializable[0]), OlapLixContent.translateCores(babylon, this.getCoreLimit()));
        infos.put(babylon.translate(memoryLimit, new Serializable[0]), OlapLixContent.translateMemory(babylon, this.getMemoryLimit()));
        infos.put(babylon.translate(gviLibrary, new Serializable[0]), OlapLixContent.translate(babylon, this.isGviAvailable()));
        infos.put(babylon.translate(reportServer, new Serializable[0]), OlapLixContent.translate(babylon, this.isReportServerAvailable()));
        infos.put(babylon.translate(discussions, new Serializable[0]), OlapLixContent.translate(babylon, this.isDiscussionsAvailable()));
        infos.put(babylon.translate(printServer, new Serializable[0]), OlapLixContent.translate(babylon, this.isPrintServerAvailable()));
        if (this.getDocsDb() != null) {
            infos.put(babylon.translate(docsDB, new Serializable[0]), OlapLixContent.translate(babylon, this.getDocsDb()));
        } else {
            infos.put(babylon.translate(docsDB, new Serializable[0]), OlapLixContent.translate(babylon, this.isDocsDbAvailable()) + " (x)");
        }
        infos.put(babylon.translate(fastEngine, new Serializable[0]), OlapLixContent.translate(babylon, this.isFastEngineAvailable()));
        infos.put(babylon.translate(simultaneousMdxQuery, new Serializable[0]), OlapLixContent.translate(babylon, this.isSimultaneousMdxQueryAvailable()));
        infos.put(babylon.translate(multithreadedMdxQuery, new Serializable[0]), OlapLixContent.translate(babylon, this.isMultithreadedMdxQueryAvailable()));
        infos.put(babylon.translate(vectorParallelSort, new Serializable[0]), OlapLixContent.translate(babylon, this.isVectorParallelSortAvailable()));
        infos.put(babylon.translate(realTime, new Serializable[0]), OlapLixContent.translate(babylon, this.isRealTimeAvailable()));
        infos.put(babylon.translate(incrLoad, new Serializable[0]), OlapLixContent.translate(babylon, this.isIncrLoadAvailable()));
        infos.put(babylon.translate(incrLoadCount, new Serializable[0]), OlapLixContent.translateIncrLoadCount(babylon, this.getIncrLoadCountPerDayLimit()));
        infos.put(babylon.translate(asyncLoad, new Serializable[0]), OlapLixContent.translate(babylon, this.isAsyncLoadReadAvailable()));
        infos.put(babylon.translate(tablePartitioning, new Serializable[0]), OlapLixContent.translate(babylon, this.isTablePartitioningAvailable()));
        infos.put(babylon.translate(indexPartitioning, new Serializable[0]), OlapLixContent.translate(babylon, this.isIndexPartitioningAvailable()));
        infos.put(babylon.translate(factsPartitioning, new Serializable[0]), OlapLixContent.translate(babylon, this.isFactsPartitioningAvailable()));
        infos.put(babylon.translate(mmapFacts, new Serializable[0]), OlapLixContent.translate(babylon, this.isMmapFactsAvailable()));
        infos.put(babylon.translate(accessRights, new Serializable[0]), OlapLixContent.translate(babylon, this.isAccessRightsAvailable()));
        infos.put(babylon.translate(perspectives, new Serializable[0]), OlapLixContent.translate(babylon, this.isPerspectiveAvailable()));
        infos.put(babylon.translate(writeBack, new Serializable[0]), OlapLixContent.translate(babylon, this.isWriteBackAvailable()));
        infos.put(babylon.translate(offlineCubes, new Serializable[0]), OlapLixContent.translate(babylon, this.isOfflineCubesAvailable()));
        infos.put(babylon.translate(managementApi, new Serializable[0]), OlapLixContent.translate(babylon, this.isManagementApiAvailable()));
        infos.put(babylon.translate(scheduler, new Serializable[0]), OlapLixContent.translate(babylon, this.isSchedulerAvailable()));
        infos.put(babylon.translate(notifications, new Serializable[0]), OlapLixContent.translate(babylon, this.isNotificationAvailable()));
        infos.put(babylon.translate(monitoring, new Serializable[0]), OlapLixContent.translate(babylon, this.isMonitoringAvailable()));
        infos.put(babylon.translate(backup, new Serializable[0]), OlapLixContent.translate(babylon, this.isBackupAvailable()));
        infos.put(babylon.translate(multiTenant, new Serializable[0]), OlapLixContent.translate(babylon, this.isMultiTenantAvailable()));
        infos.put(babylon.translate(ssl, new Serializable[0]), OlapLixContent.translate(babylon, this.isSslAvailable()));
        infos.put(babylon.translate(sslPort, new Serializable[0]), OlapLixContent.translatePort(babylon, this.getSslPort()));
        infos.put(babylon.translate(httpHost, new Serializable[0]), OlapLixContent.translateHost(babylon, this.getHttpHost()));
        infos.put(babylon.translate(httpPort, new Serializable[0]), OlapLixContent.translatePort(babylon, this.getHttpPort()));
        infos.put(babylon.translate(authService, new Serializable[0]), OlapLixContent.translateAuthService(babylon, this.getAuthService()));
        infos.put(babylon.translate(bytes, new Serializable[0]), OlapLixContent.translateBytes(babylon, this.getProperty(bytes)));
        infos.put(babylon.translate(filters, new Serializable[0]), OlapLixContent.translateFilters(babylon, this.getProperty(filters)));
        return infos;
    }

    @Nullable
    public String getUuid() {
        return this.getStringProperty(uuid);
    }

    public boolean isMissing() {
        return false;
    }

    @Nullable
    public Integer getMajor() {
        return this.getIntegerProperty(major);
    }

    @Nullable
    public Integer getMinor() {
        return this.getIntegerProperty(minor);
    }

    @Nullable
    public Integer getPatch() {
        return this.getIntegerProperty(patch);
    }

    @Nullable
    public String getSubject() {
        return this.getStringProperty(subject);
    }

    @Nullable
    public Date getIssued() {
        return this.getDateProperty(issued);
    }

    @Nullable
    public String getType() {
        return this.getStringProperty(type);
    }

    @Nullable
    public String getInformation() {
        return this.getStringProperty(information);
    }

    @Nullable
    public String getHolderNameX() {
        String name = this.getStringProperty(holderName);
        if (name != null) {
            return name;
        }
        return this.getStringProperty(newHolderName);
    }

    @Nullable
    public Date getNotAfter() {
        return this.getDateProperty(notAfter);
    }

    public boolean hasExpired() {
        return this.hasExpired(new Date());
    }

    public boolean hasExpired(Date now) {
        if (this.isCommunity() && "Community".equals(this.getHolderNameX())) {
            return true;
        }
        Date notAfter = this.getNotAfter();
        return notAfter != null && now.after(notAfter);
    }

    public static int getRemainingDays(@Nullable Date notAfter) {
        if (notAfter == null) {
            return Integer.MAX_VALUE;
        }
        Date today = new Date();
        LocalDate notAfter_ = new LocalDate(notAfter.getTime());
        LocalDate today_ = new LocalDate(today.getTime());
        return Days.daysBetween((ReadablePartial)today_, (ReadablePartial)notAfter_).getDays();
    }

    public boolean isSslAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(ssl) != false;
    }

    @Nullable
    public Integer getSslPort() {
        return this.getIntegerProperty(sslPort);
    }

    @Nullable
    public Integer getHttpPort() {
        return this.getIntegerProperty(httpPort);
    }

    @Nullable
    public String getHttpHost() {
        return this.getStringProperty(httpHost);
    }

    public int getUserLimit() {
        return this.hasExpired() ? 0 : this.getIntegerProperty(userLimit);
    }

    public int getCoreLimit() {
        if (this.hasExpired()) {
            return 0;
        }
        Integer value = this.getIntegerProperty(coreLimit);
        return value == null ? Integer.MAX_VALUE : value;
    }

    public int getMemoryLimit() {
        return this.hasExpired() ? 0 : this.getIntegerProperty(memoryLimit);
    }

    public String getPing() {
        if (this.hasExpired()) {
            return pingBestEffort;
        }
        String feature = this.getStringProperty(ping);
        if (feature == null) {
            return pingBestEffort;
        }
        return feature;
    }

    public boolean isAuthenticationServiceAvailable(IOlapAuthenticationService svc) {
        if (this.hasExpired()) {
            return false;
        }
        String requiredAuthService = this.getAuthService();
        if (requiredAuthService == null) {
            return true;
        }
        Class<?> svcClass = svc.getClass();
        if (!svcClass.getName().equals(requiredAuthService)) {
            return false;
        }
        ClassLoader cl = svcClass.getClassLoader();
        if (cl instanceof OlapPluginClassLoader) {
            OlapPluginClassLoader pluginCL = (OlapPluginClassLoader)cl;
            return pluginCL.isLoaded(svcClass.getName());
        }
        return false;
    }

    @Nullable
    private String getAuthService() {
        return this.getStringProperty(authService);
    }

    public boolean isServerVersionAvailable(CdVersion version) {
        CdVersion versionMaxL;
        CdVersion versionMinL;
        String versionMinS = this.getServerVersionMin();
        if (versionMinS != null) {
            CdVersion versionMin = CdVersion.create((String)versionMinS);
            if (versionMin.isNA()) {
                return false;
            }
            versionMinL = versionMin;
        } else {
            versionMinL = CdVersion.MIN;
        }
        String versionMaxS = this.getServerVersionMax();
        if (versionMaxS != null) {
            CdVersion versionMax = CdVersion.create((String)versionMaxS);
            if (versionMax.isNA()) {
                return false;
            }
            versionMaxL = versionMax;
        } else {
            versionMaxL = CdVersion.MAX;
        }
        return version.isGreaterOrEqual(versionMinL) && version.isLower(versionMaxL);
    }

    @Nullable
    public String getServerVersionMin() {
        return this.getStringProperty(serverVersionMin);
    }

    @Nullable
    public String getServerVersionMax() {
        return this.getStringProperty(serverVersionMax);
    }

    @Nullable
    public String getPoweredBy() {
        return this.getStringProperty(poweredBy);
    }

    @Nullable
    public String getPoweredByX() {
        String value = this.getStringProperty(poweredBy);
        if (value != null) {
            return value;
        }
        if (TYPE_COMMUNITY.equals(this.getType())) {
            return "true";
        }
        return null;
    }

    @Nullable
    public Boolean getDocsDb() {
        Object property = this.getProperty(docsDB);
        if (property instanceof Boolean) {
            return (Boolean)property;
        }
        return null;
    }

    @Nullable
    public byte[] getByteCode(String name) {
        return OlapLixContent.getByteCode(this.getProperty(bytes), name);
    }

    public boolean hasFilters() {
        return this.getProperty(filters) != null;
    }

    @Nullable
    public byte[] getFilterByteCode(String name) {
        return OlapLixContent.getByteCode(this.getProperty(filters), name);
    }

    @Nullable
    private static byte[] getByteCode(Object property, String name) {
        if (property instanceof Object[]) {
            Object[] array = (Object[])property;
            for (int ii = 0; ii < array.length; ii += 2) {
                String cName = (String)array[ii];
                if (!name.equals(cName)) continue;
                return (byte[])array[ii + 1];
            }
        }
        return null;
    }

    public boolean isGviAvailable() {
        return !this.hasExpired();
    }

    public boolean isReportServerAvailable() {
        return !this.hasExpired();
    }

    public boolean isPrintServerAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(printServer) != false;
    }

    public boolean isFastEngineAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(fastEngine) != false;
    }

    public boolean isSimultaneousMdxQueryAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(simultaneousMdxQuery) != false;
    }

    public boolean isMultithreadedMdxQueryAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(multithreadedMdxQuery) != false;
    }

    public boolean isRealTimeAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(realTime) != false;
    }

    public boolean isIncrLoadAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(incrLoad) != false;
    }

    public int getIncrLoadCountPerDayLimit() {
        return this.hasExpired() ? 0 : this.getIntegerProperty(incrLoadCount);
    }

    public boolean isAsyncLoadReadAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(asyncLoad) != false;
    }

    public boolean isAsyncLoadProcAvailable() {
        return !this.hasExpired() && this.isPayingLicense();
    }

    public boolean isTablePartitioningAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(tablePartitioning) != false;
    }

    public boolean isIndexPartitioningAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(indexPartitioning) != false;
    }

    public boolean isFactsPartitioningAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(factsPartitioning) != false;
    }

    public boolean isAllDataSourcesAvailable() {
        return !this.hasExpired();
    }

    public boolean isDiscussionsAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(discussions) != false;
    }

    public boolean isMmapFactsAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(mmapFacts) != false;
    }

    public boolean isAccessRightsAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(accessRights) != false;
    }

    public boolean isPerspectiveAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(perspectives) != false;
    }

    public boolean isWriteBackAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(writeBack) != false;
    }

    public boolean isOfflineCubesAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(offlineCubes) != false;
    }

    public boolean isManagementApiAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(managementApi) != false;
    }

    public boolean isSchedulerAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(scheduler) != false;
    }

    public boolean isNotificationAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(notifications) != false;
    }

    public boolean isMonitoringAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(monitoring) != false;
    }

    public boolean isResultCacheAvailable() {
        return !this.hasExpired() && this.isPayingLicense();
    }

    public boolean isNonEmptyCacheAvailable() {
        return !this.hasExpired() && this.isPayingLicense();
    }

    public boolean isVectorParallelSortAvailable() {
        return !this.hasExpired() && this.isPayingLicense();
    }

    public boolean isBackupAvailable() {
        Object property = this.getProperty(backup);
        if (property == null) {
            return !this.hasExpired() && this.isPayingLicense();
        }
        Boolean active = (Boolean)property;
        return active;
    }

    public boolean isDocsDbAvailable() {
        if (this.hasExpired() || !this.isPayingLicense()) {
            return false;
        }
        Boolean docsDb = this.getDocsDb();
        if (docsDb != null) {
            return docsDb;
        }
        return TYPE_CORPORATE.equals(this.getType());
    }

    public boolean isTimeoutAvailable() {
        return !this.hasExpired() && this.isPayingLicense();
    }

    public boolean isMultiTenantAvailable() {
        return !this.hasExpired() && this.getBooleanProperty(multiTenant) != false;
    }

    public boolean isCommunity() {
        return TYPE_COMMUNITY.equals(this.getType());
    }

    public boolean isEvaluationLicense() {
        return TYPE_EVALUATION.equals(this.getType());
    }

    public boolean isPayingLicense() {
        return !TYPE_COMMUNITY.equals(this.getType());
    }

    @Nullable
    private String getStringProperty(String name) {
        Object property = this.getProperty(name);
        if (property instanceof String) {
            return (String)property;
        }
        return null;
    }

    @Nullable
    private Date getDateProperty(String name) {
        Object property = this.getProperty(name);
        if (property instanceof Date) {
            return (Date)property;
        }
        return null;
    }

    @Nullable
    private Integer getIntegerProperty(String name) {
        Object property = this.getProperty(name);
        if (property instanceof Integer) {
            return (Integer)property;
        }
        return null;
    }

    private Boolean getBooleanProperty(String name) {
        Object property = this.getProperty(name);
        return property instanceof Boolean && (Boolean)property != false;
    }

    @Nullable
    private synchronized Object getProperty(String name) {
        for (int ii = 0; ii < this.names.length; ++ii) {
            Object pname = this.names[ii];
            if (!name.equals(pname)) continue;
            return this.values[ii];
        }
        return null;
    }

    public synchronized void reset(String name, @Nullable Object value) {
        for (int ii = 0; ii < this.names.length; ++ii) {
            Object pname = this.names[ii];
            if (!name.equals(pname)) continue;
            this.values[ii] = value;
            break;
        }
    }
}

