/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.http;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public abstract class OlapHttpUtils {
    public static String getFullURL(HttpServletRequest request) {
        String url = request.getRequestURL().toString();
        String queryString = request.getQueryString();
        String fullURL = url + (String)(queryString != null ? "?" + queryString : "");
        return fullURL;
    }

    public static String getClientIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static void logDEBUG(Logger logger, HttpServletRequest request) {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)OlapHttpUtils.logINFO(request));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static void logINFO(Logger logger, HttpServletRequest request) {
        try {
            if (logger.isInfoEnabled()) {
                logger.info((Object)OlapHttpUtils.logINFO(request));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    private static String logINFO(HttpServletRequest request) {
        StringBuilder sb = new StringBuilder().append("-- HTTP Request ---------------------------------------------------------------------- \n").append("HTTP request URL  : (").append(request.getMethod()).append(") ").append(request.getRequestURL()).append("\n").append("     query string : ").append(request.getQueryString()).append("\n").append("   content-length : ").append(request.getContentLength()).append("\n").append("      client-addr : ").append(OlapHttpUtils.getClientIpAddr(request)).append("\n").append("      remote-host : ").append(request.getRemoteHost()).append("\n").append("      remote-addr : ").append(request.getRemoteAddr()).append("\n").append("      remote-port : ").append(request.getRemotePort()).append("\n").append("      remote-user : ").append(request.getRemoteUser()).append("\n");
        Enumeration headers = request.getHeaderNames();
        while (headers.hasMoreElements()) {
            void var4_4;
            String header = (String)headers.nextElement();
            if (!header.equals("Authorization")) {
                String string = request.getHeader(header);
            } else {
                String string = "...";
            }
            sb.append("           header : ").append(header).append(" : ").append((String)var4_4).append("\n");
        }
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                sb.append("           cookie : ").append(cookie.getName()).append(" : ").append(cookie.getValue()).append("\n");
            }
        }
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String param = (String)enumeration.nextElement();
            String value = request.getParameter(param);
            sb.append("            param : ").append(param).append(" : ").append(value).append("\n");
        }
        return sb.toString();
    }
}

