/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gson;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public abstract class GsonUtils {
    public static void advanceStream(JsonReader stream, @Nullable String[] root) throws IOException {
        GsonUtils.advanceStream(stream, root, null);
    }

    public static void advanceStream(JsonReader stream, @Nullable String[] root, @Nullable Predicate<String> isErrorTag) throws IOException {
        if (root == null || root.length == 0) {
            return;
        }
        String path = "";
        for (String key : root) {
            JsonToken token = stream.peek();
            if (token != JsonToken.BEGIN_OBJECT) {
                throw new IOException("Nested object structure expected for root got : " + token.name());
            }
            stream.beginObject();
            boolean found = false;
            while (stream.peek() == JsonToken.NAME) {
                String tag = stream.nextName();
                if (key.equals(tag)) {
                    path = path.isEmpty() ? key : path + "." + key;
                    found = true;
                    break;
                }
                if (isErrorTag != null && isErrorTag.test(tag)) {
                    JsonElement jsonElement = JsonParser.parseReader((JsonReader)stream);
                    throw new OlapBuilderErrorException(OlapBuilderErrorCode.JSON_FILE_WITH_ERROR, new Serializable[]{tag, jsonElement.toString()});
                }
                stream.skipValue();
            }
            if (found) continue;
            throw new IOException("No matching key [" + key + "] in path " + path);
        }
    }

    @Nullable
    public static JsonElement get(JsonElement element, String[] root) {
        if (root != null) {
            for (String s : root) {
                if (!element.isJsonObject()) {
                    return null;
                }
                if ((element = element.getAsJsonObject().get(s)) != null) continue;
                return null;
            }
        }
        return element;
    }
}

