/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import crazydev.common.exception.CdRuntimeException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.datasource.common.OlapBuilderTableRow;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.def.IOlapBuilderTableRow;
import crazydev.iccube.gson.GsonTableColumnBuilder;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.log4j.Logger;

public class GsonTableReader {
    public static final Logger LOGGER = OlapLoggers.BUILDER;
    private final List<IOlapBuilderDataColumnDef> columnDefs;
    private final Node parser;
    private JsonReader reader;
    private boolean readingArray;

    public GsonTableReader(List<IOlapBuilderDataColumnDef> columnDefs) {
        this.columnDefs = columnDefs;
        this.parser = Node.buildTree(columnDefs);
    }

    public void init(JsonReader reader) {
        this.reader = reader;
        this.readingArray = false;
    }

    public IOlapBuilderTableRow nextRow() throws IOException {
        JsonObject object = null;
        try {
            object = this.nextRowElement();
            return this.toTableRow(object);
        }
        catch (Exception ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
            throw new IOException("Error [" + String.valueOf(ex) + "] parsing object : " + String.valueOf(object));
        }
    }

    public JsonObject nextRowElement() throws IOException {
        JsonToken token = this.reader.peek();
        switch (token) {
            case BEGIN_ARRAY: {
                if (this.readingArray) {
                    throw new CdShouldNotBeHereProgrammingException();
                }
                this.reader.beginArray();
                this.readingArray = true;
                return this.nextRowElement();
            }
            case END_ARRAY: {
                if (!this.readingArray) {
                    throw new CdShouldNotBeHereProgrammingException();
                }
                this.reader.endArray();
                this.readingArray = false;
                return this.nextRowElement();
            }
            case BEGIN_OBJECT: {
                return Streams.parse((JsonReader)this.reader).getAsJsonObject();
            }
            case NULL: 
            case END_DOCUMENT: 
            case END_OBJECT: 
            case NAME: {
                return null;
            }
        }
        throw new CdShouldNotBeHereProgrammingException(token.toString());
    }

    public IOlapBuilderTableRow toTableRow(JsonObject object) {
        return object == null ? null : this.parser.parse(object, this.columnDefs);
    }

    private static class Node {
        private final String key;
        private final List<Node> children = new ArrayList<Node>();
        private IOlapBuilderDataColumnDef column;

        private Node(String key) {
            this.key = key;
        }

        private Optional<Node> lookupChild(String key) {
            return this.children.stream().filter(node -> node.key.equals(key)).findFirst();
        }

        static Node buildTree(List<IOlapBuilderDataColumnDef> columns) {
            Node root = new Node(null);
            for (int i = 0; i < columns.size(); ++i) {
                IOlapBuilderDataColumnDef columnDef = columns.get(i);
                String[] path = columnDef.getName().split("\\.");
                root.build(columnDef, path, 0);
            }
            return root;
        }

        private Node build(IOlapBuilderDataColumnDef column, String[] path, int posInPath) {
            boolean isLast = posInPath == path.length - 1;
            String key = path[posInPath];
            Optional<Node> lookupChild = this.lookupChild(key);
            if (lookupChild.isPresent()) {
                if (isLast) {
                    throw new CdRuntimeException("should not be here : " + column.getName());
                }
                lookupChild.get().build(column, path, posInPath + 1);
            } else {
                Node node = new Node(key);
                this.children.add(node);
                if (isLast) {
                    node.column = column;
                } else {
                    node.build(column, path, posInPath + 1);
                }
            }
            return this;
        }

        public IOlapBuilderTableRow parse(JsonObject jsonObject, List<IOlapBuilderDataColumnDef> columnDefs) {
            if (jsonObject == null) {
                return null;
            }
            Object[] values = new Object[this.getIndexSize(columnDefs)];
            for (Node child : this.children) {
                child.setValue(values, (JsonElement)jsonObject);
            }
            return new OlapBuilderTableRow(values);
        }

        private int getIndexSize(List<IOlapBuilderDataColumnDef> columnDefs) {
            int i = 0;
            for (int j = 0; j < columnDefs.size(); ++j) {
                IOlapBuilderDataColumnDef def = columnDefs.get(j);
                i = Math.max(i, def.getIndex() + 1);
            }
            return i;
        }

        private void setValue(Object[] values, JsonElement jsonElement) {
            block3: {
                JsonElement json;
                block4: {
                    block2: {
                        if (this.column == null) break block2;
                        this.setValueInLeaf(values, jsonElement);
                        break block3;
                    }
                    if (!jsonElement.isJsonArray()) break block4;
                    JsonArray array = jsonElement.getAsJsonArray();
                    for (int i = 0; i < array.size(); ++i) {
                        JsonElement item = array.get(i);
                        this.setValue(values, item);
                    }
                    break block3;
                }
                if (!jsonElement.isJsonObject() || (json = jsonElement.getAsJsonObject().get(this.key)) == null) break block3;
                for (Node child : this.children) {
                    child.setValue(values, json);
                }
            }
        }

        private void setValueInLeaf(Object[] values, JsonElement jsonElement) {
            if (jsonElement.isJsonArray()) {
                JsonArray array = jsonElement.getAsJsonArray();
                for (int i = 0; i < array.size(); ++i) {
                    JsonElement item = array.get(i);
                    this.setValueInLeaf(values, item);
                }
            } else if (jsonElement.isJsonPrimitive()) {
                this.setPrimitive(values, jsonElement.getAsJsonPrimitive());
            } else {
                if (!jsonElement.isJsonObject()) {
                    throw new CdShouldNotBeHereProgrammingException("expected JSON object in tree : " + String.valueOf(jsonElement));
                }
                JsonElement element = jsonElement.getAsJsonObject().get(this.key);
                if (element == null) {
                    values[this.column.getIndex()] = null;
                } else {
                    this.setValueInRow(values, element);
                }
            }
        }

        private void setValueInRow(Object[] rowValues, JsonElement element) {
            if (element.isJsonNull()) {
                return;
            }
            if (element.isJsonArray()) {
                if (!this.column.isArray()) {
                    throw new RuntimeException(" Column [" + this.column.getName() + "] is not marked as an array, but the json field is an array");
                }
                JsonArray jsonArray = element.getAsJsonArray();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    this.setValueInRow(rowValues, jsonArray.get(i));
                }
                return;
            }
            if (!element.isJsonPrimitive()) {
                throw new CdShouldNotBeHereProgrammingException("unexpected JSON object in tree : " + String.valueOf(element));
            }
            this.setPrimitive(rowValues, element.getAsJsonPrimitive());
        }

        private void setPrimitive(Object[] rowValues, JsonPrimitive element) {
            Object value = GsonTableColumnBuilder.asComparable(this.column, element);
            if (value == null) {
                return;
            }
            int columnIndex = this.column.getIndex();
            Object existingValue = rowValues[columnIndex];
            if (this.column.isArray()) {
                if (existingValue == null) {
                    rowValues[columnIndex] = new Object[0];
                }
                rowValues[columnIndex] = ArrayUtils.add((Object[])((Object[])rowValues[columnIndex]), (Object)value);
            } else {
                if (existingValue != null) {
                    throw new CdShouldNotBeHereProgrammingException("");
                }
                rowValues[columnIndex] = value;
            }
        }
    }
}

