/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import crazydev.common.exception.programming.CdShouldNotBeHereProgrammingException;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.builder.model.def.IOlapBuilderDataColumnDef;
import crazydev.iccube.builder.model.impl.OlapBuilderDataColumn;
import crazydev.iccube.builder.type.OlapBuilderInputType;
import crazydev.iccube.gson.GsonUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class GsonTableColumnBuilder {
    public static List<IOlapBuilderDataColumnDef> getColumns(JsonReader stream, String[] docRoot, Predicate<String> isErrorTag, int itemLimit) throws IOException {
        try {
            JsonToken token;
            try {
                GsonUtils.advanceStream(stream, docRoot, isErrorTag);
                token = stream.peek();
            }
            catch (EOFException ok) {
                return Collections.emptyList();
            }
            if (token == JsonToken.BEGIN_OBJECT) {
                JsonElement jsonElement = JsonParser.parseReader((JsonReader)stream);
                return GsonTableColumnBuilder.addElement("", jsonElement, false);
            }
            if (token == JsonToken.BEGIN_ARRAY) {
                HashSet<IOlapBuilderDataColumnDef> setColumns = new HashSet<IOlapBuilderDataColumnDef>();
                stream.beginArray();
                int i = 0;
                while (stream.peek() != JsonToken.END_ARRAY) {
                    JsonElement jsonElement = JsonParser.parseReader((JsonReader)stream);
                    List<IOlapBuilderDataColumnDef> itemCols = GsonTableColumnBuilder.addElement("", jsonElement, false);
                    setColumns.addAll(itemCols);
                    if (itemLimit == -1 || ++i < itemLimit) continue;
                    break;
                }
                return new ArrayList<IOlapBuilderDataColumnDef>(setColumns);
            }
            if (token == JsonToken.END_DOCUMENT) {
                return Collections.emptyList();
            }
        }
        catch (MalformedJsonException ex) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.MALFORMED_JSON_EXCEPTION, new Serializable[]{ex.getMessage()});
        }
        JsonElement jsonElement = JsonParser.parseReader((JsonReader)stream);
        throw new IOException("unexpected JSON : " + jsonElement.toString());
    }

    private static List<IOlapBuilderDataColumnDef> addElement(String path, JsonElement element, boolean isArray) {
        ArrayList<IOlapBuilderDataColumnDef> list = new ArrayList<IOlapBuilderDataColumnDef>();
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            for (Map.Entry entry : object.entrySet()) {
                List<IOlapBuilderDataColumnDef> cols = GsonTableColumnBuilder.addElement(path + (path.isEmpty() ? "" : ".") + (String)entry.getKey(), (JsonElement)entry.getValue(), isArray);
                list.addAll(cols);
            }
        } else if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            if (array.size() > 0) {
                HashSet<IOlapBuilderDataColumnDef> setColumns = new HashSet<IOlapBuilderDataColumnDef>();
                for (int i = 0; i < array.size(); ++i) {
                    JsonElement jsonElement = array.get(i);
                    List<IOlapBuilderDataColumnDef> cols = GsonTableColumnBuilder.addElement(path, jsonElement, true);
                    setColumns.addAll(cols);
                }
                list.addAll(setColumns);
            }
        } else if (element.isJsonPrimitive()) {
            JsonPrimitive primitive = element.getAsJsonPrimitive();
            list.add(new OlapBuilderDataColumn(GsonTableColumnBuilder.getSimpleType(primitive), "JSON", path, isArray));
        } else if (!element.isJsonNull()) {
            throw new CdShouldNotBeHereProgrammingException(element.toString());
        }
        return list;
    }

    private static OlapBuilderInputType getSimpleType(JsonPrimitive value) {
        if (value.isNumber()) {
            return OlapBuilderInputType.DOUBLE;
        }
        if (value.isBoolean()) {
            return OlapBuilderInputType.BOOLEAN;
        }
        return OlapBuilderInputType.STRING;
    }

    @Nullable
    static Object asComparable(IOlapBuilderDataColumnDef column, JsonPrimitive jsonPrimitive) {
        if (jsonPrimitive.isJsonNull()) {
            return null;
        }
        if (jsonPrimitive.isBoolean()) {
            return jsonPrimitive.getAsBoolean();
        }
        if (jsonPrimitive.isNumber()) {
            return jsonPrimitive.getAsNumber();
        }
        return jsonPrimitive.getAsString();
    }
}

