/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.fs;

import crazydev.common.fs.CdVFilePath;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.builder.errors.OlapBuilderErrorCode;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileException;
import crazydev.iccube.fs.OlapFileNameFilter;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.request.request.IcCubeRequest;
import crazydev.iccube.runtime.OlapRuntime;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public class OlapFileSystem {
    private final CdVFileSystem vfs;
    @Nullable
    private final File root;
    @Nullable
    private final OlapDirectoriesResolved directories;
    @Nullable
    private final File cubesDirectory;

    private OlapFileSystem(CdVFileSystem vfs, @Nullable File root, @Nullable OlapDirectoriesResolved directories, @Nullable File cubesDirectory) {
        this.vfs = vfs;
        this.root = root;
        this.directories = directories;
        this.cubesDirectory = directories != null ? directories.getCubesDirectory() : cubesDirectory;
    }

    public static OlapFileSystem createDataFileSystem(OlapRuntime runtime, @Nullable File root, OlapDirectoriesResolved directories) {
        File data;
        File dataFileSystemRoot = runtime.getDataFileSystemRoot(root);
        if (directories != null) {
            OlapTenant tenant = directories.getTenant();
            if (tenant != null && dataFileSystemRoot != null) {
                File tenants = new File(dataFileSystemRoot, "$tenants$");
                data = new File(tenants, tenant.getDirectory());
            } else {
                data = dataFileSystemRoot;
            }
        } else {
            data = dataFileSystemRoot;
        }
        return new OlapFileSystem(runtime.getVfs(), data, directories, null);
    }

    public static OlapFileSystem createDataFileSystem__(OlapRuntime runtime, @Nullable File root, @Nullable File cubesDirectory) {
        return new OlapFileSystem(runtime.getVfs(), runtime.getDataFileSystemRoot(root), null, cubesDirectory);
    }

    public static OlapFileSystem createDataFileSystem__(OlapRuntime runtime, @Nullable File root) {
        return new OlapFileSystem(runtime.getVfs(), runtime.getDataFileSystemRoot(root), null, null);
    }

    public static OlapFileSystem createLogFileSystem(OlapRuntime runtime, File root) {
        return new OlapFileSystem(runtime.getVfs(), runtime.getLogFileSystemRoot(root), null, null);
    }

    public static OlapFileSystem createFileSystem(CdVFileSystem vfs, File root) {
        return new OlapFileSystem(vfs, root, null, null);
    }

    public CdVFileSystem getVfs() {
        return this.vfs;
    }

    @Nullable
    public File getRoot__() {
        return this.root;
    }

    public boolean isConstraint() {
        return this.root != null;
    }

    public boolean isTenantRootMissing() {
        if (this.directories != null && this.root != null && this.directories.getTenant() != null && !this.root.exists()) {
            String tenantName = this.directories.getTenantName();
            String rootPath = this.root.getAbsolutePath();
            OlapLoggers.GENERAL.warn((Object)String.format("[tenant] root missing [name:%s] [path:%s]", tenantName, rootPath));
            return true;
        }
        return false;
    }

    public String getPath(File underlying) {
        if (this.root == null) {
            return underlying.getPath();
        }
        Path uPath = underlying.toPath();
        Path rPath = this.root.toPath();
        File file = rPath.relativize(uPath).toFile();
        String relative = file.getPath();
        return relative;
    }

    public OlapFile create(String path) {
        if (this.isConstraint() && OlapFileSystem.containsDotDot(path)) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.PATH_WITH_DOT_DOT, new Serializable[]{path});
        }
        if (this.root == null) {
            File underlying = new File(path);
            return new OlapFile(this, path, underlying);
        }
        File underlying = new File(this.root, path);
        return new OlapFile(this, path, underlying);
    }

    public OlapFile create(OlapFile directory, String path) {
        if (this != directory.getFileSystem()) {
            File rootL = this.root;
            File rootR = directory.getFileSystem().root;
            if (rootL == null) {
                if (rootR != null) {
                    OlapLoggers.GENERAL.error((Object)("inconsistent file system (1) : " + String.valueOf(rootR)));
                    throw new OlapFileException("inconsistent file system (1)");
                }
            } else {
                if (rootR == null) {
                    OlapLoggers.GENERAL.error((Object)("inconsistent file system (2) : " + String.valueOf(rootL)));
                    throw new OlapFileException("inconsistent file system (2)");
                }
                Path pRootL = rootL.toPath();
                Path pRootR = rootR.toPath();
                try {
                    if (!Files.isSameFile(pRootL, pRootR)) {
                        OlapLoggers.GENERAL.error((Object)("inconsistent file system (3) : " + String.valueOf(rootL) + " -- " + String.valueOf(rootR)));
                        throw new OlapFileException("inconsistent file system (3)");
                    }
                }
                catch (IOException ex) {
                    OlapLoggers.GENERAL.error((Object)("inconsistent file system (4) : " + String.valueOf(rootL) + " -- " + String.valueOf(rootR)), (Throwable)ex);
                    throw new OlapFileException("inconsistent file system (4)");
                }
            }
        }
        if (this.isConstraint() && OlapFileSystem.containsDotDot(path)) {
            throw new OlapBuilderErrorException(OlapBuilderErrorCode.PATH_WITH_DOT_DOT, new Serializable[]{path});
        }
        if (this.root == null) {
            File underlying = new File(directory.getPath(), path);
            return new OlapFile(this, underlying.getPath(), underlying);
        }
        String xpath = new File(directory.getPath(), path).getPath();
        File underlying = new File(this.root, xpath);
        return new OlapFile(this, xpath, underlying);
    }

    public static boolean containsDotDot(String path) {
        if (CdStringUtils.isNullOrBlank((String)path)) {
            return false;
        }
        String pathN = FilenameUtils.normalize((String)path);
        return CdStringUtils.isNullOrBlank((String)pathN);
    }

    @Nullable
    public String evalPropertyForCubesLocation(@Nullable String directory) {
        if (directory != null) {
            if (directory.contains("${EXAMPLE}") && this.cubesDirectory != null) {
                return directory.replace("${EXAMPLE}", this.cubesDirectory.getAbsolutePath());
            }
            if (directory.contains("${auditDirectory}") && this.directories != null) {
                return directory.replace("${auditDirectory}", this.directories.getAuditDirectory().getAbsolutePath());
            }
        }
        return directory;
    }

    @Nullable
    public OlapFile getParentFile(OlapFile file) {
        String path = file.getPath();
        File parent = new File(path).getParentFile();
        if (parent == null) {
            return null;
        }
        String parentPath = parent.getPath();
        return this.create(parentPath);
    }

    public List<OlapFile> list(int maxCount, boolean showHidden) throws IOException {
        return this.list(maxCount, null, showHidden);
    }

    public List<OlapFile> list(int maxCount, @Nullable String path, boolean showHidden) throws IOException {
        return this.doList(maxCount, path, showHidden, false);
    }

    public List<OlapFile> sortedList(int maxCount, boolean showHidden) throws IOException {
        return this.sortedList(maxCount, null, showHidden);
    }

    public List<OlapFile> sortedList(int maxCount, @Nullable String path, boolean showHidden) throws IOException {
        return this.doList(maxCount, path, showHidden, true);
    }

    private List<OlapFile> doList(int maxCount, @Nullable String path, boolean showHidden, boolean sorted) throws IOException {
        if (path == null) {
            return this.doListRoots(maxCount, showHidden);
        }
        return this.doListFiles(maxCount, path, showHidden);
    }

    private List<OlapFile> doListRoots(int maxCount, boolean showHidden) throws IOException {
        if (this.root == null) {
            ArrayList<OlapFile> files = new ArrayList<OlapFile>();
            File[] paths = File.listRoots();
            if (paths != null) {
                for (File path : paths) {
                    if (!showHidden && path.isHidden()) continue;
                    files.add(this.doCreateOlapFile(null, path));
                }
            }
            return this.doSortFiles(files);
        }
        return this.doListFiles(maxCount, null, showHidden);
    }

    private List<OlapFile> doListFiles(int maxCount, @Nullable String path, boolean showHidden) throws IOException {
        OlapFile file = this.create(path == null ? "" : path);
        DirectoryStream.Filter<Path> filter = entry -> showHidden || !Files.isHidden(entry);
        try (DirectoryStream stream = this.vfs.createDirectoryStream(file.__getUnderlying(), filter);){
            List<OlapFile> list = this.doListFiles(maxCount, path, stream);
            return list;
        }
    }

    private List<OlapFile> doListFiles(int maxCount, @Nullable String path, DirectoryStream<Path> stream) {
        ArrayList<OlapFile> oFiles = new ArrayList<OlapFile>();
        int count = 0;
        for (Path entry : stream) {
            File entryF = entry.toFile();
            OlapFile oFile = this.doCreateOlapFile(path, entryF);
            oFiles.add(oFile);
            if (++count < 100) continue;
            IcCubeRequest.assertNotCancelled("ic3-file-system-iteration");
            this.doSortFiles(oFiles);
            if (oFiles.size() > maxCount) {
                oFiles = new ArrayList(oFiles.subList(0, maxCount));
            }
            count = 0;
        }
        return count != 0 ? this.doSortFiles(oFiles) : oFiles;
    }

    private List<OlapFile> doSortFiles(List<OlapFile> files) {
        files.sort((o1, o2) -> {
            if (o1.isDirectory() && o2.isFile()) {
                return -1;
            }
            if (o1.isFile() && o2.isDirectory()) {
                return 1;
            }
            return o1.getPath().compareTo(o2.getPath());
        });
        return files;
    }

    private OlapFile doCreateOlapFile(@Nullable String parent, File child) {
        String path = parent == null ? (child.getName().isEmpty() ? child.getPath() : child.getName()) : new File(parent, child.getName()).getPath();
        return new OlapFile(this, path, child);
    }

    public List<String> listLocalFileNames(OlapFile target, OlapFileNameFilter filter) {
        try {
            ArrayList files = new ArrayList();
            this.vfs.forEachFile(target.__getUnderlying(), path -> !Files.isHidden(path), vPath -> {
                File file = vPath.path.toFile();
                if (filter.accept(file.getName())) {
                    files.add(file);
                }
            });
            return files.stream().map(File::getName).toList();
        }
        catch (IOException ex) {
            OlapLoggers.VFS.error((Object)"[vfs] Could not retrieve the list of files", (Throwable)ex);
            throw new RuntimeException("Could not retrieve the list of files");
        }
    }

    public void processAllFiles(OlapFile file, DirectoryStream.Filter<? super Path> filter, Consumer<CdVFilePath> action) throws IOException {
        this.vfs.forEachFileRecursive(file.__getUnderlying(), filter, action);
    }

    public boolean exists(OlapFile target) {
        return this.vfs.exists(target.__getUnderlying());
    }

    public boolean delete(OlapFile target) {
        return this.vfs.delete(target.__getUnderlying());
    }

    public boolean mkdir(OlapFile target) {
        return this.vfs.mkdir(target.__getUnderlying());
    }

    public List<String> readAllLines(OlapFile target) throws IOException {
        return this.vfs.readAllLines(target.__getUnderlying());
    }

    public InputStream createInputStream(OlapFile target) throws IOException {
        return this.vfs.createInputStream(target.__getUnderlying());
    }

    public void saveFile(OlapFile target, InputStream content) throws IOException {
        this.vfs.saveFile(target.__getUnderlying(), content);
    }

    public void move(OlapFile source, OlapFile target) throws IOException {
        if (source.isDirectory()) {
            this.vfs.moveDirectory(source.__getUnderlying(), target.__getUnderlying());
        } else {
            this.vfs.moveFile(source.__getUnderlying(), target.__getUnderlying());
        }
    }

    public DirectoryStream<Path> createDirectoryStream(OlapFile target, DirectoryStream.Filter<? super Path> filter) throws IOException {
        return this.vfs.createDirectoryStream(target.__getUnderlying(), filter);
    }

    public File createTmpFileForDownload(File tmpDirectory, String extension) throws IOException {
        return this.vfs.createTmpFileForDownload(tmpDirectory, extension);
    }

    public File createTmpFileForUpload(File tmpDirectory, String extension) throws IOException {
        return this.vfs.createTmpFileForUpload(tmpDirectory, extension);
    }

    public void installWebDashboards(String app, String backups, File zip, Predicate<String> filter, boolean backup) throws IOException {
        File appU = this.create(app).__getUnderlying();
        File backupsU = this.create(backups).__getUnderlying();
        this.vfs.installWebDashboards(appU, backupsU, zip, filter, backup);
    }

    public void installWebDashboardsFromBackup(String app, String backups, String timestamp) throws IOException {
        File appU = this.create(app).__getUnderlying();
        File backupsU = this.create(backups).__getUnderlying();
        this.vfs.installWebDashboardsFromBackup(appU, backupsU, timestamp);
    }
}

