/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.directories;

import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.directories.OlapDirectories;
import crazydev.iccube.directories.OlapDirectoriesResolvedNotSuperAdminException;
import crazydev.iccube.directories.OlapEngineDirectoriesResolved;
import crazydev.iccube.pub.tenant.OlapTenant;
import crazydev.iccube.tenants.OlapTenantUtils;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class OlapDirectoriesResolved {
    public static final String CUBES = "cubes";
    public static final String OFFLINE = "offline";
    public static final String BUILDER = "builder";
    public static final String DOCS_REPOSITORY = "docsRepository";
    public static final String SCHEDULER = "scheduler";
    public static final String BACKUP = "backup";
    public static final String WEB_PUB = "webPub";
    private final CdVFileSystem vfs;
    @Nullable
    private final OlapTenant tenant;
    private final File dataDirectory;
    private final File tmpDirectory;
    private final File cubesDirectory;
    private final File auditDirectory;
    private final File schemaDataDirectory;
    private final File offlineDirectory;
    private final File pluginsDirectory;
    private final File builderDirectory;
    private final File oauth2Directory;
    private final File rolesDirectory;
    private final File usersDirectory;
    @Nullable
    private final File tenantsDirectory;
    private final File webPubDirectory;
    private final File docsRepositoryDirectory;
    private final File schedulerDirectory;
    private final File backupDirectory;
    private final File multiTenantDirectory;
    private final OlapEngineDirectoriesResolved engineDirectories;

    private OlapDirectoriesResolved(CdVFileSystem vfs, @Nullable OlapTenant tenant, File dataDirectory, File tmpDirectory, File cubesDirectory, File auditDirectory, File schemaDataDirectory, File offlineDirectory, File pluginsDirectory, File builderDirectory, File oauth2Directory, File rolesDirectory, File usersDirectory, @Nullable File tenantsDirectory, File webPubDirectory, File docsRepositoryDirectory, File schedulerDirectory, File backupDirectory, @Nullable File multiTenantDirectory) {
        this.vfs = vfs;
        this.tenant = tenant;
        this.dataDirectory = dataDirectory;
        this.tmpDirectory = tmpDirectory;
        this.cubesDirectory = cubesDirectory;
        this.auditDirectory = auditDirectory;
        this.schemaDataDirectory = schemaDataDirectory;
        this.offlineDirectory = offlineDirectory;
        this.pluginsDirectory = pluginsDirectory;
        this.builderDirectory = builderDirectory;
        this.oauth2Directory = oauth2Directory;
        this.rolesDirectory = rolesDirectory;
        this.usersDirectory = usersDirectory;
        this.tenantsDirectory = tenantsDirectory;
        this.webPubDirectory = webPubDirectory;
        this.docsRepositoryDirectory = docsRepositoryDirectory;
        this.schedulerDirectory = schedulerDirectory;
        this.backupDirectory = backupDirectory;
        this.multiTenantDirectory = multiTenantDirectory;
        this.engineDirectories = new OlapEngineDirectoriesResolved(vfs, tmpDirectory, cubesDirectory, schemaDataDirectory, offlineDirectory, pluginsDirectory);
    }

    public static OlapDirectoriesResolved create(OlapDirectories directories) {
        return new OlapDirectoriesResolved(directories.getVfs(), null, directories.getDataDirectory__(), directories.getTmpDirectory__(), directories.getCubesDirectory__(), directories.getAuditDirectory__(), directories.getSchemaDataDirectory__(), directories.getOfflineDirectory__(), directories.getPluginsDirectory__(), directories.getBuilderDirectory__(), directories.getOAuth2Directory__(), directories.getRolesDirectory__(), directories.getUsersDirectory__(), directories.getTenantsDirectory__(), directories.getWebPubDirectory__(), directories.getDocsRepositoryDirectory__(), directories.getSchedulerDirectory__(), directories.getBackupDirectory__(), directories.getMultiTenantDirectory__());
    }

    public OlapDirectoriesResolved create(OlapTenant tenant) throws OlapDirectoriesResolvedNotSuperAdminException {
        this.assertRoot();
        File home = OlapTenantUtils.getHomeDirectory(this, tenant);
        File tCubes = new File(home, CUBES);
        File tOffline = new File(home, OFFLINE);
        File tBuilder = new File(home, BUILDER);
        File tDocsRepository = new File(home, DOCS_REPOSITORY);
        File tWebPub = new File(home, WEB_PUB);
        File tScheduler = new File(home, SCHEDULER);
        File tBackup = new File(home, BACKUP);
        return new OlapDirectoriesResolved(this.vfs, tenant, this.dataDirectory, this.tmpDirectory, tCubes, this.auditDirectory, this.schemaDataDirectory, tOffline, this.pluginsDirectory, tBuilder, this.oauth2Directory, this.rolesDirectory, this.usersDirectory, this.tenantsDirectory, tWebPub, tDocsRepository, tScheduler, tBackup, this.multiTenantDirectory);
    }

    public CdVFileSystem getVfs() {
        return this.vfs;
    }

    @Nullable
    public OlapTenant getTenant() {
        return this.tenant;
    }

    @Nullable
    public String getTenantDirectory() {
        return this.tenant != null ? this.tenant.getDirectory() : null;
    }

    public String getTenantName() {
        return this.tenant != null ? this.tenant.getName() : "<root>";
    }

    public File getDataDirectory() {
        return this.dataDirectory;
    }

    public File getTmpDirectory() {
        return this.tmpDirectory;
    }

    public File getCubesDirectory() {
        return this.cubesDirectory;
    }

    public File getAuditDirectory() {
        return this.auditDirectory;
    }

    public File getSchemaDataDirectory() {
        return this.schemaDataDirectory;
    }

    public File getOfflineDirectory() {
        return this.offlineDirectory;
    }

    public File getPluginsDirectory() {
        return this.pluginsDirectory;
    }

    public File getBuilderDirectory() {
        return this.builderDirectory;
    }

    public File getRolesDirectory() {
        return this.rolesDirectory;
    }

    public File getOAuth2Directory() {
        return this.oauth2Directory;
    }

    public File getUsersDirectory() {
        return this.usersDirectory;
    }

    @Nullable
    public File getTenantsDirectory() {
        return this.tenantsDirectory;
    }

    public File getWebPubDirectory() {
        return this.webPubDirectory;
    }

    public File getDocsRepositoryDirectory() {
        return this.docsRepositoryDirectory;
    }

    public File getSchedulerDirectory() {
        return this.schedulerDirectory;
    }

    public File getBackupDirectory() {
        return this.backupDirectory;
    }

    @Nullable
    public File getMultiTenantDirectory() {
        return this.multiTenantDirectory;
    }

    public OlapEngineDirectoriesResolved asEngineDirectories() {
        return this.engineDirectories;
    }

    public void assertRoot() throws OlapDirectoriesResolvedNotSuperAdminException {
        if (this.tenant != null) {
            throw new OlapDirectoriesResolvedNotSuperAdminException("internal error: inconsistent directories setup [tenant:" + this.tenant.getName() + "] : the operation requires a super admin");
        }
    }
}

