/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.directories;

import crazydev.common.exception.CdException;
import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.directories.OlapDirectoriesConfiguration;
import crazydev.iccube.directories.OlapEngineDirectories;
import crazydev.iccube.directories.impl.OlapMultiTenantDirectoryConfiguration;
import crazydev.iccube.directories.impl.OlapTenantsDirectoryConfiguration;
import crazydev.iccube.runtime.OlapRuntime;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public class OlapDirectories
implements Serializable {
    private static final long serialVersionUID = 8417754998222279486L;
    private final Properties props;
    private final CdVFileSystem vfs;
    private final File dataDirectory;
    private final File tmpDirectory;
    private final File cubesDirectory;
    private final File auditDirectory;
    private final File schemaDataDirectory;
    private final File offlineDirectory;
    private final File pluginsDirectory;
    private final File builderDirectory;
    private final File oauth2Directory;
    private final File rolesDirectory;
    private final File usersDirectory;
    @Nullable
    private final File tenantsDirectory;
    private final File webPubDirectory;
    private final File docsRepositoryDirectory;
    private final File schedulerDirectory;
    private final File backupDirectory;
    @Nullable
    private final File multiTenantDirectory;

    private OlapDirectories(Properties props, CdVFileSystem vfs, File dataDirectory, File tmpDirectory, File cubesDirectory, File auditDirectory, File schemaDataDirectory, File offlineDirectory, File pluginsDirectory, File builderDirectory, File oauth2Directory, File rolesDirectory, File usersDirectory, @Nullable File tenantsDirectory, File webPubDirectory, File docsRepositoryDirectory, File schedulerDirectory, File backupDirectory, @Nullable File multiTenantDirectory) {
        this.props = props;
        this.vfs = vfs;
        this.dataDirectory = dataDirectory;
        this.tmpDirectory = tmpDirectory;
        this.cubesDirectory = cubesDirectory;
        this.auditDirectory = auditDirectory;
        this.schemaDataDirectory = schemaDataDirectory;
        this.offlineDirectory = offlineDirectory;
        this.pluginsDirectory = pluginsDirectory;
        this.builderDirectory = builderDirectory;
        this.oauth2Directory = oauth2Directory;
        this.rolesDirectory = rolesDirectory;
        this.usersDirectory = usersDirectory;
        this.tenantsDirectory = tenantsDirectory;
        this.webPubDirectory = webPubDirectory;
        this.docsRepositoryDirectory = docsRepositoryDirectory;
        this.schedulerDirectory = schedulerDirectory;
        this.backupDirectory = backupDirectory;
        this.multiTenantDirectory = multiTenantDirectory;
    }

    public static OlapDirectories create(OlapRuntime runtime, boolean withMultiTenant, OlapDirectoriesConfiguration directories) throws CdException {
        directories.validate(runtime, withMultiTenant);
        File dataDirectory = directories.getDataDirectory().asFile();
        CdVFileSystem.assertDirectory((String)"data", (File)dataDirectory);
        File tmpDirectory = directories.getTmpDirectory().asFile();
        CdVFileSystem.assertDirectory((String)"tmp", (File)tmpDirectory);
        File cubesDirectory = directories.getCubesDirectory().asFile();
        CdVFileSystem.assertDirectory((String)"cubes", (File)cubesDirectory);
        File auditDirectory = directories.getAuditDirectory().asFile();
        CdVFileSystem.assertDirectory((String)"audit", (File)auditDirectory);
        File schemaDataDirectory = directories.getSchemaDataDirectory().asFile();
        CdVFileSystem.assertDirectory((String)"schemaData", (File)schemaDataDirectory);
        File offlineDirectory = directories.getOfflineDirectory().asFile();
        CdVFileSystem.assertDirectory((String)"offline", (File)offlineDirectory);
        File pluginsDirectory = runtime.getInstallPluginsDirectory();
        File builderDirectory = directories.getBuilderDirectory().asFile();
        CdVFileSystem.assertDirectory((String)"builder", (File)builderDirectory);
        File oauth2Directory = directories.getOAuth2Directory().asFile();
        CdVFileSystem.assertDirectory((String)"oauth2", (File)oauth2Directory);
        File rolesDirectory = directories.getRolesDirectory().asFile();
        CdVFileSystem.assertDirectory((String)"roles", (File)rolesDirectory);
        File usersDirectory = directories.getUsersDirectory().asFile();
        CdVFileSystem.assertDirectory((String)"users", (File)usersDirectory);
        File webPubDirectory = directories.getWebPubDirectory().asFile();
        CdVFileSystem.assertDirectory((String)"report", (File)webPubDirectory);
        File docsRepositoryDirectory = directories.getDocsRepositoryDirectory().asFile();
        CdVFileSystem.assertDirectory((String)"docsRepository", (File)docsRepositoryDirectory);
        File schedulerDirectory = directories.getSchedulerDirectory().asFile();
        CdVFileSystem.assertDirectory((String)"scheduler", (File)schedulerDirectory);
        File backupDirectory = directories.getBackupDirectory().asFile();
        CdVFileSystem.assertDirectory((String)"backup", (File)backupDirectory);
        File tenantsDirectory = null;
        File multiTenantDirectory = null;
        if (withMultiTenant) {
            OlapTenantsDirectoryConfiguration tenantsDirectory_ = directories.getTenantsDirectory();
            if (tenantsDirectory_ == null) {
                throw new RuntimeException("icCube.xml: missing <tenantsDirectory> property.");
            }
            tenantsDirectory = tenantsDirectory_.asFile();
            CdVFileSystem.assertDirectory((String)"tenants", (File)tenantsDirectory);
            OlapMultiTenantDirectoryConfiguration multiTenantDirectory_ = directories.getMultiTenantDirectory();
            if (multiTenantDirectory_ == null) {
                throw new RuntimeException("icCube.xml: missing <multiTenantDirectory> property.");
            }
            multiTenantDirectory = multiTenantDirectory_.asFile();
            CdVFileSystem.assertDirectory((String)"multiTenant", (File)multiTenantDirectory);
        }
        Properties props = new Properties();
        props.put(directories.getDataDirectory().getFullName(), dataDirectory.getAbsolutePath());
        props.put(directories.getTmpDirectory().getFullName(), tmpDirectory.getAbsolutePath());
        props.put(directories.getCubesDirectory().getFullName(), cubesDirectory.getAbsolutePath());
        props.put(directories.getAuditDirectory().getFullName(), auditDirectory.getAbsolutePath());
        props.put(directories.getSchemaDataDirectory().getFullName(), schemaDataDirectory.getAbsolutePath());
        props.put(directories.getOfflineDirectory().getFullName(), offlineDirectory.getAbsolutePath());
        props.put(directories.getBuilderDirectory().getFullName(), builderDirectory.getAbsolutePath());
        props.put(directories.getOAuth2Directory().getFullName(), oauth2Directory.getAbsolutePath());
        props.put(directories.getRolesDirectory().getFullName(), rolesDirectory.getAbsolutePath());
        props.put(directories.getUsersDirectory().getFullName(), usersDirectory.getAbsolutePath());
        props.put(directories.getWebPubDirectory().getFullName(), webPubDirectory.getAbsolutePath());
        props.put(directories.getDocsRepositoryDirectory().getFullName(), docsRepositoryDirectory.getAbsolutePath());
        props.put(directories.getSchedulerDirectory().getFullName(), schedulerDirectory.getAbsolutePath());
        props.put(directories.getBackupDirectory().getFullName(), backupDirectory.getAbsolutePath());
        if (multiTenantDirectory != null) {
            props.put(directories.getTenantsDirectory().getFullName(), tenantsDirectory.getAbsolutePath());
            props.put(directories.getMultiTenantDirectory().getFullName(), multiTenantDirectory.getAbsolutePath());
        }
        return new OlapDirectories(props, runtime.getVfs(), dataDirectory, tmpDirectory, cubesDirectory, auditDirectory, schemaDataDirectory, offlineDirectory, pluginsDirectory, builderDirectory, oauth2Directory, rolesDirectory, usersDirectory, tenantsDirectory, webPubDirectory, docsRepositoryDirectory, schedulerDirectory, backupDirectory, multiTenantDirectory);
    }

    public Properties asSystemProperties() {
        return this.props;
    }

    public CdVFileSystem getVfs() {
        return this.vfs;
    }

    public File getDataDirectory__() {
        return this.dataDirectory;
    }

    public File getTmpDirectory__() {
        return this.tmpDirectory;
    }

    public File getPluginsDirectory__() {
        return this.pluginsDirectory;
    }

    public File getCubesDirectory__() {
        return this.cubesDirectory;
    }

    public File getAuditDirectory__() {
        return this.auditDirectory;
    }

    public File getSchemaDataDirectory__() {
        return this.schemaDataDirectory;
    }

    public File getOfflineDirectory__() {
        return this.offlineDirectory;
    }

    public File getBuilderDirectory__() {
        return this.builderDirectory;
    }

    public File getOAuth2Directory__() {
        return this.oauth2Directory;
    }

    public File getRolesDirectory__() {
        return this.rolesDirectory;
    }

    public File getUsersDirectory__() {
        return this.usersDirectory;
    }

    @Nullable
    public File getTenantsDirectory__() {
        return this.tenantsDirectory;
    }

    public File getWebPubDirectory__() {
        return this.webPubDirectory;
    }

    public File getDocsRepositoryDirectory__() {
        return this.docsRepositoryDirectory;
    }

    public File getSchedulerDirectory__() {
        return this.schedulerDirectory;
    }

    public File getBackupDirectory__() {
        return this.backupDirectory;
    }

    @Nullable
    public File getMultiTenantDirectory__() {
        return this.multiTenantDirectory;
    }

    public OlapEngineDirectories asOlapEngineDirectories() {
        return new OlapEngineDirectories(this.tmpDirectory, this.cubesDirectory, this.schemaDataDirectory, this.offlineDirectory, this.pluginsDirectory);
    }
}

