/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.de.schlichtherle.license;

import crazydev.iccube.de.schlichtherle.license.CipherParam;
import crazydev.iccube.de.schlichtherle.license.IllegalPasswordException;
import crazydev.iccube.de.schlichtherle.license.LicenseContentException;
import crazydev.iccube.de.schlichtherle.license.LicenseCreator;
import crazydev.iccube.de.schlichtherle.license.LicenseNotary;
import crazydev.iccube.de.schlichtherle.license.LicenseParam;
import crazydev.iccube.de.schlichtherle.license.LicenseVerifier;
import crazydev.iccube.de.schlichtherle.license.NoLicenseInstalledException;
import crazydev.iccube.de.schlichtherle.license.Policy;
import crazydev.iccube.de.schlichtherle.license.PrivacyGuard;
import crazydev.iccube.de.schlichtherle.util.ObfuscatedString;
import crazydev.iccube.info.OlapLixContent;
import crazydev.iccube.mdx.parser.ast.expression.literal.MdxInfoLiteralExpression;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.prefs.Preferences;

public class LicenseManager
implements LicenseCreator,
LicenseVerifier {
    private static final String PREFERENCES_KEY = new ObfuscatedString(new long[]{-2999492566024573771L, -1728025856628382701L}).toString();
    public static final String LICENSE_SUFFIX = new ObfuscatedString(new long[]{-7559156485370438418L, 5084921010819724770L}).toString();
    private static final String PARAM;
    private static final String SUBJECT;
    private static final String KEY_STORE_PARAM;
    private static final String CIPHER_PARAM;
    private static final String EXC_INVALID_SUBJECT;
    private static final String EXC_INCONSISTENT;
    private static final String EXC_HOLDER_IS_NULL;
    private static final String EXC_ISSUED_IS_NULL;
    private static final String EXC_LICENSE_HAS_EXPIRED;
    private LicenseParam param;
    private LicenseNotary notary;
    private PrivacyGuard guard;
    private MdxInfoLiteralExpression certificate;
    private long certificateTime;

    protected LicenseManager() {
    }

    public LicenseManager(LicenseParam param) throws NullPointerException, IllegalPasswordException {
        this.setLicenseParam(param);
    }

    public LicenseParam getLicenseParam() {
        return this.param;
    }

    public synchronized void setLicenseParam(LicenseParam param) throws NullPointerException, IllegalPasswordException {
        if (param == null) {
            throw new NullPointerException(PARAM);
        }
        if (param.getSubject() == null) {
            throw new NullPointerException(SUBJECT);
        }
        if (param.getKeyStoreParam() == null) {
            throw new NullPointerException(KEY_STORE_PARAM);
        }
        CipherParam cipherParam = param.getCipherParam();
        if (cipherParam == null) {
            throw new NullPointerException(CIPHER_PARAM);
        }
        Policy.getCurrent().checkPwd(cipherParam.getKeyPwd());
        this.param = param;
        this.notary = null;
        this.certificate = null;
        this.certificateTime = 0L;
    }

    public final synchronized void store(OlapLixContent content, File keyFile) throws Exception {
        this.store(content, this.getLicenseNotary(), keyFile);
    }

    @Deprecated
    protected synchronized void store(OlapLixContent content, LicenseNotary notary, File keyFile) throws Exception {
        LicenseManager.storeLicenseKey(this.create(content, notary), keyFile);
    }

    @Override
    public final synchronized byte[] create(OlapLixContent content) throws Exception {
        return this.create(content, this.getLicenseNotary());
    }

    @Deprecated
    protected synchronized byte[] create(OlapLixContent content, LicenseNotary notary) throws Exception {
        this.initialize(content);
        this.validate(true, content);
        MdxInfoLiteralExpression certificate = notary.sign(content);
        byte[] key = this.getPrivacyGuard().cert2key(certificate);
        return key;
    }

    public final synchronized OlapLixContent install(File keyFile) throws Exception {
        return this.install(keyFile, this.getLicenseNotary());
    }

    @Deprecated
    protected synchronized OlapLixContent install(File keyFile, LicenseNotary notary) throws Exception {
        return this.install(LicenseManager.loadLicenseKey(keyFile), notary);
    }

    @Deprecated
    protected synchronized OlapLixContent install(byte[] key, LicenseNotary notary) throws Exception {
        MdxInfoLiteralExpression certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        OlapLixContent content = (OlapLixContent)certificate.getContent();
        this.validate(true, content);
        this.setLicenseKey(key);
        this.setCertificate(certificate);
        return content;
    }

    public final synchronized OlapLixContent verify(boolean assertValidityPeriod) throws Exception {
        return this.verify(assertValidityPeriod, this.getLicenseNotary());
    }

    @Deprecated
    protected synchronized OlapLixContent verify(boolean assertValidityPeriod, LicenseNotary notary) throws Exception {
        MdxInfoLiteralExpression certificate = this.getCertificate();
        if (certificate != null) {
            Object properties = certificate.getContent();
            return new OlapLixContent((Object[])properties);
        }
        byte[] key = this.getLicenseKey();
        if (key == null) {
            throw new NoLicenseInstalledException(this.getLicenseParam().getSubject());
        }
        certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        Object properties = certificate.getContent();
        OlapLixContent content = new OlapLixContent((Object[])properties);
        this.validate(assertValidityPeriod, content);
        if (assertValidityPeriod || !content.hasExpired()) {
            this.setCertificate(certificate);
        }
        return content;
    }

    @Override
    public final synchronized OlapLixContent verify(byte[] key) throws Exception {
        return this.verify(key, this.getLicenseNotary());
    }

    @Deprecated
    protected synchronized OlapLixContent verify(byte[] key, LicenseNotary notary) throws Exception {
        MdxInfoLiteralExpression certificate = this.getPrivacyGuard().key2cert(key);
        notary.verify(certificate);
        OlapLixContent content = (OlapLixContent)certificate.getContent();
        this.validate(true, content);
        return content;
    }

    public synchronized void uninstall() throws Exception {
        this.setLicenseKey(null);
        this.setCertificate(null);
    }

    protected synchronized void initialize(OlapLixContent content) {
    }

    public synchronized void validate(boolean assertValidityPeriod, OlapLixContent content) throws LicenseContentException {
        LicenseParam param = this.getLicenseParam();
        if (!param.getSubject().equals(content.getSubject())) {
            throw new LicenseContentException(EXC_INVALID_SUBJECT);
        }
        if (content.getUuid() == null) {
            throw new LicenseContentException(EXC_INCONSISTENT);
        }
        if (content.getHolderNameX() == null) {
            throw new LicenseContentException(EXC_HOLDER_IS_NULL);
        }
        if (content.getIssued() == null) {
            throw new LicenseContentException(EXC_ISSUED_IS_NULL);
        }
        if (assertValidityPeriod && content.hasExpired()) {
            throw new LicenseContentException(EXC_LICENSE_HAS_EXPIRED);
        }
    }

    @Deprecated
    protected MdxInfoLiteralExpression getCertificate() {
        return this.certificate;
    }

    @Deprecated
    protected synchronized void setCertificate(MdxInfoLiteralExpression certificate) {
        this.certificate = certificate;
        this.certificateTime = System.currentTimeMillis();
    }

    protected byte[] getLicenseKey() {
        return this.getLicenseParam().getPreferences().getByteArray(PREFERENCES_KEY, null);
    }

    @Deprecated
    protected synchronized void setLicenseKey(byte[] key) {
        Preferences prefs = this.getLicenseParam().getPreferences();
        if (key != null) {
            prefs.putByteArray(PREFERENCES_KEY, key);
        } else {
            prefs.remove(PREFERENCES_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void storeLicenseKey(byte[] key, File keyFile) throws IOException {
        FileOutputStream out = new FileOutputStream(keyFile);
        try {
            ((OutputStream)out).write(key);
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] loadLicenseKey(File keyFile) throws IOException {
        int size = Math.min((int)keyFile.length(), 0x100000);
        FileInputStream in = new FileInputStream(keyFile);
        byte[] b = new byte[size];
        try {
            ((InputStream)in).read(b);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
        return b;
    }

    protected synchronized LicenseNotary getLicenseNotary() {
        if (this.notary == null) {
            this.notary = new LicenseNotary(this.getLicenseParam().getKeyStoreParam());
        }
        return this.notary;
    }

    protected synchronized PrivacyGuard getPrivacyGuard() {
        if (this.guard == null) {
            this.guard = new PrivacyGuard(this.getLicenseParam().getCipherParam());
        }
        return this.guard;
    }

    static {
        assert (LICENSE_SUFFIX.equals(LICENSE_SUFFIX.toLowerCase()));
        PARAM = LicenseNotary.PARAM;
        SUBJECT = new ObfuscatedString(new long[]{-6788193907359448604L, -2787711522493615434L}).toString();
        KEY_STORE_PARAM = new ObfuscatedString(new long[]{4943981370588954830L, 8065447823433585419L, -2749528823549501332L}).toString();
        CIPHER_PARAM = new ObfuscatedString(new long[]{-3651048337721043740L, 1928803483347080380L, 1649789960289346230L}).toString();
        EXC_INVALID_SUBJECT = new ObfuscatedString(new long[]{-9211605111142713620L, 391714365510707393L, -7356761750428556372L, 6379560902598103028L}).toString();
        EXC_INCONSISTENT = new ObfuscatedString(new long[]{1328206493984398843L, 1254380135506349955L, 5126841155396962653L}).toString();
        EXC_HOLDER_IS_NULL = new ObfuscatedString(new long[]{7150026245468079143L, 6314884536402738366L, -1360923923476698800L}).toString();
        EXC_ISSUED_IS_NULL = new ObfuscatedString(new long[]{-6084371209004858580L, 3028840747031697166L, -3524637886726219307L}).toString();
        EXC_LICENSE_HAS_EXPIRED = new ObfuscatedString(new long[]{1000558500458715757L, -6998261911041258483L, -5490039629745846648L, 3561172928787106880L}).toString();
    }
}

