/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.contextual;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdErrorLocation;
import crazydev.common.property.CdProperty;
import crazydev.iccube.contextual.IOlapContextual;
import crazydev.iccube.exception.OlapErrorLocation;
import org.jetbrains.annotations.Nullable;

public class OlapContextualErrorLocation
extends OlapErrorLocation {
    private static final long serialVersionUID = 8176233790845099657L;
    private final transient IOlapContextual[] path;
    @Nullable
    private final transient CdProperty property;
    @Nullable
    private final transient CdErrorLocation propertyLocation;
    private final String[] xmlPath;

    public OlapContextualErrorLocation(IOlapContextual[] path, @Nullable CdProperty property, @Nullable CdErrorLocation propertyLocation) {
        this.path = path;
        this.property = property;
        this.propertyLocation = propertyLocation;
        this.xmlPath = new String[path.length];
        for (int idx = 0; idx < path.length; ++idx) {
            this.xmlPath[idx] = path[idx].getContextVisualId();
        }
    }

    public IOlapContextual[] getPath() {
        return this.path;
    }

    @Nullable
    public CdProperty getProperty() {
        return this.property;
    }

    @Nullable
    public CdErrorLocation getPropertyLocation() {
        return this.propertyLocation;
    }

    public String[] asXmlPath() {
        return this.xmlPath;
    }

    public String asString(CdBabylonService babylon) {
        StringBuilder builder = new StringBuilder();
        for (String s : this.xmlPath) {
            if (builder.length() > 0) {
                builder.append(".");
            }
            builder.append(s);
        }
        if (this.property != null) {
            if (this.xmlPath.length > 0) {
                builder.append(".");
            }
            builder.append(babylon.translatePropertyLabel(this.property.getName()));
        }
        if (this.propertyLocation != null) {
            builder.append(".").append(this.propertyLocation.asString(babylon));
        }
        return builder.toString();
    }
}

