/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.contextual;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.exception.CdErrorCode;
import crazydev.common.exception.CdErrorLocation;
import crazydev.iccube.contextual.OlapContextualErrorLocation;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

public abstract class OlapContextualError<CODE extends CdErrorCode>
extends CdError<OlapContextualErrorLocation, CODE> {
    private static final long serialVersionUID = -8003160696694601937L;
    @Nullable
    private final CdError embeddedError;

    public OlapContextualError(@Nullable CdError embeddedError, OlapContextualErrorLocation location, CODE code, Serializable ... params) {
        super((CdErrorLocation)location, code, params);
        this.embeddedError = embeddedError;
    }

    public String asMessage(CdBabylonService babylon) {
        String errorMessage = super.asMessage(babylon).trim();
        if (this.embeddedError == null) {
            return errorMessage;
        }
        String embeddedErrorMessage = this.embeddedError.asMessage(babylon);
        return (errorMessage.isEmpty() ? embeddedErrorMessage : errorMessage) + " : " + embeddedErrorMessage;
    }

    public String asFullMessage(CdBabylonService babylon) {
        if (this.embeddedError == null) {
            return super.asFullMessage(babylon);
        }
        return super.asFullMessage(babylon) + " : " + this.embeddedError.asFullMessage(babylon);
    }

    @Nullable
    public CdError getEmbeddedError() {
        return this.embeddedError;
    }

    public OlapContextualErrorLocation getLocation() {
        return (OlapContextualErrorLocation)super.getLocation();
    }

    @Nullable
    public CdErrorLocation getErrorRange() {
        if (this.embeddedError == null) {
            return null;
        }
        return this.embeddedError.getLocation();
    }
}

