/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.properties;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.locale.CdLanguageIdentifier;
import crazydev.common.utils.CdClassUtils;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorSetupMode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.properties.OlapBooleanPropertyDescription;
import crazydev.iccube.configuration.component.properties.OlapEnumPropertyDescription;
import crazydev.iccube.configuration.component.properties.OlapFilterProcessingMode;
import crazydev.iccube.configuration.component.properties.OlapIntegerPropertyDescription;
import crazydev.iccube.configuration.component.properties.OlapLambdaProcessingMode;
import crazydev.iccube.configuration.component.properties.OlapLongPropertyDescription;
import crazydev.iccube.configuration.component.properties.OlapMaskPropertyDescription;
import crazydev.iccube.configuration.component.properties.OlapProcessingFactsMode;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.configuration.component.properties.OlapPropertyAccessType;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescription;
import crazydev.iccube.configuration.component.properties.OlapStringPropertyDescription;
import crazydev.iccube.configuration.component.properties.OlapVisualMode;
import crazydev.iccube.olap.entity.properties.cell.OlapFormatStringSyntax;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheMode;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCacheMode;
import crazydev.iccube.olap.facts.column.aggregator.OlapAggregationSumAlgo;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class OlapPropertyDescriptions {
    public static final OlapIntegerPropertyDescription olapEngineSimultaneousRequestCount = new OlapIntegerPropertyDescription("olapEngineSimultaneousRequestCount", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "Maximum number of simultaneous requests within the MDX engine.";
        }
    };
    public static final OlapIntegerPropertyDescription activeMdxRequestCount = new OlapIntegerPropertyDescription("activeMdxRequestCount", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "( deprecated : see mdxEvalConfiguration ) Maximum number of active MDX requests.";
        }

        @Override
        public Integer getDefaultValue() {
            return 8;
        }
    };
    public static final OlapIntegerPropertyDescription singleMdxEvalThreadCount = new OlapIntegerPropertyDescription("singleMdxEvalThreadCount", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "( deprecated : see mdxEvalConfiguration ) Maximum number of threads for (single) MDX request evaluation (-1 means number of cores, 0 means sequential processing).";
        }

        @Override
        public Integer getDefaultValue() {
            return -1;
        }
    };
    public static final OlapIntegerPropertyDescription singleMdxEvalQueueSize = new OlapIntegerPropertyDescription("singleMdxEvalQueueSize", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "( deprecated : see mdxEvalConfiguration ) Maximum number of queued tasks for (single) MDX request evaluation.";
        }

        @Override
        public Integer getDefaultValue() {
            return 256;
        }
    };
    public static final OlapIntegerPropertyDescription singleMdxExtraEvalThreadCount = new OlapIntegerPropertyDescription("singleMdxExtraEvalThreadCount", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "( deprecated : see mdxEvalConfiguration ) Maximum number of threads for (single) MDX extra. request evaluation (-1 means number of cores, 0 means sequential processing).";
        }

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return -1;
        }
    };
    public static final OlapIntegerPropertyDescription singleMdxExtraEvalQueueSize = new OlapIntegerPropertyDescription("singleMdxExtraEvalQueueSize", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "( deprecated : see mdxEvalConfiguration ) Maximum number of queued tasks for (single) MDX extra. request evaluation.";
        }

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return 256;
        }
    };
    public static final OlapIntegerPropertyDescription activeLoadCount = new OlapIntegerPropertyDescription("activeLoadCount", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "Maximum number of active LOAD requests.";
        }
    };
    public static final OlapIntegerPropertyDescription loadReadingThreadCount = new OlapIntegerPropertyDescription("loadReadingThreadCount", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "Maximum number of threads for LOAD (reading part) request evaluation (-1 means number of cores, 0 means sequential processing).";
        }
    };
    public static final OlapIntegerPropertyDescription loadReadingQueueSize = new OlapIntegerPropertyDescription("loadReadingQueueSize", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "Maximum number of queued tasks for LOAD (reading) request processing.";
        }
    };
    public static final OlapIntegerPropertyDescription loadReadingRowBatch = new OlapIntegerPropertyDescription("loadReadingRowBatch", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "Number of rows processed by each LOAD request READING task.";
        }
    };
    public static final OlapIntegerPropertyDescription loadProcessingThreadCount = new OlapIntegerPropertyDescription("loadProcessingThreadCount", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "Maximum number of threads for LOAD (processing part) request evaluation (-1 means number of cores, 0 means sequential processing).";
        }
    };
    public static final OlapIntegerPropertyDescription loadProcessingQueueSize = new OlapIntegerPropertyDescription("loadProcessingQueueSize", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "Maximum number of queued tasks for LOAD (processing) request processing.";
        }
    };
    public static final OlapEnumPropertyDescription<OlapProcessingFactsMode> loadProcessingFactsMode = new OlapEnumPropertyDescription<OlapProcessingFactsMode>("loadProcessingFactsMode", OlapProcessingFactsMode.class, OlapPropertyAccessType.READ){

        @Override
        @Nullable
        public OlapProcessingFactsMode getDefaultValue() {
            return OlapProcessingFactsMode.FULL;
        }

        @Override
        public String getInfo() {
            return "Configuration that controls how the facts are built.";
        }
    };
    public static final OlapIntegerPropertyDescription factsResolveMemberLruCacheSize = new OlapIntegerPropertyDescription("factsResolveMemberLruCacheSize", OlapPropertyAccessType.READ){

        @Override
        public Integer getDefaultValue() {
            return 2048;
        }

        @Override
        public String getInfo() {
            return "Size of the LRU cache used to resolve members while processing the facts.";
        }
    };
    public static final OlapIntegerPropertyDescription dimMemBufferSize = new OlapIntegerPropertyDescription("dimMemBufferSize", OlapPropertyAccessType.READ){

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return 15;
        }

        @Override
        public String getInfo() {
            return "Buffer size (byte) of in-memory dimension.";
        }
    };
    public static final OlapIntegerPropertyDescription factMemBufferSize = new OlapIntegerPropertyDescription("factMemBufferSize", OlapPropertyAccessType.READ){

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return 15;
        }

        @Override
        public String getInfo() {
            return "Buffer size (byte) of in-memory facts.";
        }
    };
    public static final OlapIntegerPropertyDescription factFileSize = new OlapIntegerPropertyDescription("factFileSize", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "Maximum size (byte) of fact files.";
        }
    };
    public static final OlapIntegerPropertyDescription factFileBufferSize = new OlapIntegerPropertyDescription("factFileBufferSize", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "Buffer size (byte) of fact files.";
        }
    };
    public static final OlapIntegerPropertyDescription indexFileSize = new OlapIntegerPropertyDescription("indexFileSize", OlapPropertyAccessType.READ){

        @Override
        public Integer getDefaultValue() {
            return 28;
        }

        @Override
        public String getInfo() {
            return "Index file size in 32 bits integer count ( 2 ^ N ).";
        }
    };
    public static final OlapIntegerPropertyDescription indexFileBufferSize = new OlapIntegerPropertyDescription("indexFileBufferSize", OlapPropertyAccessType.READ){

        @Override
        public Integer getDefaultValue() {
            return 18;
        }

        @Override
        public String getInfo() {
            return "Index file buffer size in 32 bits integer count ( 2 ^ N ).";
        }
    };
    public static final OlapIntegerPropertyDescription indexBufferSize = new OlapIntegerPropertyDescription("indexBufferSize", OlapPropertyAccessType.READ){

        @Override
        public Integer getDefaultValue() {
            return 8;
        }

        @Override
        public String getInfo() {
            return "Index buffer size in 32 bits integer count ( 2 ^ N ).";
        }
    };
    public static final OlapLongPropertyDescription factsIndexFileSize = new OlapLongPropertyDescription("factsIndexFileSize", OlapPropertyAccessType.READ){

        @Override
        @Nullable
        public Long getDefaultValue() {
            return -1L;
        }

        @Override
        public String getInfo() {
            return "Index file size (-1: unlimited size).";
        }
    };
    public static final OlapIntegerPropertyDescription factsIndexFileBufferSize = new OlapIntegerPropertyDescription("factsIndexFileBufferSize", OlapPropertyAccessType.READ){

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return 0x100000;
        }

        @Override
        public String getInfo() {
            return "Index file buffer size.";
        }
    };
    public static final OlapIntegerPropertyDescription factsIndexBufferSize = new OlapIntegerPropertyDescription("factsIndexBufferSize", OlapPropertyAccessType.READ){

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return 1024;
        }

        @Override
        public String getInfo() {
            return "Index buffer size.";
        }
    };
    public static final OlapLongPropertyDescription factsColumnFileSize = new OlapLongPropertyDescription("factsColumnFileSize", OlapPropertyAccessType.READ){

        @Override
        @Nullable
        public Long getDefaultValue() {
            return -1L;
        }

        @Override
        public String getInfo() {
            return "Facts file size (-1: unlimited size).";
        }
    };
    public static final OlapIntegerPropertyDescription factsColumnFileBufferSize = new OlapIntegerPropertyDescription("factsColumnFileBufferSize", OlapPropertyAccessType.READ){

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return 0x100000;
        }

        @Override
        public String getInfo() {
            return "Facts file buffer size.";
        }
    };
    public static final OlapIntegerPropertyDescription factsColumnBufferSize = new OlapIntegerPropertyDescription("factsColumnBufferSize", OlapPropertyAccessType.READ){

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return 32768;
        }

        @Override
        public String getInfo() {
            return "Facts buffer size.";
        }
    };
    public static final OlapBooleanPropertyDescription cleanerActive = new OlapBooleanPropertyDescription("cleanerActive", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "(Windows only) facts file cleaner running in the background.";
        }
    };
    public static final OlapIntegerPropertyDescription cleanerDelay = new OlapIntegerPropertyDescription("cleanerDelay", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "(Windows only) determines the delay in seconds between each run.";
        }
    };
    public static final OlapIntegerPropertyDescription cleanerFileCount = new OlapIntegerPropertyDescription("cleanerFileCount", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "(Windows only) determines the maximum number of files being deleted during each run (-1 means no limit - all files available for deletion are tried).";
        }
    };
    public static final OlapIntegerPropertyDescription maxBufferSizeForCachingIterator = new OlapIntegerPropertyDescription("maxBufferSizeForCachingIterator", OlapPropertyAccessType.READ){

        @Override
        public String getInfo() {
            return "Maximum number of tuples being cached in MDX set iterators.";
        }
    };
    public static final OlapBooleanPropertyDescription duplicatedSolveOrderError = new OlapBooleanPropertyDescription("duplicatedSolveOrderError"){

        @Override
        public String getInfo() {
            return "When set to true, an error is generated when attempting to use calculated members with ambiguous SOLVE_ORDER definition.";
        }
    };
    public static final OlapBooleanPropertyDescription excelFixDotMembers = new OlapBooleanPropertyDescription("excelFixDotMembers"){

        @Override
        public String getInfo() {
            return "When set to true, MDX queries are possibly modified on the fly to fixed wrong Excel pivot table queries.";
        }
    };
    public static final OlapBooleanPropertyDescription excelFixFilterHelperSet = new OlapBooleanPropertyDescription("excelFixFilterHelperSet"){

        @Override
        public String getInfo() {
            return "When set to true, MDX queries are possibly modified on the fly to fixed wrong Excel pivot table queries.";
        }
    };
    public static final OlapBooleanPropertyDescription excelFixXsdLong = new OlapBooleanPropertyDescription("excelFixXsdLong"){

        @Override
        public String getInfo() {
            return "When set to true, cell value types are possibly considered as xsd:int instead of their native xsd:long type.";
        }
    };
    public static final OlapBooleanPropertyDescription mdxEvalUnknownMemberError = new OlapBooleanPropertyDescription("mdxEvalUnknownMemberError"){

        @Override
        public String getInfo() {
            return "When set to true, usage of unknown MDX entities is generating an error; otherwise a NULL value is used instead.";
        }
    };
    public static final OlapIntegerPropertyDescription toStrMaxSize = new OlapIntegerPropertyDescription("toStrMaxSize"){

        @Override
        public String getInfo() {
            return "The maximum length of a string generated by the MDX .StrToXyz() function; generate an error when the size is exceeded.";
        }
    };
    public static final OlapIntegerPropertyDescription calcMemberMaxEvaluationFrameStackSize = new OlapIntegerPropertyDescription("calcMemberMaxEvaluationFrameStackSize"){

        @Override
        public String getInfo() {
            return "The maximum number of calculated member nested calls (i.e., calc-member of calc-member of ...); allows for preventing infinite loop.";
        }
    };
    public static final OlapBooleanPropertyDescription calcMemberDefinedUniqueName = new OlapBooleanPropertyDescription("calcMemberDefinedUniqueName"){

        @Override
        public String getInfo() {
            return "When true, the unique name of the calc. measure/member is the full name used for its declaration (i.e., not internally generated).";
        }
    };
    public static final OlapIntegerPropertyDescription functionMaxEvaluationFrameStackSize = new OlapIntegerPropertyDescription("functionMaxEvaluationFrameStackSize"){

        @Override
        public String getInfo() {
            return "The maximum number of function (i.e., WITH FUNCTION) nested calls (i.e., f() calling g() calling h() calling ...); allows for preventing infinite loop.";
        }
    };
    public static final OlapEnumPropertyDescription<CdLanguageIdentifier> localeIdentifier = new OlapEnumPropertyDescription<CdLanguageIdentifier>("localeIdentifier", CdLanguageIdentifier.class){

        @Override
        public String getInfo() {
            return "Language/country identifier.";
        }

        @Override
        public OlapProperty<CdLanguageIdentifier> asPropertyFromString(String location, String value) throws OlapConfigurationException {
            try {
                return super.asPropertyFromString(location, value);
            }
            catch (OlapConfigurationException ex) {
                OlapLoggers.GENERAL.warn((Object)("Unsupported LocaleIdentifier [value:" + value + "] [error-location:" + location + "]"));
                return new OlapProperty<CdLanguageIdentifier>(this, CdLanguageIdentifier.Neutral);
            }
        }
    };
    public static final OlapEnumPropertyDescription<OlapVisualMode> visualMode = new OlapEnumPropertyDescription<OlapVisualMode>("visualMode", OlapVisualMode.class){

        @Override
        public String getInfo() {
            return "Whether or not the axes are evaluated as if VisualTotals was used. Possible values are : VISUAL_TOTAL, NON_VISUAL_TOTAL.";
        }
    };
    public static final OlapBooleanPropertyDescription visualTotalsIntermediateMembers = new OlapBooleanPropertyDescription("visualTotalsIntermediateMembers"){

        @Override
        public String getInfo() {
            return "This flag allows for controlling how not set intermediate members are handled in VisualTotals function.";
        }
    };
    public static final OlapEnumPropertyDescription<OlapResultCacheMode> resultCacheMode = new OlapEnumPropertyDescription<OlapResultCacheMode>("resultCacheMode", OlapResultCacheMode.class){

        @Override
        public String getInfo() {
            return "This flag activates the MDX request result cache and its mode (OFF, MEMORY, FILE).";
        }

        @Override
        @Nullable
        public OlapResultCacheMode getDefaultValue() {
            return OlapResultCacheMode.MEMORY;
        }
    };
    public static final OlapIntegerPropertyDescription resultCacheSize = new OlapIntegerPropertyDescription("resultCacheSize"){

        @Override
        public String getInfo() {
            return "MDX request result cache size (MB).";
        }

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return 16;
        }
    };
    public static final OlapStringPropertyDescription resultCachePolicy = new OlapStringPropertyDescription("resultCachePolicy"){

        @Override
        public String getInfo() {
            return "Determines when MDX requests can be cached.";
        }

        @Override
        @Nullable
        public String getDefaultValue() {
            return "crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheBufferedPolicy";
        }
    };
    public static final OlapIntegerPropertyDescription drillthroughDefaultMaxRows = new OlapIntegerPropertyDescription("drillthroughDefaultMaxRows"){

        @Override
        public String getInfo() {
            return "Maximum number of rows returned by a DRILLTHROUGH statement when its MAXROWS is not specified.";
        }
    };
    public static final OlapIntegerPropertyDescription selectCellMaxCount = new OlapIntegerPropertyDescription("selectCellMaxCount"){

        @Override
        public String getInfo() {
            return "( deprecated : see mdxEvalConfiguration ) Maximum number of cell returned by a SELECT statement.";
        }

        @Override
        public Integer getDefaultValue() {
            return -1;
        }
    };
    public static final OlapBooleanPropertyDescription compactSetInSubSelect = new OlapBooleanPropertyDescription("compactSetInSubSelect"){

        @Override
        public String getInfo() {
            return "When activated wraps each sub-select axis expression into a CompactSet function call.";
        }
    };
    public static final OlapBooleanPropertyDescription dimensionalityCheck = new OlapBooleanPropertyDescription("dimensionalityCheck"){

        @Override
        public String getInfo() {
            return "When activated checks that axis and calculated members do not define a tuple with two members of the same hierarchy (as in SaaS).";
        }

        @Override
        public Boolean getDefaultValue() {
            return true;
        }
    };
    public static final OlapBooleanPropertyDescription setDimensionalityCheck = new OlapBooleanPropertyDescription("setDimensionalityCheck"){

        @Override
        public String getInfo() {
            return "Experimental.";
        }

        @Override
        public Boolean getDefaultValue() {
            return true;
        }
    };
    public static final OlapEnumPropertyDescription<OlapFormatStringSyntax> defaultFormatStringSyntax = new OlapEnumPropertyDescription<OlapFormatStringSyntax>("defaultFormatStringSyntax", OlapFormatStringSyntax.class){

        @Override
        public String getInfo() {
            return "icCube supports both Excel and JAVA FORMAT_STRING syntax : this property defines the default syntax to use.";
        }

        @Override
        public OlapFormatStringSyntax getDefaultValue() {
            return OlapFormatStringSyntax.JAVA;
        }
    };
    public static final OlapIntegerPropertyDescription maxTablePartitionCount = new OlapIntegerPropertyDescription("maxTablePartitionCount"){

        @Override
        public String getInfo() {
            return "Maximum number of table partitions (-1 means no limit); a few number of partitions is typically expected.";
        }
    };
    public static final OlapIntegerPropertyDescription maxUnresolvedRowsCount = new OlapIntegerPropertyDescription("maxUnresolvedRowsCount"){

        @Override
        public String getInfo() {
            return "Maximum number of unresolved rows per facts table to keep in memory for processing during the next incremental load. If that maximum amount is reached an error is generated.";
        }
    };
    public static final OlapBooleanPropertyDescription mdxEvalFastNonEmptyAxis = new OlapBooleanPropertyDescription("mdxEvalFastNonEmptyAxis"){

        @Override
        public String getInfo() {
            return "Activate fast processing of NON EMPTY axes (defaulted to true).";
        }

        @Override
        public Boolean getDefaultValue() {
            return true;
        }
    };
    public static final OlapBooleanPropertyDescription mdxEvalMeasureVector = new OlapBooleanPropertyDescription("mdxEvalMeasureVector"){

        @Override
        public String getInfo() {
            return "Activate fast processing when several [Measures] are specified on an axis (defaulted to true).";
        }

        @Override
        public Boolean getDefaultValue() {
            return true;
        }
    };
    public static final OlapBooleanPropertyDescription mdxCrossjoinWithAttributes = new OlapBooleanPropertyDescription("mdxCrossjoinWithAttributes"){

        @Override
        public String getInfo() {
            return "Use attributes for fast crossjoin to improve performance";
        }

        @Override
        public Boolean getDefaultValue() {
            return true;
        }
    };
    public static final OlapIntegerPropertyDescription mdxEvalSetCalculatorMinSize = new OlapIntegerPropertyDescription("mdxEvalSetCalculatorMinSize"){

        @Override
        public String getInfo() {
            return "Minimum size of the set to activate fast set calculators in TopCount() like function.";
        }

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return -1;
        }
    };
    public static final OlapMaskPropertyDescription<OlapLambdaProcessingMode> mdxEvalLambdaProcessingMode = new OlapMaskPropertyDescription<OlapLambdaProcessingMode>("mdxEvalLambdaProcessingMode", OlapLambdaProcessingMode.class){

        @Override
        public String getInfo() {
            return "Activate lambda processing options (defaulted to : SET_CALC | PARALLEL_AXIS).";
        }

        @Override
        @Nullable
        public OlapLambdaProcessingMode getDefaultValue() {
            return new OlapLambdaProcessingMode(OlapLambdaProcessingMode.SET_CALC, OlapLambdaProcessingMode.PARALLEL_AXIS);
        }
    };
    public static final OlapEnumPropertyDescription<OlapFilterProcessingMode> mdxEvalFilterProcessingMode = new OlapEnumPropertyDescription<OlapFilterProcessingMode>("mdxEvalFilterProcessingMode", OlapFilterProcessingMode.class){

        @Override
        public String getInfo() {
            return "Define the type of evaluation of the Filer and NonEmpty function (LAMBDA, ITERATOR).";
        }

        @Override
        @Nullable
        public OlapFilterProcessingMode getDefaultValue() {
            return OlapFilterProcessingMode.ITERATOR;
        }
    };
    public static final OlapIntegerPropertyDescription mdxQueryCacheMax = new OlapIntegerPropertyDescription("mdxQueryCacheMax"){

        @Override
        public String getInfo() {
            return "Maximum number of tuples being cached during the processing of a MDX query.";
        }

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return 1000000;
        }
    };
    public static final OlapIntegerPropertyDescription mdxQueryCellCacheMax = new OlapIntegerPropertyDescription("mdxQueryCellCacheMax"){

        @Override
        public String getInfo() {
            return "Maximum number of tuples being cached during the processing of a cell of a MDX query.";
        }

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return 1000000;
        }
    };
    public static final OlapIntegerPropertyDescription mdxQueryCalcMemberCacheMax = new OlapIntegerPropertyDescription("mdxQueryCalcMemberCacheMax"){

        @Override
        public String getInfo() {
            return "Maximum number of calculated members being cached during the processing of a MDX query.";
        }

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return 1000000;
        }
    };
    public static final OlapEnumPropertyDescription<GFCalcTupleCacheMode> mdxQueryCalcMemberCacheMode = new OlapEnumPropertyDescription<GFCalcTupleCacheMode>("mdxQueryCalcMemberCacheMode", GFCalcTupleCacheMode.class){

        @Override
        public String getInfo() {
            return "Define the type of calculated member cache used during the processing of a MDX query (NONE, ALL, ON_DEMAND).";
        }

        @Override
        @Nullable
        public GFCalcTupleCacheMode getDefaultValue() {
            return GFCalcTupleCacheMode.ON_DEMAND;
        }
    };
    public static final OlapEnumPropertyDescription<OlapAggregationSumAlgo> mdxSumAlgo = new OlapEnumPropertyDescription<OlapAggregationSumAlgo>("mdxSumAlgo", OlapAggregationSumAlgo.class){

        @Override
        public String getInfo() {
            return "Define how double values are aggregated (aka. sum) to take into account rounding errors (STANDARD, NEUMAIER).";
        }

        @Override
        @Nullable
        public OlapAggregationSumAlgo getDefaultValue() {
            return OlapAggregationSumAlgo.STANDARD;
        }
    };
    public static final OlapEnumPropertyDescription<S_NonEmptyBehaviorSetupMode> nonEmptyBehaviorSetupMode = new OlapEnumPropertyDescription<S_NonEmptyBehaviorSetupMode>("nonEmptyBehaviorSetupMode", S_NonEmptyBehaviorSetupMode.class){

        @Override
        public String getInfo() {
            return "Define how the calculated member NON EMPTY BEHAVIOR setup (MANUAL, AUTO).";
        }

        @Override
        public S_NonEmptyBehaviorSetupMode getDefaultValue() {
            return S_NonEmptyBehaviorSetupMode.MANUAL;
        }
    };
    public static final OlapIntegerPropertyDescription pivotTableCellVectorFValueGviSize = new OlapIntegerPropertyDescription("pivotTableCellVectorFValueGviSize"){

        @Override
        public String getInfo() {
            return "This property defines the maximum number of vector items sent in the FORMATTED_VALUE of the pivot table cells (GVI).";
        }

        @Override
        @Nullable
        public Integer getDefaultValue() {
            return 128;
        }
    };
    public static final OlapStringPropertyDescription defaultHierarchyAllLevelName = new OlapStringPropertyDescription("defaultHierarchyAllLevelName"){

        @Override
        public String getInfo() {
            return "This property defines the default name of the hierarchy all level.";
        }

        @Override
        @Nullable
        public String getDefaultValue() {
            return "All-Level";
        }
    };
    public static final OlapStringPropertyDescription defaultHierarchyAllMemberName = new OlapStringPropertyDescription("defaultHierarchyAllMemberName"){

        @Override
        public String getInfo() {
            return "This property defines the default name of the hierarchy all member.";
        }

        @Override
        @Nullable
        public String getDefaultValue() {
            return "All";
        }
    };
    public static final OlapBooleanPropertyDescription dimensionCubeNameUnique = new OlapBooleanPropertyDescription("dimensionCubeNameUnique"){

        @Override
        public String getInfo() {
            return "This property defines whether a dimension name can be used as a cube name.";
        }

        @Override
        public Boolean getDefaultValue() {
            return true;
        }
    };
    public static final OlapIntegerPropertyDescription initialNonEmptyMaxRow = new OlapIntegerPropertyDescription("initialNonEmptyMaxRow"){

        @Override
        public String getInfo() {
            return "This property defines the number of non-empty evaluation for sets participating in non-empty crossjoin.";
        }

        @Override
        public Integer getDefaultValue() {
            return 100000;
        }
    };
    private static final Map<String, OlapPropertyDescription> descriptions = new HashMap<String, OlapPropertyDescription>();

    public static Collection<OlapPropertyDescription> getAllDescriptions() {
        return descriptions.values();
    }

    @Nullable
    public static OlapPropertyDescription getDescription(String name) {
        return descriptions.get(name);
    }

    static {
        List fields = CdClassUtils.getAllDeclaredStaticFields(OlapPropertyDescription.class, OlapPropertyDescriptions.class);
        for (Field field : fields) {
            try {
                if (descriptions.containsKey(field.getName())) {
                    throw new CdProgrammingException("Duplicated property description name [" + String.valueOf(field) + "]");
                }
                OlapPropertyDescription description = (OlapPropertyDescription)field.get(null);
                descriptions.put(description.getName(), description);
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace(System.err);
                throw new CdProgrammingException("Field [" + String.valueOf(field) + "] error!", (Throwable)ex);
            }
        }
    }
}

