/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.properties;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.common.locale.CdLanguageIdentifier;
import crazydev.common.utils.CdSystemUtils;
import crazydev.iccube.cluster.shared.schema.S_NonEmptyBehaviorSetupMode;
import crazydev.iccube.configuration.OlapConfigurationError;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.properties.OlapFilterProcessingMode;
import crazydev.iccube.configuration.component.properties.OlapLambdaProcessingMode;
import crazydev.iccube.configuration.component.properties.OlapProcessingFactsMode;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescription;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescriptions;
import crazydev.iccube.configuration.component.properties.OlapPropertyXmlAdapter;
import crazydev.iccube.configuration.component.properties.OlapVisualMode;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxAnnotation;
import crazydev.iccube.mdx.parser.ast.expression.annotation.MdxPropAnnotation;
import crazydev.iccube.olap.entity.properties.cell.OlapFormatStringSyntax;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheMode;
import crazydev.iccube.olap.eval.execinstr.gf.context.calccache.GFCalcTupleCacheMode;
import crazydev.iccube.olap.facts.column.aggregator.OlapAggregationSumAlgo;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement
public class OlapProperties {
    @XmlAnyElement
    @XmlJavaTypeAdapter(value=OlapPropertyXmlAdapter.class)
    protected final List<OlapProperty> properties = new ArrayList<OlapProperty>();
    @XmlTransient
    protected final IdentityHashMap<OlapPropertyDescription, OlapProperty> validatedProperties = new IdentityHashMap();

    public OlapProperties() {
        this(Collections.emptyList());
    }

    public OlapProperties(List<OlapProperty> properties) {
        for (OlapProperty property : properties) {
            this.add(property, false);
        }
        this.setupValidatedProperties();
    }

    public OlapProperties __copy() {
        OlapProperties clone = new OlapProperties();
        clone.properties.addAll(this.properties);
        clone.validatedProperties.putAll(this.validatedProperties);
        return clone;
    }

    public void validate() throws OlapConfigurationException {
        for (OlapProperty property : this.properties) {
            Object value = property.getValue();
            if (!(value instanceof OlapConfigurationError)) continue;
            OlapConfigurationError error = (OlapConfigurationError)((Object)value);
            throw new OlapConfigurationException(error);
        }
        for (OlapPropertyDescription description : OlapPropertyDescriptions.getAllDescriptions()) {
            List<OlapProperty> xproperties = this.getForValidation(description);
            if (xproperties.isEmpty() && description.getDefaultValue() == null) {
                OlapConfigurationError error = new OlapConfigurationError(OlapConfigurationErrorCode.PROPERTY_IS_MISSING, new Serializable[]{description.getName()});
                throw new OlapConfigurationException(error);
            }
            if (xproperties.size() <= 1) continue;
            OlapConfigurationError error = new OlapConfigurationError(OlapConfigurationErrorCode.PROPERTY_IS_DUPLICATED, new Serializable[]{description.getName()});
            throw new OlapConfigurationException(error);
        }
        this.setupValidatedProperties();
    }

    private void setupValidatedProperties() {
        for (OlapProperty property : this.properties) {
            this.validatedProperties.put(property.getDescription(), property);
        }
        for (OlapPropertyDescription description : OlapPropertyDescriptions.getAllDescriptions()) {
            Object defaultValue = description.getDefaultValue();
            if (defaultValue == null) continue;
            OlapProperty exitingValidatedProperty = null;
            for (OlapProperty validateProperty : this.validatedProperties.values()) {
                if (!validateProperty.getDescription().equals(description)) continue;
                exitingValidatedProperty = validateProperty;
                break;
            }
            if (exitingValidatedProperty != null) continue;
            exitingValidatedProperty = description.asProperty(defaultValue);
            this.validatedProperties.put(exitingValidatedProperty.getDescription(), exitingValidatedProperty);
        }
    }

    public OlapProperties override(@Nullable MdxAnnotation[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return this;
        }
        ArrayList<OlapProperty> annProperties = new ArrayList<OlapProperty>();
        for (MdxAnnotation annotation : annotations) {
            if (!(annotation instanceof MdxPropAnnotation)) continue;
            annProperties.add(((MdxPropAnnotation)annotation).getProperty());
        }
        return this.override(annProperties);
    }

    public OlapProperties override(@Nullable List<OlapProperty> properties) {
        if (properties == null || properties.isEmpty()) {
            return this;
        }
        OlapProperties xproperties = new OlapProperties(this.properties);
        for (OlapProperty property : properties) {
            xproperties.add(property, true);
        }
        xproperties.setupValidatedProperties();
        return xproperties;
    }

    public OlapProperties _nullify(OlapPropertyDescription<?> propertyDescription) throws OlapConfigurationException {
        OlapProperties xproperties = new OlapProperties();
        for (OlapProperty property : this.properties) {
            if (property.getDescription().equals(propertyDescription)) continue;
            xproperties.properties.add(property);
        }
        xproperties.validatedProperties.clear();
        xproperties.validate();
        return xproperties;
    }

    public int getOlapEngineSimultaneousRequestCount() {
        int value = this.getPropertyValue(OlapPropertyDescriptions.olapEngineSimultaneousRequestCount);
        if (value == -1) {
            value = Math.max(2, CdSystemUtils.availableProcessors());
        }
        return Math.max(1, value);
    }

    public int getActiveMdxRequestCount() {
        return this.getPropertyValue(OlapPropertyDescriptions.activeMdxRequestCount);
    }

    public int getSingleMdxEvalThreadCount() {
        int value = this.getPropertyValue(OlapPropertyDescriptions.singleMdxEvalThreadCount);
        if (value == -1) {
            value = CdSystemUtils.availableProcessors();
        }
        return value;
    }

    public int getSingleMdxEvalQueueSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.singleMdxEvalQueueSize);
    }

    public int getSingleMdxExtraEvalThreadCount() {
        int value = this.getPropertyValue(OlapPropertyDescriptions.singleMdxExtraEvalThreadCount);
        if (value == -1) {
            value = CdSystemUtils.availableProcessors();
        }
        return value;
    }

    public int getSingleMdxExtraEvalQueueSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.singleMdxExtraEvalQueueSize);
    }

    public int getActiveLoadCount() {
        return this.getPropertyValue(OlapPropertyDescriptions.activeLoadCount);
    }

    public int getLoadReadingThreadCount() {
        int value = this.getPropertyValue(OlapPropertyDescriptions.loadReadingThreadCount);
        if (value == -1) {
            value = CdSystemUtils.availableProcessors();
        }
        return value;
    }

    public int getLoadReadingQueueSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.loadReadingQueueSize);
    }

    public int getLoadReadingRowBatch() {
        return this.getPropertyValue(OlapPropertyDescriptions.loadReadingRowBatch);
    }

    public int getLoadProcessingThreadCount() {
        int value = this.getPropertyValue(OlapPropertyDescriptions.loadProcessingThreadCount);
        if (value == -1) {
            value = CdSystemUtils.availableProcessors();
        }
        return value;
    }

    public int getLoadProcessingQueueSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.loadProcessingQueueSize);
    }

    public OlapProcessingFactsMode getLoadProcessingFactsMode() {
        return this.getPropertyValue(OlapPropertyDescriptions.loadProcessingFactsMode);
    }

    public int getFactsResolveMemberLruCacheSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.factsResolveMemberLruCacheSize);
    }

    public int getDimMemBufferSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.dimMemBufferSize);
    }

    public int getFactMemBufferSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.factMemBufferSize);
    }

    public int getFactFileSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.factFileSize);
    }

    public int getFactFileBufferSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.factFileBufferSize);
    }

    public boolean isCleanerActive() {
        return this.getPropertyValue(OlapPropertyDescriptions.cleanerActive);
    }

    public int getCleanerDelay() {
        return this.getPropertyValue(OlapPropertyDescriptions.cleanerDelay);
    }

    public int getCleanerFileCount() {
        return this.getPropertyValue(OlapPropertyDescriptions.cleanerFileCount);
    }

    public int getMaxBufferSizeForCachingIterator() {
        return this.getPropertyValue(OlapPropertyDescriptions.maxBufferSizeForCachingIterator);
    }

    public boolean isExcelFixDotMembers() {
        return this.getPropertyValue(OlapPropertyDescriptions.excelFixDotMembers);
    }

    public boolean isExcelFixFilterHelperSet() {
        return this.getPropertyValue(OlapPropertyDescriptions.excelFixFilterHelperSet);
    }

    public boolean isExcelFixXsdLong() {
        return this.getPropertyValue(OlapPropertyDescriptions.excelFixXsdLong);
    }

    public boolean isMdxEvalUnknownMemberError() {
        return this.getPropertyValue(OlapPropertyDescriptions.mdxEvalUnknownMemberError);
    }

    public boolean isDuplicatedSolveOrderError() {
        return this.getPropertyValue(OlapPropertyDescriptions.duplicatedSolveOrderError);
    }

    public int getToStrMaxSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.toStrMaxSize);
    }

    public int getFunctionMaxEvaluationFrameStackSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.functionMaxEvaluationFrameStackSize);
    }

    public int getCalcMemberMaxEvaluationFrameStackSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.calcMemberMaxEvaluationFrameStackSize);
    }

    public boolean isCalcMemberDefinedUniqueName() {
        return this.getPropertyValue(OlapPropertyDescriptions.calcMemberDefinedUniqueName);
    }

    public CdLanguageIdentifier getLocaleIdentifier() {
        return this.getPropertyValue(OlapPropertyDescriptions.localeIdentifier);
    }

    public OlapVisualMode getVisualMode() {
        return this.getPropertyValue(OlapPropertyDescriptions.visualMode);
    }

    public boolean isVisualTotalsIntermediateMembers() {
        return this.getPropertyValue(OlapPropertyDescriptions.visualTotalsIntermediateMembers);
    }

    public OlapResultCacheMode getResultCacheMode() {
        return this.getPropertyValue(OlapPropertyDescriptions.resultCacheMode);
    }

    public int getResultCacheSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.resultCacheSize);
    }

    public String getResultCachePolicy() {
        return this.getPropertyValue(OlapPropertyDescriptions.resultCachePolicy);
    }

    public int getDrillthroughDefaultMaxRows() {
        return this.getPropertyValue(OlapPropertyDescriptions.drillthroughDefaultMaxRows);
    }

    public int getSelectCellMaxCount() {
        return this.getPropertyValue(OlapPropertyDescriptions.selectCellMaxCount);
    }

    public boolean isCompactSetInSubSelect() {
        return this.getPropertyValue(OlapPropertyDescriptions.compactSetInSubSelect);
    }

    public boolean isDimensionalityCheck() {
        return this.getPropertyValue(OlapPropertyDescriptions.dimensionalityCheck);
    }

    public boolean isSetDimensionalityCheck() {
        return this.getPropertyValue(OlapPropertyDescriptions.setDimensionalityCheck);
    }

    public OlapFormatStringSyntax getDefaultFormatStringSyntax() {
        return this.getPropertyValue(OlapPropertyDescriptions.defaultFormatStringSyntax);
    }

    public int getMaxTablePartitionCount() {
        return this.getPropertyValue(OlapPropertyDescriptions.maxTablePartitionCount);
    }

    public int getMaxUnresolvedRowsCount() {
        return this.getPropertyValue(OlapPropertyDescriptions.maxUnresolvedRowsCount);
    }

    public boolean isMdxEvalFastNonEmptyAxis() {
        return this.getPropertyValue(OlapPropertyDescriptions.mdxEvalFastNonEmptyAxis);
    }

    public boolean isMdxEvalMeasureVector() {
        return this.getPropertyValue(OlapPropertyDescriptions.mdxEvalMeasureVector);
    }

    public boolean isMdxCrossjoinWithAttributes() {
        return this.getPropertyValue(OlapPropertyDescriptions.mdxCrossjoinWithAttributes);
    }

    public int getMdxEvalSetCalculatorMinSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.mdxEvalSetCalculatorMinSize);
    }

    public OlapLambdaProcessingMode getMdxEvalLambdaProcessingMode() {
        return new OlapLambdaProcessingMode(this.getPropertyValue(OlapPropertyDescriptions.mdxEvalLambdaProcessingMode));
    }

    public OlapFilterProcessingMode getMdxEvalFilterProcessingMode() {
        return this.getPropertyValue(OlapPropertyDescriptions.mdxEvalFilterProcessingMode);
    }

    public int getMdxQueryCacheMax() {
        return this.getPropertyValue(OlapPropertyDescriptions.mdxQueryCacheMax);
    }

    public int getMdxQueryCellCacheMax() {
        return this.getPropertyValue(OlapPropertyDescriptions.mdxQueryCellCacheMax);
    }

    public int getMdxQueryCalcMemberCacheMax() {
        return this.getPropertyValue(OlapPropertyDescriptions.mdxQueryCalcMemberCacheMax);
    }

    public GFCalcTupleCacheMode getMdxQueryCalcMemberCacheMode() {
        return this.getPropertyValue(OlapPropertyDescriptions.mdxQueryCalcMemberCacheMode);
    }

    public OlapAggregationSumAlgo getMdxSumAlgo() {
        return this.getPropertyValue(OlapPropertyDescriptions.mdxSumAlgo);
    }

    public S_NonEmptyBehaviorSetupMode getNonEmptyBehaviorSetupMode() {
        return this.getPropertyValue(OlapPropertyDescriptions.nonEmptyBehaviorSetupMode);
    }

    public int getPivotTableCellVectorFValueGviSize() {
        return this.getPropertyValue(OlapPropertyDescriptions.pivotTableCellVectorFValueGviSize);
    }

    public String getDefaultHierarchyAllLevelName() {
        return this.getPropertyValue(OlapPropertyDescriptions.defaultHierarchyAllLevelName);
    }

    public String getDefaultHierarchyAllMemberName() {
        return this.getPropertyValue(OlapPropertyDescriptions.defaultHierarchyAllMemberName);
    }

    public Boolean isDimensionCubeNameUnique() {
        return this.getPropertyValue(OlapPropertyDescriptions.dimensionCubeNameUnique);
    }

    public int getInitialNonEmptyMaxRow() {
        return this.getPropertyValue(OlapPropertyDescriptions.initialNonEmptyMaxRow);
    }

    public Iterable<OlapProperty> getValidatedProperties() {
        return this.validatedProperties.values();
    }

    private <T> T getPropertyValue(OlapPropertyDescription<T> description) {
        OlapProperty property = this.get(description);
        if (property != null) {
            return property.getValue();
        }
        throw new CdProgrammingException("Missing property [" + description.getName() + "]!");
    }

    public <T> String getPropertyXmlaValueAsString(OlapPropertyDescription<T> description) {
        OlapProperty property = this.get(description);
        if (property != null) {
            return property.getXmlaValueAsString();
        }
        throw new CdProgrammingException("Missing property [" + description.getName() + "]!");
    }

    @Nullable
    private OlapProperty get(OlapPropertyDescription description) {
        OlapProperty property = this.validatedProperties.get(description);
        return property;
    }

    private List<OlapProperty> getForValidation(OlapPropertyDescription description) {
        ArrayList<OlapProperty> xproperties = new ArrayList<OlapProperty>();
        for (OlapProperty property : this.properties) {
            if (!property.getDescription().equals(description)) continue;
            xproperties.add(property);
        }
        return xproperties;
    }

    private void add(OlapProperty property, boolean tagAsOverridden) {
        if (property == null) {
            return;
        }
        for (int idx = 0; idx < this.properties.size(); ++idx) {
            OlapProperty xproperty = this.properties.get(idx);
            if (!xproperty.getDescription().equals(property.getDescription())) continue;
            this.properties.set(idx, this.override(property, tagAsOverridden));
            return;
        }
        this.properties.add(this.override(property, tagAsOverridden));
    }

    private OlapProperty override(OlapProperty property, boolean tagAsOverridden) {
        return tagAsOverridden ? property.asOverridden() : property;
    }
}

