/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.properties;

import crazydev.iccube.configuration.component.properties.OlapMask;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class OlapMaskHelper {
    private static final Map<Class, MetaInfo> allMetaInfos = new HashMap<Class, MetaInfo>();

    public static synchronized String toString(OlapMask value) {
        if (value == null) {
            return "null";
        }
        MetaInfo metaInfo = OlapMaskHelper.getOrCreateMetaInfo(value.getClass());
        int count = 0;
        for (Map.Entry<String, OlapMask> entry : metaInfo.fields.entrySet()) {
            OlapMask mask = entry.getValue();
            if (mask.mask() == 0 || !value.has(mask)) continue;
            ++count;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, OlapMask> entry : metaInfo.fields.entrySet()) {
            String name = entry.getKey();
            OlapMask mask = entry.getValue();
            if (!value.has(mask) || mask.mask() == 0 && count > 0) continue;
            if (sb.length() > 0) {
                sb.append(" | ");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    public static synchronized <T extends OlapMask<T>> T valueOf(Class<T> type, String value) {
        MetaInfo metaInfo = OlapMaskHelper.getOrCreateMetaInfo(type);
        if (value.trim().isEmpty()) {
            return (T)metaInfo.create(0);
        }
        try {
            int mask = Integer.parseInt(value);
            return (T)metaInfo.create(mask);
        }
        catch (NumberFormatException mask) {
            String[] bits = value.split("\\|");
            int mask2 = 0;
            for (String bit : bits) {
                String name = bit.trim();
                OlapMask fv = metaInfo.fields.get(name);
                if (fv == null) {
                    throw new IllegalArgumentException("unrecognized mask value " + value);
                }
                mask2 |= fv.mask();
            }
            return (T)metaInfo.create(mask2);
        }
    }

    private static <T extends OlapMask<T>> MetaInfo getOrCreateMetaInfo(Class<T> type) {
        MetaInfo metaInfo = allMetaInfos.get(type);
        if (metaInfo == null) {
            metaInfo = OlapMaskHelper.createMetaInfo(type);
            allMetaInfos.put(type, metaInfo);
        }
        return metaInfo;
    }

    private static <T extends OlapMask<T>> MetaInfo createMetaInfo(Class<T> type) {
        Constructor<T> ctor;
        HashMap<String, OlapMask> maskFields = new HashMap<String, OlapMask>();
        Field[] fields = type.getDeclaredFields();
        if (fields != null) {
            for (Field field : fields) {
                Class<?> ft = field.getType();
                if (!ft.equals(type)) continue;
                try {
                    field.setAccessible(true);
                    String fn = field.getName();
                    OlapMask fv = (OlapMask)field.get(null);
                    maskFields.put(fn, fv);
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException("internal error: mask class error", ex);
                }
            }
        }
        if (maskFields.isEmpty()) {
            throw new IllegalArgumentException("internal error: mask class error [" + type.getSimpleName() + "]");
        }
        try {
            ctor = type.getDeclaredConstructor(Integer.TYPE);
            ctor.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException("internal error: mask class error", ex);
        }
        return new MetaInfo(type, ctor, maskFields);
    }

    static class MetaInfo {
        final Class<?> clazz;
        final Constructor<?> ctor;
        final Map<String, OlapMask> fields;

        MetaInfo(Class<?> clazz, Constructor<?> ctor, Map<String, OlapMask> fields) {
            this.clazz = clazz;
            this.ctor = ctor;
            this.fields = fields;
        }

        OlapMask create(int mask) {
            try {
                return (OlapMask)this.ctor.newInstance(mask);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw new IllegalArgumentException("internal error: mask class error", ex);
            }
        }
    }
}

