/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.plugins.intializer;

import crazydev.iccube.authentication.OlapAuthenticationServiceClasses;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.plugins.OlapConfPlugin;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="authenticationService")
public class OlapConfAuthenticationServicePlugin
extends OlapConfPlugin {
    @XmlAttribute(name="className", required=true)
    private String className;
    @XmlTransient
    @Nullable
    private Class clazz;

    public OlapConfAuthenticationServicePlugin() {
    }

    public OlapConfAuthenticationServicePlugin(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public void setupAndValidate(@Nullable ClassLoader classLoader) throws OlapConfigurationException {
        if (this.className == null || this.className.trim().isEmpty()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.INVALID_JAVA_CLASS_NAME, new Serializable[]{"missing"});
        }
        try {
            this.clazz = classLoader == null ? Class.forName(this.className) : classLoader.loadClass(this.className);
        }
        catch (ClassNotFoundException ex) {
            OlapLoggers.BUILDER.error((Object)"initialization plugin validation error", (Throwable)ex);
            throw new OlapConfigurationException(OlapConfigurationErrorCode.INVALID_JAVA_CLASS_NAME, new Serializable[]{this.className, ex});
        }
    }

    @Nullable
    public Class<?> register(OlapAuthenticationServiceClasses repository) {
        if (this.clazz != null) {
            repository.add(this.clazz);
            return this.clazz;
        }
        return null;
    }
}

