/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.plugins.function;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.plugins.function.OlapConfFunctionPlugin;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.plugin.function.OlapPluginOneExprStatFunctions;
import crazydev.iccube.plugin.function.OlapPluginTwoExprStatFunctions;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="olapStatFunction")
public class OlapConfOlapStatFunctionPlugin
extends OlapConfFunctionPlugin {
    @XmlAttribute(name="mdxFunctionName", required=true)
    private String mdxFunctionName;
    @XmlAttribute(name="className", required=true)
    private String className;
    @XmlAttribute(name="overwriteExisting")
    private boolean overwriteExisting;
    @XmlAttribute(name="mdxFunctionDescription")
    private String mdxFunctionDescription;
    @XmlTransient
    private OlapPluginOneExprStatFunctions olapFunction1D;
    @XmlTransient
    private OlapPluginTwoExprStatFunctions olapFunction2D;

    public OlapConfOlapStatFunctionPlugin() {
    }

    public OlapConfOlapStatFunctionPlugin(String mdxFunctionName, String className, boolean overwriteExisting, String mdxFunctionDescription) {
        this.mdxFunctionName = mdxFunctionName;
        this.className = className;
        this.overwriteExisting = overwriteExisting;
        this.mdxFunctionDescription = mdxFunctionDescription;
    }

    @Override
    public void setupAndValidate(@Nullable ClassLoader classLoader) throws OlapConfigurationException {
        block8: {
            Class<?> function;
            try {
                function = classLoader == null ? Class.forName(this.className) : classLoader.loadClass(this.className);
            }
            catch (ClassNotFoundException ex) {
                OlapLoggers.BUILDER.error((Object)"MDX stats function plugin validation error", (Throwable)ex);
                throw new OlapConfigurationException(OlapConfigurationErrorCode.INVALID_JAVA_CLASS_NAME, new Serializable[]{this.className, ex});
            }
            String string = this.mdxFunctionDescription = this.mdxFunctionDescription == null ? "" : this.mdxFunctionDescription;
            if (this.mdxFunctionName == null || this.mdxFunctionName.trim().isEmpty()) {
                throw new OlapConfigurationException(OlapConfigurationErrorCode.REP_EMPTY_MDX_FUNCTION_NAME, new Serializable[]{this.mdxFunctionName});
            }
            try {
                if (OlapPluginTwoExprStatFunctions.class.isAssignableFrom(function)) {
                    this.olapFunction2D = (OlapPluginTwoExprStatFunctions)function.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break block8;
                }
                if (OlapPluginOneExprStatFunctions.class.isAssignableFrom(function)) {
                    this.olapFunction1D = (OlapPluginOneExprStatFunctions)function.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    break block8;
                }
                String expected = OlapPluginOneExprStatFunctions.class.getName() + " or " + OlapPluginTwoExprStatFunctions.class.getName();
                throw new OlapConfigurationException(OlapConfigurationErrorCode.CLASS_NOT_EXTENDING_OTHER_CLASS, new Serializable[]{this.className, expected});
            }
            catch (InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                OlapLoggers.BUILDER.error((Object)"MDX stats function plugin validation error", (Throwable)ex);
                throw new OlapConfigurationException(OlapConfigurationErrorCode.CLASS_FAILED_ON_EMPTY_CONSTRUCTOR, new Serializable[]{this.className, ex});
            }
            catch (IllegalAccessException ex) {
                OlapLoggers.BUILDER.error((Object)"MDX stats function plugin validation error", (Throwable)ex);
                throw new OlapConfigurationException(OlapConfigurationErrorCode.CLASS_CONSTRUCTOR_ILLEGAL_ACCESS, new Serializable[]{this.className, ex});
            }
        }
    }

    @Override
    public List<OlapFunction> register(OlapFunctionRepository repository) throws OlapConfigurationException {
        ArrayList<OlapFunction> functions = new ArrayList<OlapFunction>();
        if (this.olapFunction1D != null) {
            OlapFunction function = repository.registerOlapStatUserFunction(this.mdxFunctionName, this.olapFunction1D, this.overwriteExisting, this.mdxFunctionDescription);
            functions.add(function);
        } else if (this.olapFunction2D != null) {
            OlapFunction function = repository.registerOlapStatUserFunction(this.mdxFunctionName, this.olapFunction2D, this.overwriteExisting, this.mdxFunctionDescription);
            functions.add(function);
        } else {
            throw new CdProgrammingException("Missing setupAndValidate()");
        }
        return functions;
    }

    public String getMdxFunctionName() {
        return this.mdxFunctionName;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isOverwriteExisting() {
        return this.overwriteExisting;
    }

    public String getMdxFunctionDescription() {
        return this.mdxFunctionDescription;
    }
}

