/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.plugins.function;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.plugins.OlapConfPlugin;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregator;
import crazydev.iccube.olap.eval.facts.aggregation.table.IOlapFactTableAggregatorFactory;
import crazydev.iccube.olap.eval.facts.aggregation.table.OlapTableAggregatorRepository;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="tableAggregator")
public class OlapConfJavaTableAgrregatorPlugin
extends OlapConfPlugin {
    @XmlAttribute(name="name")
    private String name;
    @XmlAttribute(name="className", required=true)
    private String className;
    @XmlTransient
    private IOlapFactTableAggregatorFactory factory;

    @Override
    public void setupAndValidate(@Nullable ClassLoader classLoader) throws OlapConfigurationException {
        block4: {
            try {
                Class<?> functionContainerClass = classLoader == null ? Class.forName(this.className) : classLoader.loadClass(this.className);
                Constructor<?> declaredConstructor = functionContainerClass.getDeclaredConstructor(new Class[0]);
                Object instance = declaredConstructor.newInstance(new Object[0]);
                if (instance instanceof IOlapFactTableAggregatorFactory) {
                    this.factory = (IOlapFactTableAggregatorFactory)instance;
                    break block4;
                }
                if (instance instanceof IOlapFactTableAggregator) {
                    this.factory = () -> {
                        try {
                            return (IOlapFactTableAggregator)declaredConstructor.newInstance(new Object[0]);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    };
                    break block4;
                }
                OlapLoggers.BUILDER.error((Object)"Java function plugin validation error");
                throw new OlapConfigurationException(OlapConfigurationErrorCode.INVALID_JAVA_CLASS_NAME, new Serializable[]{this.className});
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                OlapLoggers.BUILDER.error((Object)"Java function plugin validation error", (Throwable)ex);
                throw new OlapConfigurationException(OlapConfigurationErrorCode.INVALID_JAVA_CLASS_NAME, new Serializable[]{this.className, ex});
            }
        }
    }

    public void register(OlapTableAggregatorRepository repository) throws OlapConfigurationException {
        repository.register(this.name, this.factory);
    }

    public String getUxInfo() {
        if (this.factory == null) {
            return this.name + " NO FACTORY (" + this.className + ")";
        }
        IOlapFactTableAggregator factory = this.factory.newInstance();
        String uxInfo = factory.getUxInfo();
        return this.name + ", " + uxInfo + " (" + this.className + ")";
    }
}

