/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.plugins.function;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.plugins.function.OlapConfFunctionPlugin;
import crazydev.iccube.olap.eval.function.OlapFunction;
import crazydev.iccube.olap.eval.function.OlapFunctionRepository;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="javaFunctions")
public class OlapConfJavaFunctionsPlugin
extends OlapConfFunctionPlugin {
    @XmlAttribute(name="moduleName")
    private String moduleName = "";
    @XmlAttribute(name="className", required=true)
    private String className;
    @XmlAttribute(name="overwriteMain")
    private boolean overwriteMain = false;
    @XmlAttribute(name="overwriteModule")
    private boolean overwriteModule = true;
    @XmlTransient
    private Class functionContainerClass;

    public OlapConfJavaFunctionsPlugin() {
    }

    public OlapConfJavaFunctionsPlugin(String moduleName, String className, boolean overwriteMain, boolean overwriteModule) {
        this.moduleName = moduleName;
        this.className = className;
        this.overwriteMain = overwriteMain;
        this.overwriteModule = overwriteModule;
    }

    @Override
    public void setupAndValidate(@Nullable ClassLoader classLoader) throws OlapConfigurationException {
        try {
            this.functionContainerClass = classLoader == null ? Class.forName(this.className) : classLoader.loadClass(this.className);
        }
        catch (ClassNotFoundException ex) {
            OlapLoggers.BUILDER.error((Object)"Java function plugin validation error", (Throwable)ex);
            throw new OlapConfigurationException(OlapConfigurationErrorCode.INVALID_JAVA_CLASS_NAME, new Serializable[]{this.className, ex});
        }
    }

    @Override
    public List<OlapFunction> register(OlapFunctionRepository repository) throws OlapConfigurationException {
        return repository.registerJavaUserFunctions(this.moduleName, this.functionContainerClass, this.overwriteMain, this.overwriteModule);
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getClassName() {
        return this.className;
    }

    public boolean isOverwriteMain() {
        return this.overwriteMain;
    }

    public boolean isOverwriteModule() {
        return this.overwriteModule;
    }
}

