/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component.plugins.builder;

import crazydev.common.exception.programming.CdProgrammingException;
import crazydev.iccube.builder.OlapBuilderMetaInformationRepository;
import crazydev.iccube.builder.errors.OlapBuilderErrorException;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.plugins.OlapConfPlugin;
import crazydev.iccube.olap.loggers.OlapLoggers;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="builder")
public class OlapConfBuilderPlugin
extends OlapConfPlugin {
    @XmlAttribute(name="className", required=true)
    private String className;
    @XmlTransient
    @Nullable
    private Class clazz;

    public OlapConfBuilderPlugin() {
    }

    public OlapConfBuilderPlugin(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public void setupAndValidate(@Nullable ClassLoader classLoader) throws OlapConfigurationException {
        if (this.className == null || this.className.trim().isEmpty()) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.INVALID_JAVA_CLASS_NAME, new Serializable[]{"missing"});
        }
        try {
            this.clazz = classLoader == null ? Class.forName(this.className) : classLoader.loadClass(this.className);
        }
        catch (ClassNotFoundException ex) {
            OlapLoggers.BUILDER.error((Object)"builder plugin validation error", (Throwable)ex);
            throw new OlapConfigurationException(OlapConfigurationErrorCode.INVALID_JAVA_CLASS_NAME, new Serializable[]{this.className, ex});
        }
    }

    public Class register(OlapBuilderMetaInformationRepository builderMetaInformationRepository) throws OlapBuilderErrorException {
        Class myClass = this.clazz;
        if (myClass != null) {
            builderMetaInformationRepository.register(true, myClass);
            return myClass;
        }
        throw new CdProgrammingException("Forgot setupAndValidate ?");
    }
}

