/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.OlapUserDefinedProperty;
import crazydev.iccube.runtime.OlapRuntime;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlRootElement(name="userDefinedProperties")
public class OlapUserDefinedProperties {
    @XmlElement(name="property", required=false)
    @Nullable
    private List<OlapUserDefinedProperty> properties;
    @XmlTransient
    private boolean preValidated;

    public OlapUserDefinedProperties() {
    }

    public OlapUserDefinedProperties(List<OlapUserDefinedProperty> properties) {
        this.properties = properties;
    }

    public void validate(OlapRuntime runtime) throws OlapConfigurationException {
        if (!this.preValidated) {
            this.preValidated = true;
        }
    }

    public List<OlapUserDefinedProperty> getProperties() {
        return this.properties == null ? Collections.emptyList() : this.properties;
    }

    @Nullable
    public String getProperty(String name) {
        if (this.properties != null) {
            for (OlapUserDefinedProperty property : this.properties) {
                if (!name.equals(property.getName())) continue;
                return property.getValue();
            }
        }
        return null;
    }

    public int getIntProperty(String name, int defaultValue) {
        String val = this.getProperty(name);
        if (CdStringUtils.isNullOrBlank((String)val)) {
            return defaultValue;
        }
        return Integer.parseInt(val);
    }
}

