/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.OlapEngineResultCachePolicyConfiguration;
import crazydev.iccube.olap.eval.cache.result.cache.IOlapResultCachePolicy;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheMode;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="resultCacheConfiguration")
public class OlapEngineResultCacheConfiguration {
    @XmlElement(name="mode", required=true)
    private OlapResultCacheMode mode;
    @XmlElement(name="size", required=true)
    private int size;
    @XmlElement(name="gvi", required=true)
    private boolean gvi;
    @XmlElement(name="xmla", required=true)
    private boolean xmla;
    @XmlElement(name="rest_api", required=false)
    private Boolean restApi;
    @XmlElement(name="alerts", required=false)
    @Nullable
    private Boolean alerts;
    @XmlElement(name="cachingPolicy", required=true)
    private OlapEngineResultCachePolicyConfiguration cachingPolicyConfiguration;
    @XmlTransient
    private IOlapResultCachePolicy cachingPolicy;

    public OlapEngineResultCacheConfiguration() {
    }

    public OlapEngineResultCacheConfiguration(OlapResultCacheMode mode) {
        this.mode = mode;
    }

    public OlapEngineResultCacheConfiguration(OlapResultCacheMode mode, int size, boolean gvi, boolean xmla, boolean alerts, OlapEngineResultCachePolicyConfiguration cachingPolicyConfiguration) {
        this.mode = mode;
        this.size = size;
        this.gvi = gvi;
        this.xmla = xmla;
        this.alerts = alerts;
        this.cachingPolicyConfiguration = cachingPolicyConfiguration;
    }

    public void validate() throws OlapConfigurationException {
        if (this.mode == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"Result cache mode"});
        }
        if (this.mode == OlapResultCacheMode.OFF) {
            return;
        }
        if (this.size == 0) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"Result cache size"});
        }
        if (this.cachingPolicyConfiguration == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"Result cache cachingPolicyConfiguration"});
        }
        this.cachingPolicyConfiguration.validate();
        try {
            Class<?> clazz = Class.forName(this.cachingPolicyConfiguration.getClazz());
            this.cachingPolicy = (IOlapResultCachePolicy)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.cachingPolicy.configure(this.cachingPolicyConfiguration.createServiceConfiguration());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException ex) {
            throw new OlapConfigurationException((Throwable)ex, OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"result cache caching policy setup error"});
        }
    }

    public OlapResultCacheMode getMode() {
        return this.mode;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isGvi() {
        return this.gvi;
    }

    public boolean isXmla() {
        return this.xmla;
    }

    public boolean isRestApi() {
        return this.restApi == null || this.restApi != false;
    }

    public boolean isAlerts() {
        return this.alerts != null && this.alerts != false;
    }

    public IOlapResultCachePolicy getCachingPolicy() {
        return this.cachingPolicy;
    }
}

