/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component;

import crazydev.common.utils.CdStringUtils;
import crazydev.common.utils.CdSystemUtils;
import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalProfileForkMode;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="profile")
public class OlapEngineMdxEvalProfile {
    private static final int DEFAULT_materializedSetTupleCount = 10000000;
    private static final int DEFAULT_tidyMaterializedAxisTupleCount = 1000000;
    public static final int DEFAULT_internalTupleListCount = 10000000;
    public static final int DEFAULT_internalTupleListCountCJ = 10000000;
    private static final int DEFAULT_tidyRowCount = 1000000;
    private static final int DEFAULT_tidyColumnCount = 1000;
    private static final int DEFAULT_tidyCellCount = 1000000;
    private static final int DEFAULT_tidyCellCountNE = 10000000;
    private static final int DEFAULT_neCjIndexCacheLimit = 0;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="forkMode", required=true)
    private OlapEngineMdxEvalProfileForkMode forkMode;
    @XmlAttribute(name="default", required=false)
    private boolean isDefault;
    @XmlElement(name="activeMdxRequestCount", required=false)
    private Integer activeMdxRequestCount;
    @XmlElement(name="materializedSetTupleCount", required=false)
    @Nullable
    private Integer materializedSetTupleCount;
    @XmlElement(name="tidyMaterializedAxisTupleCount", required=false)
    @Nullable
    private Integer tidyMaterializedAxisTupleCount;
    @XmlElement(name="internalTupleListCount", required=false)
    @Nullable
    private Integer internalTupleListCount;
    @XmlElement(name="internalTupleListCountCJ", required=false)
    @Nullable
    private Integer internalTupleListCountCJ;
    @XmlElement(name="tidyRowCount", required=false)
    @Nullable
    private Integer tidyRowCount;
    @XmlElement(name="tidyColumnCount", required=false)
    @Nullable
    private Integer tidyColumnCount;
    @XmlElement(name="tidyCellCount", required=false)
    @Nullable
    private Integer tidyCellCount;
    @XmlElement(name="tidyCellCountNE", required=false)
    @Nullable
    private Integer tidyCellCountNE;
    @XmlElement(name="cellCount", required=true)
    private int cellCount;
    @XmlElement(name="timeout", required=true)
    private int timeoutS;
    @XmlElement(name="threadCount", required=true)
    private int threadCount;
    @XmlElement(name="queueSize", required=true)
    private int queueSize;
    @XmlElement(name="extraThreadCount", required=true)
    private int extraThreadCount;
    @XmlElement(name="extraQueueSize", required=true)
    private int extraQueueSize;
    @XmlElement(name="neCjIndexCacheLimit", required=false)
    @Nullable
    private Integer neCjIndexCacheLimit;
    @XmlElement(name="neCjThreadCount", required=false)
    @Nullable
    private Integer neCjThreadCount;
    @XmlElement(name="neCjMaxPreCalculated", required=false)
    @Nullable
    private Integer neCjMaxPreCalculated;
    @XmlElement(name="neCjMaxPreCalculatedTuples", required=false)
    @Nullable
    private Integer neCjMaxPreCalculatedTuples;
    @XmlElement(name="neCjAsyncActivated", required=false)
    @Nullable
    private Boolean neCjAsyncActivated;
    @XmlElement(name="neCjParallelActivated", required=false)
    @Nullable
    private Boolean neCjParallelActivated;

    public OlapEngineMdxEvalProfile() {
    }

    public OlapEngineMdxEvalProfile(String name, OlapEngineMdxEvalProfileForkMode forkMode, boolean isDefault, int activeMdxRequestCount, int cellCount, int timeoutS, int threadCount, int queueSize, int extraThreadCount, int extraQueueSize) {
        this.name = name;
        this.forkMode = forkMode;
        this.isDefault = isDefault;
        this.activeMdxRequestCount = activeMdxRequestCount;
        this.cellCount = cellCount;
        this.timeoutS = timeoutS;
        this.threadCount = threadCount;
        this.queueSize = queueSize;
        this.extraThreadCount = extraThreadCount;
        this.extraQueueSize = extraQueueSize;
    }

    public void validate() throws OlapConfigurationException {
        if (CdStringUtils.isNullOrBlank((String)this.name)) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"mdxEvalConfiguration.profile.name"});
        }
        if (this.forkMode == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"mdxEvalConfiguration.profile.forkMode"});
        }
        if (this.queueSize == 0) {
            this.queueSize = 256;
        }
        if (this.extraQueueSize == 0) {
            this.extraQueueSize = 256;
        }
        if (this.materializedSetTupleCount == null) {
            this.materializedSetTupleCount = 10000000;
        }
        if (this.tidyMaterializedAxisTupleCount == null) {
            this.tidyMaterializedAxisTupleCount = 1000000;
        }
        if (this.internalTupleListCount == null) {
            this.internalTupleListCount = 10000000;
        }
        if (this.internalTupleListCountCJ == null) {
            this.internalTupleListCountCJ = 10000000;
        }
        if (this.tidyRowCount == null) {
            this.tidyRowCount = 1000000;
        }
        if (this.tidyColumnCount == null) {
            this.tidyColumnCount = 1000;
        }
        if (this.tidyCellCount == null) {
            this.tidyCellCount = 1000000;
        }
        if (this.tidyCellCountNE == null) {
            this.tidyCellCountNE = 10000000;
        }
        if (this.tidyCellCount < this.tidyRowCount) {
            throw new RuntimeException("[icCube.xml] tidyCellCount (" + this.tidyCellCount + ") cannot be lower than tidyRowCount (" + this.tidyRowCount + ")");
        }
        if (this.tidyCellCount < this.tidyColumnCount) {
            throw new RuntimeException("[icCube.xml] tidyCellCount (" + this.tidyCellCount + ") cannot be lower than tidyColumnCount (" + this.tidyColumnCount + ")");
        }
        if (this.tidyCellCountNE < this.tidyRowCount) {
            throw new RuntimeException("[icCube.xml] tidyCellCountNE (" + this.tidyCellCountNE + ") cannot be lower than tidyRowCount (" + this.tidyRowCount + ")");
        }
        if (this.tidyCellCountNE < this.tidyColumnCount) {
            throw new RuntimeException("[icCube.xml] tidyCellCountNE (" + this.tidyCellCountNE + ") cannot be lower than tidyColumnCount (" + this.tidyColumnCount + ")");
        }
        if (this.neCjIndexCacheLimit == null) {
            this.neCjIndexCacheLimit = 0;
        }
    }

    public String getName() {
        return this.name;
    }

    public OlapEngineMdxEvalProfileForkMode getForkMode() {
        return this.forkMode;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public int getActiveMdxRequestCount() {
        return this.activeMdxRequestCount == null ? 0 : this.activeMdxRequestCount;
    }

    public int getCellCount() {
        return this.cellCount;
    }

    public int getInternalTupleListCount() {
        return Objects.requireNonNullElse(this.internalTupleListCount, 10000000);
    }

    public int getInternalTupleListCountCJ() {
        return Objects.requireNonNullElse(this.internalTupleListCountCJ, 10000000);
    }

    public int getTidyRowCount() {
        return Objects.requireNonNullElse(this.tidyRowCount, 1000000);
    }

    public int getTidyColumnCount() {
        return Objects.requireNonNullElse(this.tidyColumnCount, 1000);
    }

    public int getMaterializedSetTupleCount() {
        return Objects.requireNonNullElse(this.materializedSetTupleCount, 10000000);
    }

    public int getTidyMaterializedAxisTupleCount() {
        return Objects.requireNonNullElse(this.tidyMaterializedAxisTupleCount, 1000000);
    }

    public int getTidyCellCount() {
        return Objects.requireNonNullElse(this.tidyCellCount, 1000000);
    }

    public int getTidyCellCountNE() {
        return Objects.requireNonNullElse(this.tidyCellCountNE, 10000000);
    }

    public int getNeCjIndexCacheLimit() {
        return Objects.requireNonNullElse(this.neCjIndexCacheLimit, 0);
    }

    public int getNeCjThreadCount() {
        if (this.neCjThreadCount == null || this.neCjThreadCount == -1) {
            return CdSystemUtils.availableProcessors();
        }
        if (this.neCjThreadCount == 0) {
            return 1;
        }
        return this.neCjThreadCount;
    }

    public int getNeCjMaxPreCalculated() {
        if (this.neCjMaxPreCalculated == null || this.neCjMaxPreCalculated == -1) {
            return this.getNeCjThreadCount() * 10;
        }
        if (this.neCjMaxPreCalculated == 0) {
            return 10;
        }
        return this.neCjMaxPreCalculated;
    }

    public int getNeCjMaxPreCalculatedTuples() {
        if (this.neCjMaxPreCalculatedTuples == null || this.neCjMaxPreCalculatedTuples == -1) {
            return 100;
        }
        if (this.neCjMaxPreCalculatedTuples == 0) {
            return 100;
        }
        return this.neCjMaxPreCalculatedTuples;
    }

    public boolean isNeCjAsyncActivated() {
        return Objects.requireNonNullElse(this.neCjAsyncActivated, true);
    }

    public boolean isNeCjParallelActivated() {
        return Objects.requireNonNullElse(this.neCjParallelActivated, true);
    }

    public int getTimeoutS() {
        return this.timeoutS;
    }

    public int getCellThreadCount() {
        int value = this.threadCount;
        if (value == -1) {
            value = CdSystemUtils.availableProcessors();
        }
        return value;
    }

    public int getCellQueueSize() {
        return this.queueSize;
    }

    public int getExtraThreadCount() {
        int value = this.extraThreadCount;
        if (value == -1) {
            value = CdSystemUtils.availableProcessors();
        }
        return value;
    }

    public int getExtraQueueSize() {
        return this.extraQueueSize;
    }

    public String toString() {
        return this.name + " / " + String.valueOf((Object)this.forkMode);
    }
}

