/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration.component;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import crazydev.iccube.configuration.component.OlapEngineBackupConfiguration;
import crazydev.iccube.configuration.component.OlapEngineJavaMdxConfiguration;
import crazydev.iccube.configuration.component.OlapEngineJavaMdxNativeConfiguration;
import crazydev.iccube.configuration.component.OlapEngineJavaViewConfiguration;
import crazydev.iccube.configuration.component.OlapEngineMdxEvalConfiguration;
import crazydev.iccube.configuration.component.OlapEngineResultCacheConfiguration;
import crazydev.iccube.configuration.component.OlapEngineResultCachePolicyConfiguration;
import crazydev.iccube.configuration.component.OlapEngineResultSerializationConfiguration;
import crazydev.iccube.configuration.component.OlapUserDefinedProperties;
import crazydev.iccube.configuration.component.properties.OlapProperties;
import crazydev.iccube.configuration.component.properties.OlapProperty;
import crazydev.iccube.configuration.component.properties.OlapPropertyDescription;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapSerializedTidyResourceCompression;
import crazydev.iccube.olap.entity.result.tidy.serialize.OlapSerializedTidyResourceMode;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheBufferedPolicy;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheImmediatePolicy;
import crazydev.iccube.olap.eval.cache.result.cache.OlapResultCacheMode;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="olapEngineComponentConfiguration")
public class OlapEngineComponentConfiguration {
    @XmlElement(name="olapProperties", required=true)
    private OlapProperties properties;
    @XmlElement(name="javaMdxConfiguration", required=false)
    @Nullable
    private OlapEngineJavaMdxConfiguration javaMdxConfiguration;
    @XmlElement(name="javaMdxNativeConfiguration", required=false)
    @Nullable
    private OlapEngineJavaMdxNativeConfiguration javaMdxNativeConfiguration;
    @XmlElement(name="javaViewConfiguration", required=false)
    @Nullable
    private OlapEngineJavaViewConfiguration javaViewConfiguration;
    @XmlElement(name="mdxEvalConfiguration", required=false)
    @Nullable
    private OlapEngineMdxEvalConfiguration evalConfiguration;
    @XmlElement(name="resultSerializationConfiguration", required=false)
    @Nullable
    private OlapEngineResultSerializationConfiguration resultSerializationConfiguration;
    @XmlElement(name="resultCacheConfiguration", required=false)
    @Nullable
    private OlapEngineResultCacheConfiguration resultCacheConfiguration;
    @XmlElement(name="backupConfiguration", required=false)
    @Nullable
    private OlapEngineBackupConfiguration backupConfiguration;

    public OlapEngineComponentConfiguration() {
    }

    private OlapEngineComponentConfiguration(OlapProperties properties, @Nullable OlapEngineJavaMdxConfiguration javaMdxConfiguration, @Nullable OlapEngineJavaMdxNativeConfiguration javaMdxNativeConfiguration, @Nullable OlapEngineJavaViewConfiguration javaViewConfiguration, @Nullable OlapEngineMdxEvalConfiguration evalConfiguration, @Nullable OlapEngineResultSerializationConfiguration resultSerializationConfiguration, @Nullable OlapEngineResultCacheConfiguration resultCacheConfiguration, @Nullable OlapEngineBackupConfiguration backupConfiguration) {
        this.properties = properties;
        this.javaMdxConfiguration = javaMdxConfiguration;
        this.javaMdxNativeConfiguration = javaMdxNativeConfiguration;
        this.javaViewConfiguration = javaViewConfiguration;
        this.evalConfiguration = evalConfiguration;
        this.resultSerializationConfiguration = resultSerializationConfiguration;
        this.resultCacheConfiguration = resultCacheConfiguration;
        this.backupConfiguration = backupConfiguration;
    }

    public OlapEngineComponentConfiguration __copyForPropertiesOverride() {
        return new OlapEngineComponentConfiguration(this.properties.__copy(), this.javaMdxConfiguration, this.javaMdxNativeConfiguration, this.javaViewConfiguration, this.evalConfiguration, this.resultSerializationConfiguration, this.resultCacheConfiguration, this.backupConfiguration);
    }

    public void _overrideProperties(List<OlapProperty> properties) {
        this.properties = this.properties.override(properties);
    }

    public void _nullifyProperty(OlapPropertyDescription<?> propertyDescription) throws OlapConfigurationException {
        this.properties = this.properties._nullify(propertyDescription);
    }

    public void validate(@Nullable OlapUserDefinedProperties userDefinedProperties) throws OlapConfigurationException {
        if (this.properties == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"MDX/Properties"});
        }
        this.properties.validate();
        if (this.javaMdxConfiguration != null) {
            this.javaMdxConfiguration.validate();
        }
        if (this.javaMdxNativeConfiguration != null) {
            this.javaMdxNativeConfiguration.validate();
        }
        if (this.javaViewConfiguration != null) {
            this.javaViewConfiguration.validate();
        }
        if (this.resultSerializationConfiguration == null) {
            this.resultSerializationConfiguration = new OlapEngineResultSerializationConfiguration(OlapSerializedTidyResourceMode.FILE, OlapSerializedTidyResourceCompression.LZ4);
        }
        this.resultSerializationConfiguration.validate();
        if (this.resultCacheConfiguration == null) {
            OlapResultCacheMode resultCacheMode = this.properties.getResultCacheMode();
            if (resultCacheMode == OlapResultCacheMode.OFF) {
                this.resultCacheConfiguration = new OlapEngineResultCacheConfiguration(resultCacheMode);
            } else {
                OlapEngineResultCachePolicyConfiguration resultCachePolicyConfiguration;
                int size = this.properties.getResultCacheSize();
                String resultCachePolicy = this.properties.getResultCachePolicy();
                if (OlapResultCacheImmediatePolicy.class.getName().equals(resultCachePolicy)) {
                    resultCachePolicyConfiguration = new OlapEngineResultCachePolicyConfiguration(OlapResultCacheImmediatePolicy.class.getName(), null);
                } else if (OlapResultCacheBufferedPolicy.class.getName().equals(resultCachePolicy)) {
                    ArrayList<OlapEngineResultCachePolicyConfiguration.Param> params = new ArrayList<OlapEngineResultCachePolicyConfiguration.Param>();
                    int bufferedRequestCount = userDefinedProperties != null ? userDefinedProperties.getIntProperty("rcp.bufferedRequestCount", -1) : -1;
                    if (bufferedRequestCount != -1) {
                        params.add(new OlapEngineResultCachePolicyConfiguration.Param("bufferedRequestCount", String.valueOf(bufferedRequestCount)));
                    }
                    resultCachePolicyConfiguration = new OlapEngineResultCachePolicyConfiguration(OlapResultCacheBufferedPolicy.class.getName(), params);
                } else {
                    throw new OlapConfigurationException(OlapConfigurationErrorCode.GENERAL_ERROR, new Serializable[]{"The icCube.resultCachePolicy cannot be migrated automatically; please upgrade your icCube.xml content."});
                }
                this.resultCacheConfiguration = new OlapEngineResultCacheConfiguration(resultCacheMode, size, true, true, true, resultCachePolicyConfiguration);
            }
        }
        this.resultCacheConfiguration.validate();
        if (this.evalConfiguration == null) {
            this.evalConfiguration = OlapEngineMdxEvalConfiguration.setupFromProperties(this.properties);
        }
        this.evalConfiguration.validate();
        if (this.backupConfiguration == null) {
            this.backupConfiguration = new OlapEngineBackupConfiguration(false, "-1", "-1", "-1", "NONE", null, null);
        }
        this.backupConfiguration.validate();
    }

    public OlapProperties getProperties() {
        return this.properties;
    }

    @Nullable
    public OlapEngineJavaMdxConfiguration getJavaMdxConfiguration() {
        return this.javaMdxConfiguration;
    }

    @Nullable
    public OlapEngineResultSerializationConfiguration getResultSerializationConfiguration() {
        return this.resultSerializationConfiguration;
    }

    @Nullable
    public OlapEngineResultCacheConfiguration getResultCacheConfiguration() {
        return this.resultCacheConfiguration;
    }

    public void setResultCacheConfiguration(@Nullable OlapEngineResultCacheConfiguration resultCacheConfiguration) {
        this.resultCacheConfiguration = resultCacheConfiguration;
    }

    public OlapEngineMdxEvalConfiguration getMdxEvalConfiguration() {
        if (this.evalConfiguration == null) {
            throw new RuntimeException("internal error: missing MDX evaluation configuration");
        }
        return this.evalConfiguration;
    }

    public OlapEngineBackupConfiguration getBackupConfiguration() {
        if (this.backupConfiguration == null) {
            throw new RuntimeException("internal error: missing backup configuration");
        }
        return this.backupConfiguration;
    }

    public boolean isJavaViewsActivated() {
        return this.javaViewConfiguration != null && this.javaViewConfiguration.isActive();
    }

    public boolean isJavaMdxNativesActivated() {
        return this.javaMdxNativeConfiguration != null && this.javaMdxNativeConfiguration.isActive();
    }
}

