/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.configuration;

import crazydev.iccube.configuration.OlapConfigurationErrorCode;
import crazydev.iccube.configuration.OlapConfigurationException;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@XmlRootElement(name="filter")
public class OlapServletFilterConfiguration {
    @XmlElement(name="filter-name", required=true)
    private String filterName;
    @XmlElement(name="filter-class", required=true)
    private String filterClass;
    @XmlElementRef(type=InitParam.class)
    private List<InitParam> initParams;

    public OlapServletFilterConfiguration() {
    }

    public OlapServletFilterConfiguration(String filterName, String filterClass, InitParam ... initParams) {
        this.filterName = filterName;
        this.filterClass = filterClass;
        this.initParams = initParams == null ? null : Arrays.asList(initParams);
    }

    public void validate() throws OlapConfigurationException {
        if (this.filterName == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"Servlet filter : name"});
        }
        if (this.filterClass == null) {
            throw new OlapConfigurationException(OlapConfigurationErrorCode.COMPONENT_IS_MISSING, new Serializable[]{"Servlet filter : class"});
        }
    }

    public String getFilterName() {
        return this.filterName;
    }

    public String getFilterClass() {
        return this.filterClass.trim();
    }

    public List<InitParam> getInitParams() {
        return this.initParams == null ? Collections.emptyList() : this.initParams;
    }

    @XmlRootElement(name="init-param")
    public static class InitParam {
        @XmlElement(name="param-name", required=true)
        private String name;
        @XmlElement(name="param-value", required=true)
        private String value;

        public InitParam() {
        }

        public InitParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

