/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.common.lock;

import crazydev.iccube.common.lock.DirectoryLock;
import crazydev.iccube.common.lock.DirectoryLockException;
import crazydev.iccube.crac.CRaCUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.crac.Context;
import org.crac.Resource;

public class ExclusiveDirectoryLock
extends DirectoryLock
implements Resource {
    public static final String LOCK = ".lock";
    private final File file;
    private RandomAccessFile raFile;
    private FileLock lock;

    public ExclusiveDirectoryLock(String role, File path) throws DirectoryLockException {
        super(role);
        try {
            this.file = new File(path.getCanonicalFile(), LOCK);
            this.lock = null;
            CRaCUtils.register(this, "File Lock [%s]".formatted(this.file.getAbsolutePath()));
        }
        catch (IOException ex) {
            throw new DirectoryLockException("Could not initialize the lock [" + path.getAbsolutePath() + "]", ex);
        }
    }

    @Override
    public void acquire() throws DirectoryLockException {
        if (this.file.exists()) {
            OlapLoggers.SERVER.warn((Object)("[" + this.role + "] existing lock file [" + this.file.getAbsolutePath() + "] detected. icCube was not shut down properly."));
        }
        try {
            this.tryLock();
        }
        catch (DirectoryLockException ex) {
            this.closeRandomAccessFile();
            throw ex;
        }
    }

    private void tryLock() throws DirectoryLockException {
        try {
            this.raFile = new RandomAccessFile(this.file, "rw");
            this.lock = this.raFile.getChannel().tryLock();
        }
        catch (IOException ex) {
            throw new DirectoryLockException("Unable to create or lock the file [" + this.file.getAbsolutePath() + "]", ex);
        }
        catch (OverlappingFileLockException ex) {
            throw new DirectoryLockException("The file [" + this.file.getAbsolutePath() + "] is already locked by the current icCube process.");
        }
        if (this.lock == null) {
            throw new DirectoryLockException("The file [" + this.file.getAbsolutePath() + "] is locked by another icCube process.");
        }
    }

    private void closeRandomAccessFile() {
        if (this.raFile != null) {
            try {
                this.raFile.close();
            }
            catch (IOException ex) {
                OlapLoggers.SERVER.warn((Object)("[" + this.role + "] unable to close the (random access) file [" + this.file.getAbsolutePath() + "]"), (Throwable)ex);
            }
            this.raFile = null;
        }
    }

    @Override
    public void release() throws DirectoryLockException {
        if (this.lock != null) {
            try {
                FileChannel channel = this.lock.channel();
                this.lock.release();
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.lock = null;
            this.closeRandomAccessFile();
        }
        if (!this.file.delete()) {
            OlapLoggers.SERVER.warn((Object)("[" + this.role + "] unable to delete the lock file [" + this.file.getAbsolutePath() + "]"));
        }
    }

    public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
        CRaCUtils.LOG.info("[CRaC] File Lock before-checkpoint [%s]".formatted(this.file.getAbsolutePath()));
        this.release();
        CRaCUtils.LOG.info("[CRaC] File Lock before-checkpoint [%s] completed".formatted(this.file.getAbsolutePath()));
    }

    public void afterRestore(Context<? extends Resource> context) throws Exception {
        CRaCUtils.LOG.info("[CRaC] File Lock after-restore [%s]".formatted(this.file.getAbsolutePath()));
        this.tryLock();
        CRaCUtils.LOG.info("[CRaC] File Lock after-restore [%s] completed".formatted(this.file.getAbsolutePath()));
    }
}

