/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.common.formatter;

import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.format.CellFormatPart;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public abstract class ExcelPoiFormatter {
    public static String formatNull(String formatString) {
        return Parser.getInstance((String)formatString).nullNumFmt;
    }

    public static String formatNumeric(String formatString, Locale locale, double value) {
        int index;
        Parser parsed = Parser.getInstance(formatString);
        String actualFormat = parsed.posNumFmt;
        if (value > 0.0) {
            index = 0;
        } else if (value < 0.0) {
            index = 1;
            if (parsed.formatPartCount > 1) {
                value = -value;
                actualFormat = parsed.negNumFmt;
            }
        } else {
            index = 2;
            if (parsed.formatPartCount > 2) {
                actualFormat = parsed.zeroNumFmt;
            }
        }
        int addPercent = 0;
        for (int startLookup = actualFormat.length() - (actualFormat.endsWith(")") ? 2 : 1); startLookup > 0; --startLookup) {
            char ch = actualFormat.charAt(startLookup);
            if (ch == ',') {
                value /= 1000.0;
            } else {
                if (ch != '%') break;
                ++addPercent;
                value *= 100.0;
            }
            actualFormat = new StringBuilder(actualFormat).deleteCharAt(startLookup).toString();
        }
        DataFormatter formatter = new DataFormatter(locale);
        Object output = formatter.formatRawCellContents(value, index, actualFormat);
        while (addPercent-- > 0) {
            output = (String)output + "%";
        }
        return output;
    }

    public static String formatDate(String formatString, Locale locale, LocalDateTime date) {
        return ExcelPoiFormatter.formatDate(formatString, locale, date.toDate());
    }

    public static String formatDate(String formatString, Locale locale, LocalDate date) {
        return ExcelPoiFormatter.formatDate(formatString, locale, date.toDate());
    }

    private static String formatDate(String formatString, Locale locale, Date date) {
        double excelDate = DateUtil.getExcelDate((Date)date);
        DataFormatter formatter = new DataFormatter(locale);
        String output = formatter.formatRawCellContents(excelDate, 0, formatString);
        return output;
    }

    private static class Parser {
        private final String posNumFmt;
        private final String negNumFmt;
        private final String zeroNumFmt;
        private final String nullNumFmt;
        private final int formatPartCount;
        private static final Pattern ONE_PART = Pattern.compile(CellFormatPart.FORMAT_PAT.pattern() + "(;|$)", 6);
        private static final Map<String, Parser> formatCache = new WeakHashMap<String, Parser>();

        public static Parser getInstance(String format) {
            Parser fmt = formatCache.get(format);
            if (fmt == null) {
                fmt = new Parser(format);
                formatCache.put(format, fmt);
            }
            return fmt;
        }

        private Parser(String format) {
            Matcher m = ONE_PART.matcher(format);
            ArrayList<String> parts = new ArrayList<String>();
            while (m.find()) {
                try {
                    String valueDesc = m.group();
                    if (valueDesc.endsWith(";")) {
                        valueDesc = valueDesc.substring(0, valueDesc.length() - 1);
                    }
                    parts.add(valueDesc);
                }
                catch (RuntimeException e) {
                    parts.add(null);
                }
            }
            this.formatPartCount = parts.size();
            this.posNumFmt = this.formatPartCount < 1 ? null : (String)parts.get(0);
            this.negNumFmt = this.formatPartCount < 2 ? null : (String)parts.get(1);
            this.zeroNumFmt = this.formatPartCount < 3 ? null : (String)parts.get(2);
            this.nullNumFmt = this.formatPartCount < 4 ? null : (String)parts.get(3);
        }
    }
}

